<?php
/**
 * @package   ShackErrorNotify
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2019-2023 Joomlashack.com. All rights reserved
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of ShackErrorNotify.
 *
 * ShackErrorNotify is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * ShackErrorNotify is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ShackErrorNotify.  If not, see <http://www.gnu.org/licenses/>.
 */

use Joomla\CMS\Layout\FileLayout;

defined('_JEXEC') or die();

/**
 * @var FileLayout $this
 * @var array      $displayData
 * @var string     $layoutOutput
 * @var string     $path
 */

/**
 * @var Throwable  $error
 * @var string[][] $trace
 * @var string[]   $dataLines
 */
extract($displayData);

?>
    <style>
        table {
            border-collapse: collapse;
            margin: 0;
            padding: 0;
        }

        table th {
            text-align: left;
            vertical-align: top;
            white-space: nowrap;
            padding: 5px;
        }

        table td {
            vertical-align: top;
            padding: 5px;
        }
    </style>
    <table>
        <tbody>
        <?php
        foreach ($dataLines as $label => $value) :
            echo sprintf(
                '<tr><th>%s</th><td>%s</td></tr>',
                $label,
                $value
            );
        endforeach;
        ?>
        </tbody>
    </table>
<?php

include_once __DIR__ . '/trace.php';

echo '<br><br>';
