<?php
/**
 * @package   ShackErrorNotify
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2019-2023 Joomlashack.com. All rights reserved
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of ShackErrorNotify.
 *
 * ShackErrorNotify is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * ShackErrorNotify is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ShackErrorNotify.  If not, see <http://www.gnu.org/licenses/>.
 */

use Joomla\CMS\Form\FormHelper;

defined('_JEXEC') or die();

FormHelper::loadFieldClass('List');

abstract class AbstractShackFormFieldThrowables extends JFormFieldList
{
    /**
     * @var string[]
     */
    protected static $errors = null;

    /**
     * @var string[]
     */
    protected static $exceptions = null;

    /**
     * @inheritDoc
     */
    public function setup(SimpleXMLElement $element, $value, $group = null)
    {
        if (parent::setup($element, $value, $group)) {
            if (static::$errors === null) {
                static::$errors     = [];
                static::$exceptions = [];
                foreach (get_declared_classes() as $class) {
                    if (is_subclass_of($class, 'Error')) {
                        static::$errors[] = $class;

                    } elseif (is_subclass_of($class, 'Exception')) {
                        static::$exceptions[] = $class;
                    }
                }
            }

            return true;
        }

        return false;
    }
}
