<?php
/**
 * ------------------------------------------------------------------------
 * ospropertyplg.php Ossolution Osproperty System plugin for Joomla 5.x
 * ------------------------------------------------------------------------
 * Copyright (C) 2009-2025 Ossolution Co., Ltd. All Rights Reserved.
 * @license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: Ossolution Co., Ltd
 * Websites: http://www.joomdonation.com
 * ------------------------------------------------------------------------
 */


defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;

class Ospropertyplg extends CMSPlugin
{
	/**
	 * Application object.
	 *
	 * @var    \Joomla\CMS\Application\CMSApplication
	 */
	protected $app;

	/**
	 * Database object.
	 *
	 * @var    \Joomla\Database\DatabaseDriver
	 */
	protected $db;

    public function onAfterRespond()
    {
        global $mainframe, $configClass;
        $mainframe = $this->app;

        if (!$mainframe->isClient('administrator'))
        {
            require_once(JPATH_ROOT . "/components/com_osproperty/classes/cron.php");
            require_once(JPATH_ROOT . "/components/com_osproperty/classes/email.php");
            require_once(JPATH_ROOT . "/components/com_osproperty/helpers/common.php");

            $db    = $this->db;
            $query = $db->getQuery(true)
                ->select('*')
                ->from($db->quoteName('#__osrs_configuration'));
            $db->setQuery($query);
            $configs = $db->loadObjectList();

            $configClass = [];
            foreach ($configs as $config) 
            {
                $configClass[$config->fieldname] = $config->fieldvalue;
            }

            if ($configClass['general_use_expiration_management'] == 1)
            {
                $query = $db->getQuery(true)
                    ->select('runtime')
                    ->from($db->quoteName('#__osrs_lastcron'));
                $db->setQuery($query);
                $lastcron = (int) $db->loadResult();
                
                $current_time = time();
                
                if ($lastcron < $current_time - 3600)
                {
                    OspropertyCron::checklist();
                }
            }
        }
    }
}
