<?php

// autoload.php @generated by Weeblr

namespace Weeblr\Wblib\V_FORLOGS_217\Composer;

class ComposerAutoloaderInit
{
	private static $loader;

	/**
	 * @return \Composer\Autoload\ClassLoader
	 */
	public static function getLoader()
	{
		if (null !== self::$loader)
		{
			return self::$loader;
		}

		require_once __DIR__ . '/composer-static/ClassLoader.php';
		self::$loader = $loader = new Autoload\ClassLoader();


		$useStaticLoader = PHP_VERSION_ID >= 50600 && !defined('HHVM_VERSION') && (!function_exists('zend_loader_file_encoded') || !zend_loader_file_encoded());
		if ($useStaticLoader)
		{
			require_once __DIR__ . '/composer-static/autoload_static.php';

			call_user_func(Autoload\ComposerStaticInit::getInitializer($loader));
		}
		else
		{
			$map = require __DIR__ . '/composer-static/autoload_namespaces.php';
			foreach ($map as $namespace => $path)
			{
				$loader->set($namespace, $path);
			}

			$map = require __DIR__ . '/composer-static/autoload_psr4.php';
			foreach ($map as $namespace => $path)
			{
				$loader->setPsr4($namespace, $path);
			}

			$classMap = require __DIR__ . '/composer-static/autoload_classmap.php';
			if ($classMap)
			{
				$loader->addClassMap($classMap);
			}
		}

		$loader->register(true);

		return $loader;
	}
}


return ComposerAutoloaderInit::getLoader();

