<?php
/**
 * Project:                 4LOGS
 *
 * @author           Yannick Gaultier - Weeblr llc
 * @copyright        Copyright Weeblr llc - 2021
 * @package          4LOGS
 * @license          GNU General Public License version 3; see LICENSE.md
 * @version          @build_version_full_build@
 * @date         2021-08-20
 */

namespace Weeblr\Wblib\V_FORLOGS_217\Seo;

// Security check to ensure this file is being included by a parent file.
use Weeblr\Wblib\V_FORLOGS_217\Base\Base;
use Weeblr\Wblib\V_FORLOGS_217\System;
use Weeblr\Wblib\V_FORLOGS_217\Wb;

defined('_JEXEC') || defined('WBLIB_V_FORLOGS_217_ROOT_PATH') || die;

/**
 * HTML output helper.
 *
 */
class Helper extends Base
{
	/**
	 * @var string|null The detected search engines making the request, if any.
	 */
	private static $engine;

	/**
	 * @var bool Whether to validate search engines requesting IP address against domains.
	 */
	private static $validateIp = true;

	/**
	 * @var string This configuration unique ID.
	 */
	protected $engines = [
		'google',
		'bing'
	];

	/**
	 * Stores options.
	 *
	 * @param array $options Can inject custom factory and platform.
	 */
	public function __construct($options = [])
	{
		parent::__construct($options);

		self::$validateIp = Wb\arrayGet(
			$options,
			'validateIp',
			true
		);
	}

	/**
	 * List of supported search engines identifiers.
	 *
	 * @return string[]
	 */
	public function getSupported()
	{
		return $this->engines;
	}

	/**
	 * Returns the search engines code making the current request or empty string
	 * if no search engines is recognized.
	 *
	 * @return string
	 */
	public function getRequestingSearchEngine()
	{
		if (is_null(self::$engine))
		{
			$this->detect(self::$validateIp);
		}

		return self::$engine;
	}

	/**
	 * Whether current request is by a known search engine.
	 *
	 * @return bool
	 */
	public function isSearchEngineRequest()
	{
		if (is_null(self::$engine))
		{
			$this->detect(self::$validateIp);
		}

		return self::$engine != Searchengine::NONE;
	}

	/**
	 * Iterate over known search engines to recognize the request.
	 *
	 * @param bool $validateIp Whether to validate the IP address against search engines hosts.
	 *
	 */
	private function detect($validateIp = true)
	{
		$userAgent = System\Http::userAgent();
		$ip        = System\Http::getIpAddress();

		foreach ($this->engines as $engineId)
		{
			$engine = $this->factory->getA(
				'Weeblr\Wblib\V_FORLOGS_217\Seo\\' . ucfirst($engineId),
				[
					'validateIp' => self::$validateIp
				]
			);
			if ($engine->isRequesting(
				$userAgent,
				$ip,
				$validateIp
			))
			{
				self::$engine = $engineId;
				break;
			}
		}
	}
}
