<?php
/**
 * @build_title_build       @
 *
 * @package                 4LOGS
 * @copyright               Copyright Weeblr llc - 2021
 * @author                  Yannick Gaultier - Weeblr llc
 * @license                 GNU General Public License version 3; see LICENSE.md
 * @version                 1.1.2.217
 *
 * 2021-08-20
 */

namespace Weeblr\Wblib\V_FORLOGS_217\Platform;

// Security check to ensure this file is being included by a parent file.
defined('_JEXEC') || defined('WBLIB_V_FORLOGS_217_ROOT_PATH') || die;

/**
 * A thin interface class to the host system (CMS)
 * Performs page rendering essentially.
 *
 */
interface Platforminterface
{
	public function boot();

	public function detect();

	public function majorVersion();

	public function version();

	public function getName();

	public function getConfig();

	public function getUniqueId();

	public function getUser($id = null);

	public function isGuest();

	public function sanitizeInput($type, $input);

	public function getCSRFToken();

	public function checkCSRFToken($token);

	public function getCurrentUrl();

	public function getCurrentContentType();

	public function getCurrentRequestCategory();

	public function getSitename();

	public function getBaseUrl($pathOnly = true);

	public function getRootUrl($pathOnly = true);

	public function getHomeUrl();

	public function isHomePage();

	public function normalizeUrl($url);

	public function stripRewritePrefix($url);

	public function getUrlRewritingPrefix();

	public function getCanonicalRoot($isAdmin = null);

	public function getExtensions($type);

	public function isPluginEnabled($group, $name);

	public function saveExtensionParams($params, $options);

	public function getCategories($extensions = []);

	public function getHttpInput();

	public function getCookiesManager();

	public function getHttpClient($options = array());

	public function getCache($type, $options = array());

	public function getMethod();

	public function getScheme();

	public function getHost();

	public function getRootPath();

	public function getLogsPath();

	public function getCachePath($type);

	public function getLayoutOverridesPath();

	public function getUserImagesPath();

	public function getDefaultLanguageTag($full = true);

	public function getCurrentLanguageTag($full = true);

	public function getCurrentLanguageDirection();

	public function getLanguageDirection($lang);

	public function getLanguageOverrides($extension);

	public function loadLanguageFile($name, $location = '');

	public function t($key, $options = array('js_safe' => false, 'lang' => ''));

	public function tprintf($key);

	public function getTimezone();

	// html operations
	public function setHttpStatus($code, $message);

	public function getHttpStatus();

	public function addScript($url, $options = array(), $attribs = array());

	public function addScripts($scripts);

	public function addScriptDeclaration($content, $type = 'text/javascript');

	public function addStyleSheet($url, $options = array(), $attribs = array());

	public function addStyleSheets($stylesheets);

	public function addStyleDeclaration($content, $type = 'text/css');

	public function isMultipageContent($contentData);

	public function setTitle($title);

	public function getTitle();

	public function setAdminTitle($title);

	public function setDescription($description);

	public function getDescription();

	public function getCanonical();

	public function addHeadLink($href, $relation, $relType = 'rel', $attribs = array());

	public function setMetaData($name, $content, $attribute = 'name');

	public function getMetaData($name, $attribute = 'name');

	public function addCustomTag($html);

	public function setHeader($name, $value);

	public function setResponseType($type = 'html', $filename = 'document');

	// workflow operations
	public function triggerEvent($event, $args = []);

	public function registerEventHandler($eventName, $eventHandler);

	public function isFrontend();

	public function isFrontendEditPage();

	public function isBackend();

	public function isOffline();

	public function disableOfflineMode();

	public function enableOfflineMode();

	public function isHtmlDocument();

	public function isFeedDocument();

	public function isDocumentType();

	public function isLikelyEditPage();

	public function canCompress();

	public function getDocument();

	public function getDocumentContent();

	public function isDebugEnabled();

	// hooks
	public function getHooksPath();

	public function addHook($id, $callback, $priority = 100);

	public function removeHook($id, $callback, $priority = null);

	public function executeHook($filter, $params);

	public function hasHook($id);

	// display, or handle error
	public function handleError($request);

	public function handleMessage($msg, $type = 'info');

	// routing, redirect
	public function route($url, $xhtml = true, $ssl = null);

	public function redirectTo($redirectTo, $redirectMethod = 301);

	// users & authorization
	public function authorize($action, $subject, $userId = null);

	// filesystem
	public function createFolders($folders);

	public function deleteFolders($folders, $exclude = []);

	public function moveFile($src, $dest, $path = '');

	public function moveFiles($files, $path = '');

	public function moveToFolder($files, $src, $dest);

	public function deleteFile($file);

	public function deleteFiles($files);

	public function listFiles($path, $filter = '.', $recurse = false, $full = false, $exclude = array('.svn', 'CVS', '.DS_Store', '__MACOSX'),
	                          $excludeFilter = array('^\..*', '.*~'), $naturalSort = false);

	public function moveFolders($moves);

	public function listFolders($path, $filter = '.', $recurse = false, $full = false, $exclude = array('.svn', 'CVS', '.DS_Store', '__MACOSX'), $excludefilter = array('^\..*'));

	// Display
	public function defaultItemsPerPage();

	public function getUpdateId($extensionType, $extensionElement);

	public function setUpdateId($extensionType, $extensionElement, $id);

	// Extensions
	public function disablePlugins($type, $pluginsNames);
}
