<?php
/**
 * Project:                 4LOGS
 *
 * @author                  Yannick Gaultier - Weeblr llc
 * @copyright               Copyright Weeblr llc - 2021
 * @package                 4LOGS
 * @license                 GNU General Public License version 3; see LICENSE.md
 * @version                 @build_version_full_build@
 *
 * 2021-08-20
 */

namespace Weeblr\Wblib\V_FORLOGS_217\Mvc;

use Weeblr\Wblib\V_FORLOGS_217\Wb;

/** ensure this file is being included by a parent file */
defined('_JEXEC') || defined('WBLIB_V_FORLOGS_217_ROOT_PATH') || die;

class LayoutHelper
{
	public static $defaultBasePath = '';

	public static function render($layoutFile, $__data = null, $basePath = '', $theme = '')
	{
		$basePath       = empty($basePath) ? self::$defaultBasePath : $basePath;
		$layoutFile     = Wb\dotJoin(
			$theme,
			$layoutFile
		);
		$layout         = new LayoutFile($layoutFile, $basePath);
		$renderedLayout = $layout->render($__data);

		return $renderedLayout;
	}

	/**
	 * Check if a layout file exist
	 *
	 * @param   string  $layoutFile
	 * @param   string  $basePath
	 *
	 * @return bool
	 */
	public static function layoutExists($layoutFile, $basePath = '')
	{
		$basePath = empty($basePath) ? self::$defaultBasePath : $basePath;
		$layout   = new LayoutFile($layoutFile, $basePath);

		return $layout->exists();
	}

	/**
	 * Iterate over a list of layout files, and returns the name
	 * of the first that exists
	 *
	 * @param   array   $layoutFiles
	 * @param   string  $basePath
	 *
	 * @return string
	 */
	public static function getExistingLayout($layoutFiles, $basePath = '')
	{
		if (empty($layoutFiles))
		{
			return '';
		}

		$layoutFiles = (array) $layoutFiles;
		foreach ($layoutFiles as $layoutFile)
		{
			if (self::layoutExists($layoutFile, $basePath))
			{
				return $layoutFile;
			}
		}

		return '';
	}
}
