<?php
/**
 * 4LOGS
 *
 * @package          4LOGS
 * @copyright        Copyright Weeblr llc - 2021
 * @author           Yannick Gaultier - Weeblr llc
 * @license          GNU General Public License version 3; see LICENSE.md
 * @version          1.1.2.217
 * @date        2021-08-20
 *
 */

namespace Weeblr\Wblib\V_FORLOGS_217\Messages;

use Weeblr\Wblib\V_FORLOGS_217\Api;
use Weeblr\Wblib\V_FORLOGS_217\Wb;

// no direct access
defined('_JEXEC') || defined('WBLIB_EXEC') || die;

/**
 * API class, makes API available.
 */
class Handler extends Api\Handler
{
	/**
	 * Register all routes with the API layer.
	 */
	public function register($options = [])
	{
		$msgManager = Wb\arrayGet($options, 'msgManager');
		if (empty($msgManager))
		{
			throw new \Exception(__METHOD__ . ': no messages manager supplied when registering api handler.');
		}
		$apiController = $this->factory
			->getA(Controller::class)
			->setMsgManager(
				$msgManager
			);

		$this->api
			//
			// Change status ---------------------------------------------------------------------
			//
			->patch(
				$this->namespace,
				$this->version,
				'/messages/{id}',
				[
					$apiController,
					'patch',
				],
				$this->defaultApiOptions
			)
			//
			// Reset reminders -------------------------------------------------------------------
			//
			->patch(
				$this->namespace,
				$this->version,
				'/messages',
				[
					$apiController,
					'resetReminders',
				],
				$this->defaultApiOptions
			);

		return $this;
	}
}
