<?php
/**
 * Project:                 4LOGS
 *
 * @author                  Yannick Gaultier - Weeblr llc
 * @copyright               Copyright Weeblr llc - 2021
 * @package                 4LOGS
 * @license                 GNU General Public License version 3; see LICENSE.md
 * @version                 @build_version_full_build@
 *
 * 2021-08-20
 */

namespace Weeblr\Wblib\V_FORLOGS_217\Base;

use Weeblr\Wblib\V_FORLOGS_217\Wb;

/** ensure this file is being included by a parent file */
defined('_JEXEC') || defined('WBLIB_V_FORLOGS_217_ROOT_PATH') || die;

/**
 * Base app class.
 *
 */
class App extends Base
{
	/**
	 * @var Array Stored options.
	 */
	protected $options = null;

	protected $id = '';
	protected $namespace = '';
	protected $rootpath = '';
	protected $enabled = true;

	public function __construct($options = array())
	{
		parent::__construct();

		$this->options = $options;
		$this->id      = Wb\arrayGet(
			$options,
			'id',
			''
		);
		if (empty($this->id))
		{
			Wb\throwException(new \RuntimeException('Wblib: cannot start application, no id provided.'));
		}

		$this->namespace = Wb\arrayGet(
			$options,
			'namespace',
			''
		);
		$this->rootpath  = Wb\arrayGet(
			$options,
			'rootpath',
			''
		);
		if (!empty($this->namespace) && !empty($this->rootpath))
		{
			$this->factory->getThe('autoloader')
				->registerNamespace(
					$this->namespace,
					$this->rootpath
				);
		}

		// allow user hooks by loading the "functions" file for the app.
		$this->factory->getThe('hook')
			->load(
				$this->id . '_functions.php'
			);
	}
}
