<?php
/**
 * 4LOGS
 *
 * @package          4LOGS
 * @copyright        Copyright Weeblr llc - 2021
 * @author           Yannick Gaultier - Weeblr llc
 * @license          GNU General Public License version 3; see LICENSE.md
 * @version          1.1.2.217
 * @date        2021-08-20
 *
 * build 1.1.2.217
 */

namespace Weeblr\Forlogs;

use Weeblr\Wblib\V_FORLOGS_217\Base;
use Weeblr\Wblib\V_FORLOGS_217\System;

use Weeblr\Forlogs\Platform;
use Weeblr\Forlogs\Api;

// no direct access
defined('_JEXEC') || defined('WBLIB_EXEC') || die;

/**
 * Bootstrap app, called from higher up.
 */
class ForlogsApp extends Base\App
{
	protected $id        = 'forlogs';
	protected $namespace = '\Weeblr\Forlogs';

	public function __construct($options = [])
	{
		parent::__construct($options);

		// include 4LOGS factory to extend wbLib factory.
		include_once 'factory.php';

		// register local platform code with the autoloader
		// for instance J3 or J4 specific code
		$this->factory->getThe('autoloader')
					  ->registerNamespace(
						  '\Weeblr\Forlogs\Platform',
						  FORLOGS_APP_PLATFORM_PATH . '/platform'
					  );

		// initialize the app timezone
		System\Date::setTimezoneName(
			$this->platform->getTimezone()
		);

		// register the API handler with the wbLib API manager.
		$registered = $this->factory
			->getA(Api\Handler::class)
			->register();
		if (!$registered)
		{
			$this->enabled = false;
			$msg           = 'Failed registering 4LOGS API with wbLib, aborting.';
			$this->factory->getThe('forlogs.logger')->error($msg);
			throw new \RuntimeException($msg);
		}

		// load the api hooks, if any
		$apiHooks = $this->factory->getA(Api\Hooks::class);
		if (!empty($apiHooks))
		{
			$apiHooks->add();
		}

		// load the local platform hooks, if any
		$platformHooks = $this->factory->getA(Platform\Hooks::class);
		if (!empty($platformHooks))
		{
			$platformHooks->add();
		}

		// load the application hooks, if any
		$appHooks = $this->factory->getA(Forlogs\Hooks::class);
		if (!empty($appHooks))
		{
			$appHooks->add();
		}

		// register a version object
		$this->setVersionInfo();
	}

	/**
	 * Builds a version information object and store it with wbLib.
	 *
	 * @throws \Exception
	 */
	private function setVersionInfo()
	{
		static $version = null;

		if (is_null($version))
		{
			if (false === strpos('1.1.2.217', '_version_'))
			{
				$versionInfo = [
					'package'           => '4LOGS',
					'platform'          => '@build_platform_build@',
					'package_title'     => '4LOGS',
					'version'           => '1.1.2.217',
					'version_full'      => '1.1.2.217',
					'date'              => '2021-08-20',
					'license'           => 'GNU General Public License version 3; see LICENSE.md',
					'copyright'         => 'Copyright Weeblr llc - 2021',
					'author'            => 'Yannick Gaultier - Weeblr llc',
					'url'               => 'https://weeblr.com/',
					'edition'           => 'full',
					'documentation_url' => '@build_documentation_url_build@',
					'php'               => [
						'min' => '7.1.0',
						'max' => ''
					],
					'platform_version'  => [
						'min' => '3.9.0',
						'max' => '5.0'
					]
				];
			}
			else
			{
				$versionInfo = [
					'package'           => 'forlogs',
					'platform'          => 'joomla',
					'package_title'     => 'ForLOGS',
					'version'           => '5.0.0',
					'version_full'      => '5.0.0.1234',
					'date'              => '2021-05-07',
					'license'           => 'GPL Version 3',
					'copyright'         => '(c) Weeblr,llc - 2021',
					'author'            => 'Weeblr',
					'url'               => 'https://weeblr.com',
					'edition'           => 'full',
					'documentation_url' => 'https://weeblr.com/9k',
					'php'               => [
						'min' => '7.1',
						'max' => '8'
					],
					'platform_version'  => [
						'min' => '3.9',
						'max' => '5'
					]
				];
			}

			$version = new System\Version($versionInfo);
		}
	}
}

