<?php
/**
 * @build_title_build       @
 *
 * @package                 4LOGS
 * @copyright               Copyright Weeblr llc - 2021
 * @author                  Yannick Gaultier - Weeblr llc
 * @license                 GNU General Public License version 3; see LICENSE.md
 * @version                 1.1.2.217
 *
 * 2021-08-20
 */

namespace Weeblr\Forlogs;

use Weeblr\Wblib\V_FORLOGS_217\Factory;
use Weeblr\Wblib\V_FORLOGS_217\System;
use Weeblr\Wblib\V_FORLOGS_217\Html;

use Weeblr\Forlogs\Model;
use Weeblr\Forlogs\Controller;

// Security check to ensure this file is being included by a parent file.
defined('_JEXEC') || defined('WBLIB_EXEC') || die;

/**
 * Extends the standard factory, builds a few specific objects
 */
Factory::get()->getThe('hook')->add(
	'wblib_factory_build_object_filter',
	function ($object, $factory, $method, $class, $args, $key) {

		switch ($class)
		{
			// gather all versions info
			case 'forlogs.versionInfo':
				$factory->enforceSingleton(
					$class,
					$method
				);

				return System\Version::get('forlogs');

			case 'forlogs.logger':
				$factory->enforceSingleton(
					$class,
					$method
				);

				$appConfig = new Model\Config('app');

				return new System\Log('forlogs', $appConfig->get('loggingPreset', System\Log::LOGGING_PRODUCTION));

			case 'forlogs.config':
				$factory->enforceMultiton(
					$class,
					$method
				);

				return new Model\Config($key);

			case 'forlogs.assetsManager':
				$factory->enforceSingleton(
					$class,
					$method
				);

				if (WBLIB_V_FORLOGS_217_OP_MODE == 'prod')
				{
					$filesPath = '/media/plg_system_forlogs/vendor/weeblr/forlogs/assets';
				}
				else
				{
					$filesPath = '../../src/main/client';
				}

				return new Html\Assetsmanager(
					[
						'filesPath'   => $filesPath,
						'enableDebug' => false,
						'assetsMode'  => WBLIB_V_FORLOGS_217_OP_MODE == 'prod'
							? Html\Assetsmanager::PRODUCTION
							: Html\Assetsmanager::DEV
					]
				);

		}

		return $object;
	}
);

