<?php
/**
 * 4LOGS
 *
 * @package          4LOGS
 * @copyright        Copyright Weeblr llc - 2021
 * @author           Yannick Gaultier - Weeblr llc
 * @license          GNU General Public License version 3; see LICENSE.md
 * @version          1.1.2.217
 * @date        2021-08-20
 *
 */

namespace Weeblr\Forlogs\Api;

use Weeblr\Wblib\V_FORLOGS_217\Api,
	Weeblr\Wblib\V_FORLOGS_217\System;

// no direct access
defined('_JEXEC') || defined('WBLIB_EXEC') || die;

/**
 * API class, makes API available.
 */
class Handler extends Api\Handler
{
	protected $namespace = 'forlogs';
	protected $version   = 'v1';
	protected $asset     = 'com_config';

	/**
	 * Register all routes with the API layer.
	 */
	public function register()
	{
		/**
		 * Set this function as the "auth_callback" parameter
		 * when add a router handler to bypass auhtorization.
		 * DANGEROUS: only use for dev!
		 *
		 * @param $apiRequest
		 * @param $authorization
		 *
		 * @return array
		 */
		$byPassAuth = function ($apiRequest, $authorization) {

			$authorization = [
				'status' => System\Http::RETURN_OK
			];

			return $authorization;
		};

		// Assume anyone who can change config can look at the logs.
		$defaultOptions = $this->buildRouteOptions(
			[
				'authorizations' => [
					[
						'asset'  => $this->asset,
						'action' => 'core.manage'
					]
				],
				'auth_callback'  => null
			]
		);

		$this->api
			//
			// File ------------------------------------------------------------------------------
			//
			->get(
				$this->namespace,
				$this->version,
				'/files',
				[
					'Weeblr\Forlogs\Api\Controller\Files',
					'get',
				],
				$this->buildRouteOptions(
					[
						'authorizations'       => [
							[
								'asset'  => $this->asset,
								'action' => 'core.manage'
							]
						],
						'query_vars_whitelist' => [
							'path',
							'download',
							'search'
						],
						'auth_callback'        => null
					]
				)
			)->delete(
				$this->namespace,
				$this->version,
				'/files',
				[
					'Weeblr\Forlogs\Api\Controller\Files',
					'delete',
				],
				$this->buildRouteOptions(
					[
						'authorizations'       => [
							[
								'asset'  => $this->asset,
								'action' => 'core.manage'
							]
						],
						'query_vars_whitelist' => [
							'path'
						],
						'auth_callback'        => null
					]
				)
			);

		return $this;
	}
}
