<?php
/**
 * 4LOGS
 *
 * @author           Yannick Gaultier - Weeblr llc
 * @copyright        Copyright Weeblr llc - 2021
 * @package          4LOGS
 * @license          GNU General Public License version 3; see LICENSE.md
 * @version          1.1.2.217
 * @date        2021-08-20
 */

use Weeblr\Forlogs\Helper;
use Weeblr\Wblib\V_FORLOGS_217\Factory as wblFactory;
use Weeblr\Wblib\V_FORLOGS_217\System;
use Weeblr\Wblib\V_FORLOGS_217\Wb;

defined('_JEXEC') or die;

/**
 * Display version and edition information
 *
 */
class JFormFieldWbassets extends JFormField
{
	/**
	 * The form field type.
	 *
	 * @var    string
	 */
	protected $type = 'wbassets';

	public function getInput()
	{
		return;
	}

	public function getLabel()
	{
		$factory       = wblFactory::get();
		$platform      = $factory->getThe('platform');
		$assetsManager = $factory->getThe('forlogs.assetsManager');

		$isDev = 'dev' === WBLIB_V_FORLOGS_217_OP_MODE;

		$forlogsAppBaseCss = $assetsManager->getHashedMediaLink('forlogs.base.css');
		$forlogsAppCss     = $assetsManager->getHashedMediaLink('forlogs.css');
		$forlogsAppJs      = $isDev
			? FORLOGS_APP_DEV_JS_BUNDLE_ADMIN
			: $assetsManager->getHashedMediaLink('forlogs.js');

		$currentLanguageTag = $platform->getCurrentLanguageTag();
		$languageStrings    = $factory->getA(Helper\Language::class)
									  ->getJsLanguageStrings(
										  ['plugin_system'],
										  $currentLanguageTag
									  );

		$user = $platform->getUser();

		$forlogsJsConfig = [
			'platformVersion' => [
				'major'   => $platform->majorVersion(),
				'version' => $platform->version()
			],
			'version'         => [
				'current' => '1.1.2.217',
				'edition' => 'full',
				'api'     => 'v1'
			],
			'tz'              => $platform->getTimeZone(),
			'date'            => '2021-08-20',
			'copyright'       => 'Copyright Weeblr llc - 2021',
			'language'        => $currentLanguageTag,
			'displayConfig'   => [],
			'urls'            => [
				'root'             => $platform->getRootUrl(true),
				'rootFull'         => $platform->getRootUrl(false),
				'base'             => $platform->getBaseUrl(true),
				'baseFull'         => $platform->getBaseUrl(false),
				'api'              => System\Route::normalizePath(
					$platform->getBaseUrl(true)
					. '/?'
					. $factory->getThe('api')->getSlug()
					. '=/forlogs'),
				'helpRequirements' => 'https://weeblr.com/doc/products.forlogs/current/requirements/'
			],
			'user'            => [
				'id' => empty($user->id) ? 'default' : substr(md5($user->id), 0, 12)
			],
			'path'            => [
				'images'    => System\Route::normalizePath(FORLOGS_APP_ASSETS_BASE_URL . '/images'),
				'logs'      => Wb\lTrim(System\Route::normalizePath($platform->getLogsPath()), System\Route::normalizePath(JPATH_ROOT)),
				'logs_full' => System\Route::normalizePath($platform->getLogsPath()),
			],
			'tokens'          => [
				'csrf' => $platform->getCSRFToken()
			],
			'bundleFile'      => $forlogsAppJs,
			'uiConstants'     => [],
		];

		$js = "\nvar forLogsConfig = " . System\Strings::jsonPrettyPrint($forlogsJsConfig) . "\n";
		$js .= "\nvar forLogsLanguageStrings = " . System\Strings::jsonPrettyPrint($languageStrings) . "\n";

		$css = '';
		if ('3' == $platform->majorVersion())
		{
			$css = <<<CSSJ3
div.container-fluid.container-main {
  display: flex;
  flex-direction: column;
}
#attrib-logs .control-label {
display: none;
}
.form-horizontal #attrib-logs .controls {
margin-left: 0;
}
CSSJ3;

		}

		$platform->addScripts(
			[
				[
					'url'     => $forlogsAppJs,
					'options' => [],
					'attr'    => $isDev
						? ['type' => 'module']
						: ['defer' => 'defer']
				]
			]
		)->addStylesheets(
			[
				['url' => $forlogsAppBaseCss],
				['url' => $forlogsAppCss]
			]
		)->addScriptDeclaration(
			$js
		)->addStyleDeclaration(
			$css
		);

		return '';
	}
}

