<?php
/**
 * @package        Joomla
 * @subpackage     Membership Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2012 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use Joomla\Utilities\ArrayHelper;

class plgOSMembershipPlanRestriction extends CMSPlugin implements SubscriberInterface
{
	use MPFEventResult;

	/**
	 * Application object.
	 *
	 * @var    \Joomla\CMS\Application\CMSApplication
	 */
	protected $app;

	/**
	 * Database object.
	 *
	 * @var \Joomla\Database\DatabaseDriver
	 */
	protected $db;

	public static function getSubscribedEvents(): array
	{
		return [
			'onMPCheckCanSubscribeToPlan' => 'onMPCheckCanSubscribeToPlan',
		];
	}

	/**
	 * Listen to onMPCheckCanSubscribeToPlan event to determine whether user can subscribe to the plan
	 *
	 * @param   Event  $event
	 *
	 * @return void
	 */
	public function onMPCheckCanSubscribeToPlan(Event $event): void
	{
		/* @var OSMembershipTablePlan $row */
		[$row] = array_values($event->getArguments());

		// Get the current user
		$user = $this->app->getIdentity();

		// Guest users are not affected by this restriction
		if (!$user->id)
		{
			return;
		}

		// Get the plan restrictions from plugin parameters
		$planRestrictions = $this->params->get('plan_restrictions', []);

		// If no restrictions are configured, allow subscription
		if (empty($planRestrictions))
		{
			return;
		}

		// Get active plan IDs for the current user
		$activePlanIds = OSMembershipHelperSubscription::getActivePlanIdsForUser($user->id);

		// If user has no active subscriptions, allow subscription
		if (empty($activePlanIds))
		{
			return;
		}

		// Check each restriction rule
		foreach ($planRestrictions as $restriction)
		{
			// Check if this restriction applies to the target plan
			$targetPlanId = (int) ($restriction->plan_id ?? 0);

			if ($targetPlanId !== (int) $row->id)
			{
				continue;
			}

			// Get the blocking plan IDs from the restriction
			$blockingPlanIds = array_filter(ArrayHelper::toInteger($restriction->active_plan_ids ?? []));

			if (empty($blockingPlanIds))
			{
				continue;
			}

			// Check if user has any active subscription of the blocking plans
			$matchingPlans = array_intersect($activePlanIds, $blockingPlanIds);

			if (!empty($matchingPlans))
			{
				// User has active subscription of one of the blocking plans, prevent subscription
				$this->addResult($event, false);

				return;
			}
		}
	}
}
