<?php
/**
 * @package        Joomla
 * @subpackage     Membership Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2012 - 2021 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Registry\Registry;

class plgOSMembershipMPDF extends CMSPlugin
{
	/**
	 * Application object.
	 *
	 * @var    JApplicationCms
	 */
	protected $app;

	/**
	 * Database object.
	 *
	 * @var    JDatabaseDriver
	 */
	protected $db;

	/**
	 * Constructor.
	 *
	 * @param   object  &$subject  The object to observe
	 * @param   array    $config
	 */
	public function __construct(&$subject, $config = array())
	{
		// Add a check to make sure the plugin will only be run on PHP 7.2.0+
		if (version_compare(PHP_VERSION, '7.2.0', '<'))
		{
			return;
		}

		parent::__construct($subject, $config);
	}

	/**
	 * Generate multiple pages PDF files. See OSMembershipHelperPdf::generateOnePage for sample implementation using
	 * TCPDF library
	 *
	 * @param   string  $pageContent
	 * @param   string  $filePath
	 * @param   string  $options
	 *
	 * @return bool
	 */
	public function onBeforeGenerateOnePagePDF($pageContent, $filePath, $options)
	{
		require_once __DIR__ . '/mpdf/vendor/autoload.php';

		$options    = new Registry($options);
		$pdfOptions = [
			'format' => $options->get('PDF_PAGE_FORMAT', 'A4') . '-' . $options->get('PDF_PAGE_ORIENTATION', 'L'),
		];

		$mpdf = new \Mpdf\Mpdf($pdfOptions);
		$this->setPDFOptions($mpdf, $options);

		$pageContent = OSMembershipHelper::convertImgTags($pageContent);

		$mpdf->WriteHTML($pageContent);
		$mpdf->Output($filePath);

		// Need to return true to tell Membership Pro that the PDF file was successfully generated
		return true;
	}

	/**
	 * Generate multiple pages PDF files. See OSMembershipHelperPdf::generateMultiplePages for sample implementation
	 * using TCPDF library
	 *
	 * @param   array   $pageContents
	 * @param   string  $filePath
	 * @param   string  $options
	 *
	 * @return bool
	 */
	public function onBeforeMultiplePagesPDF($pageContents, $filePath, $options)
	{
		require_once __DIR__ . '/mpdf/vendor/autoload.php';

		$options    = new Registry($options);
		$pdfOptions = [
			'format' => $options->get('PDF_PAGE_FORMAT', 'A4') . '-' . $options->get('PDF_PAGE_ORIENTATION', 'L'),
		];

		$mpdf = new \Mpdf\Mpdf($pdfOptions);
		$this->setPDFOptions($mpdf, $options);

		$mpdf->WriteHTML($pageContents[0]);

		for ($i = 1, $n = count($pageContents); $i < $n; $i++)
		{
			$mpdf->AddPage();

			$pageContent = $pageContents[$i];
			$pageContent = OSMembershipHelper::convertImgTags($pageContent);

			$mpdf->WriteHTML($pageContent);
		}

		$mpdf->Output($filePath);

		// Need to return true to tell Membership Pro that the PDF file was successfully generated
		return true;
	}

	/**
	 * Method to get option use for MPDF to generate PDF file
	 *
	 * @param   \Mpdf\Mpdf  $mpdf
	 * @param   Registry    $options
	 */
	private function setPDFOptions($mpdf, $options)
	{
		$mpdf->SetTitle($options->get('title'));
		$mpdf->SetCreator($this->app->get('sitename'));

		// Sadly the Image method from MPDF does not work for some reasons, so background image for Member Card
		// won't work yet. We will need to handle it using css instead

		if ($options->get('bg_image'))
		{
			$backgroundImage  = $options->get('bg_image');
			$backgroundLeft   = $options->get('bg_left', '');
			$backgroundTop    = $options->get('bg_top', '');
			$backgroundWidth  = $options->get('bg_width', 0);
			$backgroundHeight = $options->get('bg_height', 0);
		}
	}
}
