<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Plugin\HelpdeskPro\TicketsHistory\Extension;

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Database\DatabaseInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;

defined('_JEXEC') or die;

class TicketsHistory extends CMSPlugin implements SubscriberInterface
{
	use DatabaseAwareTrait;

	/**
	 * The application object. This is added here for backward compatible purpose
	 *
	 * @var CMSApplication
	 */
	protected $app;


	public function __construct(
		DispatcherInterface $dispatcher,
		array $config,
		CMSApplicationInterface $application,
		DatabaseInterface $db
	) {
		parent::__construct($dispatcher, $config);

		$this->setApplication($application);
		$this->setDatabase($db);
	}


	/**
	 * Returns an array of events this subscriber will listen to.
	 *
	 * @return array
	 *
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			'onViewTicket' => 'onViewTicket',
		];
	}

	/**
	 * Display ticket history of the current user
	 *
	 * @param   Event  $event
	 *
	 * @return void
	 */
	public function onViewTicket(Event $event): void
	{
		if (!$this->getApplication()->getIdentity()->id)
		{
			return;
		}

		[$row] = array_values($event->getArguments());

		$limit      = (int) $this->params->get('limit', 10);
		$dateFormat = $this->params->get('date_format', 'm-d-Y');
		$db         = $this->getDatabase();
		$query      = $db->getQuery(true)
			->select('id, subject, created_date')
			->from('#__helpdeskpro_tickets')
			->where('(user_id = ' . (int) $row->user_id . ' OR email = ' . $db->quote($row->email) . ')')
			->order('id DESC');

		$db->setQuery($query, 0, $limit);
		$rows = $db->loadObjectList();

		if (!count($rows))
		{
			return;
		}

		ob_start();

		require PluginHelper::getLayoutPath('helpdeskpro', 'tickethistory');

		$output = ob_get_clean();

		HelpdeskProHelper::addEventListenerResult($event, $output);
	}
}