<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;

/**
 * Layout variables
 *
 * @var array $rowAttachments
 */

$app = $this->getApplication();

if ($app->isClient('site'))
{
	$bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();
}
else
{
	$bootstrapHelper = HelpdeskProHelperBootstrap::getInstance();
}
?>

<tr>
	<th colspan="2" class="hdp-ticket-attachments-heading <?php echo $bootstrapHelper->getClassMapping('btn-primary'); ?>"><?php echo Text::_('HDP_TICKET_ATTACHMENTS'); ?></th>
</tr>
<?php
$imageFileTypes  = ['gif', 'jpg', 'jpeg', 'png'];
$attachmentsPath = JPATH_ROOT . '/media/com_helpdeskpro/attachments/';

foreach ($rowAttachments as $rowAttachment)
{
	if ($rowAttachment->original_filenames)
	{
		$originalFileNames = explode('|', $rowAttachment->original_filenames);
		$attachments       = explode('|', $rowAttachment->attachments);

		for ($i = 0, $n = count($originalFileNames); $i < $n; $i++)
		{
			$filename = $attachments[$i];
			$filePath = $attachmentsPath . $filename;

			if (file_exists($attachmentsPath . $filename))
			{
				$fileExt = strtolower(HelpdeskProHelper::getFileExt($filename));

				if (in_array($fileExt, $imageFileTypes))
				{
					$linkClass = 'class="hdp-modal"';
				}
				else
				{
					$linkClass = '';
				}
				?>
				<tr>
					<td colspan="2">
						<a <?php echo $linkClass; ?>
							href="<?php echo Route::_('index.php?option=com_helpdeskpro&task=ticket.download_attachment&filename=' . $filename . '&original_filename=' . $originalFileNames[$i]); ?>"><?php echo $originalFileNames[$i]; ?></a>
						(<?php echo HelpdeskProHelper::getSize($filePath); ?>)
					</td>
				</tr>
				<?php
			}
		}
	}
}
