<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

namespace OSSolution\HelpdeskPro\Plugin\HelpdeskPro\Attachments\Extension;

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Database\DatabaseAwareTrait;
use Joomla\Database\DatabaseInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use OSSolution\HelpdeskPro\Site\Helper\Helper as HelpdeskProHelper;

defined('_JEXEC') or die;

class Attachments extends CMSPlugin implements SubscriberInterface
{
	use DatabaseAwareTrait;

	/**
	 * The application object. This is added here for backward compatible purpose
	 *
	 * @var CMSApplication
	 */
	protected $app;

	/**
	 * Constructor
	 *
	 * @param   DispatcherInterface      $dispatcher
	 * @param   array                    $config
	 * @param   CMSApplicationInterface  $application
	 * @param   DatabaseInterface        $db
	 */
	public function __construct(
		DispatcherInterface $dispatcher,
		array $config,
		CMSApplicationInterface $application,
		DatabaseInterface $db
	) {
		parent::__construct($dispatcher, $config);

		$this->setApplication($application);
		$this->setDatabase($db);
	}


	/**
	 * Returns an array of events this subscriber will listen to.
	 *
	 * @return array
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			'onViewTicket' => 'onViewTicket',
		];
	}

	/**
	 * Display assign ticket form
	 *
	 * @param   Event  $event
	 *
	 * @return void
	 */
	public function onViewTicket(Event $event): void
	{
		[$row] = array_values($event->getArguments());

		$db    = $this->getDatabase();
		$query = $db->getQuery(true)
			->select('attachments, original_filenames')
			->from('#__helpdeskpro_messages')
			->where('ticket_id = ' . $row->id);
		$db->setQuery($query);
		$rowAttachments = array_merge([$row], $db->loadObjectList());
		$hasAttachment  = false;

		foreach ($rowAttachments as $rowAttachment)
		{
			if ($rowAttachment->original_filenames)
			{
				$hasAttachment = true;
				break;
			}
		}

		if (!$hasAttachment)
		{
			return;
		}

		ob_start();

		require PluginHelper::getLayoutPath('helpdeskpro', 'attachments');

		$output = ob_get_clean();

		HelpdeskProHelper::addEventListenerResult($event, $output);
	}
}