<?php
/**
 * @package        Joomla
 * @subpackage     Helpdesk Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2013 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */

defined('_JEXEC') or die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use OSSolution\HelpdeskPro\Plugin\Finder\HelpdeskPro\Extension\HelpdeskPro;

return new class () implements ServiceProviderInterface {
	/**
	 * Registers the service provider with a DI container.
	 *
	 * @param   Container  $container  The DI container.
	 *
	 * @return  void
	 */
	public function register(Container $container)
	{
		$container->set(
			PluginInterface::class,
			function (Container $container) {
				$dispatcher = $container->get(DispatcherInterface::class);
				$plugin     = new HelpdeskPro(
					$dispatcher,
					(array) PluginHelper::getPlugin('finder', 'helpdeskpro')
				);

				$plugin->setApplication(Factory::getApplication());
				$plugin->setDatabase(Factory::getContainer()->get('DatabaseDriver'));

				return $plugin;
			}
		);
	}
};
