<?php
/**
 * @package         Joomla.Plugin
 * @subpackage      Captcha.jdcaptcha
 * @author          Tuan Pham Ngoc
 *
 * @copyright       Copyright (C) 2024 JoomDonation Team
 * @license         GNU General Public License version 3, or later
 */

\defined('_JEXEC') or die;

/**
 * Layout variables
 *
 * @var int    $index
 * @var string $source
 * @var string $honeypotFieldName
 */

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Language\Text;
?>
<div class="jd-captcha-input-container">
	<input type="text" name="jd_captcha_input" class="form-control uk-input jd-captcha-input">
	<img src="<?php echo $source; ?>" class="jd-captcha-image" id="jd-captcha-image-<?php echo $index; ?>" alt="<?php echo Text::_('JD_CAPTCHA_CAPTCHA'); ?>" />
	<a href="#" onclick="return false;" class="jd-captcha-reload" data-captcha-index="<?php echo $index; ?>" title="<?php echo Text::_('JD_CAPTCHA_RELOAD'); ?>">
		<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="jd-capcha-reload-icon">
			<path stroke-linecap="round" stroke-linejoin="round" d="M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0 3.181 3.183a8.25 8.25 0 0 0 13.803-3.7M4.031 9.865a8.25 8.25 0 0 1 13.803-3.7l3.181 3.182m0-4.991v4.99" />
		</svg>
	</a>
</div>

<input type="hidden" name="jd_captcha_index" value="<?php echo $index; ?>">
<input type="text" class="jd-not-in-view-port" name="<?php echo $honeypotFieldName; ?>" tabindex="-1" autocomplete="nope" />

<?php
if (ComponentHelper::isEnabled('com_kunena'))
{
?>
	<input type="hidden" name="g-recaptcha-response" value="fake_google_captcha_response" />
<?php
}
?>

<p class="jd-captcha-instruction-text" id="jd-captcha-instruction-<?php echo $index; ?>">
	<?php
		if ($this->captchaType == 1)
		{
			echo Text::_('JD_CAPTCHA_TEXT_INSTRUCTION');
		}
		else
		{
			echo Text::_('JD_CAPTCHA_MATH_INSTRUCTION');
		}
	?>
</p>