<?php
/**
 * @package         Joomla.Plugin
 * @subpackage      Captcha.jdcaptcha
 * @author          Tuan Pham Ngoc
 *
 * @copyright       Copyright (C) 2024 JoomDonation Team
 * @license         GNU General Public License version 3, or later
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Factory;

class PlgCaptchaJDCaptchaInstallerScript
{
	/**
	 * Minimum supported Joomla version
	 */
	public const MIN_JOOMLA_VERSION = '4.0.0';

	/**
	 * Minimum supported PHP version
	 */
	public const MIN_PHP_VERSION = '7.2.5';

	/**
	 * Checks compatibility in the preflight event
	 *
	 * @param $type
	 * @param $parent
	 *
	 * @return bool
	 * @throws Exception
	 */
	public function preflight($type, $parent)
	{
		if ($type === 'uninstall')
		{
			return true;
		}

		if (version_compare(JVERSION, self::MIN_JOOMLA_VERSION, '<'))
		{
			Factory::getApplication()->enqueueMessage(
				'Cannot install Captcha - JD Captcha in a Joomla! release prior to ' . self::MIN_JOOMLA_VERSION,
				CMSApplicationInterface::MSG_ERROR
			);

			return false;
		}

		if (version_compare(PHP_VERSION, self::MIN_PHP_VERSION, '<'))
		{
			Factory::getApplication()->enqueueMessage(
				'Events Booking requires PHP ' . self::MIN_PHP_VERSION . '+ to work. Please contact your hosting provider, ask them to update PHP version for your hosting account.',
				CMSApplicationInterface::MSG_ERROR
			);

			return false;
		}

		return true;
	}
}
