<?php


/**

 * @package     mod_jt_contentslider

 * @copyright   Copyright (C) 2007 - 2024 http://www.joomlatema.net, Inc. All rights reserved.

 * @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL

 * @author     	JoomlaTema.Net

 * @link 		http://www.joomlatema.net

 **/



defined('_JEXEC') or die;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Factory;
$jinput = Factory::getApplication()->getInput();
$configClass = OSPHelper::loadConfig();

?>
<script src="<?php echo Uri::root(); ?>media/com_osproperty/assets/js/ajax.js"></script>
<div class="jtcs_item_wrapper jt-cs" style="padding:<?php echo $params->get('content_padding');?>;">

<?php if( $params->get('show_pretext')==1 ): ?>

<div class="jt-pretext">

<span class="pretext_title"><?php echo $params->get('pretext_title');?></span>

<p class="pretext"><?php echo $params->get('pretext');?></p>

</div>

<?php endif; ?>

<div class="jtcs<?php echo $module->id; ?> owl-carousel owl-carousel owl-theme slides_container">

<?php 

	$n = 1;

	$morecatlinks = array();

	foreach ($list as $i =>  $item) : 

		// Check whether thumbnail image is exist or not. If it's not then start thumbnail generation process

		

			?>

			 <div class="slide osp-property-item" style="padding:<?php echo $params->get('article_block_padding');?>;margin:<?php echo $params->get('article_block_margin');?>" data-slide-index="<?php echo $i; ?>">
            <div class="osp-property-card">
                
                <!-- Property Image -->
                <?php if( $params->get('show_thumbnail') ==1): ?>
                <div class="osp-property-image">
                    <a href="<?php echo $item->link; ?>" class="osp-image-link" title="<?php echo $item->title?>">
                        <img src="<?php echo $item->thumbnail; ?>" alt="<?php echo $item->title?>" />
                    </a>
                    
                    <!-- For Sale Badge - Top Right -->
                    <div class="osp-for-sale-badge">
                        <span><?php echo $item->type_name;?></span>
                    </div>
                    
                    <!-- Photo Count - Bottom Right -->
                    <?php if(!empty($item->photo_count)): ?>
                    <div class="osp-photo-count">
                        <i class="fa fa-camera"></i>
                        <span><?php echo $item->photo_count; ?></span>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                
                <!-- Property Content -->
                <div class="osp-property-content">
                    
                    <!-- Property Title -->
                    <?php if($params->get('show_title')== 1):?>
                    <div class="osp-property-title">
                        <a href="<?php echo $item->link; ?>"><?php echo $item->title_cut; ?></a>
                    </div>
                    <?php endif; ?>
                    
                    <!-- Property Price -->
                    <div class="osp-property-price">
                        <span class="osp-price-amount"><?php echo $item->price;?></span>
                    </div>
                    
                    <!-- Property Description -->
                    <?php 
                    if($params->get('show_intro')== 1):?>
                    <div class="osp-property-description">
                        <?php 
                        $maxChars = (int) $params->get('description_max_chars');
                        if ($maxChars > 0) {
                            $item->pro_small_desc = JHtmlString::truncateComplex(strip_tags($item->pro_small_desc), $maxChars, false, true);
                            $item->pro_small_desc= str_replace('...', $params->get('replacer_text',''), $item->pro_small_desc);
                        } else {
                            $item->pro_small_desc = strip_tags($item->pro_small_desc);
                        }
                        echo $item->pro_small_desc ;
                        ?>
                    </div>
                    <?php endif; ?>
                    
                    <!-- Property Details -->
                    <div class="osp-property-details">
                        <ul class="osp-details-list">
                            <?php if($configClass['listing_show_nbedrooms'] == 1 && $item->bed_room > 0): ?>
                            <li class="osp-detail-item">
                                <i class="fa fa-bed" aria-hidden="true"></i>
                                <span class="osp-detail-value"><?php echo $item->bed_room; ?></span>
                            </li>
                            <?php endif; ?>
                            
                            <?php if($configClass['listing_show_nbathrooms'] == 1 && $item->bath_room > 0): ?>
                            <?php if($item->bed_room > 0): ?>
                            <li class="osp-detail-separator">|</li>
                            <?php endif; ?>
                            <li class="osp-detail-item">
                                <i class="fa fa-bath" aria-hidden="true"></i>
                                <span class="osp-detail-value"><?php echo $item->bath_room; ?></span>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    
                    <!-- Property Footer -->
                    <div class="osp-property-footer">
                        <div class="osp-agent-info">
                            <?php if(!empty($item->agent_photo)): ?>
                            <img src="<?php echo $item->agent_photo; ?>" alt="<?php echo $item->agent_name; ?>" class="osp-agent-avatar">
                            <?php endif; ?>
                            <?php
                            $needs = [];
                            $needs[] = "property_details";
                            $needs[] = $item->id;
                            $agentItemId = OSPRoute::getItemid($needs);
                            //echo $agentItemId;
                            ?>
                            <span class="osp-agent-name"><a title="<?php echo $row->agent_name?>" href="<?php echo Route::_('index.php?option=com_osproperty&task=agent_info&id='.$item->agent_id.'&Itemid='.$agentItemId);?>"><?php echo !empty($item->agent_name) ? $item->agent_name : ''; ?></a></span>
                        </div>
                        <div class="osp-property-actions">
                            <a href="<?php echo $item->link; ?>" class="osp-action-btn osp-share-btn" title="<?php echo Text::_('OS_DETAILS');?>">
                                <i class="fa fa-share"></i>
                            </a>
                            <?php
														if($configClass['show_compare_task'] == 1)
														{
															if(! OSPHelper::isInCompareList($item->id))
															{
																$msg = Text::_('OS_DO_YOU_WANT_TO_ADD_PROPERTY_TO_COMPARE_LIST');
																$msg = str_replace("'","\'",$msg);
																?>
																
																	<span id="compare<?php echo $item->id?>">
																		<a onclick="javascript:osConfirmExtend('<?php echo $msg; ?>','ajax_addCompare','<?php echo $item->id ?>','<?php echo Uri::root() ?>','compare<?php echo $item->id;?>','house','listing')" href="javascript:void(0)" title="<?php echo Text::_('OS_ADD_TO_COMPARE_LIST');?>" class="osp-action-btn osp-add-btn">
																			<i class="fa fa-plus"></i>
																		</a>
																	</span>
														
																<?php
															}
															else
															{
																$msg = Text::_('OS_DO_YOU_WANT_TO_REMOVE_PROPERTY_OUT_OF_COMPARE_LIST');
																$msg = str_replace("'", "\'", $msg);
																?>
															
																	<span id="compare<?php echo $item->id?>">
																		<a onclick="javascript:osConfirmExtend('<?php echo $msg; ?>','ajax_removeCompare','<?php echo $item->id ?>','<?php echo Uri::root() ?>','compare<?php echo $item->id;?>','house','listing')" href="javascript:void(0)" title="<?php echo Text::_('OS_REMOVE_FROM_COMPARE_LIST');?>" class="osp-action-btn osp-add-btn activated">
																			<i class="fa fa-plus" style="color:#000;"></i>
																		</a>
																	</span>
															
																<?php
															}
														}
														?>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>

		<?php 

		// More category links

		

	endforeach; ?></div>

</div>

<script defer type="text/javascript">

jQuery(document).ready(function() {

  var el = jQuery('.jtcs<?php echo $module->id; ?>.owl-carousel');

  var carousel;

  var carouselOptions = {

    margin: <?php echo $params->get('marginRight');?>,

    stagePadding: <?php echo $params->get('stagePadding');?>,

	center: <?php echo $params->get('centerItems');?>,

	loop: <?php echo $params->get('infiniteLoop');?>,

    nav: <?php echo $params->get('show_navigation');?>,

    dots: <?php echo $params->get('showDots');?>,

	mouseDrag:<?php echo $params->get('mouseDrag');?>,

	rtl: <?php echo $params->get('rtl');?>,

    slideBy: '<?php echo $params->get('slideBy');?>',

	autoplay:<?php echo $params->get('autoPlay');?>,

	autoplaySpeed:<?php echo $params->get('autoplaySpeed');?>,

	smartSpeed:<?php echo $params->get('smartSpeed');?>,

	autoplayTimeout:<?php echo $params->get('autoplayTimeout');?>,

	autoplayHoverPause:<?php echo $params->get('PauseOnHover');?>,

    responsive: {

      0: {

        items: <?php echo $params->get('slideColumnxs');?>,

        rows: <?php echo $params->get('slideRowxs');?> //custom option not used by Owl Carousel, but used by the algorithm below

      },

      768: {

        items: <?php echo $params->get('slideColumnsm');?>,

        rows:<?php echo $params->get('slideRowsm');?>//custom option not used by Owl Carousel, but used by the algorithm below

      },

      991: {

        items:<?php echo $params->get('slideColumn');?>,

        rows:<?php echo $params->get('slideRow');?> //custom option not used by Owl Carousel, but used by the algorithm below

      }

    }

  };



  //Taken from Owl Carousel so we calculate width the same way

  var viewport = function() {

    var width;

    if (carouselOptions.responsiveBaseElement && carouselOptions.responsiveBaseElement !== window) {

      width = jQuery(carouselOptions.responsiveBaseElement).width();

    } else if (window.innerWidth) {

      width = window.innerWidth;

    } else if (document.documentElement && document.documentElement.clientWidth) {

      width = document.documentElement.clientWidth;

    } else {

      console.warn('Can not detect viewport width.');

    }

    return width;

  };



  var severalRows = false;

  var orderedBreakpoints = [];

  for (var breakpoint in carouselOptions.responsive) {

    if (carouselOptions.responsive[breakpoint].rows > 1) {

      severalRows = true;

    }

    orderedBreakpoints.push(parseInt(breakpoint));

  }

  

  //Custom logic is active if carousel is set up to have more than one row for some given window width

  if (severalRows) {

    orderedBreakpoints.sort(function (a, b) {

      return b - a;

    });

    var slides = el.find('[data-slide-index]');

    var slidesNb = slides.length;

    if (slidesNb > 0) {

      var rowsNb;

      var previousRowsNb = undefined;

      var colsNb;

      var previousColsNb = undefined;



      //Calculates number of rows and cols based on current window width

      var updateRowsColsNb = function () {

        var width =  viewport();

        for (var i = 0; i < orderedBreakpoints.length; i++) {

          var breakpoint = orderedBreakpoints[i];

          if (width >= breakpoint || i == (orderedBreakpoints.length - 1)) {

            var breakpointSettings = carouselOptions.responsive['' + breakpoint];

            rowsNb = breakpointSettings.rows;

            colsNb = breakpointSettings.items;

            break;

          }

        }

      };



      var updateCarousel = function () {

        updateRowsColsNb();



        //Carousel is recalculated if and only if a change in number of columns/rows is requested

        if (rowsNb != previousRowsNb || colsNb != previousColsNb) {

          var reInit = false;

          if (carousel) {

            //Destroy existing carousel if any, and set html markup back to its initial state

            carousel.trigger('destroy.owl.carousel');

            carousel = undefined;

            slides = el.find('[data-slide-index]').detach().appendTo(el);

            el.find('.fake-col-wrapper').remove();

            reInit = true;

          }





          //This is the only real 'smart' part of the algorithm



          //First calculate the number of needed columns for the whole carousel

          var perPage = rowsNb * colsNb;

          var pageIndex = Math.floor(slidesNb / perPage);

          var fakeColsNb = pageIndex * colsNb + (slidesNb >= (pageIndex * perPage + colsNb) ? colsNb : (slidesNb % colsNb));



          //Then populate with needed html markup

          var count = 0;

          for (var i = 0; i < fakeColsNb; i++) {

            //For each column, create a new wrapper div

            var fakeCol = jQuery('<div class="fake-col-wrapper"></div>').appendTo(el);

            for (var j = 0; j < rowsNb; j++) {

              //For each row in said column, calculate which slide should be present

              var index = Math.floor(count / perPage) * perPage + (i % colsNb) + j * colsNb;

              if (index < slidesNb) {

                //If said slide exists, move it under wrapper div

                slides.filter('[data-slide-index=' + index + ']').detach().appendTo(fakeCol);

              }

              count++;

            }

          }

          //end of 'smart' part



          previousRowsNb = rowsNb;

          previousColsNb = colsNb;



          if (reInit) {

            //re-init carousel with new markup

            carousel = el.owlCarousel(carouselOptions);

          }

        }

      };



      //Trigger possible update when window size changes

      jQuery(window).on('resize', updateCarousel);



      //We need to execute the algorithm once before first init in any case

      updateCarousel();

    }

  }



  //init

  carousel = el.owlCarousel(carouselOptions);

});

</script>



<script>

lightbox.option({

    fadeDuration:<?php echo $params->get('fadeDuration',300);?>,

    fitImagesInViewport:<?php echo $params->get('fitImagesInViewport',true);?>,

    imageFadeDuration: <?php echo $params->get('imageFadeDuration',300);?>,

    positionFromTop: <?php echo $params->get('positionFromTop');?>,

    resizeDuration: <?php echo $params->get('resizeDuration',150);?>,

	  })

</script>
