<?php
/**
 * @package     mod_edocman_contentslider
 * @copyright   Copyright (C) 2010 - 2022 http://www.joomdonation.com, Inc.
 * @license     GNU/GPL
 * @author      Joomdonation.com
 * @link        http://www.joomdonation.com
 **/

defined('_JEXEC') or die;

use Joomla\Filesystem\Folder;
use Joomla\Filesystem\File;
use Joomla\Filesystem\Path;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\Utilities\ArrayHelper;
use Joomla\CMS\HTML\HTMLHelper;

// Ensure jQuery and Bootstrap modal
HTMLHelper::_('jquery.framework');
HTMLHelper::_('bootstrap.renderModal');

// Thumbnail folder setup
$modulebase = "mod_ospslider";
$thumb_folder = "/cache/$modulebase/";

if (!is_dir(Path::clean(JPATH_BASE . $thumb_folder))) {
    Folder::create(JPATH_BASE . $thumb_folder);
    File::write(JPATH_BASE . $thumb_folder . 'index.html', "");
}

// Load helper
require_once JPATH_ROOT . '/modules/mod_ospslider/Helper/OSPSliderHelper.php';
$list = OSPSliderHelper::getList($params, $module);

// Params
$show_introtext = $params->get('show_introtext', 1);
$thumb_width = $params->get('thumb_width', 56);
$thumb_loadorder = $params->get('loadorder', 0);
$introtext_truncate = $params->get('limit_intro', 200);
$limit_title = $params->get('title_max_chars', 25);
$show_morecat_links = $params->get('show_more_in', 1);
$show_date = $params->get('show_date', 1);
$show_date_type = $params->get('show_date_type', 1);
$custom_date_format = $params->get('custom_date_format', "");
$show_default_thumb = $params->get('show_default_thumb', 0);
$use_caption = $params->get('use_caption', 0);

$tmp = $params->get('keep_aspect_ratio', 'true');
$tmp2 = $params->get('thumb_height', 200);
$thumb_height = ($tmp == 'true') ? '' : (int)$tmp2;

$openTarget = $params->get('open_target', '_parent');
$modal = $params->get('modalbox');

$thumbPath = JPATH_BASE . '/cache/' . $module->module . '/';

$itemsPerRow = (int)$params->get('items_per_rows', 3);
$itemsPerCol = (int)$params->get('items_per_cols', 1);
$moduleclass_sfx = $params->get('moduleclass_sfx');
$imgClass = $params->get('hovereffect', 1) ? 'class="hovereffect"' : '';
$maxPages = $itemsPerRow * $itemsPerCol;
$pages = array_chunk($list, $maxPages);
$totalPages = count($pages);
$itemWidth = 100 / $itemsPerRow;

$tmp = $params->get('module_height', 'auto');
$moduleHeight = ($tmp == 'auto') ? 'auto' : (int)$tmp . 'px';
$tmp = $params->get('module_width', 'auto');
$moduleWidth = ($tmp == 'auto') ? 'auto' : (int)$tmp . 'px';
$moduleWidthWrapper = ($tmp == 'auto') ? 'auto' : (int)$tmp . 'px';

$auto_start = $params->get('auto_start', 1);
$next_back = $params->get('next_back', 0);
$butlet = $params->get('butlet', 1);

$showReadmore = $params->get('show_readmore', '1');
$showTitle = $params->get('show_title', '1');
$show_category_name = $params->get('show_category_name', 0);
$show_category_name_as_link = $params->get('show_category_name_as_link', 0);

$showDate = $params->get('show_date', '0');
$showAuthor = $params->get('show_author', '0');
$show_intro = $params->get('show_intro', '0');

$thumbWidth = (int)$params->get('thumb_width', 200);
$thumbHeight = (int)$params->get('thumb_height', 150);

$image_crop = $params->get('image_crop', '0');
$show_image = $params->get('show_image', '0');
$effect = $params->get('next_back_effect', 'slider') . ',' . $params->get('bullet_effect', 'slider');
$slideEasing = $params->get('effect', 'easeInQuad');
$preloadImg = Uri::root() . 'modules/mod_os_contentslider/tmpl/images/loading.gif';
$paging = $params->get('butlet', 0) > 0 ? 'true' : 'false';
$play = $auto_start ? (int)$params->get('interval', '5000') : 0;
$hoverPause = $params->get('pause_hover', 1) > 0 ? 'true' : 'false';
$duration = (int)$params->get('duration', '1000');
$autoHeight = $params->get('auto_height', 0) > 0 ? 'true' : 'false';
$fadeSpeed = (int)$params->get('duration', '1000');
$modid = '#oscontentslider' . $module->id;

// Add CSS/JS
HTMLHelper::_('jquery.framework');
$doc = Factory::getApplication()->getDocument();
$wa = $doc->getWebAssetManager();
$wa->registerAndUseScript('mod_ospslider.lightbox-plus-jquery.js', Uri::root() . '/modules/' . $modulebase . '/tmpl/assets/js/lightbox-plus-jquery.js');
$wa->registerAndUseScript('mod_ospslider.owl.carousel.js', Uri::root() . '/modules/' . $modulebase . '/tmpl/assets/js/owl.carousel.js');

$wa->registerAndUseStyle('mod_ospslider.style.css', Uri::root() . 'modules/' . $modulebase . '/tmpl/assets/css/style.css');
$wa->registerAndUseStyle('mod_ospslider.ospslider.css', Uri::root() . 'modules/' . $modulebase . '/tmpl/assets/css/ospslider.css');
$wa->registerAndUseStyle('mod_ospslider.lightbox.css', Uri::root() . 'modules/' . $modulebase . '/tmpl/assets/css/lightbox.css');

// Load layout
require ModuleHelper::getLayoutPath($modulebase, $params->get('layout', 'default'));
