<?php
/**
 * @package     mod_os_contentslider - OS ContentSlider Module
 * @version     1
 * @created     July 2013
 * @author      Dang Thuc Dam
 * @email       damdt@joomservices.com
 * @website     http://joomservice.com
 * @support     http://joomservice.com
 * @copyright   Copyright (C) 2013 Joomdonation. All rights reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Form\Field\ListField;

class JFormFieldOSPMultipropertytypes extends ListField
{
    protected $type = 'OSPMultipropertytypes'; // the form field type
    protected array $options = [];

    protected function getOptions(): array
    {
        $path = JPATH_ROOT . '/components/com_osproperty';
        if (is_dir($path)) {
            // Get the database object (Joomla 5+)
            $db = Factory::getContainer()->get('db');

            // Build query
            $query = $db->getQuery(true)
                ->select('id AS value, type_name AS text')
                ->from($db->quoteName('#__osrs_types'))
                ->where($db->quoteName('published') . ' = 1')
                ->order('type_name');
            $db->setQuery($query);

            $results = $db->loadObjectList();
            if (!empty($results)) {
                foreach ($results as $item) {
                    $this->options[] = HTMLHelper::_('select.option', $item->value, $item->text);
                }
            }
        }

        return array_merge(parent::getOptions(), $this->options);
    }

    // Only needed if you have a custom field name handling for multi-select
    public function bind($array, $ignore = '')
    {
        if (isset($array['field-name']) && is_array($array['field-name'])) {
            $array['field-name'] = implode(',', $array['field-name']);
        }

        return parent::bind($array, $ignore);
    }
}
