<?php
/**
 * @package     mod_os_contentslider - OS ContentSlider Module
 * @version     1
 * @created     July 2013
 * @author      Dang Thuc Dam
 * @email       damdt@joomservices.com
 * @website     http://joomservice.com
 * @support     http://joomservice.com
 * @copyright   Copyright (C) 2013 Joomdonation. All rights reserved.
 * @license     http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Form\Field\ListField;

class JFormFieldOSPMulticategories extends ListField
{
    protected $type = 'OSPMulticategories'; // The form field type
    protected array $options = [];

    protected function getOptions(): array
    {
        $path = JPATH_ROOT . '/components/com_osproperty';
        if (is_dir($path)) {
            // Get the database object (Joomla 5+)
            $db = Factory::getContainer()->get('db');

            // Generating query
            $query = $db->getQuery(true)
                ->select('c.category_name AS name, c.id AS id, c.parent_id AS parent')
                ->from($db->quoteName('#__osrs_categories', 'c'))
                ->where($db->quoteName('published') . ' = 1')
                ->order('c.category_name, c.parent_id ASC');

            $db->setQuery($query);
            $results = $db->loadObjectList();

            if (!empty($results)) {
                $temp_options = [];

                foreach ($results as $item) {
                    $temp_options[] = [$item->id, $item->name, $item->parent];
                }

                foreach ($temp_options as $option) {
                    if ($option[2] == 0) {
                        $this->options[] = HTMLHelper::_('select.option', $option[0], $option[1]);
                        $this->recursive_options($temp_options, 1, $option[0]);
                    }
                }
            }
        }
        return array_merge(parent::getOptions(), $this->options);
    }

    // Recursive function for building options
    protected function recursive_options(array $temp_options, int $level, int $parent): void
    {
        foreach ($temp_options as $option) {
            if ($option[2] == $parent) {
                $level_string = str_repeat('- - ', $level);
                $this->options[] = HTMLHelper::_('select.option', $option[0], $level_string . $option[1]);
                $this->recursive_options($temp_options, $level + 1, $option[0]);
            }
        }
    }

    // No need for bind override unless you have a custom field-name, if so, update as below
    public function bind($array, $ignore = '')
    {
        if (isset($array['field-name']) && is_array($array['field-name'])) {
            $array['field-name'] = implode(',', $array['field-name']);
        }
        return parent::bind($array, $ignore);
    }
}
