<?php
/*------------------------------------------------------------------------
# default.php - mod_ospropertyrandom
# ------------------------------------------------------------------------
# author    Dang Thuc Dam
# copyright Copyright (C) 2016 joomdonation.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

$db = Factory::getContainer()->get('db');
$moduleId = 'osp-random-' . $module->id;
?>

<div class="osp-random-properties-wrapper" id="<?php echo $moduleId; ?>">
    <div class="osp-random-grid osp-random-cols-<?php echo $properties_per_row; ?>">
        <?php
        $k = 0;
        if($enable_nav == 1 && $nproperties > 0) {
            $npages = ceil(count($properties) / $nproperties);
            $startPoint = 0;
            $pageClass = 1;
        }
        
        foreach ($properties as $property) {
            $k++;
            
            if($enable_nav == 1 && $nproperties > 0) {
                if($startPoint == $nproperties) {
                    $startPoint = 0;
                    $pageClass++;
                }
                $startPoint++;
                $pageClassAttr = 'osp-random-page-' . $pageClass;
                $displayStyle = ($pageClass > 1) ? 'style="display:none;"' : '';
            } else {
                $pageClassAttr = '';
                $displayStyle = '';
            }
            
            $itemid = modOSpropertyramdomHelper::getItemid($property->id);
            $propertyLink = Route::_('index.php?option=com_osproperty&task=property_details&id='.$property->id.'&Itemid='.$itemid);
            ?>
            
            <div class="osp-random-property-card <?php echo $pageClassAttr; ?>" <?php echo $displayStyle; ?>>
                <div class="osp-random-card-inner">
                    
                    <?php if($show_photo == 1): ?>
                    <!-- Property Image -->
                    <div class="osp-random-card-image">
                        <a href="<?php echo $propertyLink; ?>" title="<?php echo Text::_('OSPROPERTY_MOREDETAILS'); ?>">
                            <?php if ($property->photo != ''): ?>
                                <?php OSPHelper::showPropertyPhoto($property->photo,'medium',$property->id,'','','',0); ?>
                            <?php else: ?>
                                <img alt="<?php echo htmlspecialchars($property->pro_name); ?>" 
                                     src="<?php echo JURI::root(true); ?>/media/com_osproperty/assets/images/nopropertyphoto.png" />
                            <?php endif; ?>
                        </a>
                        
                        <!-- Badges -->
                        <div class="osp-random-badges">
                            <?php if($property->isFeatured == 1): ?>
                                <span class="osp-random-badge osp-random-badge-featured">
                                    <?php echo Text::_('OS_FEATURED'); ?>
                                </span>
                            <?php endif; ?>
                            
                            <?php if(($configClass['active_market_status'] == 1) && ($property->isSold > 0)): ?>
                                <span class="osp-random-badge osp-random-badge-market">
                                    <?php echo OSPHelper::returnMarketStatus($property->isSold); ?>
                                </span>
                            <?php endif; ?>
                            
                            <?php if($show_type == 1): ?>
                                <span class="osp-random-badge osp-random-badge-type osp-random-type-<?php echo $property->pro_type; ?>">
                                    <?php echo OSPHelper::loadTypeName($property->pro_type); ?>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <!-- Property Content -->
                    <div class="osp-random-card-content">
                        
                        <!-- Title & Price -->
                        <div class="osp-random-card-header">
                            <h3 class="osp-random-card-title">
                                <a href="<?php echo $propertyLink; ?>" title="<?php echo Text::_('OSPROPERTY_MOREDETAILS'); ?>">
                                    <?php
                                    if($property->ref != "" && $configClass['show_ref'] == 1) {
                                        echo '<span class="osp-random-ref">' . $property->ref . '</span> ';
                                    }
                                    
                                    $arr_title_word = explode(' ', $property->pro_name);
                                    if (!$limit_title_word || $limit_title_word > count($arr_title_word)) {
                                        echo htmlspecialchars($property->pro_name);
                                    } else {
                                        $tmp_title = array();
                                        for ($i=0; $i < $limit_title_word; $i++) {
                                            $tmp_title[] = $arr_title_word[$i];
                                            if ($i > 2*count($arr_title_word)/3 && stristr($arr_title_word[$i],'.')) break;
                                        }
                                        echo htmlspecialchars(implode(' ', $tmp_title)) . '...';
                                    }
                                    ?>
                                </a>
                            </h3>
                            
                            <?php if ($show_price): ?>
                                <div class="osp-random-card-price">
                                    <?php echo $property->price_information; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <!-- Category -->
                        <?php if($show_category == 1): ?>
                            <div class="osp-random-card-category">
                                <span class="osp-random-label"><?php echo Text::_('OSPROPERTY_CATEGORY'); ?>:</span>
                                <?php
                                $link = Route::_('index.php?option=com_osproperty&task=category_details&id='.$property->catid.'&Itemid='.$itemid);
                                echo '<a href="'.$link.'">' . htmlspecialchars($property->category_name) . '</a>';
                                ?>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Address -->
                        <?php if ($show_address && $property->show_address == 1): ?>
                            <div class="osp-random-card-address">
                                <i class="osp-random-icon-location"></i>
                                <?php echo OSPHelper::generateAddress($property); ?>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Description -->
                        <?php if (($show_small_desc == 1) && ($property->pro_small_desc != "")): ?>
                            <div class="osp-random-card-description">
                                <?php
                                $small_desc = $property->pro_small_desc;
                                $small_descArr = explode(" ", $small_desc);
                                $count_small_desc = count($small_descArr);
                                
                                if(($count_small_desc > $limit_word) && ($limit_word > 0)) {
                                    echo implode(" ", array_slice($small_descArr, 0, $limit_word)) . "...";
                                } else {
                                    echo $small_desc;
                                }
                                ?>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Property Features -->
                        <?php
                        $features = array();
                        if(($show_bedrooms == 1) && ($property->bed_room > 0)) {
                            $features[] = '<span class="osp-random-feature"><i class="osp-random-icon-bed"></i> ' . $property->bed_room . '</span>';
                        }
                        if(($show_bathrooms == 1) && ($property->bath_room > 0)) {
                            $features[] = '<span class="osp-random-feature"><i class="osp-random-icon-bath"></i> ' . OSPHelper::showBath($property->bath_room) . '</span>';
                        }
                        if(($show_parking == 1) && ($property->parking != "")) {
                            $features[] = '<span class="osp-random-feature"><i class="osp-random-icon-parking"></i> ' . $property->parking . '</span>';
                        }
                        if(($show_square == 1) && ($property->square_feet > 0)) {
                            $features[] = '<span class="osp-random-feature"><i class="osp-random-icon-square"></i> ' . OSPHelper::showSquare($property->square_feet) . ' ' . OSPHelper::showSquareSymbol() . '</span>';
                        }
                        
                        if(count($features) > 0):
                        ?>
                            <div class="osp-random-card-features">
                                <?php echo implode('', $features); ?>
                            </div>
                        <?php endif; ?>
                        
                    </div>
                </div>
            </div>
            
        <?php } ?>
    </div>
    
    <?php if($enable_nav == 1 && $nproperties > 0 && $npages > 1): ?>
    <!-- Pagination -->
    <div class="osp-random-pagination">
        <?php for($i=1; $i<=$npages; $i++): ?>
            <button type="button" 
                    class="osp-random-page-btn <?php echo ($i == 1) ? 'osp-random-active' : ''; ?>" 
                    data-page="<?php echo $i; ?>"
                    aria-label="<?php echo Text::sprintf('Page %s', $i); ?>">
                <?php echo $i; ?>
            </button>
        <?php endfor; ?>
    </div>
    
    <script>
    (function() {
        const moduleId = '<?php echo $moduleId; ?>';
        const module = document.getElementById(moduleId);
        const buttons = module.querySelectorAll('.osp-random-page-btn');
        const totalPages = <?php echo $npages; ?>;
        
        buttons.forEach(button => {
            button.addEventListener('click', function() {
                const targetPage = parseInt(this.getAttribute('data-page'));
                
                // Hide all properties
                for(let i = 1; i <= totalPages; i++) {
                    const properties = module.querySelectorAll('.osp-random-page-' + i);
                    properties.forEach(prop => prop.style.display = 'none');
                }
                
                // Show target page properties
                const targetProperties = module.querySelectorAll('.osp-random-page-' + targetPage);
                targetProperties.forEach(prop => {
                    prop.style.display = 'block';
                    // Add fade-in animation
                    prop.style.animation = 'ospRandomFadeIn 0.5s ease-in-out';
                });
                
                // Update active button
                buttons.forEach(btn => btn.classList.remove('osp-random-active'));
                this.classList.add('osp-random-active');
            });
        });
    })();
    </script>
    <?php endif; ?>
</div>
