<?php
/**
 * ------------------------------------------------------------------------
 * JA Promo Bar module
 * ------------------------------------------------------------------------
 * Copyright (C) 2004-2016 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
 * @license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: J.O.O.M Solutions Co., Ltd
 * Websites: http://www.joomlart.com - http://www.joomlancers.com
 * ------------------------------------------------------------------------
 */

defined('_JEXEC') or die( 'Restricted access' );

jimport('joomla.form.formfield');
jimport('joomla.filesystem.folder');
jimport('joomla.filesystem.file');
jimport( 'joomla.application.module.helper' );

/**
 * Form Field class for the Joomla Framework.
 *
 * @since  2.5
 */
class JFormFieldJacustom extends JFormField
{
	/**
	 * The field type.
	 *
	 * @var		string
	 */
	protected $type = 'Jacustom';
	protected function getInput()
	{
		return '';
	}

	/**
	 * Method to get the field label markup for a spacer.
	 * Use the label text or name from the XML element as the spacer or
	 * Use a hr="true" to automatically generate plain hr markup
	 *
	 * @return  string  The field label markup.
	 *
	 * @since   11.1
	 */
	protected function getLabel()
	{
		return '';
	}

	public function setup(SimpleXMLElement $element, $value, $group = null)
	{
		// save the current config to revision.
		$path = dirname(__FILE__).'/../../../../media/mod_promobar/preset/';
		// attemp to create folder if not exists.
		if(!JFolder::exists($path)) {
			JFolder::create($path, 0755);
		}
		
		$time = time();
		$jaset = JFolder::files($path, $filter = '.', false, false);
		$moduleFormObject = $this->form;
		$moduleParams = $this->form->getValue('params', array());
		
		// default preset
		$defaultpath = dirname(__FILE__).'/../etc/preset/';
		$defaultpre = JFolder::files($defaultpath, $filter = '.', false, false);
		
		// include the params will be save.
		$include = array('bgcolor', 'bg_img', 'bg_image', 'sticky_opacity', 'bordercolor', 'height', 'textcolor', 'control_color', 'custom_css',
						'position', 'animation_speed', 'animation_easing', 'push_page_down', 'always_top',
						'button_color', 'button_text_color', 'button_color_hover', 'button_text_color_hover', 'countdown_bgcolor',
						'countdown_text_color', 'countdown_number_bgcolor', 'countdown_number_color');

		if (!is_array($moduleParams)) {
			$moduleParams = array();
		}
		
		// exclude the params don't need to save.
		foreach ($moduleParams AS $k => $v) {
			if (!in_array($k, $include)) {
				unset($moduleParams->$k);
			}
		}
		// end exclude.
		$defaultval='';
		if (!empty($jaset)) {
			$same = false;
			// check if the current config match one of the previous config.
			foreach ($jaset AS $jset) {
				$content = file_get_contents($path.$jset);
				if ($content === json_encode($moduleParams)) {
					//$defaultval = str_replace(array('.json', ' '),array('',''),$jset);
					$same=true;
				}
			}
			
			// check if the current config match one of the default config.
			foreach ($defaultpre AS $jset) {
				$content = file_get_contents($defaultpath.$jset);
				if ($content === json_encode($moduleParams)) {
					$defaultval = str_replace(array('-','.json','.'),array('','',''),$jset); // set selected.
					$same=true;
				}
			}
			
			if ($same == false) {
				JFile::write($path.'rev-'.date('Y-m-d.H.i.s', $time).'.json', json_encode($moduleParams));
			}
		} else {
			JFile::write($path.'rev-'.date('Y-m-d.H.i.s', $time).'.json', json_encode($moduleParams));
		}
		
		// load all the revision again. so we always had at least 1 value.
		$jaset = JFolder::files($path, $filter = '.', false, false);
		$numb = count($jaset)-19;
		if ($numb>0) { // control only 20 revision show up and delete all other revision
			for ($i=0;$i<($numb-1);$i++) {
				if (file_exists($path.$jaset[$i])) {
					unlink($path.$jaset[$i]);
					unset($jaset[$i]);
				}
			}
		}
		$jsondata = array();
		$presetlist = array();
		
		
		if (!empty($defaultpre)) {
			foreach ($defaultpre AS $k => $jt) {
				$content = file_get_contents($defaultpath.$jt);
				$presetlist[str_replace(array('-','.json','.'),array('','',''),$jt)] = str_replace(array('.json'),array(''),$jt);
				$jsondata[str_replace(array('-','.json','.'),array('','',''),$jt)] = json_decode($content);
			}
		}
		
		unset($jaset[0]); // remove the first one.
		if (!empty($jaset)) {
			// put all the data to json
			foreach ($jaset AS $k => $jt) {
				$content = file_get_contents($path.$jt);
				if ($content === json_encode($moduleParams) && $defaultval == '') {
					$defaultval = str_replace(array('-','.json','.'),array('','',''),$jt); // set selected.
				}
				$presetlist[str_replace(array('-','.json','.'),array('','',''),$jt)] = str_replace(array('.json'),array(''),$jt);
				$jsondata[str_replace(array('-','.json','.'),array('','',''),$jt)] = json_decode($content);
			}
		}

		$doc = JFactory::getDocument();
		$doc->addScript(JUri::root(true).'/modules/mod_japromobar/assets/elements/japreset.js');
		$incparam = implode('", "', $include);
		$script = '
			jQuery(document).ready(function(){
				var $presetdata = '.json_encode($jsondata).';
				var $presetlist = '.json_encode($presetlist).';
				var $defaultval = "'.$defaultval.'";
				var defaultpreset = {};
				var incdefault = ["'.$incparam.'"];
				jQuery("#attrib-settings input,#attrib-settings select,#attrib-settings textarea").each(function(){
					$id = jQuery(this).attr("id");
					for (i=0;i<incdefault.length;i++) {
						if ("jform_params_"+incdefault[i] == $id) {
							defaultpreset[incdefault[i]] = jQuery(this).val();
						}
					}
				});
				
				if ($presetlist.length == undefined) { // undefined mean it had some data.
					for (x in $presetlist) {
						jQuery("select#jform_params_preset").append("<option value=\'"+x+"\'>"+$presetlist[x]+"</option>");
					}
					jQuery("select#jform_params_preset").trigger("liszt:updated");
					if ($defaultval != "") {
						jQuery("select#jform_params_preset").val($defaultval).trigger("liszt:updated");
					}
				}
				jQuery("#jform_params_ga").find("label").each(function(){
					if (jQuery(this).hasClass("active") && jQuery(this).attr("for") == "jform_params_ga1") {
						jQuery("#jform_params_link_url, #jform_params_ga_utm_source, #jform_params_ga_utm_medium, #jform_params_ga_utm_campaign").addClass("required");
					} else {
						jQuery("#jform_params_link_url, #jform_params_ga_utm_source, #jform_params_ga_utm_medium, #jform_params_ga_utm_campaign").removeClass("required");
					}
				});
				
				jQuery("#jform_params_ga").find("label").click(function(){
					if (jQuery(this).attr("for") == "jform_params_ga1") {
						jQuery("#jform_params_link_url, #jform_params_ga_utm_source, #jform_params_ga_utm_medium, #jform_params_ga_utm_campaign").addClass("required");
					} else {
						jQuery("#jform_params_link_url, #jform_params_ga_utm_source, #jform_params_ga_utm_medium, #jform_params_ga_utm_campaign").removeClass("required");
					}
				});

				function setpreset(obj) {
					for (x in obj) {
						value = obj[x];
						ele = jQuery("#jform_params_"+x);
						// check if radio.
						if (ele.prop("tagName") == "FIELDSET") {
							ele.find("input").each(function() {
								if (jQuery(this).val() == value) {
									jQuery(this).next().trigger("click");
								}
							});
						}
						// check if list.
						else if (ele.prop("tagName") == "SELECT") {
							ele.val(value).trigger("change").trigger("liszt:updated");
						}
						// check if color.
						else if (ele.hasClass("minicolors")) {
							ele.val(value).trigger("change");
							ele.next().children().css("background-color", value);
							ele.next().next().children(".minicolors-grid.minicolors-sprite").css("background-color", value);
						}
						// text+media+textare field.
						else {
							ele.val(value).trigger("change");
						}
						
					}
				}
				jQuery("#jform_params_preset").change(function() {
					if ($presetdata[jQuery(this).val()] != undefined && jQuery(this).val() != "") {
						setpreset($presetdata[jQuery(this).val()]);
					}
					if (jQuery(this).val() == "") {
						setpreset(defaultpreset);
					}
				});
			});
		';
		$doc->addScriptDeclaration($script);
		return parent::setup($element, $value, $group);
	}

}
