(function (document, Joomla) {
	document.querySelectorAll('.jd-captcha-reload').forEach(function (item) {
		item.addEventListener('click', function () {
			var index = item.dataset.captchaIndex;
			var url = Joomla.getOptions('jdReloadCaptchaURL') + '&captcha_index=' + index;

			Joomla.request({
				url: url,
				method: 'POST',
				headers: {
					'Content-Type': 'application/json'
				},
				onSuccess: function (resp) {
					const json = JSON.parse(resp);
					document.getElementById('jd-captcha-image-' + index).src = json.imageData;

					if (json.instruction.length > 0)
					{
						document.getElementById('jd-captcha-instruction-' + index).innerHTML  = json.instruction;
					}
				},
				onError: function (error) {
					alert(error.statusText);
				}
			});
		});
	});
})(document, Joomla);