(function (document, Joomla) {
    document.addEventListener('DOMContentLoaded', () => {
        document.getElementById('ajaxButton').addEventListener('click', function () {
            document.querySelector('.ajax-loading').style.display = '';
            const ticketId = Joomla.getOptions('ticket_id');
            const userId = document.getElementById('user_id').value;

            Joomla.request({
                url: Joomla.getOptions('hdpBaseUri') + '/index.php?option=com_helpdeskpro&task=ticket.assign_ticket&id=' + ticketId + '&user_id=' + userId,
                method: 'GET',
                perform: true,
                onSuccess: response => {
                    document.querySelector('.ajax-loading').style.display = 'none';
                    Joomla.renderMessages({
                        message: [Joomla.Text._('HDP_ASSIGN_TICKET_SUCCESS')]
                    });
                },
                onError: error => {
                    alert(error.statusText);
                }
            });
        });
    });
})(document, Joomla);