(function (document, Joomla) {
    document.addEventListener('DOMContentLoaded', () => {
        let commentId = 0;
        const userRole = Joomla.getOptions('userRole', 'user');

        if (!Joomla.getOptions('useHtmlEditor'))
        {
            const modal = new tingle.modal({
                footer: true,
                stickyFooter: false,
                closeMethods: ['escape'],
                closeLabel: "Close",
                cssClass: ['custom-class-1', 'custom-class-2'],
            });

            const btn = Joomla.getOptions('btnClass', 'tingle-btn');
            const btnPrimary = Joomla.getOptions('btnPrimaryClass', 'tingle-btn--primary');
            const btnDanger = Joomla.getOptions('btnDangerClass', 'tingle-btn--danger');
            const editCommentText = Joomla.getOptions('editCommentText', 'Edit Comment');
            const saveButtonLabel = Joomla.getOptions('saveButtonLabel', 'Save');
            const cancelButtonLabel = Joomla.getOptions('cancelButtonLabel', 'Cancel');

            modal.setContent('<h3 class="hdp-edit-comment-heading">' + editCommentText + '</h3><textarea class="hdp_fullwidth form-control" name="edit_comment_value" id="edit_comment_value" rows="10" cols="70"></textarea>');

            modal.addFooterBtn(saveButtonLabel, btn + ' ' + btnPrimary, function () {
                const editCommentInput = document.getElementById('edit_comment_value');
                HDP.updateComment(commentId, editCommentInput.value);
                document.getElementById('ticket-comment-' + commentId).innerText = editCommentInput.value;
                modal.close();
            });

            modal.addFooterBtn(cancelButtonLabel, btn + ' ' + btnDanger, function () {
                modal.close();
            });

            document.querySelectorAll('.hdp-edit-comment-button').forEach(function (button) {
                button.addEventListener('click', function () {
                    commentId = button.dataset.commentId;
                    document.getElementById('edit_comment_value').value = document.getElementById('ticket-comment-' + commentId).innerText;
                    modal.open();
                });
            });
        }

        document.querySelectorAll('.hdp-delete-comment-button').forEach(function (button) {
            button.addEventListener('click', function () {
                if (confirm('Do you want to delete the selected message ?')) {
                    commentId = button.dataset.commentId;
                    HDP.removeComment(commentId);

                    var commentRowNode = document.getElementById('ticket-comment-' + commentId).parentNode;
                    commentRowNode.parentNode.removeChild(commentRowNode);
                }
            });
        });

        // Register event listeners

        const btnSubmitComment = document.getElementById('btnSubmitComment');
        btnSubmitComment.addEventListener('click', function (event) {
            HDP.addComment(event.target.form, 'add_comment');
        });

        const btnCommentAndList = document.getElementById('btnCommentAndList');

        if (btnCommentAndList) {
            btnCommentAndList.addEventListener('click', function (event) {
                HDP.addComment(event.target.form, 'comment_and_list');
            });
        }

        const btnCommentAndClose = document.getElementById('btnCommentAndClose');
        btnCommentAndClose.addEventListener('click', function (event) {
            HDP.addComment(event.target.form, 'comment_and_close');
        });

        if (['admin', 'manager'].indexOf(userRole) !== -1 && Joomla.getOptions('useKeyboardShortcuts')) {
            const messageInput = document.getElementById('message');

            messageInput.addEventListener('keydown', function (event) {
                if (event.ctrlKey && ['s', 'r', 'd'].indexOf(event.key) !== -1) {
                    event.preventDefault();
                    let task;
                    switch (event.key) {
                        case 's':
                            task = 'comment_and_list';
                            break;
                        case 'd':
                            task = 'comment_and_close';
                            break;
                        default:
                            task = 'add_comment';
                            break;
                    }

                    HDP.addComment(messageInput.form, task);
                }
            });
        }

        const options = {arrowNavigation: true};

        [].slice.call(document.querySelectorAll('.hdp-attachments-container')).forEach(function (ul) {
            const images = ul.querySelectorAll('.hdp-modal');
            if (images.length > 0) {
                if (images.length === 1) {
                    new Luminous(images[0]);
                } else {
                    new LuminousGallery(images, options);
                }
            }
        });

        const imagesInAttachmentsPlugin = document.querySelectorAll('td .hdp-modal');

        if (imagesInAttachmentsPlugin.length > 0) {
            if (imagesInAttachmentsPlugin.length === 1) {
                new Luminous(imagesInAttachmentsPlugin[0]);
            } else {
                new LuminousGallery(imagesInAttachmentsPlugin, options);
            }
        }
    });
})(document, Joomla);