(function (document, $) {
    Joomla.submitbutton = function (pressbutton)
    {
        var form = document.adminForm;

        if (pressbutton === 'cancel')
        {
            Joomla.submitform(pressbutton);
        }
        else
        {
            if (form.name.value === "") {
                alert('Please enter name of custom field');
                form.name.focus();
                return;
            }
            if (form.title.value === "") {
                alert('Please enter title of custom field');
                form.title.focus();
                return;
            }
            Joomla.submitform(pressbutton);
        }
    };

    $(document).ready(function () {
        function validateRules(change)
        {
            var validateEngine = Joomla.getOptions('validationRules');
            var validateType = parseInt($('#datatype_validation').val());
            var validationString = validateEngine[validateType];
            var required = $("input[name='required']:checked").val();

            if (required === 1)
            {
                if (validationString === '')
                {
                    validationString = 'validate[required]';
                }
                else
                {
                    if (validationString.indexOf('required') === -1)
                    {
                        validationString = [validationString.slice(0, 9), 'required,', validationString.slice(9)].join('');
                    }
                }
            }
            else
            {
                if (validationString === 'validate[required]')
                {
                    validationString = '';
                }
                else
                {
                    validationString = validationString.replace('validate[required', 'validate[');
                }
            }

            if(change === 1)
            {
                $("input[name='validation_rules']").val(validationString);
            }
        }


        $("input[name='required']").bind( "click", function() {
            validateRules(1);
        });
        $( "#datatype_validation" ).bind( "change", function() {
            validateRules(1);
        });

        $("#name").on("change", function () {
            var name = $(this).val();
            var oldValue = name;
            name = name.replace('hdp_', '');
            while (name.indexOf('  ') >= 0)
            {
                name = name.replace('  ', ' ');
            }
            while (name.indexOf(' ') >= 0)
            {
                name = name.replace(' ', '_');
            }
            name = name.replace(/[^a-zA-Z0-9_]*/ig, '');

            $(this).val('hdp_' + name);
        });

        validateRules(0);

        var dependOnFieldId = document.getElementById('depend_on_field_id');

        dependOnFieldId.addEventListener('change', function () {
            var siteUrl = Joomla.getOptions('siteUrl');
            var fieldId = dependOnFieldId.value;

            if (fieldId > 0) {
                Joomla.request({
                    url: siteUrl + '/index.php?option=com_helpdeskpro&view=field&format=raw&field_id=' + fieldId,
                    method: 'POST',
                    onSuccess: function (resp) {
                        document.getElementById('options_container').innerHTML = resp;
                        document.getElementById('depend_on_options_container').style.display = '';
                    },
                    onError: function (error) {
                        alert(error.statusText);
                    }
                });
            } else {
                document.getElementById('options_container').innerHTML = '';
                document.getElementById('depend_on_options_container').style.display = 'none';
            }
        });
    });
})(document, jQuery);