<?php
/**
 * @package     OSL
 * @subpackage  Controller
 *
 * @copyright   Copyright (C) 2016 Ossolution Team, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

namespace OSL\Utils;

use JHtmlSidebar;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Form\FormHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\Database\DatabaseDriver;
use SimpleXMLElement;

class Html
{
	/**
	 * Add sub-menus which allow users to access to the other views in the component
	 *
	 * @param   string  $option    Name of the component being dispatched
	 * @param   string  $viewName  Name of the view currently displayed
	 */

	public static function addSubMenus($option, $viewName)
	{
		/* @var DatabaseDriver $db */
		$db              = Factory::getContainer()->get('db');
		$query           = $db->getQuery(true);
		$baseLink        = 'index.php?option=' . $option;
		$currentViewLink = 'index.php?option=' . $option . '&view=' . $viewName;
		$query->select('title, link')
			->from('#__menu')
			->where('link LIKE ' . $db->quote($baseLink . '%'))
			->where('parent_id != 1')
			->where('client_id = 1')
			->order('id');
		$db->setQuery($query);
		$rows = $db->loadObjectList();

		foreach ($rows as $row)
		{
			JHtmlSidebar::addEntry(Text::_($row->title), $row->link, $row->link == $currentViewLink);
		}
	}

	/**
	 * Get label of the field (including tooltip)
	 *
	 * @param           $name
	 * @param           $title
	 * @param   string  $tooltip
	 *
	 * @return string
	 */
	public static function getFieldLabel($name, $title, $tooltip = '')
	{
		$label = '';
		$text  = $title;

		// Build the class for the label.
		$class = !empty($tooltip) ? 'hasTooltip hasTip' : '';

		// Add the opening label tag and main attributes attributes.
		$label .= '<label id="' . $name . '-lbl" for="' . $name . '" class="' . $class . '"';

		// If a description is specified, use it to build a tooltip.
		if (!empty($tooltip))
		{
			$label .= ' title="' . HTMLHelper::tooltipText(trim($text, ':'), $tooltip, 0) . '"';
		}

		$label .= '>' . $text . '</label>';

		return $label;
	}

	/**
	 * Get bootstrapped style boolean input
	 *
	 * @param $name
	 * @param $value
	 *
	 * @return string
	 */
	/**
	 * Get bootstrapped style boolean input
	 *
	 * @param $name
	 * @param $value
	 *
	 * @return string
	 */
	public static function getBooleanInput($name, $value)
	{
		HTMLHelper::_('jquery.framework');
		$value = (int) $value;
		$field = FormHelper::loadFieldType('Radio');

		$element = new SimpleXMLElement('<field />');
		$element->addAttribute('name', $name);
		$element->addAttribute('class', 'switcher');
		$element->addAttribute('layout', 'joomla.form.field.radio.switcher');

		$element->addAttribute('default', '0');

		$node = $element->addChild('option', 'JNO');
		$node->addAttribute('value', '0');

		$node = $element->addChild('option', 'JYES');
		$node->addAttribute('value', '1');

		$field->setup($element, $value);

		return $field->input;
	}

	/**
	 * Generate User Input Select
	 *
	 * @param   int     $userId
	 * @param   string  $name
	 * @param   array   $attributes
	 *
	 * @return string
	 */
	public static function getUserInput($userId, $name = 'user_id', array $attributes = [])
	{
		/* @var FormField $field */
		$field = FormHelper::loadFieldType('User');

		$element = new SimpleXMLElement('<field />');
		$element->addAttribute('name', $name);
		$element->addAttribute('class', 'readonly');

		foreach ($attributes as $key => $value)
		{
			$element->addAttribute($key, $value);
		}

		$field->setup($element, $userId);

		return $field->input;
	}
}