<?php


namespace Omnipay\PayU\Message\Latam;


use Omnipay\Common\Message\RedirectResponseInterface;
use Omnipay\PayU\Message\Response;

class PurchaseResponse extends Response implements RedirectResponseInterface
{
    public function isRedirect()
    {
        return true;
    }

    public function isSuccessful()
    {
        return false;
    }

    public function getRedirectResponse()
    {
        return parent::getRedirectResponse(); // TODO: Change the autogenerated stub
    }


    public function getRedirectUrl()
    {
        if (method_exists($this->request, "getEndpoint")) {
            return $this->request->getEndpoint();
        }
        throw new \InvalidArgumentException("Incorrect request type");
    }

    public function getRedirectMethod()
    {
        return "POST";
    }

    public function getRedirectData()
    {
        return $this->getData();
    }
}
