<?php
/**
 * @package		eshiol Library
 * @subpackage	lib_eshiol
 *
 * @author		Helios Ciancio <info (at) eshiol (dot) it>
 * @link		http://www.eshiol.it
 * @copyright	Copyright (C) 2010 - 2020 Helios Ciancio. All Rights Reserved
 * @license		http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL v3
 * eshiol Library is free software. This version may have been modified
 * pursuant to the GNU General Public License, and as distributed it includes
 * or is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */
defined('_JEXEC') or die();

/**
 * Renders a standard button
 *
 * @version __DEPLOY_VERSION__
 * @since 12.0.1
 */
if (class_exists('JPlatform') && version_compare(JPlatform::RELEASE, '12', 'ge'))
{

	class JToolbarButtonStandard2 extends JToolbarButton
	{

		/**
		 * Button type
		 *
		 * @var string
		 */
		protected $_name = 'Standard2';

		/**
		 * Fetch the HTML for the button
		 *
		 * @param string $type
		 *        	Unused string.
		 * @param string $name
		 *        	The name of the button icon class.
		 * @param string $text
		 *        	Button text.
		 * @param string $task
		 *        	Task associated with the button.
		 * @param boolean $list
		 *        	True to allow lists
		 *        	
		 * @return string HTML string for the button
		 *        
		 * @since 3.0
		 */
		public function fetchButton ($type = 'Standard2', $name = '', $text = '', $task = '', $list = true)
		{
			$i18n_text = JText::_($text);
			$class = $this->fetchIconClass($name);
			$doTask = $this->_getCommand($text, $task, $list);
			
			if ($name == "apply" || $name == "new")
			{
				$btnClass = "btn btn-small btn-success";
				$iconWhite = "icon-white";
			}
			else
			{
				$btnClass = "btn btn-small";
				$iconWhite = "";
			}
			
			$html = "<button href=\"#\" onclick=\"$doTask\" class=\"" . $btnClass . "\">\n";
			$html .= "<i class=\"$class $iconWhite\">\n";
			$html .= "</i>\n";
			$html .= "$i18n_text\n";
			$html .= "</button>\n";
			
			return $html;
		}

		/**
		 * Get the button CSS Id
		 *
		 * @param string $type
		 *        	Unused string.
		 * @param string $name
		 *        	Name to be used as apart of the id
		 * @param string $text
		 *        	Button text
		 * @param string $task
		 *        	The task associated with the button
		 * @param boolean $list
		 *        	True to allow use of lists
		 * @param boolean $hideMenu
		 *        	True to hide the menu on click
		 *        	
		 * @return string Button CSS Id
		 *        
		 * @since 3.0
		 */
		public function fetchId ($type = 'Standard2', $name = '', $text = '', $task = '', $list = true, $hideMenu = false)
		{
			return $this->_parent->getName() . '-' . $name;
		}

		/**
		 * Get the JavaScript command for the button
		 *
		 * @param string $name
		 *        	The task name as seen by the user
		 * @param string $task
		 *        	The task used by the application
		 * @param boolean $list
		 *        	True is requires a list confirmation.
		 *        	
		 * @return string JavaScript command string
		 *        
		 * @since 3.0
		 */
		protected function _getCommand ($name, $task, $list)
		{
			JHtml::_('behavior.framework');
			$message = JText::_('JLIB_HTML_PLEASE_MAKE_A_SELECTION_FROM_THE_LIST');
			$message = addslashes($message);
			
			$tmp = explode('.', $task);
			$i = count($tmp);
			if ($i == 3)
			{
				$task = $tmp[1] . '.' . $tmp[2];
				$option = $tmp[0];
			}
			else
				$option = '';
			
			$cmd = "Joomla.submitbutton('{$task}');";
			if ($option)
				$cmd = "{
				var action = document.adminForm.action;
				document.adminForm.action = '" . JURI::base(true) . "/index.php?option=com_" . $option . "';
				" . $cmd . "
				document.adminForm.action = action;
			}";
			if ($list)
				$cmd = "
			if (document.adminForm.boxchecked.value==0)
				alert('{$message}');
			else " . $cmd;
			return $cmd;
		}
	}
}
else
{

	class JButtonStandard2 extends JButton
	{

		/**
		 * Button type
		 *
		 * @access public
		 * @var string
		 */
		var $_name = 'Standard2';

		public function fetchButton ($type = 'Standard2', $name = '', $text = '', $task = '', $list = true, $hideMenu = false)
		{
			$i18n_text = JText::_($text);
			$class = $this->fetchIconClass($name);
			
			$doTask = $this->_getCommand($text, $task, $list);
			
			$html = "";
			$html .= "<a href=\"#\" onclick=\"$doTask\" class=\"toolbar\">\n";
			$html .= "<span class=\"$class\" title=\"$i18n_text\">\n";
			$html .= "</span>\n";
			$html .= "$i18n_text\n";
			$html .= "</a>";
			$html .= "\n";
			
			return $html;
		}

		/**
		 * Get the button CSS Id
		 *
		 * @param string $type
		 *        	Unused string.
		 * @param string $name
		 *        	Name to be used as apart of the id
		 * @param string $text
		 *        	Button text
		 * @param string $task
		 *        	The task associated with the button
		 * @param boolean $list
		 *        	True to allow use of lists
		 * @param boolean $hideMenu
		 *        	True to hide the menu on click
		 *        	
		 * @return string Button CSS Id
		 *        
		 * @since 11.1
		 */
		public function fetchId ($type = 'Standard2', $name = '', $text = '', $task = '', $list = true)
		{
			return $this->_parent->getName() . '-' . $name;
		}

		/**
		 * Get the JavaScript command for the button
		 *
		 * @access private
		 * @param string $name
		 *        	The task name as seen by the user
		 * @param string $task
		 *        	The task used by the application
		 * @param ??? $list
		 * @param boolean $hide
		 * @return string JavaScript command string
		 * @since 1.5
		 */
		private function _getCommand ($name, $task, $list)
		{
			JHtml::_('behavior.framework');
			$message = JText::_('JLIB_HTML_PLEASE_MAKE_A_SELECTION_FROM_THE_LIST');
			$message = addslashes($message);
			
			$tmp = explode('.', $task);
			$i = count($tmp);
			if ($i == 3)
			{
				$task = $tmp[1] . '.' . $tmp[2];
				$option = $tmp[0];
			}
			else
				$option = '';
			
			$cmd = "Joomla.submitbutton('{$task}');";
			if ($option)
				$cmd = "{
				var action = document.adminForm.action;
				var task = document.adminForm.task.value;
				document.adminForm.action = '" . JURI::base(true) . "/index.php?option=com_" . $option . "';
				" . $cmd . "
				document.adminForm.action = action;
				document.adminForm.task.value = task;
		}";
			if ($list)
				$cmd = "
				if (document.adminForm.boxchecked.value==0)
				alert('{$message}');
				else " . $cmd;
			return $cmd;
		}
	}
}
