!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?factory(exports):"function"==typeof define&&define.amd?define(["exports"],factory):factory((global="undefined"!=typeof globalThis?globalThis:global||self).IMask={})}(this,(function(exports){"use strict";function isString(str){return"string"==typeof str||str instanceof String}function isObject(obj){var _obj$constructor;return"object"==typeof obj&&null!=obj&&"Object"===(null==obj||null==(_obj$constructor=obj.constructor)?void 0:_obj$constructor.name)}function pick(obj,keys){return Array.isArray(keys)?pick(obj,(_,k)=>keys.includes(k)):Object.entries(obj).reduce((acc,_ref)=>{let[k,v]=_ref;return keys(v,k)&&(acc[k]=v),acc},{})}const DIRECTION={NONE:"NONE",LEFT:"LEFT",FORCE_LEFT:"FORCE_LEFT",RIGHT:"RIGHT",FORCE_RIGHT:"FORCE_RIGHT"};function forceDirection(direction){switch(direction){case DIRECTION.LEFT:return DIRECTION.FORCE_LEFT;case DIRECTION.RIGHT:return DIRECTION.FORCE_RIGHT;default:return direction}}function escapeRegExp(str){return str.replace(/([.*+?^=!:${}()|[\]/\\])/g,"\\$1")}function objectIncludes(b,a){if(a===b)return!0;const arrA=Array.isArray(a),arrB=Array.isArray(b);let i;if(arrA&&arrB){if(a.length!=b.length)return!1;for(i=0;i<a.length;i++)if(!objectIncludes(a[i],b[i]))return!1;return!0}if(arrA!=arrB)return!1;if(a&&b&&"object"==typeof a&&"object"==typeof b){const dateA=a instanceof Date,dateB=b instanceof Date;if(dateA&&dateB)return a.getTime()==b.getTime();if(dateA!=dateB)return!1;const regexpA=a instanceof RegExp,regexpB=b instanceof RegExp;if(regexpA&&regexpB)return a.toString()==b.toString();if(regexpA!=regexpB)return!1;const keys=Object.keys(a);for(i=0;i<keys.length;i++)if(!Object.prototype.hasOwnProperty.call(b,keys[i]))return!1;for(i=0;i<keys.length;i++)if(!objectIncludes(b[keys[i]],a[keys[i]]))return!1;return!0}return!(!a||!b||"function"!=typeof a||"function"!=typeof b)&&a.toString()===b.toString()}class ActionDetails{constructor(opts){for(Object.assign(this,opts);this.value.slice(0,this.startChangePos)!==this.oldValue.slice(0,this.startChangePos);)--this.oldSelection.start;if(this.insertedCount)for(;this.value.slice(this.cursorPos)!==this.oldValue.slice(this.oldSelection.end);)this.value.length-this.cursorPos<this.oldValue.length-this.oldSelection.end?++this.oldSelection.end:++this.cursorPos}get startChangePos(){return Math.min(this.cursorPos,this.oldSelection.start)}get insertedCount(){return this.cursorPos-this.startChangePos}get inserted(){return this.value.substr(this.startChangePos,this.insertedCount)}get removedCount(){return Math.max(this.oldSelection.end-this.startChangePos||this.oldValue.length-this.value.length,0)}get removed(){return this.oldValue.substr(this.startChangePos,this.removedCount)}get head(){return this.value.substring(0,this.startChangePos)}get tail(){return this.value.substring(this.startChangePos+this.insertedCount)}get removeDirection(){return!this.removedCount||this.insertedCount?DIRECTION.NONE:this.oldSelection.end!==this.cursorPos&&this.oldSelection.start!==this.cursorPos||this.oldSelection.end!==this.oldSelection.start?DIRECTION.LEFT:DIRECTION.RIGHT}}function IMask(el,opts){return new IMask.InputMask(el,opts)}function maskedClass(mask){if(null==mask)throw new Error("mask property should be defined");return mask instanceof RegExp?IMask.MaskedRegExp:isString(mask)?IMask.MaskedPattern:mask===Date?IMask.MaskedDate:mask===Number?IMask.MaskedNumber:Array.isArray(mask)||mask===Array?IMask.MaskedDynamic:IMask.Masked&&mask.prototype instanceof IMask.Masked?mask:IMask.Masked&&mask instanceof IMask.Masked?mask.constructor:mask instanceof Function?IMask.MaskedFunction:(console.warn("Mask not found for mask",mask),IMask.Masked)}function normalizeOpts(opts){if(!opts)throw new Error("Options in not defined");if(IMask.Masked){if(opts.prototype instanceof IMask.Masked)return{mask:opts};const{mask:mask,...instanceOpts}=opts instanceof IMask.Masked?{mask:opts}:isObject(opts)&&opts.mask instanceof IMask.Masked?opts:{};if(mask){const _mask=mask.mask;return{...pick(mask,(_,k)=>!k.startsWith("_")),mask:mask.constructor,_mask:_mask,...instanceOpts}}}return isObject(opts)?{...opts}:{mask:opts}}function createMask(opts){if(IMask.Masked&&opts instanceof IMask.Masked)return opts;const nOpts=normalizeOpts(opts),MaskedClass=maskedClass(nOpts.mask);if(!MaskedClass)throw new Error("Masked class is not found for provided mask "+nOpts.mask+", appropriate module needs to be imported manually before creating mask.");return nOpts.mask===MaskedClass&&delete nOpts.mask,nOpts._mask&&(nOpts.mask=nOpts._mask,delete nOpts._mask),new MaskedClass(nOpts)}IMask.createMask=createMask;class MaskElement{get selectionStart(){let start;try{start=this._unsafeSelectionStart}catch{}return null!=start?start:this.value.length}get selectionEnd(){let end;try{end=this._unsafeSelectionEnd}catch{}return null!=end?end:this.value.length}select(start,end){if(null!=start&&null!=end&&(start!==this.selectionStart||end!==this.selectionEnd))try{this._unsafeSelect(start,end)}catch{}}get isActive(){return!1}}IMask.MaskElement=MaskElement;const KEY_Z=90,KEY_Y=89;class HTMLMaskElement extends MaskElement{constructor(input){super(),this.input=input,this._onKeydown=this._onKeydown.bind(this),this._onInput=this._onInput.bind(this),this._onBeforeinput=this._onBeforeinput.bind(this),this._onCompositionEnd=this._onCompositionEnd.bind(this)}get rootElement(){var _this$input$getRootNo,_this$input$getRootNo2,_this$input;return null!=(_this$input$getRootNo=null==(_this$input$getRootNo2=(_this$input=this.input).getRootNode)?void 0:_this$input$getRootNo2.call(_this$input))?_this$input$getRootNo:document}get isActive(){return this.input===this.rootElement.activeElement}bindEvents(handlers){this.input.addEventListener("keydown",this._onKeydown),this.input.addEventListener("input",this._onInput),this.input.addEventListener("beforeinput",this._onBeforeinput),this.input.addEventListener("compositionend",this._onCompositionEnd),this.input.addEventListener("drop",handlers.drop),this.input.addEventListener("click",handlers.click),this.input.addEventListener("focus",handlers.focus),this.input.addEventListener("blur",handlers.commit),this._handlers=handlers}_onKeydown(e){return this._handlers.redo&&(90===e.keyCode&&e.shiftKey&&(e.metaKey||e.ctrlKey)||89===e.keyCode&&e.ctrlKey)?(e.preventDefault(),this._handlers.redo(e)):this._handlers.undo&&90===e.keyCode&&(e.metaKey||e.ctrlKey)?(e.preventDefault(),this._handlers.undo(e)):void(e.isComposing||this._handlers.selectionChange(e))}_onBeforeinput(e){return"historyUndo"===e.inputType&&this._handlers.undo?(e.preventDefault(),this._handlers.undo(e)):"historyRedo"===e.inputType&&this._handlers.redo?(e.preventDefault(),this._handlers.redo(e)):void 0}_onCompositionEnd(e){this._handlers.input(e)}_onInput(e){e.isComposing||this._handlers.input(e)}unbindEvents(){this.input.removeEventListener("keydown",this._onKeydown),this.input.removeEventListener("input",this._onInput),this.input.removeEventListener("beforeinput",this._onBeforeinput),this.input.removeEventListener("compositionend",this._onCompositionEnd),this.input.removeEventListener("drop",this._handlers.drop),this.input.removeEventListener("click",this._handlers.click),this.input.removeEventListener("focus",this._handlers.focus),this.input.removeEventListener("blur",this._handlers.commit),this._handlers={}}}IMask.HTMLMaskElement=HTMLMaskElement;class HTMLInputMaskElement extends HTMLMaskElement{constructor(input){super(input),this.input=input}get _unsafeSelectionStart(){return null!=this.input.selectionStart?this.input.selectionStart:this.value.length}get _unsafeSelectionEnd(){return this.input.selectionEnd}_unsafeSelect(start,end){this.input.setSelectionRange(start,end)}get value(){return this.input.value}set value(value){this.input.value=value}}IMask.HTMLMaskElement=HTMLMaskElement;class HTMLContenteditableMaskElement extends HTMLMaskElement{get _unsafeSelectionStart(){const root=this.rootElement,selection=root.getSelection&&root.getSelection(),anchorOffset=selection&&selection.anchorOffset,focusOffset=selection&&selection.focusOffset;return null==focusOffset||null==anchorOffset||anchorOffset<focusOffset?anchorOffset:focusOffset}get _unsafeSelectionEnd(){const root=this.rootElement,selection=root.getSelection&&root.getSelection(),anchorOffset=selection&&selection.anchorOffset,focusOffset=selection&&selection.focusOffset;return null==focusOffset||null==anchorOffset||anchorOffset>focusOffset?anchorOffset:focusOffset}_unsafeSelect(start,end){if(!this.rootElement.createRange)return;const range=this.rootElement.createRange();range.setStart(this.input.firstChild||this.input,start),range.setEnd(this.input.lastChild||this.input,end);const root=this.rootElement,selection=root.getSelection&&root.getSelection();selection&&(selection.removeAllRanges(),selection.addRange(range))}get value(){return this.input.textContent||""}set value(value){this.input.textContent=value}}IMask.HTMLContenteditableMaskElement=HTMLContenteditableMaskElement;class InputHistory{constructor(){this.states=[],this.currentIndex=0}get currentState(){return this.states[this.currentIndex]}get isEmpty(){return 0===this.states.length}push(state){this.currentIndex<this.states.length-1&&(this.states.length=this.currentIndex+1),this.states.push(state),this.states.length>InputHistory.MAX_LENGTH&&this.states.shift(),this.currentIndex=this.states.length-1}go(steps){return this.currentIndex=Math.min(Math.max(this.currentIndex+steps,0),this.states.length-1),this.currentState}undo(){return this.go(-1)}redo(){return this.go(1)}clear(){this.states.length=0,this.currentIndex=0}}InputHistory.MAX_LENGTH=100;class InputMask{constructor(el,opts){this.el=el instanceof MaskElement?el:el.isContentEditable&&"INPUT"!==el.tagName&&"TEXTAREA"!==el.tagName?new HTMLContenteditableMaskElement(el):new HTMLInputMaskElement(el),this.masked=createMask(opts),this._listeners={},this._value="",this._unmaskedValue="",this._rawInputValue="",this.history=new InputHistory,this._saveSelection=this._saveSelection.bind(this),this._onInput=this._onInput.bind(this),this._onChange=this._onChange.bind(this),this._onDrop=this._onDrop.bind(this),this._onFocus=this._onFocus.bind(this),this._onClick=this._onClick.bind(this),this._onUndo=this._onUndo.bind(this),this._onRedo=this._onRedo.bind(this),this.alignCursor=this.alignCursor.bind(this),this.alignCursorFriendly=this.alignCursorFriendly.bind(this),this._bindEvents(),this.updateValue(),this._onChange()}maskEquals(mask){var _this$masked;return null==mask||(null==(_this$masked=this.masked)?void 0:_this$masked.maskEquals(mask))}get mask(){return this.masked.mask}set mask(mask){if(this.maskEquals(mask))return;if(!(mask instanceof IMask.Masked)&&this.masked.constructor===maskedClass(mask))return void this.masked.updateOptions({mask:mask});const masked=mask instanceof IMask.Masked?mask:createMask({mask:mask});masked.unmaskedValue=this.masked.unmaskedValue,this.masked=masked}get value(){return this._value}set value(str){this.value!==str&&(this.masked.value=str,this.updateControl("auto"))}get unmaskedValue(){return this._unmaskedValue}set unmaskedValue(str){this.unmaskedValue!==str&&(this.masked.unmaskedValue=str,this.updateControl("auto"))}get rawInputValue(){return this._rawInputValue}set rawInputValue(str){this.rawInputValue!==str&&(this.masked.rawInputValue=str,this.updateControl(),this.alignCursor())}get typedValue(){return this.masked.typedValue}set typedValue(val){this.masked.typedValueEquals(val)||(this.masked.typedValue=val,this.updateControl("auto"))}get displayValue(){return this.masked.displayValue}_bindEvents(){this.el.bindEvents({selectionChange:this._saveSelection,input:this._onInput,drop:this._onDrop,click:this._onClick,focus:this._onFocus,commit:this._onChange,undo:this._onUndo,redo:this._onRedo})}_unbindEvents(){this.el&&this.el.unbindEvents()}_fireEvent(ev,e){const listeners=this._listeners[ev];listeners&&listeners.forEach(l=>l(e))}get selectionStart(){return this._cursorChanging?this._changingCursorPos:this.el.selectionStart}get cursorPos(){return this._cursorChanging?this._changingCursorPos:this.el.selectionEnd}set cursorPos(pos){this.el&&this.el.isActive&&(this.el.select(pos,pos),this._saveSelection())}_saveSelection(){this.displayValue!==this.el.value&&console.warn("Element value was changed outside of mask. Syncronize mask using `mask.updateValue()` to work properly."),this._selection={start:this.selectionStart,end:this.cursorPos}}updateValue(){this.masked.value=this.el.value,this._value=this.masked.value,this._unmaskedValue=this.masked.unmaskedValue,this._rawInputValue=this.masked.rawInputValue}updateControl(cursorPos){const newUnmaskedValue=this.masked.unmaskedValue,newValue=this.masked.value,newRawInputValue=this.masked.rawInputValue,newDisplayValue=this.displayValue,isChanged=this.unmaskedValue!==newUnmaskedValue||this.value!==newValue||this._rawInputValue!==newRawInputValue;this._unmaskedValue=newUnmaskedValue,this._value=newValue,this._rawInputValue=newRawInputValue,this.el.value!==newDisplayValue&&(this.el.value=newDisplayValue),"auto"===cursorPos?this.alignCursor():null!=cursorPos&&(this.cursorPos=cursorPos),isChanged&&this._fireChangeEvents(),this._historyChanging||!isChanged&&!this.history.isEmpty||this.history.push({unmaskedValue:newUnmaskedValue,selection:{start:this.selectionStart,end:this.cursorPos}})}updateOptions(opts){const{mask:mask,...restOpts}=opts,updateMask=!this.maskEquals(mask),updateOpts=this.masked.optionsIsChanged(restOpts);updateMask&&(this.mask=mask),updateOpts&&this.masked.updateOptions(restOpts),(updateMask||updateOpts)&&this.updateControl()}updateCursor(cursorPos){null!=cursorPos&&(this.cursorPos=cursorPos,this._delayUpdateCursor(cursorPos))}_delayUpdateCursor(cursorPos){this._abortUpdateCursor(),this._changingCursorPos=cursorPos,this._cursorChanging=setTimeout(()=>{this.el&&(this.cursorPos=this._changingCursorPos,this._abortUpdateCursor())},10)}_fireChangeEvents(){this._fireEvent("accept",this._inputEvent),this.masked.isComplete&&this._fireEvent("complete",this._inputEvent)}_abortUpdateCursor(){this._cursorChanging&&(clearTimeout(this._cursorChanging),delete this._cursorChanging)}alignCursor(){this.cursorPos=this.masked.nearestInputPos(this.masked.nearestInputPos(this.cursorPos,DIRECTION.LEFT))}alignCursorFriendly(){this.selectionStart===this.cursorPos&&this.alignCursor()}on(ev,handler){return this._listeners[ev]||(this._listeners[ev]=[]),this._listeners[ev].push(handler),this}off(ev,handler){if(!this._listeners[ev])return this;if(!handler)return delete this._listeners[ev],this;const hIndex=this._listeners[ev].indexOf(handler);return hIndex>=0&&this._listeners[ev].splice(hIndex,1),this}_onInput(e){this._inputEvent=e,this._abortUpdateCursor();const details=new ActionDetails({value:this.el.value,cursorPos:this.cursorPos,oldValue:this.displayValue,oldSelection:this._selection}),oldRawValue=this.masked.rawInputValue,offset=this.masked.splice(details.startChangePos,details.removed.length,details.inserted,details.removeDirection,{input:!0,raw:!0}).offset,removeDirection=oldRawValue===this.masked.rawInputValue?details.removeDirection:DIRECTION.NONE;let cursorPos=this.masked.nearestInputPos(details.startChangePos+offset,removeDirection);removeDirection!==DIRECTION.NONE&&(cursorPos=this.masked.nearestInputPos(cursorPos,DIRECTION.NONE)),this.updateControl(cursorPos),delete this._inputEvent}_onChange(){this.displayValue!==this.el.value&&this.updateValue(),this.masked.doCommit(),this.updateControl(),this._saveSelection()}_onDrop(ev){ev.preventDefault(),ev.stopPropagation()}_onFocus(ev){this.alignCursorFriendly()}_onClick(ev){this.alignCursorFriendly()}_onUndo(){this._applyHistoryState(this.history.undo())}_onRedo(){this._applyHistoryState(this.history.redo())}_applyHistoryState(state){state&&(this._historyChanging=!0,this.unmaskedValue=state.unmaskedValue,this.el.select(state.selection.start,state.selection.end),this._saveSelection(),this._historyChanging=!1)}destroy(){this._unbindEvents(),this._listeners.length=0,delete this.el}}IMask.InputMask=InputMask;class ChangeDetails{static normalize(prep){return Array.isArray(prep)?prep:[prep,new ChangeDetails]}constructor(details){Object.assign(this,{inserted:"",rawInserted:"",tailShift:0,skip:!1},details)}aggregate(details){return this.inserted+=details.inserted,this.rawInserted+=details.rawInserted,this.tailShift+=details.tailShift,this.skip=this.skip||details.skip,this}get offset(){return this.tailShift+this.inserted.length}get consumed(){return Boolean(this.rawInserted)||this.skip}equals(details){return this.inserted===details.inserted&&this.tailShift===details.tailShift&&this.rawInserted===details.rawInserted&&this.skip===details.skip}}IMask.ChangeDetails=ChangeDetails;class ContinuousTailDetails{constructor(value,from,stop){void 0===value&&(value=""),void 0===from&&(from=0),this.value=value,this.from=from,this.stop=stop}toString(){return this.value}extend(tail){this.value+=String(tail)}appendTo(masked){return masked.append(this.toString(),{tail:!0}).aggregate(masked._appendPlaceholder())}get state(){return{value:this.value,from:this.from,stop:this.stop}}set state(state){Object.assign(this,state)}unshift(beforePos){if(!this.value.length||null!=beforePos&&this.from>=beforePos)return"";const shiftChar=this.value[0];return this.value=this.value.slice(1),shiftChar}shift(){if(!this.value.length)return"";const shiftChar=this.value[this.value.length-1];return this.value=this.value.slice(0,-1),shiftChar}}class Masked{constructor(opts){this._value="",this._update({...Masked.DEFAULTS,...opts}),this._initialized=!0}updateOptions(opts){this.optionsIsChanged(opts)&&this.withValueRefresh(this._update.bind(this,opts))}_update(opts){Object.assign(this,opts)}get state(){return{_value:this.value,_rawInputValue:this.rawInputValue}}set state(state){this._value=state._value}reset(){this._value=""}get value(){return this._value}set value(value){this.resolve(value,{input:!0})}resolve(value,flags){void 0===flags&&(flags={input:!0}),this.reset(),this.append(value,flags,""),this.doCommit()}get unmaskedValue(){return this.value}set unmaskedValue(value){this.resolve(value,{})}get typedValue(){return this.parse?this.parse(this.value,this):this.unmaskedValue}set typedValue(value){this.format?this.value=this.format(value,this):this.unmaskedValue=String(value)}get rawInputValue(){return this.extractInput(0,this.displayValue.length,{raw:!0})}set rawInputValue(value){this.resolve(value,{raw:!0})}get displayValue(){return this.value}get isComplete(){return!0}get isFilled(){return this.isComplete}nearestInputPos(cursorPos,direction){return cursorPos}totalInputPositions(fromPos,toPos){return void 0===fromPos&&(fromPos=0),void 0===toPos&&(toPos=this.displayValue.length),Math.min(this.displayValue.length,toPos-fromPos)}extractInput(fromPos,toPos,flags){return void 0===fromPos&&(fromPos=0),void 0===toPos&&(toPos=this.displayValue.length),this.displayValue.slice(fromPos,toPos)}extractTail(fromPos,toPos){return void 0===fromPos&&(fromPos=0),void 0===toPos&&(toPos=this.displayValue.length),new ContinuousTailDetails(this.extractInput(fromPos,toPos),fromPos)}appendTail(tail){return isString(tail)&&(tail=new ContinuousTailDetails(String(tail))),tail.appendTo(this)}_appendCharRaw(ch,flags){return ch?(this._value+=ch,new ChangeDetails({inserted:ch,rawInserted:ch})):new ChangeDetails}_appendChar(ch,flags,checkTail){void 0===flags&&(flags={});const consistentState=this.state;let details;if([ch,details]=this.doPrepareChar(ch,flags),ch&&(details=details.aggregate(this._appendCharRaw(ch,flags)),!details.rawInserted&&"pad"===this.autofix)){const noFixState=this.state;this.state=consistentState;let fixDetails=this.pad(flags);const chDetails=this._appendCharRaw(ch,flags);fixDetails=fixDetails.aggregate(chDetails),chDetails.rawInserted||fixDetails.equals(details)?details=fixDetails:this.state=noFixState}if(details.inserted){let consistentTail,appended=!1!==this.doValidate(flags);if(appended&&null!=checkTail){const beforeTailState=this.state;if(!0===this.overwrite){consistentTail=checkTail.state;for(let i=0;i<details.rawInserted.length;++i)checkTail.unshift(this.displayValue.length-details.tailShift)}let tailDetails=this.appendTail(checkTail);if(appended=tailDetails.rawInserted.length===checkTail.toString().length,!(appended&&tailDetails.inserted||"shift"!==this.overwrite)){this.state=beforeTailState,consistentTail=checkTail.state;for(let i=0;i<details.rawInserted.length;++i)checkTail.shift();tailDetails=this.appendTail(checkTail),appended=tailDetails.rawInserted.length===checkTail.toString().length}appended&&tailDetails.inserted&&(this.state=beforeTailState)}appended||(details=new ChangeDetails,this.state=consistentState,checkTail&&consistentTail&&(checkTail.state=consistentTail))}return details}_appendPlaceholder(){return new ChangeDetails}_appendEager(){return new ChangeDetails}append(str,flags,tail){if(!isString(str))throw new Error("value should be string");const checkTail=isString(tail)?new ContinuousTailDetails(String(tail)):tail;let details;null!=flags&&flags.tail&&(flags._beforeTailState=this.state),[str,details]=this.doPrepare(str,flags);for(let ci=0;ci<str.length;++ci){const d=this._appendChar(str[ci],flags,checkTail);if(!d.rawInserted&&!this.doSkipInvalid(str[ci],flags,checkTail))break;details.aggregate(d)}return(!0===this.eager||"append"===this.eager)&&null!=flags&&flags.input&&str&&details.aggregate(this._appendEager()),null!=checkTail&&(details.tailShift+=this.appendTail(checkTail).tailShift),details}remove(fromPos,toPos){return void 0===fromPos&&(fromPos=0),void 0===toPos&&(toPos=this.displayValue.length),this._value=this.displayValue.slice(0,fromPos)+this.displayValue.slice(toPos),new ChangeDetails}withValueRefresh(fn){if(this._refreshing||!this._initialized)return fn();this._refreshing=!0;const rawInput=this.rawInputValue,value=this.value,ret=fn();return this.rawInputValue=rawInput,this.value&&this.value!==value&&0===value.indexOf(this.value)&&(this.append(value.slice(this.displayValue.length),{},""),this.doCommit()),delete this._refreshing,ret}runIsolated(fn){if(this._isolated||!this._initialized)return fn(this);this._isolated=!0;const state=this.state,ret=fn(this);return this.state=state,delete this._isolated,ret}doSkipInvalid(ch,flags,checkTail){return Boolean(this.skipInvalid)}doPrepare(str,flags){return void 0===flags&&(flags={}),ChangeDetails.normalize(this.prepare?this.prepare(str,this,flags):str)}doPrepareChar(str,flags){return void 0===flags&&(flags={}),ChangeDetails.normalize(this.prepareChar?this.prepareChar(str,this,flags):str)}doValidate(flags){return(!this.validate||this.validate(this.value,this,flags))&&(!this.parent||this.parent.doValidate(flags))}doCommit(){this.commit&&this.commit(this.value,this)}splice(start,deleteCount,inserted,removeDirection,flags){void 0===inserted&&(inserted=""),void 0===removeDirection&&(removeDirection=DIRECTION.NONE),void 0===flags&&(flags={input:!0});const tailPos=start+deleteCount,tail=this.extractTail(tailPos),eagerRemove=!0===this.eager||"remove"===this.eager;let oldRawValue;eagerRemove&&(removeDirection=forceDirection(removeDirection),oldRawValue=this.extractInput(0,tailPos,{raw:!0}));let startChangePos=start;const details=new ChangeDetails;if(removeDirection!==DIRECTION.NONE&&(startChangePos=this.nearestInputPos(start,deleteCount>1&&0!==start&&!eagerRemove?DIRECTION.NONE:removeDirection),details.tailShift=startChangePos-start),details.aggregate(this.remove(startChangePos)),eagerRemove&&removeDirection!==DIRECTION.NONE&&oldRawValue===this.rawInputValue)if(removeDirection===DIRECTION.FORCE_LEFT){let valLength;for(;oldRawValue===this.rawInputValue&&(valLength=this.displayValue.length);)details.aggregate(new ChangeDetails({tailShift:-1})).aggregate(this.remove(valLength-1))}else removeDirection===DIRECTION.FORCE_RIGHT&&tail.unshift();return details.aggregate(this.append(inserted,flags,tail))}maskEquals(mask){return this.mask===mask}optionsIsChanged(opts){return!objectIncludes(this,opts)}typedValueEquals(value){const tval=this.typedValue;return value===tval||Masked.EMPTY_VALUES.includes(value)&&Masked.EMPTY_VALUES.includes(tval)||!!this.format&&this.format(value,this)===this.format(this.typedValue,this)}pad(flags){return new ChangeDetails}}Masked.DEFAULTS={skipInvalid:!0},Masked.EMPTY_VALUES=[void 0,null,""],IMask.Masked=Masked;class ChunksTailDetails{constructor(chunks,from){void 0===chunks&&(chunks=[]),void 0===from&&(from=0),this.chunks=chunks,this.from=from}toString(){return this.chunks.map(String).join("")}extend(tailChunk){if(!String(tailChunk))return;tailChunk=isString(tailChunk)?new ContinuousTailDetails(String(tailChunk)):tailChunk;const lastChunk=this.chunks[this.chunks.length-1],extendLast=lastChunk&&(lastChunk.stop===tailChunk.stop||null==tailChunk.stop)&&tailChunk.from===lastChunk.from+lastChunk.toString().length;if(tailChunk instanceof ContinuousTailDetails)extendLast?lastChunk.extend(tailChunk.toString()):this.chunks.push(tailChunk);else if(tailChunk instanceof ChunksTailDetails){if(null==tailChunk.stop){let firstTailChunk;for(;tailChunk.chunks.length&&null==tailChunk.chunks[0].stop;)firstTailChunk=tailChunk.chunks.shift(),firstTailChunk.from+=tailChunk.from,this.extend(firstTailChunk)}tailChunk.toString()&&(tailChunk.stop=tailChunk.blockIndex,this.chunks.push(tailChunk))}}appendTo(masked){if(!(masked instanceof IMask.MaskedPattern)){const tail=new ContinuousTailDetails(this.toString());return tail.appendTo(masked)}const details=new ChangeDetails;for(let ci=0;ci<this.chunks.length;++ci){const chunk=this.chunks[ci],lastBlockIter=masked._mapPosToBlock(masked.displayValue.length),stop=chunk.stop;let chunkBlock;if(null!=stop&&(!lastBlockIter||lastBlockIter.index<=stop)&&((chunk instanceof ChunksTailDetails||masked._stops.indexOf(stop)>=0)&&details.aggregate(masked._appendPlaceholder(stop)),chunkBlock=chunk instanceof ChunksTailDetails&&masked._blocks[stop]),chunkBlock){const tailDetails=chunkBlock.appendTail(chunk);details.aggregate(tailDetails);const remainChars=chunk.toString().slice(tailDetails.rawInserted.length);remainChars&&details.aggregate(masked.append(remainChars,{tail:!0}))}else details.aggregate(masked.append(chunk.toString(),{tail:!0}))}return details}get state(){return{chunks:this.chunks.map(c=>c.state),from:this.from,stop:this.stop,blockIndex:this.blockIndex}}set state(state){const{chunks:chunks,...props}=state;Object.assign(this,props),this.chunks=chunks.map(cstate=>{const chunk="chunks"in cstate?new ChunksTailDetails:new ContinuousTailDetails;return chunk.state=cstate,chunk})}unshift(beforePos){if(!this.chunks.length||null!=beforePos&&this.from>=beforePos)return"";const chunkShiftPos=null!=beforePos?beforePos-this.from:beforePos;let ci=0;for(;ci<this.chunks.length;){const chunk=this.chunks[ci],shiftChar=chunk.unshift(chunkShiftPos);if(chunk.toString()){if(!shiftChar)break;++ci}else this.chunks.splice(ci,1);if(shiftChar)return shiftChar}return""}shift(){if(!this.chunks.length)return"";let ci=this.chunks.length-1;for(;0<=ci;){const chunk=this.chunks[ci],shiftChar=chunk.shift();if(chunk.toString()){if(!shiftChar)break;--ci}else this.chunks.splice(ci,1);if(shiftChar)return shiftChar}return""}}class PatternCursor{constructor(masked,pos){this.masked=masked,this._log=[];const{offset:offset,index:index}=masked._mapPosToBlock(pos)||(pos<0?{index:0,offset:0}:{index:this.masked._blocks.length,offset:0});this.offset=offset,this.index=index,this.ok=!1}get block(){return this.masked._blocks[this.index]}get pos(){return this.masked._blockStartPos(this.index)+this.offset}get state(){return{index:this.index,offset:this.offset,ok:this.ok}}set state(s){Object.assign(this,s)}pushState(){this._log.push(this.state)}popState(){const s=this._log.pop();return s&&(this.state=s),s}bindBlock(){this.block||(this.index<0&&(this.index=0,this.offset=0),this.index>=this.masked._blocks.length&&(this.index=this.masked._blocks.length-1,this.offset=this.block.displayValue.length))}_pushLeft(fn){for(this.pushState(),this.bindBlock();0<=this.index;--this.index,this.offset=(null==(_this$block=this.block)?void 0:_this$block.displayValue.length)||0){var _this$block;if(fn())return this.ok=!0}return this.ok=!1}_pushRight(fn){for(this.pushState(),this.bindBlock();this.index<this.masked._blocks.length;++this.index,this.offset=0)if(fn())return this.ok=!0;return this.ok=!1}pushLeftBeforeFilled(){return this._pushLeft(()=>{if(!this.block.isFixed&&this.block.value)return this.offset=this.block.nearestInputPos(this.offset,DIRECTION.FORCE_LEFT),0!==this.offset||void 0})}pushLeftBeforeInput(){return this._pushLeft(()=>{if(!this.block.isFixed)return this.offset=this.block.nearestInputPos(this.offset,DIRECTION.LEFT),!0})}pushLeftBeforeRequired(){return this._pushLeft(()=>{if(!(this.block.isFixed||this.block.isOptional&&!this.block.value))return this.offset=this.block.nearestInputPos(this.offset,DIRECTION.LEFT),!0})}pushRightBeforeFilled(){return this._pushRight(()=>{if(!this.block.isFixed&&this.block.value)return this.offset=this.block.nearestInputPos(this.offset,DIRECTION.FORCE_RIGHT),this.offset!==this.block.value.length||void 0})}pushRightBeforeInput(){return this._pushRight(()=>{if(!this.block.isFixed)return this.offset=this.block.nearestInputPos(this.offset,DIRECTION.NONE),!0})}pushRightBeforeRequired(){return this._pushRight(()=>{if(!(this.block.isFixed||this.block.isOptional&&!this.block.value))return this.offset=this.block.nearestInputPos(this.offset,DIRECTION.NONE),!0})}}class PatternFixedDefinition{constructor(opts){Object.assign(this,opts),this._value="",this.isFixed=!0}get value(){return this._value}get unmaskedValue(){return this.isUnmasking?this.value:""}get rawInputValue(){return this._isRawInput?this.value:""}get displayValue(){return this.value}reset(){this._isRawInput=!1,this._value=""}remove(fromPos,toPos){return void 0===fromPos&&(fromPos=0),void 0===toPos&&(toPos=this._value.length),this._value=this._value.slice(0,fromPos)+this._value.slice(toPos),this._value||(this._isRawInput=!1),new ChangeDetails}nearestInputPos(cursorPos,direction){void 0===direction&&(direction=DIRECTION.NONE);const minPos=0,maxPos=this._value.length;switch(direction){case DIRECTION.LEFT:case DIRECTION.FORCE_LEFT:return 0;case DIRECTION.NONE:case DIRECTION.RIGHT:case DIRECTION.FORCE_RIGHT:default:return maxPos}}totalInputPositions(fromPos,toPos){return void 0===fromPos&&(fromPos=0),void 0===toPos&&(toPos=this._value.length),this._isRawInput?toPos-fromPos:0}extractInput(fromPos,toPos,flags){return void 0===fromPos&&(fromPos=0),void 0===toPos&&(toPos=this._value.length),void 0===flags&&(flags={}),flags.raw&&this._isRawInput&&this._value.slice(fromPos,toPos)||""}get isComplete(){return!0}get isFilled(){return Boolean(this._value)}_appendChar(ch,flags){if(void 0===flags&&(flags={}),this.isFilled)return new ChangeDetails;const appendEager=!0===this.eager||"append"===this.eager,appended=this.char===ch,isResolved=appended&&(this.isUnmasking||flags.input||flags.raw)&&(!flags.raw||!appendEager)&&!flags.tail,details=new ChangeDetails({inserted:this.char,rawInserted:isResolved?this.char:""});return this._value=this.char,this._isRawInput=isResolved&&(flags.raw||flags.input),details}_appendEager(){return this._appendChar(this.char,{tail:!0})}_appendPlaceholder(){const details=new ChangeDetails;return this.isFilled?details:(this._value=details.inserted=this.char,details)}extractTail(){return new ContinuousTailDetails("")}appendTail(tail){return isString(tail)&&(tail=new ContinuousTailDetails(String(tail))),tail.appendTo(this)}append(str,flags,tail){const details=this._appendChar(str[0],flags);return null!=tail&&(details.tailShift+=this.appendTail(tail).tailShift),details}doCommit(){}get state(){return{_value:this._value,_rawInputValue:this.rawInputValue}}set state(state){this._value=state._value,this._isRawInput=Boolean(state._rawInputValue)}pad(flags){return this._appendPlaceholder()}}class PatternInputDefinition{constructor(opts){const{parent:parent,isOptional:isOptional,placeholderChar:placeholderChar,displayChar:displayChar,lazy:lazy,eager:eager,...maskOpts}=opts;this.masked=createMask(maskOpts),Object.assign(this,{parent:parent,isOptional:isOptional,placeholderChar:placeholderChar,displayChar:displayChar,lazy:lazy,eager:eager})}reset(){this.isFilled=!1,this.masked.reset()}remove(fromPos,toPos){return void 0===fromPos&&(fromPos=0),void 0===toPos&&(toPos=this.value.length),0===fromPos&&toPos>=1?(this.isFilled=!1,this.masked.remove(fromPos,toPos)):new ChangeDetails}get value(){return this.masked.value||(this.isFilled&&!this.isOptional?this.placeholderChar:"")}get unmaskedValue(){return this.masked.unmaskedValue}get rawInputValue(){return this.masked.rawInputValue}get displayValue(){return this.masked.value&&this.displayChar||this.value}get isComplete(){return Boolean(this.masked.value)||this.isOptional}_appendChar(ch,flags){if(void 0===flags&&(flags={}),this.isFilled)return new ChangeDetails;const state=this.masked.state;let details=this.masked._appendChar(ch,this.currentMaskFlags(flags));return details.inserted&&!1===this.doValidate(flags)&&(details=new ChangeDetails,this.masked.state=state),details.inserted||this.isOptional||this.lazy||flags.input||(details.inserted=this.placeholderChar),details.skip=!details.inserted&&!this.isOptional,this.isFilled=Boolean(details.inserted),details}append(str,flags,tail){return this.masked.append(str,this.currentMaskFlags(flags),tail)}_appendPlaceholder(){return this.isFilled||this.isOptional?new ChangeDetails:(this.isFilled=!0,new ChangeDetails({inserted:this.placeholderChar}))}_appendEager(){return new ChangeDetails}extractTail(fromPos,toPos){return this.masked.extractTail(fromPos,toPos)}appendTail(tail){return this.masked.appendTail(tail)}extractInput(fromPos,toPos,flags){return void 0===fromPos&&(fromPos=0),void 0===toPos&&(toPos=this.value.length),this.masked.extractInput(fromPos,toPos,flags)}nearestInputPos(cursorPos,direction){void 0===direction&&(direction=DIRECTION.NONE);const minPos=0,maxPos=this.value.length,boundPos=Math.min(Math.max(cursorPos,0),maxPos);switch(direction){case DIRECTION.LEFT:case DIRECTION.FORCE_LEFT:return this.isComplete?boundPos:0;case DIRECTION.RIGHT:case DIRECTION.FORCE_RIGHT:return this.isComplete?boundPos:maxPos;case DIRECTION.NONE:default:return boundPos}}totalInputPositions(fromPos,toPos){return void 0===fromPos&&(fromPos=0),void 0===toPos&&(toPos=this.value.length),this.value.slice(fromPos,toPos).length}doValidate(flags){return this.masked.doValidate(this.currentMaskFlags(flags))&&(!this.parent||this.parent.doValidate(this.currentMaskFlags(flags)))}doCommit(){this.masked.doCommit()}get state(){return{_value:this.value,_rawInputValue:this.rawInputValue,masked:this.masked.state,isFilled:this.isFilled}}set state(state){this.masked.state=state.masked,this.isFilled=state.isFilled}currentMaskFlags(flags){var _flags$_beforeTailSta;return{...flags,_beforeTailState:(null==flags||null==(_flags$_beforeTailSta=flags._beforeTailState)?void 0:_flags$_beforeTailSta.masked)||(null==flags?void 0:flags._beforeTailState)}}pad(flags){return new ChangeDetails}}PatternInputDefinition.DEFAULT_DEFINITIONS={0:/\d/,a:/[\u0041-\u005A\u0061-\u007A\u00AA\u00B5\u00BA\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u0527\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0\u08A2-\u08AC\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0977\u0979-\u097F\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C33\u0C35-\u0C39\u0C3D\u0C58\u0C59\u0C60\u0C61\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D60\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F4\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191C\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19C1-\u19C7\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2183\u2184\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005\u3006\u3031-\u3035\u303B\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA697\uA6A0-\uA6E5\uA717-\uA71F\uA722-\uA788\uA78B-\uA78E\uA790-\uA793\uA7A0-\uA7AA\uA7F8-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA80-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uABC0-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]/,"*":/./};class MaskedRegExp extends Masked{updateOptions(opts){super.updateOptions(opts)}_update(opts){const mask=opts.mask;mask&&(opts.validate=value=>value.search(mask)>=0),super._update(opts)}}IMask.MaskedRegExp=MaskedRegExp;class MaskedPattern extends Masked{constructor(opts){super({...MaskedPattern.DEFAULTS,...opts,definitions:Object.assign({},PatternInputDefinition.DEFAULT_DEFINITIONS,null==opts?void 0:opts.definitions)})}updateOptions(opts){super.updateOptions(opts)}_update(opts){opts.definitions=Object.assign({},this.definitions,opts.definitions),super._update(opts),this._rebuildMask()}_rebuildMask(){const defs=this.definitions;this._blocks=[],this.exposeBlock=void 0,this._stops=[],this._maskedBlocks={};const pattern=this.mask;if(!pattern||!defs)return;let unmaskingBlock=!1,optionalBlock=!1;for(let i=0;i<pattern.length;++i){if(this.blocks){const p=pattern.slice(i),bNames=Object.keys(this.blocks).filter(bName=>0===p.indexOf(bName));bNames.sort((a,b)=>b.length-a.length);const bName=bNames[0];if(bName){const{expose:expose,repeat:repeat,...bOpts}=normalizeOpts(this.blocks[bName]),blockOpts={lazy:this.lazy,eager:this.eager,placeholderChar:this.placeholderChar,displayChar:this.displayChar,overwrite:this.overwrite,autofix:this.autofix,...bOpts,repeat:repeat,parent:this},maskedBlock=null!=repeat?new IMask.RepeatBlock(blockOpts):createMask(blockOpts);maskedBlock&&(this._blocks.push(maskedBlock),expose&&(this.exposeBlock=maskedBlock),this._maskedBlocks[bName]||(this._maskedBlocks[bName]=[]),this._maskedBlocks[bName].push(this._blocks.length-1)),i+=bName.length-1;continue}}let char=pattern[i],isInput=char in defs;if(char===MaskedPattern.STOP_CHAR){this._stops.push(this._blocks.length);continue}if("{"===char||"}"===char){unmaskingBlock=!unmaskingBlock;continue}if("["===char||"]"===char){optionalBlock=!optionalBlock;continue}if(char===MaskedPattern.ESCAPE_CHAR){if(++i,char=pattern[i],!char)break;isInput=!1}const def=isInput?new PatternInputDefinition({isOptional:optionalBlock,lazy:this.lazy,eager:this.eager,placeholderChar:this.placeholderChar,displayChar:this.displayChar,...normalizeOpts(defs[char]),parent:this}):new PatternFixedDefinition({char:char,eager:this.eager,isUnmasking:unmaskingBlock});this._blocks.push(def)}}get state(){return{...super.state,_blocks:this._blocks.map(b=>b.state)}}set state(state){if(!state)return void this.reset();const{_blocks:_blocks,...maskedState}=state;this._blocks.forEach((b,bi)=>b.state=_blocks[bi]),super.state=maskedState}reset(){super.reset(),this._blocks.forEach(b=>b.reset())}get isComplete(){return this.exposeBlock?this.exposeBlock.isComplete:this._blocks.every(b=>b.isComplete)}get isFilled(){return this._blocks.every(b=>b.isFilled)}get isFixed(){return this._blocks.every(b=>b.isFixed)}get isOptional(){return this._blocks.every(b=>b.isOptional)}doCommit(){this._blocks.forEach(b=>b.doCommit()),super.doCommit()}get unmaskedValue(){return this.exposeBlock?this.exposeBlock.unmaskedValue:this._blocks.reduce((str,b)=>str+b.unmaskedValue,"")}set unmaskedValue(unmaskedValue){if(this.exposeBlock){const tail=this.extractTail(this._blockStartPos(this._blocks.indexOf(this.exposeBlock))+this.exposeBlock.displayValue.length);this.exposeBlock.unmaskedValue=unmaskedValue,this.appendTail(tail),this.doCommit()}else super.unmaskedValue=unmaskedValue}get value(){return this.exposeBlock?this.exposeBlock.value:this._blocks.reduce((str,b)=>str+b.value,"")}set value(value){if(this.exposeBlock){const tail=this.extractTail(this._blockStartPos(this._blocks.indexOf(this.exposeBlock))+this.exposeBlock.displayValue.length);this.exposeBlock.value=value,this.appendTail(tail),this.doCommit()}else super.value=value}get typedValue(){return this.exposeBlock?this.exposeBlock.typedValue:super.typedValue}set typedValue(value){if(this.exposeBlock){const tail=this.extractTail(this._blockStartPos(this._blocks.indexOf(this.exposeBlock))+this.exposeBlock.displayValue.length);this.exposeBlock.typedValue=value,this.appendTail(tail),this.doCommit()}else super.typedValue=value}get displayValue(){return this._blocks.reduce((str,b)=>str+b.displayValue,"")}appendTail(tail){return super.appendTail(tail).aggregate(this._appendPlaceholder())}_appendEager(){var _this$_mapPosToBlock;const details=new ChangeDetails;let startBlockIndex=null==(_this$_mapPosToBlock=this._mapPosToBlock(this.displayValue.length))?void 0:_this$_mapPosToBlock.index;if(null==startBlockIndex)return details;this._blocks[startBlockIndex].isFilled&&++startBlockIndex;for(let bi=startBlockIndex;bi<this._blocks.length;++bi){const d=this._blocks[bi]._appendEager();if(!d.inserted)break;details.aggregate(d)}return details}_appendCharRaw(ch,flags){void 0===flags&&(flags={});const blockIter=this._mapPosToBlock(this.displayValue.length),details=new ChangeDetails;if(!blockIter)return details;for(let bi=blockIter.index,block;block=this._blocks[bi];++bi){var _flags$_beforeTailSta;const blockDetails=block._appendChar(ch,{...flags,_beforeTailState:null==(_flags$_beforeTailSta=flags._beforeTailState)||null==(_flags$_beforeTailSta=_flags$_beforeTailSta._blocks)?void 0:_flags$_beforeTailSta[bi]});if(details.aggregate(blockDetails),blockDetails.consumed)break}return details}extractTail(fromPos,toPos){void 0===fromPos&&(fromPos=0),void 0===toPos&&(toPos=this.displayValue.length);const chunkTail=new ChunksTailDetails;return fromPos===toPos?chunkTail:(this._forEachBlocksInRange(fromPos,toPos,(b,bi,bFromPos,bToPos)=>{const blockChunk=b.extractTail(bFromPos,bToPos);blockChunk.stop=this._findStopBefore(bi),blockChunk.from=this._blockStartPos(bi),blockChunk instanceof ChunksTailDetails&&(blockChunk.blockIndex=bi),chunkTail.extend(blockChunk)}),chunkTail)}extractInput(fromPos,toPos,flags){if(void 0===fromPos&&(fromPos=0),void 0===toPos&&(toPos=this.displayValue.length),void 0===flags&&(flags={}),fromPos===toPos)return"";let input="";return this._forEachBlocksInRange(fromPos,toPos,(b,_,fromPos,toPos)=>{input+=b.extractInput(fromPos,toPos,flags)}),input}_findStopBefore(blockIndex){let stopBefore;for(let si=0;si<this._stops.length;++si){const stop=this._stops[si];if(!(stop<=blockIndex))break;stopBefore=stop}return stopBefore}_appendPlaceholder(toBlockIndex){const details=new ChangeDetails;if(this.lazy&&null==toBlockIndex)return details;const startBlockIter=this._mapPosToBlock(this.displayValue.length);if(!startBlockIter)return details;const startBlockIndex=startBlockIter.index,endBlockIndex=null!=toBlockIndex?toBlockIndex:this._blocks.length;return this._blocks.slice(startBlockIndex,endBlockIndex).forEach(b=>{var _blocks2;b.lazy&&null==toBlockIndex||details.aggregate(b._appendPlaceholder(null==(_blocks2=b._blocks)?void 0:_blocks2.length))}),details}_mapPosToBlock(pos){let accVal="";for(let bi=0;bi<this._blocks.length;++bi){const block=this._blocks[bi],blockStartPos=accVal.length;if(accVal+=block.displayValue,pos<=accVal.length)return{index:bi,offset:pos-blockStartPos}}}_blockStartPos(blockIndex){return this._blocks.slice(0,blockIndex).reduce((pos,b)=>pos+b.displayValue.length,0)}_forEachBlocksInRange(fromPos,toPos,fn){void 0===toPos&&(toPos=this.displayValue.length);const fromBlockIter=this._mapPosToBlock(fromPos);if(fromBlockIter){const toBlockIter=this._mapPosToBlock(toPos),isSameBlock=toBlockIter&&fromBlockIter.index===toBlockIter.index,fromBlockStartPos=fromBlockIter.offset,fromBlockEndPos=toBlockIter&&isSameBlock?toBlockIter.offset:this._blocks[fromBlockIter.index].displayValue.length;if(fn(this._blocks[fromBlockIter.index],fromBlockIter.index,fromBlockStartPos,fromBlockEndPos),toBlockIter&&!isSameBlock){for(let bi=fromBlockIter.index+1;bi<toBlockIter.index;++bi)fn(this._blocks[bi],bi,0,this._blocks[bi].displayValue.length);fn(this._blocks[toBlockIter.index],toBlockIter.index,0,toBlockIter.offset)}}}remove(fromPos,toPos){void 0===fromPos&&(fromPos=0),void 0===toPos&&(toPos=this.displayValue.length);const removeDetails=super.remove(fromPos,toPos);return this._forEachBlocksInRange(fromPos,toPos,(b,_,bFromPos,bToPos)=>{removeDetails.aggregate(b.remove(bFromPos,bToPos))}),removeDetails}nearestInputPos(cursorPos,direction){if(void 0===direction&&(direction=DIRECTION.NONE),!this._blocks.length)return 0;const cursor=new PatternCursor(this,cursorPos);if(direction===DIRECTION.NONE)return cursor.pushRightBeforeInput()?cursor.pos:(cursor.popState(),cursor.pushLeftBeforeInput()?cursor.pos:this.displayValue.length);if(direction===DIRECTION.LEFT||direction===DIRECTION.FORCE_LEFT){if(direction===DIRECTION.LEFT){if(cursor.pushRightBeforeFilled(),cursor.ok&&cursor.pos===cursorPos)return cursorPos;cursor.popState()}if(cursor.pushLeftBeforeInput(),cursor.pushLeftBeforeRequired(),cursor.pushLeftBeforeFilled(),direction===DIRECTION.LEFT){if(cursor.pushRightBeforeInput(),cursor.pushRightBeforeRequired(),cursor.ok&&cursor.pos<=cursorPos)return cursor.pos;if(cursor.popState(),cursor.ok&&cursor.pos<=cursorPos)return cursor.pos;cursor.popState()}return cursor.ok?cursor.pos:direction===DIRECTION.FORCE_LEFT?0:(cursor.popState(),cursor.ok?cursor.pos:(cursor.popState(),cursor.ok?cursor.pos:0))}return direction===DIRECTION.RIGHT||direction===DIRECTION.FORCE_RIGHT?(cursor.pushRightBeforeInput(),cursor.pushRightBeforeRequired(),cursor.pushRightBeforeFilled()?cursor.pos:direction===DIRECTION.FORCE_RIGHT?this.displayValue.length:(cursor.popState(),cursor.ok?cursor.pos:(cursor.popState(),cursor.ok?cursor.pos:this.nearestInputPos(cursorPos,DIRECTION.LEFT)))):cursorPos}totalInputPositions(fromPos,toPos){void 0===fromPos&&(fromPos=0),void 0===toPos&&(toPos=this.displayValue.length);let total=0;return this._forEachBlocksInRange(fromPos,toPos,(b,_,bFromPos,bToPos)=>{total+=b.totalInputPositions(bFromPos,bToPos)}),total}maskedBlock(name){return this.maskedBlocks(name)[0]}maskedBlocks(name){const indices=this._maskedBlocks[name];return indices?indices.map(gi=>this._blocks[gi]):[]}pad(flags){const details=new ChangeDetails;return this._forEachBlocksInRange(0,this.displayValue.length,b=>details.aggregate(b.pad(flags))),details}}MaskedPattern.DEFAULTS={...Masked.DEFAULTS,lazy:!0,placeholderChar:"_"},MaskedPattern.STOP_CHAR="`",MaskedPattern.ESCAPE_CHAR="\\",MaskedPattern.InputDefinition=PatternInputDefinition,MaskedPattern.FixedDefinition=PatternFixedDefinition,IMask.MaskedPattern=MaskedPattern;class MaskedRange extends MaskedPattern{get _matchFrom(){return this.maxLength-String(this.from).length}constructor(opts){super(opts)}updateOptions(opts){super.updateOptions(opts)}_update(opts){const{to:to=this.to||0,from:from=this.from||0,maxLength:maxLength=this.maxLength||0,autofix:autofix=this.autofix,...patternOpts}=opts;this.to=to,this.from=from,this.maxLength=Math.max(String(to).length,maxLength),this.autofix=autofix;const fromStr=String(this.from).padStart(this.maxLength,"0"),toStr=String(this.to).padStart(this.maxLength,"0");let sameCharsCount=0;for(;sameCharsCount<toStr.length&&toStr[sameCharsCount]===fromStr[sameCharsCount];)++sameCharsCount;patternOpts.mask=toStr.slice(0,sameCharsCount).replace(/0/g,"\\0")+"0".repeat(this.maxLength-sameCharsCount),super._update(patternOpts)}get isComplete(){return super.isComplete&&Boolean(this.value)}boundaries(str){let minstr="",maxstr="";const[,placeholder,num]=str.match(/^(\D*)(\d*)(\D*)/)||[];return num&&(minstr="0".repeat(placeholder.length)+num,maxstr="9".repeat(placeholder.length)+num),minstr=minstr.padEnd(this.maxLength,"0"),maxstr=maxstr.padEnd(this.maxLength,"9"),[minstr,maxstr]}doPrepareChar(ch,flags){let details;return void 0===flags&&(flags={}),[ch,details]=super.doPrepareChar(ch.replace(/\D/g,""),flags),ch||(details.skip=!this.isComplete),[ch,details]}_appendCharRaw(ch,flags){if(void 0===flags&&(flags={}),!this.autofix||this.value.length+1>this.maxLength)return super._appendCharRaw(ch,flags);const fromStr=String(this.from).padStart(this.maxLength,"0"),toStr=String(this.to).padStart(this.maxLength,"0"),[minstr,maxstr]=this.boundaries(this.value+ch);return Number(maxstr)<this.from?super._appendCharRaw(fromStr[this.value.length],flags):Number(minstr)>this.to?!flags.tail&&"pad"===this.autofix&&this.value.length+1<this.maxLength?super._appendCharRaw(fromStr[this.value.length],flags).aggregate(this._appendCharRaw(ch,flags)):super._appendCharRaw(toStr[this.value.length],flags):super._appendCharRaw(ch,flags)}doValidate(flags){const str=this.value,firstNonZero=str.search(/[^0]/);if(-1===firstNonZero&&str.length<=this._matchFrom)return!0;const[minstr,maxstr]=this.boundaries(str);return this.from<=Number(maxstr)&&Number(minstr)<=this.to&&super.doValidate(flags)}pad(flags){const details=new ChangeDetails;if(this.value.length===this.maxLength)return details;const value=this.value,padLength=this.maxLength-this.value.length;if(padLength){this.reset();for(let i=0;i<padLength;++i)details.aggregate(super._appendCharRaw("0",flags));value.split("").forEach(ch=>this._appendCharRaw(ch))}return details}}IMask.MaskedRange=MaskedRange;const DefaultPattern="d{.}`m{.}`Y";class MaskedDate extends MaskedPattern{static extractPatternOptions(opts){const{mask:mask,pattern:pattern,...patternOpts}=opts;return{...patternOpts,mask:isString(mask)?mask:pattern}}constructor(opts){super(MaskedDate.extractPatternOptions({...MaskedDate.DEFAULTS,...opts}))}updateOptions(opts){super.updateOptions(opts)}_update(opts){const{mask:mask,pattern:pattern,blocks:blocks,...patternOpts}={...MaskedDate.DEFAULTS,...opts},patternBlocks=Object.assign({},MaskedDate.GET_DEFAULT_BLOCKS());opts.min&&(patternBlocks.Y.from=opts.min.getFullYear()),opts.max&&(patternBlocks.Y.to=opts.max.getFullYear()),opts.min&&opts.max&&patternBlocks.Y.from===patternBlocks.Y.to&&(patternBlocks.m.from=opts.min.getMonth()+1,patternBlocks.m.to=opts.max.getMonth()+1,patternBlocks.m.from===patternBlocks.m.to&&(patternBlocks.d.from=opts.min.getDate(),patternBlocks.d.to=opts.max.getDate())),Object.assign(patternBlocks,this.blocks,blocks),super._update({...patternOpts,mask:isString(mask)?mask:pattern,blocks:patternBlocks})}doValidate(flags){const date=this.date;return super.doValidate(flags)&&(!this.isComplete||this.isDateExist(this.value)&&null!=date&&(null==this.min||this.min<=date)&&(null==this.max||date<=this.max))}isDateExist(str){return this.format(this.parse(str,this),this).indexOf(str)>=0}get date(){return this.typedValue}set date(date){this.typedValue=date}get typedValue(){return this.isComplete?super.typedValue:null}set typedValue(value){super.typedValue=value}maskEquals(mask){return mask===Date||super.maskEquals(mask)}optionsIsChanged(opts){return super.optionsIsChanged(MaskedDate.extractPatternOptions(opts))}}MaskedDate.GET_DEFAULT_BLOCKS=()=>({d:{mask:MaskedRange,from:1,to:31,maxLength:2},m:{mask:MaskedRange,from:1,to:12,maxLength:2},Y:{mask:MaskedRange,from:1900,to:9999}}),MaskedDate.DEFAULTS={...MaskedPattern.DEFAULTS,mask:Date,pattern:"d{.}`m{.}`Y",format:(date,masked)=>{if(!date)return"";const day=String(date.getDate()).padStart(2,"0"),month=String(date.getMonth()+1).padStart(2,"0"),year=date.getFullYear();return[day,month,year].join(".")},parse:(str,masked)=>{const[day,month,year]=str.split(".").map(Number);return new Date(year,month-1,day)}},IMask.MaskedDate=MaskedDate;class MaskedDynamic extends Masked{constructor(opts){super({...MaskedDynamic.DEFAULTS,...opts}),this.currentMask=void 0}updateOptions(opts){super.updateOptions(opts)}_update(opts){super._update(opts),"mask"in opts&&(this.exposeMask=void 0,this.compiledMasks=Array.isArray(opts.mask)?opts.mask.map(m=>{const{expose:expose,...maskOpts}=normalizeOpts(m),masked=createMask({overwrite:this._overwrite,eager:this._eager,skipInvalid:this._skipInvalid,...maskOpts});return expose&&(this.exposeMask=masked),masked}):[])}_appendCharRaw(ch,flags){void 0===flags&&(flags={});const details=this._applyDispatch(ch,flags);return this.currentMask&&details.aggregate(this.currentMask._appendChar(ch,this.currentMaskFlags(flags))),details}_applyDispatch(appended,flags,tail){void 0===appended&&(appended=""),void 0===flags&&(flags={}),void 0===tail&&(tail="");const prevValueBeforeTail=flags.tail&&null!=flags._beforeTailState?flags._beforeTailState._value:this.value,inputValue=this.rawInputValue,insertValue=flags.tail&&null!=flags._beforeTailState?flags._beforeTailState._rawInputValue:inputValue,tailValue=inputValue.slice(insertValue.length),prevMask=this.currentMask,details=new ChangeDetails,prevMaskState=null==prevMask?void 0:prevMask.state;return this.currentMask=this.doDispatch(appended,{...flags},tail),this.currentMask&&(this.currentMask!==prevMask?(this.currentMask.reset(),insertValue&&(this.currentMask.append(insertValue,{raw:!0}),details.tailShift=this.currentMask.value.length-prevValueBeforeTail.length),tailValue&&(details.tailShift+=this.currentMask.append(tailValue,{raw:!0,tail:!0}).tailShift)):prevMaskState&&(this.currentMask.state=prevMaskState)),details}_appendPlaceholder(){const details=this._applyDispatch();return this.currentMask&&details.aggregate(this.currentMask._appendPlaceholder()),details}_appendEager(){const details=this._applyDispatch();return this.currentMask&&details.aggregate(this.currentMask._appendEager()),details}appendTail(tail){const details=new ChangeDetails;return tail&&details.aggregate(this._applyDispatch("",{},tail)),details.aggregate(this.currentMask?this.currentMask.appendTail(tail):super.appendTail(tail))}currentMaskFlags(flags){var _flags$_beforeTailSta,_flags$_beforeTailSta2;return{...flags,_beforeTailState:(null==(_flags$_beforeTailSta=flags._beforeTailState)?void 0:_flags$_beforeTailSta.currentMaskRef)===this.currentMask&&(null==(_flags$_beforeTailSta2=flags._beforeTailState)?void 0:_flags$_beforeTailSta2.currentMask)||flags._beforeTailState}}doDispatch(appended,flags,tail){return void 0===flags&&(flags={}),void 0===tail&&(tail=""),this.dispatch(appended,this,flags,tail)}doValidate(flags){return super.doValidate(flags)&&(!this.currentMask||this.currentMask.doValidate(this.currentMaskFlags(flags)))}doPrepare(str,flags){void 0===flags&&(flags={});let[s,details]=super.doPrepare(str,flags);if(this.currentMask){let currentDetails;[s,currentDetails]=super.doPrepare(s,this.currentMaskFlags(flags)),details=details.aggregate(currentDetails)}return[s,details]}doPrepareChar(str,flags){void 0===flags&&(flags={});let[s,details]=super.doPrepareChar(str,flags);if(this.currentMask){let currentDetails;[s,currentDetails]=super.doPrepareChar(s,this.currentMaskFlags(flags)),details=details.aggregate(currentDetails)}return[s,details]}reset(){var _this$currentMask;null==(_this$currentMask=this.currentMask)||_this$currentMask.reset(),this.compiledMasks.forEach(m=>m.reset())}get value(){return this.exposeMask?this.exposeMask.value:this.currentMask?this.currentMask.value:""}set value(value){this.exposeMask?(this.exposeMask.value=value,this.currentMask=this.exposeMask,this._applyDispatch()):super.value=value}get unmaskedValue(){return this.exposeMask?this.exposeMask.unmaskedValue:this.currentMask?this.currentMask.unmaskedValue:""}set unmaskedValue(unmaskedValue){this.exposeMask?(this.exposeMask.unmaskedValue=unmaskedValue,this.currentMask=this.exposeMask,this._applyDispatch()):super.unmaskedValue=unmaskedValue}get typedValue(){return this.exposeMask?this.exposeMask.typedValue:this.currentMask?this.currentMask.typedValue:""}set typedValue(typedValue){if(this.exposeMask)return this.exposeMask.typedValue=typedValue,this.currentMask=this.exposeMask,void this._applyDispatch();let unmaskedValue=String(typedValue);this.currentMask&&(this.currentMask.typedValue=typedValue,unmaskedValue=this.currentMask.unmaskedValue),this.unmaskedValue=unmaskedValue}get displayValue(){return this.currentMask?this.currentMask.displayValue:""}get isComplete(){var _this$currentMask2;return Boolean(null==(_this$currentMask2=this.currentMask)?void 0:_this$currentMask2.isComplete)}get isFilled(){var _this$currentMask3;return Boolean(null==(_this$currentMask3=this.currentMask)?void 0:_this$currentMask3.isFilled)}remove(fromPos,toPos){const details=new ChangeDetails;return this.currentMask&&details.aggregate(this.currentMask.remove(fromPos,toPos)).aggregate(this._applyDispatch()),details}get state(){var _this$currentMask4;return{...super.state,_rawInputValue:this.rawInputValue,compiledMasks:this.compiledMasks.map(m=>m.state),currentMaskRef:this.currentMask,currentMask:null==(_this$currentMask4=this.currentMask)?void 0:_this$currentMask4.state}}set state(state){const{compiledMasks:compiledMasks,currentMaskRef:currentMaskRef,currentMask:currentMask,...maskedState}=state;compiledMasks&&this.compiledMasks.forEach((m,mi)=>m.state=compiledMasks[mi]),null!=currentMaskRef&&(this.currentMask=currentMaskRef,this.currentMask.state=currentMask),super.state=maskedState}extractInput(fromPos,toPos,flags){return this.currentMask?this.currentMask.extractInput(fromPos,toPos,flags):""}extractTail(fromPos,toPos){return this.currentMask?this.currentMask.extractTail(fromPos,toPos):super.extractTail(fromPos,toPos)}doCommit(){this.currentMask&&this.currentMask.doCommit(),super.doCommit()}nearestInputPos(cursorPos,direction){return this.currentMask?this.currentMask.nearestInputPos(cursorPos,direction):super.nearestInputPos(cursorPos,direction)}get overwrite(){return this.currentMask?this.currentMask.overwrite:this._overwrite}set overwrite(overwrite){this._overwrite=overwrite}get eager(){return this.currentMask?this.currentMask.eager:this._eager}set eager(eager){this._eager=eager}get skipInvalid(){return this.currentMask?this.currentMask.skipInvalid:this._skipInvalid}set skipInvalid(skipInvalid){this._skipInvalid=skipInvalid}get autofix(){return this.currentMask?this.currentMask.autofix:this._autofix}set autofix(autofix){this._autofix=autofix}maskEquals(mask){return Array.isArray(mask)?this.compiledMasks.every((m,mi)=>{if(!mask[mi])return;const{mask:oldMask,...restOpts}=mask[mi];return objectIncludes(m,restOpts)&&m.maskEquals(oldMask)}):super.maskEquals(mask)}typedValueEquals(value){var _this$currentMask5;return Boolean(null==(_this$currentMask5=this.currentMask)?void 0:_this$currentMask5.typedValueEquals(value))}}MaskedDynamic.DEFAULTS={...Masked.DEFAULTS,dispatch:(appended,masked,flags,tail)=>{if(!masked.compiledMasks.length)return;const inputValue=masked.rawInputValue,inputs=masked.compiledMasks.map((m,index)=>{const isCurrent=masked.currentMask===m,startInputPos=isCurrent?m.displayValue.length:m.nearestInputPos(m.displayValue.length,DIRECTION.FORCE_LEFT);return m.rawInputValue!==inputValue?(m.reset(),m.append(inputValue,{raw:!0})):isCurrent||m.remove(startInputPos),m.append(appended,masked.currentMaskFlags(flags)),m.appendTail(tail),{index:index,weight:m.rawInputValue.length,totalInputPositions:m.totalInputPositions(0,Math.max(startInputPos,m.nearestInputPos(m.displayValue.length,DIRECTION.FORCE_LEFT)))}});return inputs.sort((i1,i2)=>i2.weight-i1.weight||i2.totalInputPositions-i1.totalInputPositions),masked.compiledMasks[inputs[0].index]}},IMask.MaskedDynamic=MaskedDynamic;class MaskedEnum extends MaskedPattern{constructor(opts){super({...MaskedEnum.DEFAULTS,...opts})}updateOptions(opts){super.updateOptions(opts)}_update(opts){const{enum:enum_,...eopts}=opts;if(enum_){const lengths=enum_.map(e=>e.length),requiredLength=Math.min(...lengths),optionalLength=Math.max(...lengths)-requiredLength;eopts.mask="*".repeat(requiredLength),optionalLength&&(eopts.mask+="["+"*".repeat(optionalLength)+"]"),this.enum=enum_}super._update(eopts)}_appendCharRaw(ch,flags){void 0===flags&&(flags={});const matchFrom=Math.min(this.nearestInputPos(0,DIRECTION.FORCE_RIGHT),this.value.length),matches=this.enum.filter(e=>this.matchValue(e,this.unmaskedValue+ch,matchFrom));if(matches.length){1===matches.length&&this._forEachBlocksInRange(0,this.value.length,(b,bi)=>{const mch=matches[0][bi];bi>=this.value.length||mch===b.value||(b.reset(),b._appendChar(mch,flags))});const d=super._appendCharRaw(matches[0][this.value.length],flags);return 1===matches.length&&matches[0].slice(this.unmaskedValue.length).split("").forEach(mch=>d.aggregate(super._appendCharRaw(mch))),d}return new ChangeDetails({skip:!this.isComplete})}extractTail(fromPos,toPos){return void 0===fromPos&&(fromPos=0),void 0===toPos&&(toPos=this.displayValue.length),new ContinuousTailDetails("",fromPos)}remove(fromPos,toPos){if(void 0===fromPos&&(fromPos=0),void 0===toPos&&(toPos=this.displayValue.length),fromPos===toPos)return new ChangeDetails;const matchFrom=Math.min(super.nearestInputPos(0,DIRECTION.FORCE_RIGHT),this.value.length);let pos;for(pos=fromPos;pos>=0;--pos){const matches=this.enum.filter(e=>this.matchValue(e,this.value.slice(matchFrom,pos),matchFrom));if(matches.length>1)break}const details=super.remove(pos,toPos);return details.tailShift+=pos-fromPos,details}get isComplete(){return this.enum.indexOf(this.value)>=0}}MaskedEnum.DEFAULTS={...MaskedPattern.DEFAULTS,matchValue:(estr,istr,matchFrom)=>estr.indexOf(istr,matchFrom)===matchFrom},IMask.MaskedEnum=MaskedEnum;class MaskedFunction extends Masked{updateOptions(opts){super.updateOptions(opts)}_update(opts){super._update({...opts,validate:opts.mask})}}var _MaskedNumber;IMask.MaskedFunction=MaskedFunction;class MaskedNumber extends Masked{constructor(opts){super({...MaskedNumber.DEFAULTS,...opts})}updateOptions(opts){super.updateOptions(opts)}_update(opts){super._update(opts),this._updateRegExps()}_updateRegExps(){const start="^"+(this.allowNegative?"[+|\\-]?":""),mid="\\d*",end=(this.scale?"("+escapeRegExp(this.radix)+"\\d{0,"+this.scale+"})?":"")+"$";this._numberRegExp=new RegExp(start+mid+end),this._mapToRadixRegExp=new RegExp("["+this.mapToRadix.map(escapeRegExp).join("")+"]","g"),this._thousandsSeparatorRegExp=new RegExp(escapeRegExp(this.thousandsSeparator),"g")}_removeThousandsSeparators(value){return value.replace(this._thousandsSeparatorRegExp,"")}_insertThousandsSeparators(value){const parts=value.split(this.radix);return parts[0]=parts[0].replace(/\B(?=(\d{3})+(?!\d))/g,this.thousandsSeparator),parts.join(this.radix)}doPrepareChar(ch,flags){void 0===flags&&(flags={});const[prepCh,details]=super.doPrepareChar(this._removeThousandsSeparators(this.scale&&this.mapToRadix.length&&(flags.input&&flags.raw||!flags.input&&!flags.raw)?ch.replace(this._mapToRadixRegExp,this.radix):ch),flags);return ch&&!prepCh&&(details.skip=!0),!prepCh||this.allowPositive||this.value||"-"===prepCh||details.aggregate(this._appendChar("-")),[prepCh,details]}_separatorsCount(to,extendOnSeparators){void 0===extendOnSeparators&&(extendOnSeparators=!1);let count=0;for(let pos=0;pos<to;++pos)this._value.indexOf(this.thousandsSeparator,pos)===pos&&(++count,extendOnSeparators&&(to+=this.thousandsSeparator.length));return count}_separatorsCountFromSlice(slice){return void 0===slice&&(slice=this._value),this._separatorsCount(this._removeThousandsSeparators(slice).length,!0)}extractInput(fromPos,toPos,flags){return void 0===fromPos&&(fromPos=0),void 0===toPos&&(toPos=this.displayValue.length),[fromPos,toPos]=this._adjustRangeWithSeparators(fromPos,toPos),this._removeThousandsSeparators(super.extractInput(fromPos,toPos,flags))}_appendCharRaw(ch,flags){void 0===flags&&(flags={});const prevBeforeTailValue=flags.tail&&flags._beforeTailState?flags._beforeTailState._value:this._value,prevBeforeTailSeparatorsCount=this._separatorsCountFromSlice(prevBeforeTailValue);this._value=this._removeThousandsSeparators(this.value);const oldValue=this._value;this._value+=ch;const num=this.number;let accepted=!isNaN(num),skip=!1,appendDetails;if(accepted){let fixedNum;null!=this.min&&this.min<0&&this.number<this.min&&(fixedNum=this.min),null!=this.max&&this.max>0&&this.number>this.max&&(fixedNum=this.max),null!=fixedNum&&(this.autofix?(this._value=this.format(fixedNum,this).replace(MaskedNumber.UNMASKED_RADIX,this.radix),skip||(skip=oldValue===this._value&&!flags.tail)):accepted=!1),accepted&&(accepted=Boolean(this._value.match(this._numberRegExp)))}accepted?appendDetails=new ChangeDetails({inserted:this._value.slice(oldValue.length),rawInserted:skip?"":ch,skip:skip}):(this._value=oldValue,appendDetails=new ChangeDetails),this._value=this._insertThousandsSeparators(this._value);const beforeTailValue=flags.tail&&flags._beforeTailState?flags._beforeTailState._value:this._value,beforeTailSeparatorsCount=this._separatorsCountFromSlice(beforeTailValue);return appendDetails.tailShift+=(beforeTailSeparatorsCount-prevBeforeTailSeparatorsCount)*this.thousandsSeparator.length,appendDetails}_findSeparatorAround(pos){if(this.thousandsSeparator){const searchFrom=pos-this.thousandsSeparator.length+1,separatorPos=this.value.indexOf(this.thousandsSeparator,searchFrom);if(separatorPos<=pos)return separatorPos}return-1}_adjustRangeWithSeparators(from,to){const separatorAroundFromPos=this._findSeparatorAround(from);separatorAroundFromPos>=0&&(from=separatorAroundFromPos);const separatorAroundToPos=this._findSeparatorAround(to);return separatorAroundToPos>=0&&(to=separatorAroundToPos+this.thousandsSeparator.length),[from,to]}remove(fromPos,toPos){void 0===fromPos&&(fromPos=0),void 0===toPos&&(toPos=this.displayValue.length),[fromPos,toPos]=this._adjustRangeWithSeparators(fromPos,toPos);const valueBeforePos=this.value.slice(0,fromPos),valueAfterPos=this.value.slice(toPos),prevBeforeTailSeparatorsCount=this._separatorsCount(valueBeforePos.length);this._value=this._insertThousandsSeparators(this._removeThousandsSeparators(valueBeforePos+valueAfterPos));const beforeTailSeparatorsCount=this._separatorsCountFromSlice(valueBeforePos);return new ChangeDetails({tailShift:(beforeTailSeparatorsCount-prevBeforeTailSeparatorsCount)*this.thousandsSeparator.length})}nearestInputPos(cursorPos,direction){if(!this.thousandsSeparator)return cursorPos;switch(direction){case DIRECTION.NONE:case DIRECTION.LEFT:case DIRECTION.FORCE_LEFT:{const separatorAtLeftPos=this._findSeparatorAround(cursorPos-1);if(separatorAtLeftPos>=0){const separatorAtLeftEndPos=separatorAtLeftPos+this.thousandsSeparator.length;if(cursorPos<separatorAtLeftEndPos||this.value.length<=separatorAtLeftEndPos||direction===DIRECTION.FORCE_LEFT)return separatorAtLeftPos}break}case DIRECTION.RIGHT:case DIRECTION.FORCE_RIGHT:{const separatorAtRightPos=this._findSeparatorAround(cursorPos);if(separatorAtRightPos>=0)return separatorAtRightPos+this.thousandsSeparator.length}}return cursorPos}doCommit(){if(this.value){const number=this.number;let validnum=number;null!=this.min&&(validnum=Math.max(validnum,this.min)),null!=this.max&&(validnum=Math.min(validnum,this.max)),validnum!==number&&(this.unmaskedValue=this.format(validnum,this));let formatted=this.value;this.normalizeZeros&&(formatted=this._normalizeZeros(formatted)),this.padFractionalZeros&&this.scale>0&&(formatted=this._padFractionalZeros(formatted)),this._value=formatted}super.doCommit()}_normalizeZeros(value){const parts=this._removeThousandsSeparators(value).split(this.radix);return parts[0]=parts[0].replace(/^(\D*)(0*)(\d*)/,(match,sign,zeros,num)=>sign+num),value.length&&!/\d$/.test(parts[0])&&(parts[0]=parts[0]+"0"),parts.length>1&&(parts[1]=parts[1].replace(/0*$/,""),parts[1].length||(parts.length=1)),this._insertThousandsSeparators(parts.join(this.radix))}_padFractionalZeros(value){if(!value)return value;const parts=value.split(this.radix);return parts.length<2&&parts.push(""),parts[1]=parts[1].padEnd(this.scale,"0"),parts.join(this.radix)}doSkipInvalid(ch,flags,checkTail){void 0===flags&&(flags={});const dropFractional=0===this.scale&&ch!==this.thousandsSeparator&&(ch===this.radix||ch===MaskedNumber.UNMASKED_RADIX||this.mapToRadix.includes(ch));return super.doSkipInvalid(ch,flags,checkTail)&&!dropFractional}get unmaskedValue(){return this._removeThousandsSeparators(this._normalizeZeros(this.value)).replace(this.radix,MaskedNumber.UNMASKED_RADIX)}set unmaskedValue(unmaskedValue){super.unmaskedValue=unmaskedValue}get typedValue(){return this.parse(this.unmaskedValue,this)}set typedValue(n){this.rawInputValue=this.format(n,this).replace(MaskedNumber.UNMASKED_RADIX,this.radix)}get number(){return this.typedValue}set number(number){this.typedValue=number}get allowNegative(){return null!=this.min&&this.min<0||null!=this.max&&this.max<0}get allowPositive(){return null!=this.min&&this.min>0||null!=this.max&&this.max>0}typedValueEquals(value){return(super.typedValueEquals(value)||MaskedNumber.EMPTY_VALUES.includes(value)&&MaskedNumber.EMPTY_VALUES.includes(this.typedValue))&&!(0===value&&""===this.value)}}_MaskedNumber=MaskedNumber,MaskedNumber.UNMASKED_RADIX=".",MaskedNumber.EMPTY_VALUES=[...Masked.EMPTY_VALUES,0],MaskedNumber.DEFAULTS={...Masked.DEFAULTS,mask:Number,radix:",",thousandsSeparator:"",mapToRadix:[_MaskedNumber.UNMASKED_RADIX],min:Number.MIN_SAFE_INTEGER,max:Number.MAX_SAFE_INTEGER,scale:2,normalizeZeros:!0,padFractionalZeros:!1,parse:Number,format:n=>n.toLocaleString("en-US",{useGrouping:!1,maximumFractionDigits:20})},IMask.MaskedNumber=MaskedNumber;const PIPE_TYPE={MASKED:"value",UNMASKED:"unmaskedValue",TYPED:"typedValue"};function createPipe(arg,from,to){void 0===from&&(from=PIPE_TYPE.MASKED),void 0===to&&(to=PIPE_TYPE.MASKED);const masked=createMask(arg);return value=>masked.runIsolated(m=>(m[from]=value,m[to]))}function pipe(value,mask,from,to){return createPipe(mask,from,to)(value)}IMask.PIPE_TYPE=PIPE_TYPE,IMask.createPipe=createPipe,IMask.pipe=pipe;class RepeatBlock extends MaskedPattern{get repeatFrom(){var _ref;return null!=(_ref=Array.isArray(this.repeat)?this.repeat[0]:this.repeat===1/0?0:this.repeat)?_ref:0}get repeatTo(){var _ref2;return null!=(_ref2=Array.isArray(this.repeat)?this.repeat[1]:this.repeat)?_ref2:1/0}constructor(opts){super(opts)}updateOptions(opts){super.updateOptions(opts)}_update(opts){var _ref3,_ref4,_this$_blocks;const{repeat:repeat,...blockOpts}=normalizeOpts(opts);this._blockOpts=Object.assign({},this._blockOpts,blockOpts);const block=createMask(this._blockOpts);this.repeat=null!=(_ref3=null!=(_ref4=null!=repeat?repeat:block.repeat)?_ref4:this.repeat)?_ref3:1/0,super._update({mask:"m".repeat(Math.max(this.repeatTo===1/0&&(null==(_this$_blocks=this._blocks)?void 0:_this$_blocks.length)||0,this.repeatFrom)),blocks:{m:block},eager:block.eager,overwrite:block.overwrite,skipInvalid:block.skipInvalid,lazy:block.lazy,placeholderChar:block.placeholderChar,displayChar:block.displayChar})}_allocateBlock(bi){return bi<this._blocks.length?this._blocks[bi]:this.repeatTo===1/0||this._blocks.length<this.repeatTo?(this._blocks.push(createMask(this._blockOpts)),this.mask+="m",this._blocks[this._blocks.length-1]):void 0}_appendCharRaw(ch,flags){void 0===flags&&(flags={});const details=new ChangeDetails;for(let bi=null!=(_this$_mapPosToBlock$=null==(_this$_mapPosToBlock=this._mapPosToBlock(this.displayValue.length))?void 0:_this$_mapPosToBlock.index)?_this$_mapPosToBlock$:Math.max(this._blocks.length-1,0),block,allocated;block=null!=(_this$_blocks$bi=this._blocks[bi])?_this$_blocks$bi:allocated=!allocated&&this._allocateBlock(bi);++bi){var _this$_mapPosToBlock$,_this$_mapPosToBlock,_this$_blocks$bi,_flags$_beforeTailSta;const blockDetails=block._appendChar(ch,{...flags,_beforeTailState:null==(_flags$_beforeTailSta=flags._beforeTailState)||null==(_flags$_beforeTailSta=_flags$_beforeTailSta._blocks)?void 0:_flags$_beforeTailSta[bi]});if(blockDetails.skip&&allocated){this._blocks.pop(),this.mask=this.mask.slice(1);break}if(details.aggregate(blockDetails),blockDetails.consumed)break}return details}_trimEmptyTail(fromPos,toPos){var _this$_mapPosToBlock2,_this$_mapPosToBlock3;void 0===fromPos&&(fromPos=0);const firstBlockIndex=Math.max((null==(_this$_mapPosToBlock2=this._mapPosToBlock(fromPos))?void 0:_this$_mapPosToBlock2.index)||0,this.repeatFrom,0);let lastBlockIndex;null!=toPos&&(lastBlockIndex=null==(_this$_mapPosToBlock3=this._mapPosToBlock(toPos))?void 0:_this$_mapPosToBlock3.index),null==lastBlockIndex&&(lastBlockIndex=this._blocks.length-1);let removeCount=0;for(let blockIndex=lastBlockIndex;firstBlockIndex<=blockIndex&&!this._blocks[blockIndex].unmaskedValue;--blockIndex,++removeCount);removeCount&&(this._blocks.splice(lastBlockIndex-removeCount+1,removeCount),this.mask=this.mask.slice(removeCount))}reset(){super.reset(),this._trimEmptyTail()}remove(fromPos,toPos){void 0===fromPos&&(fromPos=0),void 0===toPos&&(toPos=this.displayValue.length);const removeDetails=super.remove(fromPos,toPos);return this._trimEmptyTail(fromPos,toPos),removeDetails}totalInputPositions(fromPos,toPos){return void 0===fromPos&&(fromPos=0),null==toPos&&this.repeatTo===1/0?1/0:super.totalInputPositions(fromPos,toPos)}get state(){return super.state}set state(state){this._blocks.length=state._blocks.length,this.mask=this.mask.slice(0,this._blocks.length),super.state=state}}IMask.RepeatBlock=RepeatBlock;try{globalThis.IMask=IMask}catch{}exports.ChangeDetails=ChangeDetails,exports.ChunksTailDetails=ChunksTailDetails,exports.DIRECTION=DIRECTION,exports.HTMLContenteditableMaskElement=HTMLContenteditableMaskElement,exports.HTMLInputMaskElement=HTMLInputMaskElement,exports.HTMLMaskElement=HTMLMaskElement,exports.InputMask=InputMask,exports.MaskElement=MaskElement,exports.Masked=Masked,exports.MaskedDate=MaskedDate,exports.MaskedDynamic=MaskedDynamic,exports.MaskedEnum=MaskedEnum,exports.MaskedFunction=MaskedFunction,exports.MaskedNumber=MaskedNumber,exports.MaskedPattern=MaskedPattern,exports.MaskedRange=MaskedRange,exports.MaskedRegExp=MaskedRegExp,exports.PIPE_TYPE=PIPE_TYPE,exports.PatternFixedDefinition=PatternFixedDefinition,exports.PatternInputDefinition=PatternInputDefinition,exports.RepeatBlock=RepeatBlock,exports.createMask=createMask,exports.createPipe=createPipe,exports.default=IMask,exports.forceDirection=forceDirection,exports.normalizeOpts=normalizeOpts,exports.pipe=pipe,Object.defineProperty(exports,"__esModule",{value:!0})}));