// Add event listener for keyboard navigation (ESC, Arrow Left, Arrow Right)
document.addEventListener('keydown', (event) => {
    const slideshowContainer = document.getElementById('slideshowContainer');
    if (slideshowContainer.style.display === 'flex') {
        if (event.key === 'Escape') {
            slideshowContainer.style.display = 'none';
            pauseSlideshow();
            isPlaying = false;
        } else if (event.key === 'ArrowLeft') {
            stopSlideshow();
            goToPrevSlide();
            startSlideshow();
        } else if (event.key === 'ArrowRight') {
            stopSlideshow();
            goToNextSlide();
            startSlideshow();
        }
    }
});

document.getElementById('slideshowContainer').addEventListener('click', (event) => {
    const target = event.target;
    // Check if the device is desktop (window width >= 768px)
    if (window.innerWidth >= 768) {
        // Check if clicked area is not the slideshow content or buttons
        if (!target.closest('#slideshowTrack') && 
            !target.closest('#prevBtn') && 
            !target.closest('#nextBtn') && 
            !target.closest('#pauseBtn') && 
            !target.closest('#closeBtn') && 
            !target.closest('#gridBtn') && 
            !target.closest('#thumbnailContainer')) {
            document.getElementById('slideshowContainer').style.display = 'none';
            pauseSlideshow();
            isPlaying = false;
        }
    }
    // Check if the device is mobile (window width < 768px)
    else {
        // Close slideshow if tapped outside content and buttons (except close button)
        if (!target.closest('#slideshowTrack') && 
            !target.closest('#prevBtn') && 
            !target.closest('#nextBtn') && 
            !target.closest('#pauseBtn') && 
            !target.closest('#gridBtn') && 
            !target.closest('#thumbnailContainer')) {
            document.getElementById('slideshowContainer').style.display = 'none';
            pauseSlideshow();
            isPlaying = false;
        }
    }
});

// Variables for image containers
const largeImageContainer = document.getElementById('largeImageContainer');
const smallImagesContainer = document.getElementById('smallImagesContainer');

// Variables for slideshow
let currentIndex = 0;
let slideshowInterval;
let isPlaying = false;
let isUserInteracting = false;
let touchStartX = 0;
let touchStartY = 0;

const intervalTime = 3000;
const transitionTime = 500;

// Initialize large image
largeImageContainer.innerHTML = `<img src="${images[0]}" class="theme3_property_photos" alt="" data-index="0" onClick="openSlideshow(0);" id="first_property_picture">`;

// Initialize small images
for (let i = 1; i < images.length; i++) {
    const item = document.createElement('div');
    item.classList.add('gallery-item-small');
    item.innerHTML = `<img src="${images[i]}" class="theme3_property_photos" alt="Image ${i + 1}" data-index="${i}">`;
    item.querySelector('img').addEventListener('click', (e) => openSlideshow(parseInt(e.target.getAttribute('data-index'))));
    
    if (i === images.length - 1) {
        const moreImage = document.createElement('div');
        moreImage.classList.add('more-image');
        moreImage.textContent = moreImageText;
        if(count_photos > count_photos1) {
            item.appendChild(moreImage);
        }
    }
    smallImagesContainer.appendChild(item);
}

// Add random text for odd number of images
if ((images.length) % 2 !== 1 || images.length <= 2) {
    const textItem = document.createElement('div');
    textItem.classList.add('gallery-item-small', 'random-text');
    textItem.textContent = randomTexts[Math.floor(Math.random() * randomTexts.length)];
    smallImagesContainer.appendChild(textItem);
}

// Adjust layout for single image
if(images.length == 1) {
    smallImagesContainer.style.gridTemplateColumns = '1fr';
}

// Mobile gallery update
function updateGalleryForMobile() {
    const gallery = document.querySelector('.gallery');
    const images = gallery.querySelectorAll('img');

    if (window.innerWidth < 768) {
        images.forEach((img, index) => {
            img.style.display = index === 0 ? 'block' : 'none';
        });
    } else {
        images.forEach(img => {
            img.style.display = 'block';
        });
    }
}

// Slideshow functionality
const slideshowTrack = document.getElementById('slideshowTrack');
const pauseBtn = document.getElementById('pauseBtn');

// Touch event listeners for swipe
slideshowTrack.addEventListener('touchstart', function(e) {
    touchStartX = e.touches[0].clientX;
    touchStartY = e.touches[0].clientY;
});

slideshowTrack.addEventListener('touchmove', function(e) {
    if (e.touches.length > 1) return;
    
    const touch = e.touches[0];
    const deltaX = touch.clientX - touchStartX;
    const deltaY = touch.clientY - touchStartY;
    
    if (Math.abs(deltaX) > Math.abs(deltaY)) {
        e.preventDefault();
    }
}, { passive: false });

slideshowTrack.addEventListener('touchend', function(e) {
    if (touchStartX === 0) return;
    
    const touchEnd = e.changedTouches[0];
    const deltaX = touchEnd.clientX - touchStartX;
    const deltaY = touchEnd.clientY - touchStartY;
    
    if (Math.abs(deltaX) > Math.abs(deltaY) && Math.abs(deltaX) > 30) {
        if (deltaX > 0) {
            handleUserInteraction();
            goToPrevSlide();
        } else {
            handleUserInteraction();
            goToNextSlide();
        }
    }
    
    touchStartX = 0;
    touchStartY = 0;
});

function openSlideshow(index) {
    document.getElementById('slideshowContainer').style.display = 'flex';
    renderSlides();
    showImage(index);
    startSlideshow();
    setupThumbnails();
}

function renderSlides() {
    slideshowTrack.innerHTML = images1.map(img => 
        `<img src="${baseUrl}images/osproperty/properties/${propertyId}/medium/${img.src}" class="slideshow-image">`
    ).join('');
    if (images.length <= 1) {
        document.getElementById('prevBtn').style.display = 'none';
        document.getElementById('nextBtn').style.display = 'none';
    }
}

function showImage(index) {
    currentIndex = index;
    const isRtl = document.documentElement.getAttribute('dir') === 'rtl';
    const offset = isRtl ? index * 100 : -index * 100;
    slideshowTrack.style.transform = `translateX(${offset}%)`;
    document.getElementById('photoDescription').textContent = images1[currentIndex].description;
}

function startSlideshow() {
    if (!isPlaying) {
        isPlaying = true;
        pauseBtn.textContent = "❙❙";
        clearInterval(slideshowInterval);
        slideshowInterval = setInterval(() => {
            goToNextSlide();
        }, intervalTime);
    }
}

function pauseSlideshow() {
    if (isPlaying) {
        isPlaying = false;
        pauseBtn.textContent = "▶";
        clearInterval(slideshowInterval);
    } else {
        startSlideshow();
    }
}

function goToNextSlide() {
    if (slideshowTrack.style.transition) return;
    if(images1.length > 1) {
        currentIndex = (currentIndex + 1) % images1.length;
        updateSlide();
    }
}

function goToPrevSlide() {
    if (slideshowTrack.style.transition) return;
    if(images1.length > 1) {
        currentIndex = (currentIndex - 1 + images1.length) % images1.length;
        updateSlide();
    }
}

function updateSlide() {
    slideshowTrack.style.transition = `transform ${transitionTime}ms ease-in-out`;
    const isRtl = document.documentElement.getAttribute('dir') === 'rtl';
    const offset = isRtl ? currentIndex * 100 : -currentIndex * 100;
    slideshowTrack.style.transform = `translateX(${offset}%)`;
    document.getElementById('photoDescription').textContent = images1[currentIndex].description;
    setTimeout(() => {
        slideshowTrack.style.transition = '';
    }, transitionTime);
}

function setupThumbnails() {
    document.getElementById('thumbnailContainer').innerHTML = images1.map((img, index) => 
        `<img src="${baseUrl}images/osproperty/properties/${propertyId}/thumb/${img.src}" onclick="showImage(${index})">`
    ).join('');
}

function handleUserInteraction() {
    isUserInteracting = true;
    stopSlideshow();
    setTimeout(() => {
        isUserInteracting = false;
        startSlideshow();
    }, 3000);
}

function stopSlideshow() {
    clearInterval(slideshowInterval);
}

// Event Listeners
window.addEventListener('load', updateGalleryForMobile);
window.addEventListener('resize', updateGalleryForMobile);
pauseBtn.addEventListener('click', pauseSlideshow);

document.getElementById('closeBtn').addEventListener('click', () => {
    document.getElementById('slideshowContainer').style.display = 'none';
    pauseSlideshow();
    isPlaying = false;
});

document.getElementById('gridBtn').addEventListener('click', () => {
    document.getElementById('slideshowContainer').classList.toggle('grid-active');
});

document.getElementById('prevBtn').addEventListener('click', () => {
    stopSlideshow();
    goToPrevSlide();
    startSlideshow();
});

document.getElementById('nextBtn').addEventListener('click', () => {
    stopSlideshow();
    goToNextSlide();
    startSlideshow();
});
