// Listings
jQuery(".listing-grid").addClass("listing-active");

jQuery(".listing-full").click(function() {
    jQuery(".listing").addClass("listing-full");
    jQuery(this).addClass("listing-active");
    jQuery('.listing-grid').removeClass("listing-active");
});

jQuery(".listing-grid").click(function() {
    jQuery(".listing").removeClass("listing-full");
    jQuery(this).addClass("listing-active");
    jQuery('.listing-full').removeClass("listing-active");
});

// Add event listener for keyboard navigation (ESC, Arrow Left, Arrow Right)
document.addEventListener('keydown', (event) => {
    const slideshowContainer = document.getElementById('slideshowContainer');
    if (slideshowContainer.style.display === 'flex') {
        if (event.key === 'Escape') {
            slideshowContainer.style.display = 'none';
            pauseSlideshow();
            isPlaying = false;
        } else if (event.key === 'ArrowLeft') {
            stopSlideshow();
            goToPrevSlide();
            startSlideshow();
        } else if (event.key === 'ArrowRight') {
            stopSlideshow();
            goToNextSlide();
            startSlideshow();
        }
    }
});

// Add event listener for clicking outside slideshow on both desktop and mobile
document.getElementById('slideshowContainer').addEventListener('click', (event) => {
    const target = event.target;
    // Close if clicked area is not the slideshow content or buttons (except close button)
    if (!target.closest('#slideshowTrack') && 
        !target.closest('#prevBtn') && 
        !target.closest('#nextBtn') && 
        !target.closest('#pauseBtn') && 
        !target.closest('#gridBtn') && 
        !target.closest('#thumbnailContainer')) {
        document.getElementById('slideshowContainer').style.display = 'none';
        pauseSlideshow();
        isPlaying = false;
    }
});

function openSlideshow(index) {
    document.getElementById('slideshowContainer').style.display = 'flex';
    renderSlides();
    showImage(index);
    startSlideshow();
    setupThumbnails();
}

let currentIndex = 0;
let slideshowInterval;
let isUserInteracting = false;
let isPlaying = false;

let touchStartX = 0;
let touchStartY = 0;
let touchEndX = 0;
let touchEndY = 0;

const intervalTime = 3000;
const transitionTime = 500;

const slideshowTrack = document.getElementById('slideshowTrack');
const pauseBtn = document.getElementById('pauseBtn');

// Swipe functionality for mobile
if (slideshowTrack) {
    slideshowTrack.addEventListener('touchstart', (e) => {
        touchStartX = e.touches[0].clientX;
        touchStartY = e.touches[0].clientY;
    }, { passive: false });

    slideshowTrack.addEventListener('touchmove', (e) => {
        if (e.touches.length > 1) return;
        touchEndX = e.touches[0].clientX;
        touchEndY = e.touches[0].clientY;
        const deltaX = touchEndX - touchStartX;
        const deltaY = touchEndY - touchStartY;
        if (Math.abs(deltaX) > Math.abs(deltaY)) {
            e.preventDefault();
        }
    }, { passive: false });

    slideshowTrack.addEventListener('touchend', () => {
        const deltaX = touchEndX - touchStartX;
        const deltaY = touchEndY - touchStartY;
        if (Math.abs(deltaX) > 30) { // Minimum swipe distance
            if (deltaX > 0) {
                goToPrevSlide(); // Swipe right
            } else {
                goToNextSlide(); // Swipe left
            }
            handleUserInteraction();
        }
        touchStartX = 0;
        touchStartY = 0;
        touchEndX = 0;
        touchEndY = 0;
    });
}

function renderSlides() {
    slideshowTrack.innerHTML = images1.map(img => 
        `<img src="${baseUrl}images/osproperty/properties/${propertyId}/medium/${img.src}" class="slideshow-image">`
    ).join('');
    if (images1.length <= 1) {
        document.getElementById('prevBtn').style.display = 'none';
        document.getElementById('nextBtn').style.display = 'none';
    }
}

function showImage(index) {
    currentIndex = index;
    const isRtl = document.documentElement.getAttribute('dir') === 'rtl';
    const offset = isRtl ? index * 100 : -index * 100;
    slideshowTrack.style.transform = `translateX(${offset}%)`;
    document.getElementById('photoDescription').textContent = images1[index].description;
}

function startSlideshow() {
    if (!isPlaying) {
        isPlaying = true;
        pauseBtn.textContent = "❙❙"; // Pause icon
        clearInterval(slideshowInterval);
        slideshowInterval = setInterval(() => {
            goToNextSlide();
        }, intervalTime);
    }
}

function pauseSlideshow() {
    if (isPlaying) {
        isPlaying = false;
        pauseBtn.textContent = "▶"; // Play icon
        clearInterval(slideshowInterval);
    } else {
        startSlideshow();
    }
}

function goToNextSlide() {
    if (slideshowTrack.style.transition) return;
    if (images1.length > 1) {
        currentIndex = (currentIndex + 1) % images1.length;
        updateSlide();
    }
}

function goToPrevSlide() {
    if (slideshowTrack.style.transition) return;
    if (images1.length > 1) {
        currentIndex = (currentIndex - 1 + images1.length) % images1.length;
        updateSlide();
    }
}

function updateSlide() {
    slideshowTrack.style.transition = `transform ${transitionTime}ms ease-in-out`;
    const isRtl = document.documentElement.getAttribute('dir') === 'rtl';
    const offset = isRtl ? currentIndex * 100 : -currentIndex * 100;
    slideshowTrack.style.transform = `translateX(${offset}%)`;
    document.getElementById('photoDescription').textContent = images1[currentIndex].description;

    setTimeout(() => {
        slideshowTrack.style.transition = '';
    }, transitionTime);
}

function setupThumbnails() {
    document.getElementById('thumbnailContainer').innerHTML = images1.map((img, index) => 
        `<img src="${baseUrl}images/osproperty/properties/${propertyId}/thumb/${img.src}" onclick="showImage(${index})">`
    ).join('');
}

document.getElementById('closeBtn').addEventListener('click', () => {
    document.getElementById('slideshowContainer').style.display = 'none';
    clearInterval(slideshowInterval);
    isPlaying = false;
});

document.getElementById('gridBtn').addEventListener('click', () => {
    document.getElementById('slideshowContainer').classList.toggle('grid-active');
});

document.getElementById('prevBtn').addEventListener('click', () => {
    stopSlideshow();
    goToPrevSlide();
    startSlideshow();
});

document.getElementById('nextBtn').addEventListener('click', () => {
    stopSlideshow();
    goToNextSlide();
    startSlideshow();
});

function handleUserInteraction() {
    isUserInteracting = true;
    stopSlideshow();
    setTimeout(() => {
        isUserInteracting = false;
        startSlideshow();
    }, 3000);
}

function stopSlideshow() {
    clearInterval(slideshowInterval);
}

pauseBtn.addEventListener('click', pauseSlideshow);
