<?php
/*------------------------------------------------------------------------
# listing.html.tpl.php - Ossolution Property
# ------------------------------------------------------------------------
# author    Dang Thuc Dam
# copyright Copyright (C) 2025 joomdonation.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// No direct access.
defined('_JEXEC') or die;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

// Load required assets
echo OSPHelper::loadTooltip();
HTMLHelper::_('bootstrap.dropdown');

// Get document and register assets
$document = Factory::getApplication()->getDocument();
$wa = $document->getWebAssetManager();
$wa->registerAndUseStyle('osproperty.google.fonts', '//fonts.googleapis.com/css?family=Oswald:700');
$wa->registerAndUseScript('osproperty.listing', 'components/com_osproperty/assets/js/listing.js', [], ['defer' => true]);

// Get parameters
$titleColor = $params->get('titleColor', '#03b4ea');
$show_google_map = $params->get('show_map', 1);
?>

<script type="text/javascript">
function loadStateInListPage() {
    var country_id = document.getElementById('country_id');
    loadStateInListPageAjax(country_id.value, "<?php echo Uri::root(); ?>");
}

function changeCity(state_id, city_id) {
    var live_site = '<?php echo Uri::root(); ?>';
    loadLocationInfoCity(state_id, city_id, 'state_id', live_site);
}
</script>

<div id="notice" style="display:none;"></div>

<style>
.os-propertytitle {
    color: <?php echo $titleColor; ?> !important;
}
</style>

<?php
// Display filter form
HelperOspropertyCommon::filterForm($lists);
?>

<div id="listings">
    <?php if(count($rows) > 0): ?>
    
    <?php
    // Prepare currency data
    $db = Factory::getContainer()->get('db');
    $query = $db->getQuery(true)
        ->select('id as value, currency_code as text')
        ->from('#__osrs_currencies')
        ->where('id <> ' . $db->quote($row->curr))
        ->order('currency_code');
    $db->setQuery($query);
    $currencies = $db->loadObjectList();
    $currenyArr[] = HTMLHelper::_('select.option', '', Text::_('OS_SELECT'));
    $currenyArr = array_merge($currenyArr, $currencies);
    ?>
    
    <input type="hidden" name="currency_item" id="currency_item" value="" />
    <input type="hidden" name="live_site" id="live_site" value="<?php echo Uri::root(); ?>" />
    <div class="clearfix"></div>
    
    <?php if ($show_google_map == 1): ?>
        <?php if($configClass['map_type'] == 0): ?>
            <?php if(HelperOspropertyGoogleMap::loadMapInListing($rows)): ?>
                <div id="map_canvas" class="map2x relative" role="application" aria-label="<?php echo Text::_('OS_PROPERTY_MAP'); ?>"></div>
            <?php endif; ?>
        <?php else: ?>
            <?php HelperOspropertyOpenStreetMap::loadMapInListing($rows); ?>
        <?php endif; ?>
    <?php endif; ?>
    
    <div class="latestproperties latestproperties_right">
        <?php foreach($rows as $i => $row): ?>
            <?php
            // Prepare property data
            $row->id = (int)$row->id; // Ensure integer type for security
            $needs = ['property_details', $row->id];
            $itemid = OSPRoute::getItemid($needs);
            $lists['curr'] = HTMLHelper::_('select.genericlist', $currenyArr, 'curr'.$i, 
                'onChange="javascript:updateCurrency('.$i.','.$row->id.',this.value)" class="form-select form-select-sm"', 
                'value', 'text');
                
            // Handle image loading
            if($configClass['load_lazy']){
                $photourl = Uri::root()."media/com_osproperty/assets/images/loader.gif";
            } else {
                $photourl = $row->photo;
            }
            ?>
            
            <div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> os_item">
                <div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
                    <div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
                        <div class="os_property-title <?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
                            <div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
                                <div class="<?php echo $bootstrapHelper->getClassMapping('span9'); ?>">
                                    <span class="os-propertytitle title-blue">
                                        <a title="<?php echo Text::_('OS_PROPERTY_DETAILS'); ?>" 
                                           href="<?php echo Route::_("index.php?option=com_osproperty&task=property_details&id=".$row->id."&Itemid=".$itemid); ?>" 
                                           class="os-propertytitle">
                                            <?php if(($row->ref != "") && ($configClass['show_ref'] == 1)): ?>
                                                <?php echo htmlspecialchars($row->ref); ?>,
                                            <?php endif; ?>
                                            <?php echo htmlspecialchars($row->pro_name); ?>
                                        </a>
                                        
                                        <?php if(($row->show_address == 1) && ($row->lat_add != "") && ($row->long_add != "") && ($show_google_map == 1)): ?>
                                            <?php if($configClass['map_type'] == 0): ?>
                                                <a href="#map_canvas" 
                                                   onclick="javascript:openMarker(<?php echo $row->mapid; ?>);return false;" 
                                                   class="maplink" 
                                                   aria-label="<?php echo Text::_('OS_VIEW_ON_MAP'); ?>">
                                                    <i class="osicon-location" aria-hidden="true"></i>
                                                </a>
                                            <?php else: ?>
                                                <a href="#map_canvas" 
                                                   id="openmap<?php echo $row->mapid; ?>" 
                                                   class="maplink" 
                                                   aria-label="<?php echo Text::_('OS_VIEW_ON_MAP'); ?>">
                                                    <i class="osicon-location" aria-hidden="true"></i>
                                                </a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </span>
                                    
                                    <?php
                                    echo $row->featured_ico;
                                    echo $row->market_ico;
                                    echo $row->just_added_ico;
                                    echo $row->just_updated_ico;
                                    ?>
                                </div>
                                
                                <div class="<?php echo $bootstrapHelper->getClassMapping('span3'); ?>">
                                    <span class="os_currency_red">
                                        <?php if(OSPHelper::getLanguageFieldValue($row, 'price_text') != ""): ?>
                                            <?php echo " ".OSPHelper::showPriceText(OSPHelper::getLanguageFieldValue($row, 'price_text')); ?>
                                        <?php elseif($row->price_call == 0): ?>
                                            <?php echo OSPHelper::generatePrice($row->curr, $row->price); ?>
                                            <?php if($row->rent_time != ""): ?>
                                                <?php echo " /".Text::_($row->rent_time); ?>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <?php echo " ".Text::_('OS_CALL_FOR_DETAILS_PRICE'); ?>
                                        <?php endif; ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> os_property-main">
                        <div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
                            <div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
                                <div class="<?php echo $bootstrapHelper->getClassMapping('span4'); ?>">
                                    <div id="os_images">
                                        <a title="<?php echo Text::_('OS_PROPERTY_DETAILS'); ?>" 
                                           href="<?php echo Route::_("index.php?option=com_osproperty&task=property_details&id=".$row->id."&Itemid=".$itemid); ?>" 
                                           class="ositem-hrefphoto">
                                            <img alt="<?php echo htmlspecialchars($row->pro_name); ?>" 
                                                 title="<?php echo htmlspecialchars($row->pro_name); ?>" 
                                                 src="<?php echo $photourl; ?>" 
                                                 data-original="<?php echo $row->photo; ?>" 
                                                 class="ospitem-imgborder oslazy" 
                                                 loading="lazy" />
                                        </a>
                                        
                                        <?php if($row->isFeatured == 1): ?>
                                            <div class="os_featured">
                                                <?php echo Text::_('OS_FEATURED'); ?>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <?php if(($configClass['listing_show_rating'] == 1) && ($configClass['comment_active_comment'] == 1)): ?>
                                            <div class="os_rating">
                                                <?php OSPHelper::showRatingOverPicture($row->rate, $titleColor); ?>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <?php if(OSPHelper::isSoldProperty($row, $configClass)): ?>
                                            <div class="os_sold">
                                                <?php echo Text::_('OS_SOLD'); ?>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <div class="os_types_red">
                                            <?php echo htmlspecialchars($row->type_name); ?>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="<?php echo $bootstrapHelper->getClassMapping('span8'); ?> os-leftpad">
                                    <div class="ospitem-leftpad <?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
                                        <div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
                                            <div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> ">
                                                <div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
                                                    <div class="os_category os-toppad">
                                                        <?php echo $row->category_name; ?>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <?php if(($row->show_address == 1) && ($configClass['listing_show_address'] == 1)): ?>
                                                <div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> os-address">
                                                    <div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
                                                        <strong>
                                                            <?php echo Text::_('OS_ADDRESS'); ?>:
                                                        </strong>
                                                        <?php echo OSPHelper::generateAddress($row); ?>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            
                                            <div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> os-desc">
                                                <div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
                                                    <?php
                                                    $pro_small_desc = $row->pro_small_desc;
                                                    $pro_small_descArr = explode(" ", $pro_small_desc);
                                                    if(count($pro_small_descArr) > 15) {
                                                        echo htmlspecialchars(implode(" ", array_slice($pro_small_descArr, 0, 15))) . "..";
                                                    } else {
                                                        echo htmlspecialchars($pro_small_desc);
                                                    }
                                                    ?>
                                                </div>
                                            </div>

                                            <?php
                                            $fieldarr = (array)$row->fieldarr;
                                            if(count($fieldarr) > 0):
                                            ?>
                                                <div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> ospitem-bopad">
                                                    <div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
                                                        <?php foreach($fieldarr as $field): ?>
                                                            <?php if($field->fieldvalue != ""): ?>
                                                                <p>
                                                                    <span class="field">
                                                                        <?php if($field->label != ""): ?>
                                                                            <?php echo htmlspecialchars($field->label); ?>
                                                                            </span> <span>:
                                                                        <?php endif; ?>
                                                                        <?php echo $field->fieldvalue; ?>
                                                                    </span>
                                                                </p>
                                                            <?php endif; ?>
                                                        <?php endforeach; ?>
                                                    </div>
                                                </div>
                                            <?php endif; ?>

                                            <div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> os_bottom">
                                                <div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
                                                    <?php
                                                    $user = Factory::getApplication()->getIdentity();
                                                    $db = Factory::getContainer()->get('db');

                                                    // Compare list functionality
                                                    if($configClass['show_compare_task'] == 1):
                                                        if(!OSPHelper::isInCompareList($row->id)):
                                                            $msg = Text::_('OS_DO_YOU_WANT_TO_ADD_PROPERTY_TO_COMPARE_LIST');
                                                            $msg = str_replace("'", "\'", $msg);
                                                    ?>
                                                            <span id="compare<?php echo $row->id; ?>">
                                                                <a onclick="javascript:osConfirmExtend('<?php echo $msg; ?>','ajax_addCompare','<?php echo $row->id; ?>','<?php echo Uri::root(); ?>','compare<?php echo $row->id; ?>','theme1','listing')"
                                                                   href="javascript:void(0)"
                                                                   class="btn btn-warning btn-sm"
                                                                   aria-label="<?php echo Text::_('OS_ADD_TO_COMPARE_LIST'); ?>">
                                                                    <i class="osicon-bookmark osicon-white" aria-hidden="true"></i> 
                                                                    <?php echo Text::_('OS_ADD_TO_COMPARE_LIST'); ?>
                                                                </a>
                                                            </span>
                                                    <?php
                                                        else:
                                                            $msg = Text::_('OS_DO_YOU_WANT_TO_REMOVE_PROPERTY_OUT_OF_COMPARE_LIST');
                                                            $msg = str_replace("'", "\'", $msg);
                                                    ?>
                                                            <span id="compare<?php echo $row->id; ?>">
                                                                <a onclick="javascript:osConfirmExtend('<?php echo $msg; ?>','ajax_removeCompare','<?php echo $row->id; ?>','<?php echo Uri::root(); ?>','compare<?php echo $row->id; ?>','theme1','listing')"
                                                                   href="javascript:void(0)"
                                                                   class="btn btn-warning btn-sm"
                                                                   aria-label="<?php echo Text::_('OS_REMOVE_FROM_COMPARE_LIST'); ?>">
                                                                    <i class="osicon-bookmark osicon-white" aria-hidden="true"></i> 
                                                                    <?php echo Text::_('OS_REMOVE_FROM_COMPARE_LIST'); ?>
                                                                </a>
                                                            </span>
                                                    <?php
                                                        endif;
                                                    endif;

                                                    // Favorites functionality for logged in users
                                                    if(intval($user->id) > 0):
                                                        if($configClass['property_save_to_favories'] == 1):
                                                            $query = $db->getQuery(true)
                                                                ->select('COUNT(id)')
                                                                ->from('#__osrs_favorites')
                                                                ->where('user_id = ' . $db->quote($user->id))
                                                                ->where('pro_id = ' . $db->quote($row->id));
                                                            $db->setQuery($query);
                                                            $count = $db->loadResult();
                                                            
                                                            if($count == 0):
                                                                $msg = Text::_('OS_DO_YOU_WANT_TO_ADD_PROPERTY_TO_YOUR_FAVORITE_LISTS');
                                                                $msg = str_replace("'", "\'", $msg);
                                                    ?>
                                                                <span id="fav<?php echo $row->id; ?>">
                                                                    <a onclick="javascript:osConfirmExtend('<?php echo $msg; ?>','ajax_addFavorites','<?php echo $row->id; ?>','<?php echo Uri::root(); ?>','fav<?php echo $row->id; ?>','theme1','listing')" 
                                                                       href="javascript:void(0)" 
                                                                       class="btn btn-success btn-sm"
                                                                       aria-label="<?php echo Text::_('OS_ADD_TO_FAVORITES'); ?>">
                                                                        <i class="osicon-ok osicon-white" aria-hidden="true"></i> 
                                                                        <?php echo Text::_('OS_ADD_TO_FAVORITES'); ?>
                                                                    </a>
                                                                </span>
                                                    <?php
                                                            endif;
                                                            
                                                            if($count > 0):
                                                                $msg = Text::_('OS_DO_YOU_WANT_TO_REMOVE_PROPERTY_OUT_OF_YOUR_FAVORITE_LISTS');
                                                                $msg = str_replace("'", "\'", $msg);
                                                    ?>
                                                                <span id="fav<?php echo $row->id; ?>">
                                                                    <a onclick="javascript:osConfirmExtend('<?php echo $msg; ?>','ajax_removeFavorites','<?php echo $row->id; ?>','<?php echo Uri::root(); ?>','fav<?php echo $row->id; ?>','theme1','listing')" 
                                                                       href="javascript:void(0)" 
                                                                       class="btn btn-success btn-sm"
                                                                       aria-label="<?php echo Text::_('OS_REMOVE_FAVORITES'); ?>">
                                                                        <i class="osicon-remove osicon-white" aria-hidden="true"></i> 
                                                                        <?php echo Text::_('OS_REMOVE_FAVORITES'); ?>
                                                                    </a>
                                                                </span>
                                                    <?php
                                                            endif;
                                                        endif;
                                                        
                                                        // Agent editing functionality
                                                        if(HelperOspropertyCommon::isAgent()):
                                                            $my_agent_id = HelperOspropertyCommon::getAgentID();
                                                            
                                                            if($my_agent_id == $row->agent_id):
                                                                $link = Uri::root() . "index.php?option=com_osproperty&task=property_edit&id=" . $row->id;
                                                    ?>
                                                                <span id="favorite_1">
                                                                    <a href="<?php echo $link; ?>" 
                                                                       title="<?php echo Text::_('OS_EDIT_PROPERTY'); ?>" 
                                                                       class="btn btn-danger btn-sm"
                                                                       aria-label="<?php echo Text::_('OS_EDIT_PROPERTY'); ?>">
                                                                        <i class="osicon-edit osicon-white" aria-hidden="true"></i> 
                                                                        <?php echo Text::_('OS_EDIT_PROPERTY'); ?>
                                                                    </a>
                                                                </span>
                                                    <?php
                                                            endif;
                                                        endif;
                                                    endif;
                                                    ?>
                                                    
                                                    <a title="<?php echo Text::_('OS_PROPERTY_DETAILS'); ?>" 
                                                       class="btn btn-info btn-sm" 
                                                       href="<?php echo Route::_("index.php?option=com_osproperty&task=property_details&id=".$row->id."&Itemid=".$itemid)?>"                                                        aria-label="<?php echo Text::_('OS_PROPERTY_DETAILS'); ?>">
                                                        <i class="osicon-file osicon-white" aria-hidden="true"></i> 
                                                        <?php echo Text::_('OS_DETAILS'); ?>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="os_property-meta">
                        <ul>
                            <?php if($configClass['use_squarefeet'] == 1 && $row->square_feet > 0): ?>
                                <li class="property-icon-square meta-block">
                                    <i class="os-icon-sqmt os-2x" aria-hidden="true"></i>
                                    <span>
                                        <?php
                                        echo OSPHelper::showSquare($row->square_feet);
                                        echo "&nbsp;";
                                        echo OSPHelper::showSquareSymbol();
                                        ?>
                                    </span>
                                </li>
                            <?php endif; ?>

                            <?php if(($configClass['listing_show_nbedrooms'] == 1) && ($row->bed_room > 0)): ?>
                                <li class="property-icon-bed meta-block">
                                    <i class="os-icon-bedroom os-2x" aria-hidden="true"></i>
                                    <span><?php echo (int)$row->bed_room; ?></span>
                                </li>
                            <?php endif; ?>

                            <?php if(($configClass['listing_show_nbathrooms'] == 1) && ($row->bath_room > 0)): ?>
                                <li class="property-icon-bath meta-block">
                                    <i class="os-icon-bathroom os-2x" aria-hidden="true"></i>
                                    <span><?php echo OSPHelper::showBath($row->bath_room); ?></span>
                                </li>
                            <?php endif; ?>

                            <?php if(($configClass['use_parking'] == 1) && ($row->parking != "")): ?>
                                <li class="property-icon-parking meta-block">
                                    <i class="os-icon-parking os-2x" aria-hidden="true"></i>
                                    <span><?php echo htmlspecialchars($row->parking); ?></span>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
    
    <?php if((count($rows) > 0) && ($pageNav->total > $pageNav->limit)): ?>
        <div class="pageNavdiv">
            <?php echo $pageNav->getListFooter(); ?>
        </div>
    <?php endif; ?>
    
    <?php else: ?>
        <div class="alert alert-info">
            <?php echo Text::_('OS_NO_PROPERTY_FOUND'); ?>
        </div>
    <?php endif; ?>
</div>

<input type="hidden" name="process_element" id="process_element" value="" />

<?php
// Add cache control headers for better performance
$app = Factory::getApplication();
$app->setHeader('Cache-Control', 'public, max-age=3600');
$app->setHeader('Pragma', 'cache');
?>

