<?php
/*------------------------------------------------------------------------
# listing.html.tpl.php - Ossolution Property
# ------------------------------------------------------------------------
# author        Dang Thuc Dam
# copyright     2025 joomdonation.com. All Rights Reserved.
# @license      http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites      https://www.joomdonation.com
# Technical Support  Forum - http://www.joomdonation.com/forum.html
*/

// No direct access.
defined('_JEXEC') or die;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

echo OSPHelper::loadTooltip();
$user       = Factory::getUser();
$document   = Factory::getDocument();
$document->addStyleSheet(Uri::root()."components/com_osproperty/templates/".$themename."/style/font.css");
?>
<script type = "text/javascript">
function loadStateInListPage(){
	var country_id = document.getElementById('country_id');
	loadStateInListPageAjax(country_id.value,"<?php echo Uri::root()?>");
}
function changeCity(state_id,city_id){
	var live_site = '<?php echo Uri::root()?>';
	loadLocationInfoCity(state_id,city_id,'state_id',live_site);
}
</script>
<div id="notice" style="display:none;">
</div>

<?php
HTMLHelper::_('bootstrap.dropdown');
$show_google_map = $params->get('show_map',1);
?>
<div style="display:none;">
<?php
//HelperOspropertyCommon::filterForm($lists);
echo $lists['sortby'];
echo $lists['ordertype'];
?>
</div>

<div id="listings" class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
	<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
		<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
			<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
				<div class="dropdown inlinedisplay">
					<button class="btn dropdown-toggle" type="button" id="propertiesSortButton" data-bs-toggle="dropdown" aria-expanded="false">
					  <?php
						echo Text::_('OS_SORT_BY'). " ".$lists['orderby_selected_text']." ".$lists['ordertype_selected_text'];
					  ?>
					</button>
					<ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
					  <li><a class="dropdown-item" id="a.ordering" data-sortby="a.ordering" data-orderby="" href="javascript:updateSort('a.ordering','<?php echo Text::_('OS_SORT_BY')." ".Text::_('OS_ORDERING')?>')"><?php echo Text::_('OS_ORDERING')?></a></li>
					  <li><a class="dropdown-item" id="a.created_desc" data-sortby="a.created" data-orderby="desc" href="javascript:updateSort('a.created_desc','<?php echo Text::_('OS_SORT_BY')." ".Text::_('OS_CREATED')."  ".Text::_('OS_DESC')?>')"><?php echo Text::_('OS_CREATED')."  ".Text::_('OS_DESC'); ?></a></li>
					  <li><a class="dropdown-item" id="a.created_asc" data-sortby="a.created" data-orderby="asc" href="javascript:updateSort('a.created_asc','<?php echo Text::_('OS_SORT_BY')." ".Text::_('OS_CREATED')."  ".Text::_('OS_ASC')?>')"><?php echo Text::_('OS_CREATED')."  ".Text::_('OS_ASC'); ?></a></li>

					  <li><a class="dropdown-item" id="a.modified_desc" data-sortby="a.modified" data-orderby="desc" href="javascript:updateSort('a.modified_desc','<?php echo Text::_('OS_SORT_BY')." ".Text::_('OS_MODIFIED')."  ".Text::_('OS_DESC')?>')"><?php echo Text::_('OS_MODIFIED')."  ".Text::_('OS_DESC'); ?></a></li>
					  <li><a class="dropdown-item" id="a.modified_asc" data-sortby="a.modified" data-orderby="asc" href="javascript:updateSort('a.modified_asc','<?php echo Text::_('OS_SORT_BY')." ".Text::_('OS_MODIFIED')."  ".Text::_('OS_ASC')?>')"><?php echo Text::_('OS_MODIFIED')."  ".Text::_('OS_ASC'); ?></a></li>

					  <li><a class="dropdown-item" id="a.pro_name_desc" data-sortby="a.pro_name" data-orderby="desc" href="javascript:updateSort('a.pro_name_desc','<?php echo Text::_('OS_SORT_BY')." ".Text::_('OS_TITLE')."  ".Text::_('OS_DESC')?>')"><?php echo Text::_('OS_TITLE')."  ".Text::_('OS_DESC'); ?></a></li>
					  <li><a class="dropdown-item" id="a.pro_name_asc" data-sortby="a.pro_name" data-orderby="asc" href="javascript:updateSort('a.pro_name_asc','<?php echo Text::_('OS_SORT_BY')." ".Text::_('OS_TITLE')."  ".Text::_('OS_ASC')?>')"><?php echo Text::_('OS_TITLE')."  ".Text::_('OS_ASC'); ?></a></li>
					  <li><a class="dropdown-item" id="a.price_desc" data-sortby="a.price" data-orderby="desc" href="javascript:updateSort('a.price_desc','<?php echo Text::_('OS_SORT_BY')." ".Text::_('OS_PRICE')."  ".Text::_('OS_DESC')?>')"><?php echo Text::_('OS_PRICE')."  ".Text::_('OS_DESC'); ?></a></li>
					  <li><a class="dropdown-item" id="a.price_asc" data-sortby="a.price" data-orderby="asc" href="javascript:updateSort('a.price','<?php echo Text::_('OS_SORT_BY')." ".Text::_('OS_PRICE')."  ".Text::_('OS_ASC')?>')"><?php echo Text::_('OS_PRICE')."  ".Text::_('OS_ASC'); ?></a></li>
					</ul>
				  </div>
			</div>
		</div>
		<script type="text/javascript">
		function updateSort(type, text)
		{
			item = document.getElementById(type);
			sortby = item.getAttribute('data-sortby');
			orderby = item.getAttribute('data-orderby');
			document.getElementById('orderby').value = sortby;
			document.getElementById('ordertype').value = orderby;
			var button = document.getElementById('propertiesSortButton');
	        button.textContent = text;
			document.ftForm.submit();
		}
		</script>
		<?php
		if(count($rows) > 0)
		{
			$db             = Factory::getDbo();
			$db->setQuery("Select id as value, currency_code as text from #__osrs_currencies where id <> '$row->curr' order by currency_code");
			$currencies     = $db->loadObjectList();
			$currenyArr[]   = HTMLHelper::_('select.option','',Text::_('OS_SELECT'));
			$currenyArr     = array_merge($currenyArr,$currencies);
			?>
			<input type="hidden" name="currency_item" id="currency_item" value="" />
			<input type="hidden" name="live_site" id="live_site" value="<?php echo Uri::root()?>" />
			
			<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> toplisting">
				<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?> noleftmargin nopadding">
					<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
						<?php
						$j = 0;
						for($i=0;$i<count($rows);$i++) 
						{
							$row        = $rows[$i];
							$needs      = array();
							$needs[]    = "property_details";
							$needs[]    = $row->id;
							$itemid     = OSPRoute::getItemid($needs);
							$link       = Route::_('index.php?option=com_osproperty&task=property_details&id='.$row->id.'&Itemid='.$itemid);
							if($configClass['load_lazy']){
								$photourl = Uri::root()."media/com_osproperty/assets/images/loader.gif";
							}else{
								$photourl = $row->photo;
							}

							$db->setQuery("Select count(id) from #__osrs_photos where pro_id = '$row->id'");
							$count_photos = $db->loadResult();

							?>
							<div class="<?php echo $bootstrapHelper->getClassMapping('span4'); ?> house_property_item">
								<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
									<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
										<div class="house_property_item_box">
											<figure>
												<h6 class="house_snipe ptype<?php echo $row->pro_type;?> ptype blockdisplay">
													<span><?php echo $row->type_name;?></span>
												</h6>
												<?php 
												if($row->tour_link != "")
												{
												?>
													<h6 class="virtual_tour_label blockdisplay">
														<span class="bluelabel"><?php echo Text::_('OS_VIRTUAL_TOUR');?></span>
													</h6>
												<?php
												}
												
												?>
												<h7 class="house_snipe photos blockdisplay">
													<span><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-camera" viewBox="0 0 16 16">
  <path d="M15 12a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V6a1 1 0 0 1 1-1h1.172a3 3 0 0 0 2.12-.879l.83-.828A1 1 0 0 1 6.827 3h2.344a1 1 0 0 1 .707.293l.828.828A3 3 0 0 0 12.828 5H14a1 1 0 0 1 1 1zM2 4a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-1.172a2 2 0 0 1-1.414-.586l-.828-.828A2 2 0 0 0 9.172 2H6.828a2 2 0 0 0-1.414.586l-.828.828A2 2 0 0 1 3.172 4z"/>
  <path d="M8 11a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5m0 1a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7M3 6.5a.5.5 0 1 1-1 0 .5.5 0 0 1 1 0"/>
</svg>&nbsp;<?php echo (int)$count_photos;?></span>
												</h7>
												<a href="<?php echo Route::_('index.php?option=com_osproperty&task=property_details&id='.$row->id.'&Itemid='.$itemid);?>" class="property_mark_a">
													<img alt="<?php echo $row->pro_name?>" title="<?php echo $row->pro_name?>" src="<?php echo $photourl;?>" data-original="<?php echo $row->photo; ?>" class="ospitem-imgborder oslazy" id="picture_<?php echo $i?>" />
												</a>
												
											</figure>
											<div class="house_grid-listing-info">
												<header>
													<h5 class="house_marB0">
														<a href="<?php echo Route::_('index.php?option=com_osproperty&task=property_details&id='.$row->id.'&Itemid='.$itemid);?>" class="property_mark_a"><?php echo $row->pro_name?></a>
													</h5>
												</header>
												<div class="house_marB0 house_propertypricevalue">
													<span class="listing-price">
														<?php
														if(OSPHelper::getLanguageFieldValue($row,'price_text') != "")
														{
															echo " ".OSPHelper::getLanguageFieldValue($row,'price_text');
														}
														elseif($row->price_call == 1)
														{
															echo Text::_('OS_CALL_FOR_PRICE');
														}
														else
														{
															echo OSPHelper::generatePrice($row->curr, $row->price);
															if($row->rent_time != "")
															{
																echo " /".Text::_($row->rent_time);
															}
														}
														?>
													</span>
												</div>
												<div class="propertydescription">
													<?php
													$pro_small_desc = $row->pro_small_desc;
													$pro_small_descArr = explode(" ",$pro_small_desc);
													if(count($pro_small_descArr) > 15){
														for($j=0;$j<15;$j++){
															echo $pro_small_descArr[$j]." ";
														}
														echo "..";
													}else{
														echo $pro_small_desc;
													}		
													?>
												</div>
												<div class="house_propinfo">
													<?php
													if($configClass['listing_show_nbedrooms'] == 1 && $row->bed_room > 0)
													{
													?>
														<i class="fa fa-bed" aria-hidden="true"></i>
														<?php echo $row->bed_room; ?>
														&nbsp;

													<?php
													}
													if(($configClass['listing_show_nbathrooms'] == 1) && ($row->bath_room > 0))
													{
													?>
														|&nbsp;
														<i class="fa fa-bath" aria-hidden="true"></i>
														<?php echo OSPHelper::showBath($row->bath_room); ?>&nbsp;
													<?php
													}
													if($configClass['use_squarefeet'] == 1 && $row->square_feet > 0)
													{
													?>
														|&nbsp;
														<i class="fa fa-arrows-alt" aria-hidden="true"></i>
														<?php echo OSPHelper::showSquare($row->square_feet);?>
														<?php echo OSPHelper::showSquareSymbol(); ?>
													<?php } ?>
												</div>
											</div>
											<div class="house_brokerage">
												<div class="house_agent-info">
													<?php
													if($row->agent_photo != "")
													{
														if(file_exists(JPATH_ROOT."/images/osproperty/agent/thumbnail/".$row->agent_photo))
														{
															?>
															<img decoding="async" src="<?php echo Uri::root()?>images/osproperty/agent/thumbnail/<?php echo $row->agent_photo?>" />
															<?php
														}
													}
													?>
													<a title="<?php echo $row->agent_name?>" href="<?php echo Route::_('index.php?option=com_osproperty&task=agent_info&id='.$row->agent_id.'&Itemid='.$jinput->getInt('Itemid',0));?>">
														<?php echo $row->agent_name?>
													</a>
												</div>
												<div class="icons-wrap">
													<ul>
														<li>
															<a href="<?php echo $link; ?>" title="<?php echo Text::_('OS_DETAILS');?>">
																<i class="fa fa-share" aria-hidden="true"></i>
															</a>
														</li>
														<?php
														if($configClass['show_compare_task'] == 1)
														{
															if(! OSPHelper::isInCompareList($row->id))
															{
																$msg = Text::_('OS_DO_YOU_WANT_TO_ADD_PROPERTY_TO_COMPARE_LIST');
																$msg = str_replace("'","\'",$msg);
																?>
																<li>
																	<span id="compare<?php echo $row->id?>">
																		<a onclick="javascript:osConfirmExtend('<?php echo $msg; ?>','ajax_addCompare','<?php echo $row->id ?>','<?php echo Uri::root() ?>','compare<?php echo $row->id;?>','house','listing')" href="javascript:void(0)" title="<?php echo Text::_('OS_ADD_TO_COMPARE_LIST');?>" class="compareLink">
																			<i class="fa fa-plus"></i>
																		</a>
																	</span>
																</li>
																<?php
															}
															else
															{
																$msg = Text::_('OS_DO_YOU_WANT_TO_REMOVE_PROPERTY_OUT_OF_COMPARE_LIST');
																$msg = str_replace("'", "\'", $msg);
																?>
																<li>
																	<span id="compare<?php echo $row->id?>">
																		<a onclick="javascript:osConfirmExtend('<?php echo $msg; ?>','ajax_removeCompare','<?php echo $row->id ?>','<?php echo Uri::root() ?>','compare<?php echo $row->id;?>','house','listing')" href="javascript:void(0)" title="<?php echo Text::_('OS_REMOVE_FROM_COMPARE_LIST');?>" class="compareLink activated">
																			<i class="fa fa-plus" style="color:#000;"></i>
																		</a>
																	</span>
																<li>
																<?php
															}
														}
														?>
													</ul>
												</div>
											</div>
												
										</div>
									</div>
								</div>
							</div>
							<?php
							$j++;
							if($j == 3){
								$j = 0;
								?>
								</div><div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
								<?php
							}
						}
						?>
					</div>
				</div>
			</div>
			<div>
				<?php
				if((count($rows) > 0) && ($pageNav->total > $pageNav->limit)){
					?>
					<div class="pageNavdiv">
						<?php
							echo $pageNav->getListFooter();
						?>
					</div>
					<?php
				}
				?>
			</div>
		<?php
		}
		?>
	</div>
</div>
<input type="hidden" name="process_element" id="process_element" value="" />