<?php

/*------------------------------------------------------------------------
# details.html.tpl.php - Ossolution Property
# ------------------------------------------------------------------------
# author    Dang Thuc Dam
# copyright Copyright (C) 2025 joomdonation.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// No direct access.
defined('_JEXEC') or die;
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

$db                 = Factory::getDbo();

$db->setQuery("Select * from #__osrs_properties where id = '$row->id'");
$property			= $db->loadObject();

$document           = Factory::getDocument();
$document->addScript(Uri::root()."components/com_osproperty/templates/".$themename."/js/sticky-sidebar.js");
$document->addStyleSheet(Uri::root()."components/com_osproperty/templates/".$themename."/style/style.css");
$document->addStyleSheet(Uri::root()."components/com_osproperty/templates/".$themename."/style/font.css");
$extrafieldncolumns = $params->get('extrafieldncolumns',3);
$googleadsense      = $params->get('googleadsense');
$show_location      = $params->get('show_location',1);
$module_ids			= $params->get('module_ids','');
$user               = Factory::getUser();
OSPHelperJquery::colorbox('a.osmodal');
HTMLHelper::_('bootstrap.dropdown');
$url				= Route::_("index.php?option=com_osproperty&task=property_details&id=$row->id",  true, 0, true);
//$url				= Uri::getInstance()->toString(array('scheme', 'user', 'pass', 'host')).$url;
?>
<style>
#main ul{
	margin:0px;
}
</style>
<div id="notice" style="display:none;">
</div>
<?php
if(count($topPlugin) > 0)
{
	for($i=0;$i<count($topPlugin);$i++)
	{
		echo $topPlugin[$i];
	}
}
?>
<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> theme4" id="propertydetails">
	<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
        <div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> theme4propertyheading">
            <div class="<?php echo $bootstrapHelper->getClassMapping('span9'); ?> theme4propertyheader">
				<h1 class="property_title">
					<?php
					echo $row->pro_name;
					?>
				</h1>
                <div class="property-labels-wrap">
					<?php
					if($configClass['active_market_status'] == 1 && $row->isSold > 0){
					?>
						<span class="osplabel label-gray"><?php echo OSPHelper::returnMarketStatus($row->isSold);?></span>
					<?php } ?>
					<span class="osplabel label-yellow"><?php echo $row->type_name?></span>
					<?php
					if($row->isFeatured == 1)
					{
						?>
						<span class="osplabel label-red">
							<?php echo Text::_('OS_FEATURED');?>
						</span>
						<?php
					}
					?>
				</div>
				<?php
				if($row->show_address == 1)
				{
				?>
					<address class="item-address">
						<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-geo-alt" viewBox="0 0 16 16">
						  <path d="M12.166 8.94c-.524 1.062-1.234 2.12-1.96 3.07A32 32 0 0 1 8 14.58a32 32 0 0 1-2.206-2.57c-.726-.95-1.436-2.008-1.96-3.07C3.304 7.867 3 6.862 3 6a5 5 0 0 1 10 0c0 .862-.305 1.867-.834 2.94M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10"/>
						  <path d="M8 8a2 2 0 1 1 0-4 2 2 0 0 1 0 4m0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6"/>
						</svg>
						<?php
						
							echo OSPHelper::generateAddress($row);
						?>
					</address>
				<?php
				}		
				?>
            </div>
            <div class="<?php echo $bootstrapHelper->getClassMapping('span3'); ?> alignright">
				<ul class="item-tools">
					<?php
					if($configClass['show_getdirection'] == 1 && $row->show_address == 1)
					{
						?>
						<li class="item-tool">
							<span class="getdirectionLink">
								<a href="<?php echo Route::_("index.php?option=com_osproperty&task=direction_map&id=".$row->id)?>" title="<?php echo Text::_('OS_GET_DIRECTIONS')?>">
									<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-geo-alt-fill" viewBox="0 0 16 16">
  <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10m0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6"/>
</svg>
								</a>
							</span>
						</li>
						<?php
					}
					if($configClass['show_compare_task'] == 1)
					{
						?>
						<li class="item-tool">
							
								<span id="compare<?php echo $row->id;?>">
								<?php
								if(! OSPHelper::isInCompareList($row->id)) {
									$msg = Text::_('OS_DO_YOU_WANT_TO_ADD_PROPERTY_TO_YOUR_COMPARE_LIST');
									$msg = str_replace("'","\'",$msg);
									?>
									<a title="<?php echo Text::_('OS_ADD_TO_COMPARE_LIST');?>" onclick="javascript:osConfirmExtend('<?php echo $msg; ?>','ajax_addCompare','<?php echo $row->id ?>','<?php echo Uri::root() ?>','compare<?php echo $row->id;?>','house','details')" href="javascript:void(0)" class="compareLink">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-diagram-2" viewBox="0 0 16 16">
  <path fill-rule="evenodd" d="M6 3.5A1.5 1.5 0 0 1 7.5 2h1A1.5 1.5 0 0 1 10 3.5v1A1.5 1.5 0 0 1 8.5 6v1H11a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-1 0V8h-5v.5a.5.5 0 0 1-1 0v-1A.5.5 0 0 1 5 7h2.5V6A1.5 1.5 0 0 1 6 4.5zM8.5 5a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5zM3 11.5A1.5 1.5 0 0 1 4.5 10h1A1.5 1.5 0 0 1 7 11.5v1A1.5 1.5 0 0 1 5.5 14h-1A1.5 1.5 0 0 1 3 12.5zm1.5-.5a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5zm4.5.5a1.5 1.5 0 0 1 1.5-1.5h1a1.5 1.5 0 0 1 1.5 1.5v1a1.5 1.5 0 0 1-1.5 1.5h-1A1.5 1.5 0 0 1 9 12.5zm1.5-.5a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5z"/>
</svg>
									</a>
									<?php
								}else{
									$msg = Text::_('OS_DO_YOU_WANT_TO_REMOVE_PROPERTY_OUT_OF_COMPARE_LIST');
									$msg = str_replace("'","\'",$msg);
									?>
									<a title="<?php echo Text::_('OS_REMOVE_FROM_COMPARE_LIST');?>" onclick="javascript:osConfirmExtend('<?php echo $msg; ?>','ajax_removeCompare','<?php echo $row->id ?>','<?php echo Uri::root() ?>','compare<?php echo $row->id;?>','house','details')" href="javascript:void(0)" class="compareLinkActive">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-diagram-2-fill" viewBox="0 0 16 16">
  <path fill-rule="evenodd" d="M6 3.5A1.5 1.5 0 0 1 7.5 2h1A1.5 1.5 0 0 1 10 3.5v1A1.5 1.5 0 0 1 8.5 6v1H11a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-1 0V8h-5v.5a.5.5 0 0 1-1 0v-1A.5.5 0 0 1 5 7h2.5V6A1.5 1.5 0 0 1 6 4.5zm-3 8A1.5 1.5 0 0 1 4.5 10h1A1.5 1.5 0 0 1 7 11.5v1A1.5 1.5 0 0 1 5.5 14h-1A1.5 1.5 0 0 1 3 12.5zm6 0a1.5 1.5 0 0 1 1.5-1.5h1a1.5 1.5 0 0 1 1.5 1.5v1a1.5 1.5 0 0 1-1.5 1.5h-1A1.5 1.5 0 0 1 9 12.5z"/>
</svg>
									</a>
									<?php
								}
								?>
								</span>
						</li>
						<?php
					}
					if($configClass['property_save_to_favories'] == 1 && $user->id > 0)
					{
						if($inFav == 0)
						{
							?>
							<li class="item-tool">
							
								<span id="fav<?php echo $row->id;?>">
									<?php
									$msg = Text::_('OS_DO_YOU_WANT_TO_ADD_PROPERTY_TO_YOUR_FAVORITE_LISTS');
									$msg = str_replace("'","\'",$msg);
									?>
									<a title="<?php echo Text::_('OS_ADD_TO_FAVORITES');?>" onclick="javascript:osConfirmExtend('<?php echo $msg;?>','ajax_addFavorites','<?php echo $row->id?>','<?php echo Uri::root()?>','fav<?php echo $row->id; ?>','house','details')" class="favLink">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-heart" viewBox="0 0 16 16">
<path d="m8 2.748-.717-.737C5.6.281 2.514.878 1.4 3.053c-.523 1.023-.641 2.5.314 4.385.92 1.815 2.834 3.989 6.286 6.357 3.452-2.368 5.365-4.542 6.286-6.357.955-1.886.838-3.362.314-4.385C13.486.878 10.4.28 8.717 2.01zM8 15C-7.333 4.868 3.279-3.04 7.824 1.143q.09.083.176.171a3 3 0 0 1 .176-.17C12.72-3.042 23.333 4.867 8 15"/>
</svg>
									</a>
								</span>
							
							</li>
							<?php
						}
						else
						{
							?>
							<li class="item-tool">
							
								<span id="fav<?php echo $row->id;?>">
									<?php
									$msg = Text::_('OS_DO_YOU_WANT_TO_REMOVE_PROPERTY_OUT_OF_YOUR_FAVORITE_LISTS');
									$msg = str_replace("'","\'",$msg);
									?>
									<a title="<?php echo Text::_('OS_REMOVE_FAVORITES');?>" onclick="javascript:osConfirmExtend('<?php echo $msg;?>','ajax_removeFavorites','<?php echo $row->id?>','<?php echo Uri::root()?>','fav<?php echo $row->id; ?>','house','details')" href="javascript:void(0)" class="favLinkActive">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-heart-fill" viewBox="0 0 16 16">
<path fill-rule="evenodd" d="M8 1.314C12.438-3.248 23.534 4.735 8 15-7.534 4.736 3.562-3.248 8 1.314"/>
</svg>
									</a>
								</span>
						
							</li>
							<?php
						}
					}
					?>
					<li class="item-tool">
						<span class="dropdown">
							<a class="dropdown-toggle" id="dropdownMenuLink" data-bs-toggle="dropdown" aria-expanded="false" href="#">
								<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-share-fill" viewBox="0 0 16 16">
  <path d="M11 2.5a2.5 2.5 0 1 1 .603 1.628l-6.718 3.12a2.5 2.5 0 0 1 0 1.504l6.718 3.12a2.5 2.5 0 1 1-.488.876l-6.718-3.12a2.5 2.5 0 1 1 0-3.256l6.718-3.12A2.5 2.5 0 0 1 11 2.5"/>
</svg>
							</a>
							<ul class="dropdown-menu" aria-labelledby="dropdownMenuLink">
								<li><a class="dropdown-item" href="http://www.facebook.com/share.php?u=<?php echo $url;?>&t=<?php echo $row->pro_name?>"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-facebook" viewBox="0 0 16 16">
  <path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951"/>
</svg> Facebook</a></li>
								<li><a class="dropdown-item" href="https://twitter.com/intent/tweet?original_referer=<?php echo $url;?>&tw_p=tweetbutton&url=<?php echo $url;?>"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-twitter-x" viewBox="0 0 16 16">
  <path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865z"/>
</svg> Twitter</a></li>
							 </ul>
						</span>
					</li>
					<?php
					if($configClass['property_show_print'] == 1)
					{
						?>
						<li class="item-tool">
							<span>
								<a target="_blank" href="<?php echo Uri::root()?>index.php?option=com_osproperty&tmpl=component&no_html=1&task=property_print&id=<?php echo $row->id?>" title="<?php echo Text::_('OS_PRINT_PROPERTY');?>">
									<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-printer-fill" viewBox="0 0 16 16">
	  <path d="M5 1a2 2 0 0 0-2 2v1h10V3a2 2 0 0 0-2-2zm6 8H5a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1v-3a1 1 0 0 0-1-1"/>
	  <path d="M0 7a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v3a2 2 0 0 1-2 2h-1v-2a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v2H2a2 2 0 0 1-2-2zm2.5 1a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1"/>
	</svg>							
								</a>
							</span>
						</li>
						<?php
					}
					?>
				</ul>
				<div class="clearfix"></div>
				<ul class="item-price-wrap hide-on-list">
					<li class="item-price">
						<?php
						if(OSPHelper::getLanguageFieldValue($property,'price_text') != "")
						{
							echo " ".OSPHelper::getLanguageFieldValue($property,'price_text');
						}
						elseif($property->price_call == 1)
						{
							echo Text::_('OS_CALL_FOR_PRICE');
						}
						else
						{
							echo OSPHelper::generatePrice($property->curr, $property->price);
						}
						?>
					</li>
					<?php
					if($row->rent_time != "")
					{
						?>
						<li class="item-sub-price">
						<?php
						echo Text::_($row->rent_time);
						?>
						<li>
						<?php
					}
					?>
				</ul>
            </div>
        </div>
		<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> propertyheadingmobile">
			<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
				<div class="summary singleTopHouse">
					<div class="mobile-property-tools houzez-media-tabs-5 clearfix alignright">
						<ul class="item-tools">
							<?php
							if($configClass['show_getdirection'] == 1 && $row->show_address == 1)
							{
								?>
								<li class="item-tool">
									<span class="getdirectionLink">
										<a href="<?php echo Route::_("index.php?option=com_osproperty&task=direction_map&id=".$row->id)?>" title="<?php echo Text::_('OS_GET_DIRECTIONS')?>">
											<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-geo-alt-fill" viewBox="0 0 16 16">
		  <path d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10m0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6"/>
		</svg>
										</a>
									</span>
								</li>
								<?php
							}
							if($configClass['show_compare_task'] == 1)
							{
								?>
								<li class="item-tool">
									
										<span id="compare<?php echo $row->id;?>">
										<?php
										if(! OSPHelper::isInCompareList($row->id)) {
											$msg = Text::_('OS_DO_YOU_WANT_TO_ADD_PROPERTY_TO_YOUR_COMPARE_LIST');
											$msg = str_replace("'","\'",$msg);
											?>
											<a title="<?php echo Text::_('OS_ADD_TO_COMPARE_LIST');?>" onclick="javascript:osConfirmExtend('<?php echo $msg; ?>','ajax_addCompare','<?php echo $row->id ?>','<?php echo Uri::root() ?>','compare<?php echo $row->id;?>','house','details')" href="javascript:void(0)" class="compareLink">
												<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-diagram-2" viewBox="0 0 16 16">
		  <path fill-rule="evenodd" d="M6 3.5A1.5 1.5 0 0 1 7.5 2h1A1.5 1.5 0 0 1 10 3.5v1A1.5 1.5 0 0 1 8.5 6v1H11a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-1 0V8h-5v.5a.5.5 0 0 1-1 0v-1A.5.5 0 0 1 5 7h2.5V6A1.5 1.5 0 0 1 6 4.5zM8.5 5a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5zM3 11.5A1.5 1.5 0 0 1 4.5 10h1A1.5 1.5 0 0 1 7 11.5v1A1.5 1.5 0 0 1 5.5 14h-1A1.5 1.5 0 0 1 3 12.5zm1.5-.5a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5zm4.5.5a1.5 1.5 0 0 1 1.5-1.5h1a1.5 1.5 0 0 1 1.5 1.5v1a1.5 1.5 0 0 1-1.5 1.5h-1A1.5 1.5 0 0 1 9 12.5zm1.5-.5a.5.5 0 0 0-.5.5v1a.5.5 0 0 0 .5.5h1a.5.5 0 0 0 .5-.5v-1a.5.5 0 0 0-.5-.5z"/>
		</svg>
											</a>
											<?php
										}else{
											$msg = Text::_('OS_DO_YOU_WANT_TO_REMOVE_PROPERTY_OUT_OF_COMPARE_LIST');
											$msg = str_replace("'","\'",$msg);
											?>
											<a title="<?php echo Text::_('OS_REMOVE_FROM_COMPARE_LIST');?>" onclick="javascript:osConfirmExtend('<?php echo $msg; ?>','ajax_removeCompare','<?php echo $row->id ?>','<?php echo Uri::root() ?>','compare<?php echo $row->id;?>','house','details')" href="javascript:void(0)" class="compareLinkActive">
												<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-diagram-2-fill" viewBox="0 0 16 16">
		  <path fill-rule="evenodd" d="M6 3.5A1.5 1.5 0 0 1 7.5 2h1A1.5 1.5 0 0 1 10 3.5v1A1.5 1.5 0 0 1 8.5 6v1H11a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-1 0V8h-5v.5a.5.5 0 0 1-1 0v-1A.5.5 0 0 1 5 7h2.5V6A1.5 1.5 0 0 1 6 4.5zm-3 8A1.5 1.5 0 0 1 4.5 10h1A1.5 1.5 0 0 1 7 11.5v1A1.5 1.5 0 0 1 5.5 14h-1A1.5 1.5 0 0 1 3 12.5zm6 0a1.5 1.5 0 0 1 1.5-1.5h1a1.5 1.5 0 0 1 1.5 1.5v1a1.5 1.5 0 0 1-1.5 1.5h-1A1.5 1.5 0 0 1 9 12.5z"/>
		</svg>
											</a>
											<?php
										}
										?>
										</span>
								</li>
								<?php
							}
							if($configClass['property_save_to_favories'] == 1 && $user->id > 0)
							{
								if($inFav == 0)
								{
									?>
									<li class="item-tool">
									
										<span id="fav<?php echo $row->id;?>">
											<?php
											$msg = Text::_('OS_DO_YOU_WANT_TO_ADD_PROPERTY_TO_YOUR_FAVORITE_LISTS');
											$msg = str_replace("'","\'",$msg);
											?>
											<a title="<?php echo Text::_('OS_ADD_TO_FAVORITES');?>" onclick="javascript:osConfirmExtend('<?php echo $msg;?>','ajax_addFavorites','<?php echo $row->id?>','<?php echo Uri::root()?>','fav<?php echo $row->id; ?>','house','details')" class="favLink">
												<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-heart" viewBox="0 0 16 16">
		<path d="m8 2.748-.717-.737C5.6.281 2.514.878 1.4 3.053c-.523 1.023-.641 2.5.314 4.385.92 1.815 2.834 3.989 6.286 6.357 3.452-2.368 5.365-4.542 6.286-6.357.955-1.886.838-3.362.314-4.385C13.486.878 10.4.28 8.717 2.01zM8 15C-7.333 4.868 3.279-3.04 7.824 1.143q.09.083.176.171a3 3 0 0 1 .176-.17C12.72-3.042 23.333 4.867 8 15"/>
		</svg>
											</a>
										</span>
									
									</li>
									<?php
								}
								else
								{
									?>
									<li class="item-tool">
									
										<span id="fav<?php echo $row->id;?>">
											<?php
											$msg = Text::_('OS_DO_YOU_WANT_TO_REMOVE_PROPERTY_OUT_OF_YOUR_FAVORITE_LISTS');
											$msg = str_replace("'","\'",$msg);
											?>
											<a title="<?php echo Text::_('OS_REMOVE_FAVORITES');?>" onclick="javascript:osConfirmExtend('<?php echo $msg;?>','ajax_removeFavorites','<?php echo $row->id?>','<?php echo Uri::root()?>','fav<?php echo $row->id; ?>','house','details')" href="javascript:void(0)" class="favLinkActive">
												<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-heart-fill" viewBox="0 0 16 16">
		<path fill-rule="evenodd" d="M8 1.314C12.438-3.248 23.534 4.735 8 15-7.534 4.736 3.562-3.248 8 1.314"/>
		</svg>
											</a>
										</span>
								
									</li>
									<?php
								}
							}
							?>
							<li class="item-tool">
								<span class="dropdown">
									<a class="dropdown-toggle" id="dropdownMenuLink" data-bs-toggle="dropdown" aria-expanded="false" href="#">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-share-fill" viewBox="0 0 16 16">
		  <path d="M11 2.5a2.5 2.5 0 1 1 .603 1.628l-6.718 3.12a2.5 2.5 0 0 1 0 1.504l6.718 3.12a2.5 2.5 0 1 1-.488.876l-6.718-3.12a2.5 2.5 0 1 1 0-3.256l6.718-3.12A2.5 2.5 0 0 1 11 2.5"/>
		</svg>
									</a>
									<ul class="dropdown-menu" aria-labelledby="dropdownMenuLink">
										<li><a class="dropdown-item" href="http://www.facebook.com/share.php?u=<?php echo $url;?>&t=<?php echo $row->pro_name?>"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-facebook" viewBox="0 0 16 16">
		  <path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951"/>
		</svg> Facebook</a></li>
										<li><a class="dropdown-item" href="https://twitter.com/intent/tweet?original_referer=<?php echo $url;?>&tw_p=tweetbutton&url=<?php echo $url;?>"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-twitter-x" viewBox="0 0 16 16">
		  <path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865z"/>
		</svg> Twitter</a></li>
									 </ul>
								</span>
							</li>
							<?php
							if($configClass['property_show_print'] == 1)
							{
								?>
								<li class="item-tool">
									<span>
										<a target="_blank" href="<?php echo Uri::root()?>index.php?option=com_osproperty&tmpl=component&no_html=1&task=property_print&id=<?php echo $row->id?>" title="<?php echo Text::_('OS_PRINT_PROPERTY');?>">
											<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-printer-fill" viewBox="0 0 16 16">
			  <path d="M5 1a2 2 0 0 0-2 2v1h10V3a2 2 0 0 0-2-2zm6 8H5a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1v-3a1 1 0 0 0-1-1"/>
			  <path d="M0 7a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v3a2 2 0 0 1-2 2h-1v-2a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v2H2a2 2 0 0 1-2-2zm2.5 1a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1"/>
			</svg>							
										</a>
									</span>
								</li>
								<?php
							}
							?>
							
						</ul>
					</div>
					<div class="mobile-property-title clearfix">
						<?php
						if($configClass['active_market_status'] == 1 && $row->isSold > 0){
						?>
						<span class="osplabel label-gray"><?php echo OSPHelper::returnMarketStatus($row->isSold);?></span>
						<?php } ?>
						<span class="osplabel label-yellow"><?php echo $row->type_name?></span>
						<?php
						if($row->isFeatured == 1)
						{
							?>
							<span class="osplabel label-red">
								<?php echo Text::_('OS_FEATURED');?>
							</span>
							<?php
						}
						?>
						<h1 class="property_title">
							<?php
							echo $row->pro_name;
							?>
						</h1>
						<?php
						if($row->show_address == 1)
						{
						?>
							<address class="item-address">
								<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-geo-alt" viewBox="0 0 16 16">
								  <path d="M12.166 8.94c-.524 1.062-1.234 2.12-1.96 3.07A32 32 0 0 1 8 14.58a32 32 0 0 1-2.206-2.57c-.726-.95-1.436-2.008-1.96-3.07C3.304 7.867 3 6.862 3 6a5 5 0 0 1 10 0c0 .862-.305 1.867-.834 2.94M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10"/>
								  <path d="M8 8a2 2 0 1 1 0-4 2 2 0 0 1 0 4m0 1a3 3 0 1 0 0-6 3 3 0 0 0 0 6"/>
								</svg>
								<?php
								
									echo OSPHelper::generateAddress($row);
								?>
							</address>
						<?php
						}		
						?>
					</div>
				</div>
			</div>
		</div>
		<?php
		$addspan = 60;
		if ($configClass['goole_use_map'] == 1 && $row->lat_add != "" && $row->long_add != "" && $row->lat_add != "0" && $row->long_add != "0")	
		{
			$addspan += 65;
			if ($configClass['show_streetview'] == 1 && $row->show_address == 1) 
			{
				$addspan += 55;
			}
		}
		?>
		<style>
		#videobuttons
		{
			left:<?php echo $addspan?>px !important;
		}
		</style>
		<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
			<div class="<?php echo $bootstrapHelper->getClassMapping('span8'); ?>" >
				<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>" >
					<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>" style="position:relative;padding-left:0px;padding-right:0px;">
						<?php
						if($row->pro_video != "" || $row->tour_link != "")
						{
						?>
						<ul id="videobuttons" class="joomla-tabs nav nav-tabs">
							<?php
							if($row->pro_video != "")
							{
								?>
								<li class="nav-item">
									<a href="javascript:scrollToDiv('shellvideoh3')" class="nav-link" title="<?php echo Text::_('OS_VIDEO')?>">
										<i class="fa fa-video-camera" aria-hidden="true"></i>
									</a>
								<li>
								<?php
							}
							if($row->tour_link != "")
							{
								?>
								<li class="nav-item">
									<a href="javascript:scrollToDiv('shellheading')" class="nav-link" title="<?php echo Text::_('OS_VIRTUAL_TOUR')?>">
										<i class="fa fa-home" aria-hidden="true"></i>

									</a>
								<li>
								<?php
							}
							?>
						</ul>
						<?php
						}	
						?>
						<?php echo HTMLHelper::_('bootstrap.startTabSet', 'propertyDetailsTab', array('active' => 'tabphoto')); ?>
							<?php
							$phototext = '<i class="fa fa-camera" aria-hidden="true"></i>';
							?>
							<?php echo HTMLHelper::_('bootstrap.addTab', 'propertyDetailsTab', 'tabphoto', $phototext); ?>
								<div class="tab-pane active">
									 <script src="<?php echo Uri::root()?>media/com_osproperty/assets/js/jquery.bxslider.js"></script>
									 <div id="slides">
										 <script type="text/javascript" src="<?php echo Uri::root()?>media/com_osproperty/assets/js/colorbox/jquery.colorbox.js"></script>
										 <link rel="stylesheet" href="<?php echo Uri::root()?>media/com_osproperty/assets/js/colorbox/colorbox.css" type="text/css" media="screen" />
										 <script type="text/javascript">
										  jQuery(document).ready(function(){
											  jQuery(".propertyphotogroup").colorbox({rel:'colorbox',maxWidth:'95%', maxHeight:'95%'});
										  });
										  </script>
										  <?php
											$slidertype		= 'slidernav';
											$animation		= 'slide';
											$slideshow		= 'true';
											$slideshowspeed = 5000;
											$arrownav		= 'true';
											$controlnav		= 'true' ;
											$keyboardnav	= 'true';
											$mousewheel		= 'false';
											$randomize		=  'false';
											$animationloop	=  'true';
											$pauseonhover	=  'true' ;
											$target			= 'self';
											$jquery			= 'noconflict';
											
											if ($jquery != 0) 
											{
												HTMLHelper::script('https://ajax.googleapis.com/ajax/libs/jquery/1/jquery.min.js');
											}
											echo '<script type="text/javascript" src="'.Uri::root().'components/com_osproperty/templates/default/js/jquery.flexslider.js"></script>';
											HTMLHelper::stylesheet(Uri::root().'components/com_osproperty/templates/default/style/favslider.css');
											
											if ($jquery == 1 || $jquery == 0) 
											{ 
												$noconflict = ''; $varj = '$';
											}
											if ($jquery == "noconflict") 
											{
												$noconflict = 'jQuery.noConflict();'; $varj = 'jQuery';
											}
											if ($slidertype == "slidernav") 
											{
												echo '<style type= text/css>#carousel1 {margin-top: 3px;}</style><script type="text/javascript">
												'.$noconflict.'
													'.$varj.'(window).load(function(){
													  '.$varj.'(\'#carousel1\').favslider({
														animation: "slide",
														controlNav: false,
														directionNav: '.$arrownav.',
														mousewheel: '.$mousewheel.',
														animationLoop: false,
														slideshow: false,
														itemWidth: 120,
														asNavFor: \'#slider1\'
													  });
													  
													  '.$varj.'(\'#slider1\').favslider({
														animation: "'.$animation.'",
														directionNav: '.$arrownav.',
														mousewheel: '.$mousewheel.',
														slideshow: '.$slideshow.',
														slideshowSpeed: '.$slideshowspeed.',
														randomize: '.$randomize.',
														animationLoop: '.$animationloop.',
														pauseOnHover: '.$pauseonhover.',
														controlNav: false,
														sync: "#carousel1",
														start: function(slider){
														'.$varj.'(\'body\').removeClass(\'loading\');
														}
													  });
													});
												</script>'; 
											} 
											if(count($photos) > 0)
											{
												if(count($photos) == 1)
												{
													?>
													<li class="propertyinfoli">
														<a class="propertyphotogroup propertyinfolilink" href="<?php echo Uri::root()?>images/osproperty/properties/<?php echo $row->id;?>/<?php echo $photos[0]->image?>">
															<?php
															OSPHelper::showPropertyPhoto($photos[0]->image,'medium',$row->id,'','','',$photos[0]->image_desc);
															?>
														</a>
													</li>
													<?php
												}
												else
												{
												?>
													<div id="slider1" class="favslider1 margin0">
														<ul class="favs">
															<?php
															for($i=0;$i<count($photos);$i++)
															{
																if($photos[$i]->image != "")
																{
																	if(file_exists(JPATH_ROOT.'/images/osproperty/properties/'.$row->id.'/medium/'.$photos[$i]->image))
																	{
																		?>
																		<li class="propertyinfoli">
																			<a class="propertyphotogroup propertyinfolilink" href="<?php echo Uri::root()?>images/osproperty/properties/<?php echo $row->id;?>/<?php echo $photos[$i]->image?>">
																				<img class="pictureslideshow" src="<?php echo Uri::root()?>images/osproperty/properties/<?php echo $row->id;?>/medium/<?php echo $photos[$i]->image?>" alt="<?php echo $photos[$i]->image_desc;?>" title="<?php echo $photos[$i]->image_desc;?>"/>
																			</a>
																		</li>
																		<?php
																	}
																	else
																	{
																		?>
																		<li class="propertyinfoli">
																			<img src="<?php echo Uri::root()?>media/com_osproperty/assets/images/nopropertyphoto.png" alt="<?php echo $photos[$i]->image_desc;?>" title="<?php echo $photos[$i]->image_desc;?>"/>
																		</li>
																		<?php
																	}
																}
																else
																{
																	?>
																	<li class="propertyinfoli">
																		<img src="<?php echo Uri::root()?>media/com_osproperty/assets/images/nopropertyphoto.png" alt="<?php echo $photos[$i]->image_desc;?>" title="<?php echo $photos[$i]->image_desc;?>"/>
																	</li>
																	<?php
																}
															}
															?>
														</ul>
													</div>
													<div id="carousel1" class="favslider1 hidden-phone">
														<ul class="favs">
														<?php 
														for($i=0;$i<count($photos);$i++)
														{
															if($photos[$i]->image != "")
															{
																if(JPATH_ROOT.'/images/osproperty/properties/'.$row->id.'/thumb/'.$photos[$i]->image)
																{
																	?>
																	<li <?php if ($i>0) {?>style="margin-left: 3px;width:120px !important;"<?php }else{ ?>style="width:120px !important;; "<?php } ?>><img class="detailwidth" alt="<?php echo $photos[$i]->image_desc;?>" title="<?php echo $photos[$i]->image_desc;?>" src="<?php echo Uri::root()?>images/osproperty/properties/<?php echo $row->id;?>/thumb/<?php echo $photos[$i]->image?>" /></li>
																	<?php
																}
																else
																{
																	?>
																	<li <?php if ($i>0) {?>style="margin-left: 3px;width:120px !important;"<?php }else{ ?>style="width:120px; !important;"<?php } ?>><img src="<?php echo Uri::root()?>media/com_osproperty/assets/images/nopropertyphoto.png" /></li>
																	<?php
																}
															}
															else
															{
																?>
																<li <?php if ($i>0) {?>style="margin-left: 3px;width:120px !important;"<?php }else{ ?>style="width:120px !important;;"<?php } ?>><img src="<?php echo Uri::root()?>media/com_osproperty/assets/images/nopropertyphoto.png" /></li>
																<?php
															}
														}
														?>
														</ul>
													</div>
												<?php } ?>
											<?php
											}
											else
											{
											?>
												<ul class="bxslider padding0 margin0">
													<li class="propertyinfoli"><img src="<?php echo Uri::root()?>media/com_osproperty/assets/images/nopropertyphoto.png" alt="" title=""/></li>
												</ul>
												<?php
											}
										?>
									</div>
								</div>
							<?php echo HTMLHelper::_('bootstrap.endTab') ?>
							<?php
							if ($configClass['goole_use_map'] == 1 && $row->lat_add != "" && $row->long_add != "" && $row->lat_add != "0" && $row->long_add != "0")
							{
								$maptext = '<i class="fa fa-map"></i>';
								?>
								<?php echo HTMLHelper::_('bootstrap.addTab', 'propertyDetailsTab', 'tabgoogle', $maptext); ?>
									<div class="tab-pane">
										<div id="map_canvas" style="height: <?php echo $configClass['property_map_height'] ?>px; width: <?php echo $mapwidth ?>px;"></div>
									</div>
								<?php echo HTMLHelper::_('bootstrap.endTab') ?>
								<?php
								if($configClass['map_type'] == 0)
								{
									if ($configClass['show_streetview'] == 1 && $row->show_address == 1) 
									{
										$streetview = '<i class="fa fa-street-view"></i>';
										echo HTMLHelper::_('bootstrap.addTab', 'propertyDetailsTab', 'tabstreet', $streetview);
										?>
										<div class="tab-pane">
											<div id="pano" style="height: <?php echo $configClass['property_map_height']?>px; width: 100%;"></div>
										</div>
										<?php
										echo HTMLHelper::_('bootstrap.endTab');
									}
								}
							}
							?>
						 <?php echo HTMLHelper::_('bootstrap.endTabSet'); ?>
					</div>
				</div>
		<?php
		if($row->show_address == 1 && $row->lat_add != "" && $row->long_add != "" && $row->lat_add != "0" && $row->long_add != "0")
		{
			$spanClass = 9;
		}
		else
		{
			$spanClass = 12;
		}
		?>
		<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> overview">
			<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
				<h3><?php echo Text::_('OS_OVERVIEW')?></h3>
				<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
					<div class="<?php echo $bootstrapHelper->getClassMapping('span'.$spanClass); ?>">
						<div class="property-overview-data houzez-tablet-layout-2cols">
							<ul class="list-unstyled flex-fill">
								<li class="property-overview-item"><strong><?php echo $row->category_name?></strong></li>
								<li class="hz-meta-label property-overview-type"><?php echo Text::_('OS_CATEGORY')?></li>
							</ul>
							<?php
							if($configClass['use_bedrooms'] == 1 && $row->bed_room > 0){
							?>
							<ul class="list-unstyled flex-fill">
								<li class="property-overview-item">
									<i class="fa fa-bed" aria-hidden="true"></i> <strong><?php echo $row->bed_room; ?></strong> 
								</li>
								<li class="hz-meta-label h-beds"><?php echo Text::_('OS_BEDS')?></li>
							</ul>
							<?php
							}
							if($configClass['use_bathrooms'] == 1 && $row->bath_room > 0){
							?>
							<ul class="list-unstyled flex-fill">
								<li class="property-overview-item">
									<i class="fa fa-bath" aria-hidden="true"></i> <strong><?php echo OSPHelper::showBath($row->bath_room); ?></strong>
								</li>
								<li class="hz-meta-label h-baths"><?php echo Text::_('OS_BATHS') ?></li>
							</ul>
							<?php
							}	
							?>
							<ul class="list-unstyled flex-fill">
								<li class="property-overview-item">
									<i class="fa fa-car" aria-hidden="true"></i> <strong><?php echo $row->parking; ?></strong>
								</li>
								<li class="hz-meta-label h-garage"><?php echo Text::_('OS_GARAGE_DESCRIPTION');?></li>
							</ul>
							<ul class="list-unstyled flex-fill">
								<li class="property-overview-item">
									<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-rulers" viewBox="0 0 16 16">
		  <path d="M1 0a1 1 0 0 0-1 1v14a1 1 0 0 0 1 1h5v-1H2v-1h4v-1H4v-1h2v-1H2v-1h4V9H4V8h2V7H2V6h4V2h1v4h1V4h1v2h1V2h1v4h1V4h1v2h1V2h1v4h1V1a1 1 0 0 0-1-1z"/>
		</svg> <strong><?php echo OSPHelper::showSquare($row->square_feet); ?></strong>
								</li>
								<li class="hz-meta-label h-area"><?php echo OSPHelper::showSquareLabels(); ?></li>
							</ul>
							<?php
							if($row->built_on > 0)
							{
							?>
							<ul class="list-unstyled flex-fill">
								<li class="property-overview-item">
									<i class="fa fa-calendar" aria-hidden="true"></i> <strong><?php echo $row->built_on?></strong>
								</li>
								<li class="hz-meta-label h-year-built"><?php echo Text::_('OS_YEAR_BUILT');?></li>
							</ul>
							<?php } ?>
						</div>
					</div>
					<?php
					if($row->show_address == 1 && $row->lat_add != "" && $row->long_add != "" && $row->lat_add != "0" && $row->long_add != "0")
					{
					?>
						<div class="<?php echo $bootstrapHelper->getClassMapping('span3'); ?>">
							<?php
							if($configClass['map_type'] == 1)
							{
								HelperOspropertyOpenStreetMap::loadOpenStreetMapDetails($row, $configClass, '', 2);
							}
							else
							{
								HelperOspropertyGoogleMap::loadGoogleMapDetails($row, $configClass, '', 2);
							}
							?>
						</div>
					<?php
								
					}		
					?>
				</div>
			</div>
		</div>

		<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> descriptionTop">
			<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?> description">
				<h3><?php echo Text::_('OS_DESCRIPTION')?></h3>
				<div class="entry-content">
					<?php
					$row->pro_small_desc = OSPHelper::getLanguageFieldValue($row,'pro_small_desc');
					echo $row->pro_small_desc;

					$pro_full_desc = OSPHelper::getLanguageFieldValue($row,'pro_full_desc');
					$row->pro_full_desc =  HTMLHelper::_('content.prepare', $pro_full_desc);
					echo stripslashes($row->pro_full_desc);
				?>
				</div>
				
				<?php if(count((array)$tagArr) > 0){ ?>
				<h3><i class="edicon edicon-price-tags"></i>&nbsp;<?php echo Text::_('OS_TAGS')?></h3>
				<div class="entry-content tagdiv">
					<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?> noleftmargin">
						<?php echo implode("&nbsp;",$tagArr);?>
					</div>
					<div class="clearfix"></div>
				</DIV>
				<?php } ?>
			</div>
		</div>

		<?php
		if(count($middlePlugin) > 0){
			for($i=0;$i<count($middlePlugin);$i++){
				echo $middlePlugin[$i];
			}
		}
		?>
		<!-- description list -->
		<?php
		$fieldok = 0;
		if(count((array)$row->extra_field_groups) > 0)
		{
			$extra_field_groups = $row->extra_field_groups;
			for($i=0;$i<count((array)$extra_field_groups);$i++)
			{
				$group		= $extra_field_groups[$i];
				$group_name = $group->group_name;
				$fields		= (array)$group->fields;
				if(count($fields)> 0)
				{
					$fieldok = 1;
				}
			}
		}
		?>
		
		<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> address">
			<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
				<h3><?php echo Text::_('OS_ADDRESS')?></h3>
				<div class="entry-content">
					<ul class="list-2-cols list-unstyled">
						<?php
						if($row->address != ""){
						?>
						<li class="detail-address">
							<strong><?php echo Text::_('OS_ADDRESS');?></strong>
							<span><?php echo $row->address; ?></span>
						</li>
						<?php } ?>
						<?php
						if($row->postcode != ""){
						?>
						<li class="detail-zip">
							<strong><?php echo Text::_('OS_ZIP_CODE');?></strong>
							<span><?php echo $row->postcode; ?></span>
						</li>
						<?php } ?>
						<?php
						if($row->city > 0){
						?>
						<li class="detail-city">
							<strong><?php echo Text::_('OS_CITY');?></strong>
							<span><?php echo OSPHelper::loadCityName($row->city); ?></span>
						</li>
						<?php } ?>
						<?php
						if($row->region != ""){
						?>
						<li class="detail-area">
							<strong><?php echo Text::_('OS_REGION');?></strong>
							<span><?php echo $row->region; ?></span>
						</li>
						<?php } ?>
						<?php
						if($row->state > 0){
						?>
						<li class="detail-state">
							<strong><?php echo Text::_('OS_STATE');?></strong>
							<span><?php echo OSPHelper::loadSateName($row->state); ?></span>
						</li>
						<?php
						}	
						?>
						<li class="detail-country">
							<strong><?php echo Text::_('OS_COUNTRY');?></strong>
							<span><?php echo OSPHelper::loadCountryName($row->country); ?></span>
						</li>
					</ul>
				</div>
			</div>
		</div>


		<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> propertydetailspart">
			<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
				<h3><?php echo Text::_('OS_DETAILS')?></h3>
				<div class="detail-wrap">
					<ul class="list-2-cols list-unstyled">
						<li class="detail-id">
							<strong><?php echo Text::_('OS_PROPERTY_ID');?></strong>
							<span><?php echo $row->ref; ?></span>
						</li>
						<li class="detail-price">
							<strong><?php echo Text::_('OS_PRICE');?></strong>
							<span><?php 
							if(OSPHelper::getLanguageFieldValue($property,'price_text') != "")
							{
								echo " ".OSPHelper::getLanguageFieldValue($property,'price_text');
							}
							elseif($property->price_call == 1)
							{
								echo Text::_('OS_CALL_FOR_PRICE');
							}
							else
							{
								echo OSPHelper::generatePrice($property->curr, $property->price);
							}
							?></span>
						</li>
						<?php
						if($configClass['use_squarefeet'] == 1 && $row->square_feet > 0){
						?>
						<li class="detail-city">
							<strong><?php echo Text::_('OS_PROPERTY_SIZE');?></strong>
							<span><?php echo OSPHelper::showSquare($row->square_feet)." ".OSPHelper::showSquareSymbol(); ?></span>
						</li>
						<?php
						}	
						?>
						<?php
						if($configClass['use_bathrooms'] == 1 && $row->bath_room > 0){
						?>
						<li class="detail-baths">
							<strong><?php echo Text::_('OS_BATHS');?></strong>
							<span><?php echo OSPHelper::showBath($row->bath_room); ?></span>
						</li>
						<?php
						}	
						?>
						<?php
						if($configClass['use_bedrooms'] == 1 && $row->bed_room > 0){
						?>
						<li class="detail-beds">
							<strong><?php echo Text::_('OS_BEDS');?></strong>
							<span><?php echo $row->bed_room; ?></span>
						</li>
						<?php
						}	
						?>
						<?php
						if($configClass['use_parking'] == 1 && ($row->garage_description != "" || $row->parking != "")){
						?>
							<li class="detail-parking">
								<strong><?php echo Text::_('OS_PARKING');?></strong>
								<span><?php echo $row->parking; ?></span>
							</li>
							<?php
							if($row->garage_description != "")
							{
								?>
								<li class="detail-parking-description">
									<strong><?php echo Text::_('OS_GARAGE_DESCRIPTION');?></strong>
									<span><?php echo $row->garage_description; ?></span>
								</li>
								<?php
							}	
							?>
						<?php } ?>
						<?php
						if($row->built_on > 0){
						?>
						<li class="detail-parking">
							<strong><?php echo Text::_('OS_BUILT_ON');?></strong>
							<span><?php echo $row->built_on; ?></span>
						</li>
						<?php } ?>
						<li class="detail-type">
							<strong><?php echo Text::_('OS_PROPERTY_TYPE');?></strong>
							<span><?php echo $row->type_name; ?></span>
						</li>
						<li class="detail-category">
							<strong><?php echo Text::_('OS_CATEGORIES');?></strong>
							<span><?php echo OSPHelper::getCategoryNamesOfPropertyWithLinks($row->id); ?></span>
						</li>
						<?php
						if($configClass['active_market_status'] == 1 && $row->isSold > 0)
						{	
						?>
						<li class="detail-status">
							<strong><?php echo Text::_('OS_MARKET_STATUS');?></strong>
							<span><?php echo OSPHelper::returnMarketStatus($row->isSold);?></span>
						</li>
						<?php
						}	
						?>
					</ul>
				</div>
			</div>
		</div>


		<?php
		
		if($configClass['use_open_house'] == 1 && $row->open_hours != "")
		{
			?>
			<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> open_house">
				<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
					<h3><?php echo Text::_('OS_OPEN_FOR_INSPECTION_TIMES')?></h3>
						<div class="entry-content">
							<?php echo $row->open_hours;?>
						</div>
				</div>
			</div>
			<?php
		}
		?>

		<?php
		if ($configClass['use_nfloors'] == 1 || ($configClass['basement_foundation'] == 1 && ($row->basement_size > 0 || $row->basement_foundation != "" || $row->percent_finished != "")) || ($configClass['use_squarefeet'] == 1 && ($row->subdivision != '' || $row->land_holding_type != '' || $row->lot_dimensions != '' || $row->frontpage != '' || $row->frontpage != '' || $row->living_areas > 0 || $row->lot_size > 0 || $row->total_acres > 0)) || $configClass['use_business'] == 1)
		{
			?>
			<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> additional_information">
				<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
					<h3><?php echo Text::_('OS_ADDITIONAL_INFORMATION')?></h3>
					<div class="entry-content">
						<ul class="list-2-cols list-unstyled">
							<?php
							$tmpArray                   = [];
							?>
							<!-- building information -->
							<?php
							if($configClass['use_nfloors'] == 1)
							{
								$textFieldsArr = array('house_style','house_construction','exterior_finish','roof','flooring');
								$numberFieldArr = array('floor_area_lower','floor_area_main_level','floor_area_upper','floor_area_total');
								$intFieldArr = array('number_of_floors','built_on','remodeled_on');
								$show = 0;
								foreach($textFieldsArr as $textfield){
									if($row->{$textfield} != ""){
										$show = 1;
									}
								}
								foreach($numberFieldArr as $numfield){
									if($row->{$numfield}  > 0){
										$show = 1;
									}
								}
								foreach($intFieldArr as $numfield){
									if($row->{$numfield}  > 0){
										$show = 1;
									}
								}
								if($show == 1) 
								{
									foreach($textFieldsArr as $textfield)
									{
										if($row->{$textfield} != "")
										{
											?>
											<li>
												<strong><?php echo Text::_('OS_'.strtoupper($textfield));?></strong>
												<span><?php echo $row->{$textfield}; ?></span>
											</li>
											<?php
										}
									}
									foreach($intFieldArr as $numfield)
									{
										if($row->{$numfield}  > 0)
										{
											?>
											<li>
												<strong><?php echo Text::_('OS_'.strtoupper($numfield));?></strong>
												<span><?php echo $row->{$numfield}; ?></span>
											</li>
											<?php
										}
									}
									foreach($numberFieldArr as $numfield)
									{
										if($row->{$numfield}  > 0)
										{
											?>
											<li>
												<strong><?php echo Text::_('OS_'.strtoupper($numfield));?></strong>
												<span><?php echo $row->{$numfield}; 
													if($numfield != "number_of_floors")
													{
														echo " ".OSPHelper::showSquareSymbol();
													}
												?>
												
												</span>
											</li>
											<?php
										}
									}
								}
							}
							if($configClass['basement_foundation'] == 1 && ($row->basement_size > 0 || $row->basement_foundation != "" || $row->percent_finished != ""))
							{
								if($row->basement_foundation != "")
								{
									?>
									<li>
										<strong><?php echo Text::_('OS_BASEMENT_FOUNDATION');?></strong>
										<span><?php echo $row->basement_foundation; ?></span>
									</li>
									<?php
								}
								if($row->basement_size > 0)
								{
									?>
									<li>
										<strong><?php echo Text::_('OS_BASEMENT_SIZE');?></strong>
										<span><?php echo $row->basement_size; ?></span>
									</li>
									<?php
								}
								if($row->percent_finished != "")
								{
									?>
									<li>
										<strong><?php echo Text::_('OS_PERCENT_FINISH');?></strong>
										<span><?php echo $row->percent_finished; ?></span>
									</li>
									<?php
								}
							}
							if($configClass['use_squarefeet'] == 1 && ($row->subdivision != '' || $row->land_holding_type != '' || $row->lot_dimensions != '' || $row->frontpage != '' || $row->frontpage != '' || $row->living_areas > 0 || $row->lot_size > 0 || $row->total_acres > 0))
							{
								$textFieldsArr = array('subdivision','land_holding_type','lot_dimensions','frontpage','depth');
								$numberFieldArr = array('total_acres','lot_size','living_areas');
								$show = 0;
								foreach($textFieldsArr as $textfield){
									if($row->{$textfield} != ""){
										$show = 1;
									}
								}
								foreach($numberFieldArr as $numfield){
									if($row->{$numfield}  > 0){
										$show = 1;
									}
								}
								if($show == 1) {
									foreach($textFieldsArr as $textfield)
									{
										if($row->{$textfield} != "")
										{
											?>
											<li>
												<strong><?php echo Text::_('OS_'.strtoupper($textfield));?></strong>
												<span><?php echo $row->{$textfield}; ?></span>
											</li>
											<?php
										}
									}
									foreach($numberFieldArr as $numfield)
									{
										if($row->{$numfield}  > 0)
										{
											?>
											<li>
												<strong><?php echo Text::_('OS_'.strtoupper($numfield));?></strong>
												<span><?php echo OSPHelper::showBath($row->{$numfield}); 
												switch($numfield)
												{
													case "square_feet":
													case "lot_size":
														echo " ".OSPHelper::showSquareSymbol();
														break;
													default:
														echo " ".OSPHelper::showAcresSymbol();
														break;
												}
												?></span>
											</li>
											<?php
										}
									}
								}
							}

							if($configClass['use_business'] == 1)
							{
								$textFieldsArr = array('takings','returns','net_profit','business_type','stock','fixtures','fittings','percent_office','percent_warehouse','loading_facilities');
								$show = 0;
								foreach($textFieldsArr as $textfield){
									if($row->{$textfield} != ""){
										$show = 1;
									}
								}

								if($show == 1) {
									foreach($textFieldsArr as $textfield)
									{
										if($row->{$textfield} != "")
										{
											?>
											<li>
												<strong><?php echo Text::_('OS_'.strtoupper($textfield));?></strong>
												<span><?php echo $row->{$textfield}; ?></span>
											</li>
											<?php
										}
									}
								}
							}
							if($configClass['use_rural'] == 1){
								$textFieldsArr = array('fencing','rainfall','soil_type','grazing','cropping','irrigation','water_resources','carrying_capacity','storage');
								$show = 0;
								foreach($textFieldsArr as $textfield){
									if($row->{$textfield} != ""){
										$show = 1;
									}
								}

								if($show == 1) {
									foreach($textFieldsArr as $textfield)
									{
										if($row->{$textfield} != "")
										{
											?>
											<li>
												<strong><?php echo Text::_('OS_'.strtoupper($textfield));?></strong>
												<span><?php echo $row->{$textfield}; ?></span>
											</li>
											<?php
										}
									}
								}
							}
							?>
						</ul>
					</div>
				</div>
			</div>
			<?php
			}
			if($configClass['energy'] == 1 && ($row->energy > 0 || $row->climate > 0 || $row->e_class != "" || $row->c_class != ""))
			{
			?>
				<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> descriptionTop">
					<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?> description">
						<h3><?php echo Text::_('OS_ENERGY_CLASS')?></h3>
						<div class="entry-content">
							<?php
							echo HelperOspropertyCommon::drawGraph($row->energy, $row->climate,$row->e_class,$row->c_class);
							?>
						</div>
					</div>
				</div>
			<?php
			}
		if($configClass['show_amenity_group'] == 1)
		{
			?>
			<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> amenities">
				<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
					<h3><?php echo Text::_('OS_AMENITIES')?></h3>
					<div class="entry-content">
						<ul class="list-3-cols list-unstyled">
							<?php
							$optionArr = [];
							$optionArr[] = Text::_('OS_GENERAL_AMENITIES');
							$optionArr[] = Text::_('OS_ACCESSIBILITY_AMENITIES');
							$optionArr[] = Text::_('OS_APPLIANCE_AMENITIES');
							$optionArr[] = Text::_('OS_COMMUNITY_AMENITIES');
							$optionArr[] = Text::_('OS_ENERGY_SAVINGS_AMENITIES');
							$optionArr[] = Text::_('OS_EXTERIOR_AMENITIES');
							$optionArr[] = Text::_('OS_INTERIOR_AMENITIES');
							$optionArr[] = Text::_('OS_LANDSCAPE_AMENITIES');
							$optionArr[] = Text::_('OS_SECURITY_AMENITIES');
							$l = 0;
							
							foreach ($optionArr as $amen_cat)
							{
								$query = "Select a.* from #__osrs_amenities as a"
									." inner join #__osrs_property_amenities as b on b.amen_id = a.id"
									." where a.published = '1' and b.pro_id = '$row->id' and a.category_id = '$l' order by a.ordering";
								$db->setQuery($query);
								$amens = $db->loadObjectList();
								$amens_str1 = "";
								if(count($amens) > 0)
								{
									$amens_str = "";
									$j = 0;
									$k = 0;
									if($configClass['amenities_layout'] == 1)
									{
										$span = $bootstrapHelper->getClassMapping('span6'); //"span6";
										$jump = 2;
									}
									else
									{
										$span = $bootstrapHelper->getClassMapping('span4');
										$jump = 3;
									}
									
									for($i=0;$i<count($amens);$i++)
									{
										$k++;
										$amen = $amens[$i];
										?>
										<li>
											<?php
											if($amen->icon != "")
											{
												?>
												<i class="<?php echo $amen->icon;?>"></i>&nbsp;
												<?php
											}
											else
											{
												?>
												<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check2" viewBox="0 0 16 16">
			  <path d="M13.854 3.646a.5.5 0 0 1 0 .708l-7 7a.5.5 0 0 1-.708 0l-3.5-3.5a.5.5 0 1 1 .708-.708L6.5 10.293l6.646-6.647a.5.5 0 0 1 .708 0z"/>
			</svg>
												<?php
											}
											echo OSPHelper::getLanguageFieldValue($amen,'amenities');
										?>
										</li>
										<?php
									}
								}
								$l++;
							}
							?>
						</ul>
					</div>
				</div>
			</div>
			<?php
		}

		$query = "Select a.*,b.neighborhood from #__osrs_neighborhood as a"
				." inner join #__osrs_neighborhoodname as b on b.id = a.neighbor_id"
				." where a.pid = '$row->id'";
		$db->setQuery($query);
		$neighbors = $db->loadObjectList();
		if($configClass['show_neighborhood_group'] == 1 && count($neighbors) > 0)
		{
			?>
			<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> neighbor">
				<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
					<h3><?php echo Text::_('OS_NEIGHBORHOOD')?></h3>
					<div class="entry-content">
						<ul class="list-2-cols list-unstyled">
							<?php
							foreach($neighbors as $item)
							{
								
								?>
								<li><strong><?php echo Text::_($item->neighborhood)?></strong>
								<span>
								<?php 
								if($item->distance > 0)
								{
									echo OSPHelper::showBath((float)$item->distance). ' km';
								}
								else
								{
									echo $item->mins > 0 ?$item->mins. " ".Text::_('OS_MINS')." " : " ";?> <?php echo Text::_('OS_BY')?> &nbsp;
									<?php
									switch ($item->traffic_type){
										case "1":
											echo Text::_('OS_WALK');
										break;
										case "2":
											echo Text::_('OS_CAR');
										break;
										case "3":
											echo Text::_('OS_TRAIN');
										break;
									}
								}
								?>
								</span></li>
							<?php
							}
							?>
						</ul>
					</div>
				</div>
			</div>
			<?php
		}

		
		if($module_ids != "")
		{
			?>
				</div>
				<div class="<?php echo $bootstrapHelper->getClassMapping('span4');?>">
                    <?php
                    $document = Factory::getDocument();
                    $renderer = $document->loadRenderer('module');
					$moduleArr = explode(",", $module_ids);

					foreach($moduleArr as $module)
					{
						$db->setQuery("Select title from #__modules where id = '$module' and showtitle = '1'");
						$module_title = $db->loadResult();
                    ?>
						<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid');?>">
							<div class="<?php echo $bootstrapHelper->getClassMapping('span12');?>">
								<h3 class="module_title"><?php echo $module_title;?></h3>
								<?php
								$moduleContent->text = "{loadmoduleid ".$module."}";
								$moduleContent->text = HTMLHelper::_('content.prepare', $moduleContent->text);
								echo $moduleContent->text;
								?>
							</div>
						</div>
						<?php
					}
                    ?>
                </div>
			</div>
			<?php
		}
		?>
		<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> media">
			<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
				<div id="shellvideo">
					<h3 id="shellvideoh3">
						<?php echo Text::_('OS_MEDIA')?>
					</h3>
					<div class="entry-content">
						<ul class="list-2-cols list-unstyled">
							<?php
							if($row->pro_pdf != "")
							{
								?>
								<li>
									<a href="<?php echo $row->pro_pdf?>" title="<?php echo Text::_('OS_OPEN_PROPERTY_DOCUMENT')?>" alt="<?php echo Text::_('OS_OPEN_PROPERTY_DOCUMENT')?>" target="_blank">
										<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-text" viewBox="0 0 16 16">
  <path d="M5.5 7a.5.5 0 0 0 0 1h5a.5.5 0 0 0 0-1zM5 9.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5m0 2a.5.5 0 0 1 .5-.5h2a.5.5 0 0 1 0 1h-2a.5.5 0 0 1-.5-.5"/>
  <path d="M9.5 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.5zm0 1v2A1.5 1.5 0 0 0 11 4.5h2V14a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1z"/>
</svg> <?php echo Text::_('OS_OPEN_PROPERTY_DOCUMENT'); ?>
									</a>
								</li>
								<?php
							}

							for($f = 0; $f < 10 ; $f++)
							{
								if($f == 0)
								{
									$fname = "";
								}
								else
								{
									$fname = $f;
								}
								$name = "pro_pdf_file".$fname;
								if($row->{$name} != "")
								{
								?>
									<li>
										<?php
										if(file_exists(JPATH_ROOT.'/media/com_osproperty/document/'.$row->{$name}))
										{
											$fileUrl = Uri::root().'media/com_osproperty/document/'.$row->{$name};
										}
										else
										{
											$fileUrl = Uri::root().'components/com_osproperty/document/'.$row->{$name};
										}
										?>
										<a href="<?php echo $fileUrl ;?>" title="<?php echo Text::_('OS_DOWNLOAD_PROPERTY_DOCUMENT')?> <?php echo $fname; ?>" alt="<?php echo Text::_('OS_DOWNLOAD_PROPERTY_DOCUMENT')?> <?php echo $fname; ?>" target="_blank">
											<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-pdf" viewBox="0 0 16 16">
  <path d="M14 14V4.5L9.5 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2M9.5 3A1.5 1.5 0 0 0 11 4.5h2V14a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h5.5z"/>
  <path d="M4.603 14.087a.8.8 0 0 1-.438-.42c-.195-.388-.13-.776.08-1.102.198-.307.526-.568.897-.787a7.7 7.7 0 0 1 1.482-.645 20 20 0 0 0 1.062-2.227 7.3 7.3 0 0 1-.43-1.295c-.086-.4-.119-.796-.046-1.136.075-.354.274-.672.65-.823.192-.077.4-.12.602-.077a.7.7 0 0 1 .477.365c.088.164.12.356.127.538.007.188-.012.396-.047.614-.084.51-.27 1.134-.52 1.794a11 11 0 0 0 .98 1.686 5.8 5.8 0 0 1 1.334.05c.364.066.734.195.96.465.12.144.193.32.2.518.007.192-.047.382-.138.563a1.04 1.04 0 0 1-.354.416.86.86 0 0 1-.51.138c-.331-.014-.654-.196-.933-.417a5.7 5.7 0 0 1-.911-.95 11.7 11.7 0 0 0-1.997.406 11.3 11.3 0 0 1-1.02 1.51c-.292.35-.609.656-.927.787a.8.8 0 0 1-.58.029m1.379-1.901q-.25.115-.459.238c-.328.194-.541.383-.647.547-.094.145-.096.25-.04.361q.016.032.026.044l.035-.012c.137-.056.355-.235.635-.572a8 8 0 0 0 .45-.606m1.64-1.33a13 13 0 0 1 1.01-.193 12 12 0 0 1-.51-.858 21 21 0 0 1-.5 1.05zm2.446.45q.226.245.435.41c.24.19.407.253.498.256a.1.1 0 0 0 .07-.015.3.3 0 0 0 .094-.125.44.44 0 0 0 .059-.2.1.1 0 0 0-.026-.063c-.052-.062-.2-.152-.518-.209a4 4 0 0 0-.612-.053zM8.078 7.8a7 7 0 0 0 .2-.828q.046-.282.038-.465a.6.6 0 0 0-.032-.198.5.5 0 0 0-.145.04c-.087.035-.158.106-.196.283-.04.192-.03.469.046.822q.036.167.09.346z"/>
</svg> <?php echo Text::_('OS_DOWNLOAD_PROPERTY_DOCUMENT'); ?> <?php echo $fname; ?>
										</a>
									</li>
									<?php
								}
							}
							if($configClass['property_pdf_layout'] == 1)
							{
								?>
								<li>
									<a href="<?php echo Uri::root()?>index.php?option=com_osproperty&no_html=1&task=property_pdf&id=<?php echo $row->id?>" title="<?php echo Text::_('OS_EXPORT_PDF')?>"  rel="nofollow" target="_blank">
										<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-box-arrow-down" viewBox="0 0 16 16">
  <path fill-rule="evenodd" d="M3.5 10a.5.5 0 0 1-.5-.5v-8a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 .5.5v8a.5.5 0 0 1-.5.5h-2a.5.5 0 0 0 0 1h2A1.5 1.5 0 0 0 14 9.5v-8A1.5 1.5 0 0 0 12.5 0h-9A1.5 1.5 0 0 0 2 1.5v8A1.5 1.5 0 0 0 3.5 11h2a.5.5 0 0 0 0-1z"/>
  <path fill-rule="evenodd" d="M7.646 15.854a.5.5 0 0 0 .708 0l3-3a.5.5 0 0 0-.708-.708L8.5 14.293V5.5a.5.5 0 0 0-1 0v8.793l-2.146-2.147a.5.5 0 0 0-.708.708z"/>
</svg> 
										<?php echo Text::_('OS_EXPORT_PDF');?>
									</a>
								</li>
								<?php
							}
							?>
						</ul>
					</div>
				</div>
			</div>
		</div>
		<?php
		if($row->pro_video != "")
		{
			?>
			<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> video">
				<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
					<div id="shellvideo">
						<h3 id="shellvideo3">
							<?php echo Text::_('OS_VIDEO')?>
						</h3>
						<?php
						if (stripos(strtolower($row->pro_video), "watch") !== false) 
						{
							$row->pro_video = OSPHelper::convertToEmbedLink($row->pro_video);
						}
						if (stripos(strtolower($row->pro_video), "iframe") === false) {
							?>
							<iframe src="<?php echo $row->pro_video; ?>" allowfullscreen="allowfullscreen" frameborder="0" height="480" width="100%"></iframe>
							<?php
						}
						else
						{
							echo $row->pro_video;
						}
						?>
					</div>
					
				</div>
			</div>
			
			<?php
		}

		if($row->tour_link != "")
		{
			?>
			<div id="shellheading" style="width:1px; height:1px;"></div>
			<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> virtual_tour">
				<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
					<div id="shelltour">
						<h3 id="shelltourh3">
							<?php echo Text::_('OS_VIRTUAL_TOUR')?>
						</h3>
						<?php
						if (stripos(strtolower($row->tour_link), "iframe") === false) {
		
							?>
							<iframe src="<?php echo $row->tour_link; ?>" allowfullscreen="allowfullscreen" frameborder="0" height="480" width="100%"></iframe>
							<?php
						}
						else
						{
							echo $row->tour_link;
						}
						?>
					</div>
				</div>
			</div>
			<?php
		}
		?>
		<!-- end des -->
		<?php
		if(($configClass['show_walkscore'] == 1) && ($configClass['ws_id'] != "")){
			?>
			<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
				<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
					<div id="shellwalkscore">
						<h2>
							<i class="edicon edicon-map"></i>&nbsp;<?php echo Text::_('OS_WALK_SCORE')?>
						</h2>
						<?php
						echo $row->ws;
						?>
					</div>
				</div>
			</div>
			<?php
		}
		?>
		
		<?php
		if($configClass['comment_active_comment'] == 1){
			?>
			<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> comment">
				<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?> noleftmargin">
					<div id="shellcomments">
						<h3>
							<?php echo Text::_('OS_COMMENTS')?>
						</h3>
						<?php
						echo $row->comments;
						if(($owner == 0) && ($can_add_cmt == 1)){
							HelperOspropertyCommon::reviewForm($row,$itemid,$configClass);
						}
						?>
					</div>
				</div>
			</div>
			<?php
		}
		?>
		<?php
		if($configClass['use_property_history'] == 1 && ($row->price_history != "" || $row->tax != ""))
		{
			?>
			<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> history">
				<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
					<div id="shellhistorytax">
						<h3>
							<?php echo Text::_('OS_HISTORY_TAX')?>
						</h3>
						<?php
						if($row->price_history != ""){
							echo $row->price_history;
							echo "<BR />";
						}
						if($row->tax != ""){
							echo $row->tax;
						}
						?>
					</div>
				</div>
			</div>
			<?php
		}
		?>
		<?php
		if($configClass['property_mail_to_friends'] == 1)
		{
		?>
		<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> tellfrendform" id="shellsharing">
			<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?> tellfrendformsub">
				<h3>
					<?php echo Text::_('OS_TELL_A_FRIEND')?>
				</h3>
				<?php HelperOspropertyCommon::sharingForm($row,$itemid); ?>
			</div>
		</div>
		<?php } ?>
		<?php
			if(file_exists(JPATH_ROOT."/components/com_oscalendar/oscalendar.php")){
				if(($configClass['integrate_oscalendar'] == 1) && (in_array($row->pro_type,explode("|",$configClass['show_date_search_in'])))){
					?>
					<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
						<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
							<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> availabilityform" id="availform">
								<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?> availabilityformsub">
									<h3>
										<?php echo Text::_('OS_AVAILABILITY')?>
									</h3>
									<?php
									require_once(JPATH_ROOT."/components/com_oscalendar/classes/default.php");
									require_once(JPATH_ROOT."/components/com_oscalendar/classes/default.html.php");
									$otherlanguage =& Factory::getLanguage();
									$otherlanguage->load( 'com_oscalendar', JPATH_SITE );
									OsCalendarDefault::calendarForm($row->id);
									?>
								</div>
							</div>
						</div>
					</div>
					<?php
				}
			}
		?>
		<?php
		if($configClass['show_agent_details'] == 1 || $configClass['show_request_more_details'] == 1)
		{
			?>
			<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> contactagent">
				<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
					<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> agentsharingform" id="agentsharing">
						<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?> agentsharingformsub">
							<?php
							if($configClass['show_agent_details'] == 1){
								$link = Route::_("index.php?option=com_osproperty&task=agent_info&id=".$row->agent_id."&Itemid=".OSPRoute::getAgentItemid());
								if($row->agentdetails->agent_type == 0){
									$title = Text::_('OS_AGENT_INFO');
								}else{
									$title = Text::_('OS_OWNER_INFO');
								}
							?>
							<h3>
								<a href="<?php echo $link;?>" title="<?php echo $title;?>">
									<?php echo $row->agent_name;?>
								</a>
							</h3>
							<?php 
							}
							if(($configClass['show_agent_details'] == 1) && ($configClass['show_request_more_details'] == 1)){
								$span1 = $bootstrapHelper->getClassMapping('span4');//"span4";
								$span2 = "";
								$span3 = $bootstrapHelper->getClassMapping('span8');//"span8";
							}elseif(($configClass['show_agent_details'] == 1) && ($configClass['show_request_more_details'] == 0)){
								$span1 = $bootstrapHelper->getClassMapping('span4');
								$span2 = $bootstrapHelper->getClassMapping('span8');
								$span3 = "";
							}elseif(($configClass['show_agent_details'] == 0) && ($configClass['show_request_more_details'] == 1)){
								$span1 = "";
								$span2 = "";
								$span3 = $bootstrapHelper->getClassMapping('span12');
							}
							?>
							<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
								<?php
								if($configClass['show_agent_details'] == 1){
								?>
								<div class="<?php echo $span1;?>">
									<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
										<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
											<?php
											if($configClass['show_agent_image'] == 1){
												$agent_photo = $row->agentdetails->photo;
												if(($agent_photo != "") && (file_exists(JPATH_ROOT.'/images/osproperty/agent/'.$agent_photo))){
													?>
													<img src="<?php echo Uri::root(true)?>/images/osproperty/agent/<?php echo $agent_photo; ?>" class="agentphoto"/>
													<?php
												}else{
													?>
													<img src="<?php echo Uri::root(true)?>/media/com_osproperty/assets/images/user.jpg" class="agentphoto"/>
													<?php
												}
											}
											?>
										</div>
									</div>
									<?php
									if($configClass['show_request_more_details'] == 1){
									?>
										<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
											<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
												<ul class="marB0 agentbasicinformation divbottom">
													<?php if(($row->agentdetails->phone != "") && ($configClass['show_agent_phone'] == 1)){?>
													<li class="marT3 marB0">
														<span class="left">
															<i class="edicon edicon-phone-hang-up"></i>
														</span>
														<span class="alignright"><?php echo $row->agentdetails->phone;?></span>
													</li>
													<?php } 
													if(($row->agentdetails->mobile != "") && ($configClass['show_agent_mobile'] == 1)){
													?>
													<li class="marT3 marB0">
														<span class="left">
															<i class="edicon edicon-mobile"></i>
														</span>
														<span class="alignright"><?php echo $row->agentdetails->mobile;?></span>
													</li>
													<?php } 
													if(($row->agentdetails->fax != "") && ($configClass['show_agent_fax'] == 1)){
													?>
													<li class="marT3 marB0">
														<span class="left">
															<i class="edicon edicon-printer"></i>
														</span>
														<span class="alignright"><?php echo $row->agentdetails->fax;?></span>
													</li>
													<?php }
													if(($row->agentdetails->email != "") && ($configClass['show_agent_email'] == 1)){
													?>
													<li class="marT3 marB0">
														<span class="left">
															<i class="osicon-mail"></i>
														</span>
														<span class="alignright"><a href="mailto:<?php echo $row->agentdetails->email;?>" target="_blank"><?php echo $row->agentdetails->email;?></a></span>
													</li>
													<?php }
													if(($row->agentdetails->skype != "") && ($configClass['show_agent_skype'] == 1)){
													?>
													<li class="marT3 marB0">
														<span class="left">
															<i class="edicon edicon-skype"></i>
														</span>
														<span class="alignright"><?php echo $row->agentdetails->skype;?></span>
													</li>
													<?php }
													if(($row->agentdetails->msn != "") && ($configClass['show_agent_msn'] == 1)){
													?>
													<li class="marT3 marB0">
														<span class="left">
															<i class="edicon edicon-bubble2"></i>
														</span>
														<span class="alignright"><?php echo $row->agentdetails->msn;?></span>
													</li>
													<?php }
													?>
												</ul>
											</div>
										</div>		
										<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> divbottom">
											<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
												<ul class="social marT15 marL0">
													<?php
													if(($row->agentdetails->facebook != "") && ($configClass['show_agent_facebook'] == 1)){
													?>
													<li class="facebook">
														<a href="<?php echo $row->agentdetails->facebook; ?>" target="_blank">
															<i class="edicon edicon-facebook"></i>
														</a>
													</li>
													<?php }
													if(($row->agentdetails->aim != "") && ($configClass['show_agent_twitter'] == 1)){
													?>
													<li class="twitter">
														<a href="<?php echo $row->agentdetails->aim; ?>" target="_blank">
															<i class="edicon edicon-twitter"></i>
														</a>
													</li>
													<?php }
													if(($row->agentdetails->yahoo != "") && ($configClass['show_agent_linkin'] == 1)){
													?>
													<li class="linkin">
														<a href="<?php echo $row->agentdetails->yahoo; ?>" target="_blank">
															<i class="edicon edicon-linkedin2"></i>
														</a>
													</li>
													<?php }
													if(($row->agentdetails->gtalk != "") && ($configClass['show_agent_gplus'] == 1)){
													?>
													<li class="gplus">
														<a href="<?php echo $row->agentdetails->gtalk; ?>" target="_blank">
															<i class="edicon edicon-google-plus"></i>
														</a>
													</li>
													<?php }
													?>
												</ul>
											</div>
										</div>
									<?php } ?>
								</div>
								<?php
								}
								if($configClass['show_request_more_details'] == 0){
								?>
								<div class="<?php echo $span2;?>">
                                    <div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
                                        <div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
                                            <ul class="marB0 agentbasicinformation">
                                                <?php if(($row->agentdetails->phone != "") && ($configClass['show_agent_phone'] == 1)){?>
                                                <li class="marT3 marB0">
                                                    <span class="left">
                                                        <i class="edicon edicon-phone-hang-up"></i>
                                                    </span>
                                                    <span class="right"><?php echo $row->agentdetails->phone;?></span>
                                                </li>
                                                <?php }
                                                if(($row->agentdetails->mobile != "") && ($configClass['show_agent_mobile'] == 1)){
                                                ?>
                                                <li class="marT3 marB0">
                                                    <span class="left">
                                                        <i class="edicon edicon-mobile"></i>
                                                    </span>
                                                    <span class="right"><?php echo $row->agentdetails->mobile;?></span>
                                                </li>
                                                <?php }
                                                if(($row->agentdetails->fax != "") && ($configClass['show_agent_fax'] == 1)){
                                                ?>
                                                <li class="marT3 marB0">
                                                    <span class="left">
                                                        <i class="edicon edicon-printer"></i>
                                                    </span>
                                                    <span class="right"><?php echo $row->agentdetails->fax;?></span>
                                                </li>
                                                <?php }
                                                if(($row->agentdetails->email != "") && ($configClass['show_agent_email'] == 1)){
                                                ?>
                                                <li class="marT3 marB0">
                                                    <span class="left">
                                                        <i class="osicon-mail"></i>
                                                    </span>
                                                    <span class="right"><a href="mailto:<?php echo $row->agentdetails->email;?>" target="_blank"><?php echo $row->agentdetails->email;?></a></span>
                                                </li>
                                                <?php }
                                                if(($row->agentdetails->skype != "") && ($configClass['show_agent_skype'] == 1)){
                                                ?>
                                                <li class="marT3 marB0">
                                                    <span class="left">
                                                        <i class="edicon edicon-skype"></i>
                                                    </span>
                                                    <span class="right"><?php echo $row->agentdetails->skype;?></span>
                                                </li>
                                                <?php }
                                                if(($row->agentdetails->msn != "") && ($configClass['show_agent_msn'] == 1)){
                                                ?>
                                                <li class="marT3 marB0">
                                                    <span class="left">
                                                        <i class="edicon edicon-bubble2"></i>
                                                    </span>
                                                    <span class="right"><?php echo $row->agentdetails->msn;?></span>
                                                </li>
                                                <?php }
                                                ?>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> divbottom">
                                        <div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
                                            <ul class="social marT15 marL0">
                                                <?php
                                                if(($row->agentdetails->facebook != "") && ($configClass['show_agent_facebook'] == 1)){
                                                ?>
                                                <li class="facebook">
                                                    <a href="<?php echo $row->agentdetails->facebook; ?>" target="_blank">
                                                        <i class="edicon edicon-facebook"></i>
                                                    </a>
                                                </li>
                                                <?php }
                                                if(($row->agentdetails->aim != "") && ($configClass['show_agent_twitter'] == 1)){
                                                ?>
                                                <li class="twitter">
                                                    <a href="<?php echo $row->agentdetails->aim; ?>" target="_blank">
                                                        <i class="edicon edicon-twitter"></i>
                                                    </a>
                                                </li>
                                                <?php }
                                                if(($row->agentdetails->yahoo != "") && ($configClass['show_agent_linkin'] == 1)){
                                                ?>
                                                <li class="linkin">
                                                    <a href="<?php echo $row->agentdetails->yahoo; ?>" target="_blank">
                                                        <i class="edicon edicon-linkedin2"></i>
                                                    </a>
                                                </li>
                                                <?php }
                                                if(($row->agentdetails->gtalk != "") && ($configClass['show_agent_gplus'] == 1)){
                                                ?>
                                                <li class="gplus">
                                                    <a href="<?php echo $row->agentdetails->gtalk; ?>" target="_blank">
                                                        <i class="edicon edicon-google-plus"></i>
                                                    </a>
                                                </li>
                                                <?php }
                                                ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
								<?php } ?>
								<?php
								if($configClass['show_request_more_details'] == 1){
								?>
								<div class="<?php echo $span3;?> requestmoredetails">
									<h3>
										<?php echo Text::_('OS_REQUEST_MORE_INFOR');?>
									</h3>
									<?php echo HelperOspropertyCommon::requestMoreDetails($row,$itemid); ?>
								</div>
								<?php } ?>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
		?>
		<?php
		if($configClass['relate_properties'] == 1 && $row->relate != "")
		{
		?>
			
			<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?> related_properties">
				<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
					<div class="shellrelatedproperties">
						<h3><?php echo Text::_('OS_RELATE_PROPERTY')?></h3>
						<?php
						echo $row->relate;
						?>
					</div>
				</div>
			</div>
		<?php
		}
		?>
		<?php
		if($integrateJComments == 1){
		?>
			<div class="detailsBar clearfix">
				<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
					<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?>">
						<div class="shell">
							<fieldset><legend><span><?php echo Text::_('OS_JCOMMENTS')?></span></legend></fieldset>
							<?php
							$comments = JPATH_SITE . DS .'components/com_jcomments/jcomments.php';
							if (file_exists($comments)) {
								require_once($comments);
								echo JComments::showComments($row->id, 'com_osproperty', $row->pro_name);
							}
							?>
						</div>
					</div>
				</div>
			</div>
		<?php
		}
		?>
		<?php
		if(count($bottomPlugin) > 0){
			for($i=0;$i<count($bottomPlugin);$i++){
				echo $bottomPlugin[$i];
			}
		}
		?>
		<!-- end tabs bottom -->
		
			</div>
			<!-- Right hand side -->
            <div class="<?php echo $bootstrapHelper->getClassMapping('span4'); ?>" style="position: relative;" id="sidebar">
				<div id="fixed-nav-sticky" class="nav-menu-stick"><nav>
					<?php
					if($configClass['show_agent_details'] == 1) 
					{
						?>
						<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?> agentinformation">
							<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
								<div class="<?php echo $bootstrapHelper->getClassMapping('span4'); ?>">
									<?php
									if(($configClass['show_agent_image'] == 1) && ($row->agentdetails->photo != "") && file_exists(JPATH_ROOT.'/images/osproperty/agent/thumbnail/'.$row->agentdetails->photo))
									{
										$link = Route::_("index.php?option=com_osproperty&task=agent_info&id=".$row->agent_id."&Itemid=".OSPRoute::getAgentItemid($row->agent_id));
										?>
										<a href="<?php echo $link; ?>">
											<img class="img img-polaroid" src="<?php echo Uri::root()."images/osproperty/agent/thumbnail/".$row->agentdetails->photo ?>" alt="<?php echo $row->agentdetails->name;?>" />
										</a>
										<?php
									}
									?>
								</div>
								<div class="<?php echo $bootstrapHelper->getClassMapping('span8'); ?>">
									<div class="agentName">
										<?php
										$link = Route::_("index.php?option=com_osproperty&task=agent_info&id=".$row->agent_id."&Itemid=".OSPRoute::getAgentItemid());
										?>
										<a href="<?php echo $link;?>" title="<?php echo $row->agentdetails->name;?>">
											<?php echo $row->agentdetails->name;?>
										</a>
									</div>

									<?php
									if(($row->agentdetails->phone != "") && ($configClass['show_agent_phone'] == 1))
									{
									?>
									<div class="headerphone">
										<i class="edicon edicon-phone"></i>
										<span id="phone_number">
											<?php
											echo Text::_('OS_PHONE');
											?>
										</span>
									</div>
									<?php
									}
									?>
									<script type="text/javascript">
										jQuery(".headerphone").click(function(){
											jQuery("#phone_number").text('<?php echo $row->agentdetails->phone;?>');
										});
									</script>
								</div>
							</div>
						</div>
						<?php
					}
					?>
					<div class="<?php echo $bootstrapHelper->getClassMapping('row-fluid'); ?>">
						<div class="<?php echo $bootstrapHelper->getClassMapping('span12'); ?> requestmoredetails">
							<?php echo HelperOspropertyCommon::requestMoreDetailsTop($row,$itemid); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<!-- end wrap content -->
<input type="hidden" name="process_element" id="process_element" value="" />
<script type="text/javascript">
var width = jQuery(".propertyinfoli").width();
jQuery(".pictureslideshow").attr("width",width);


var stickySidebar = new StickySidebar('#sidebar', {

	topSpacing: 60,

	bottomSpacing: 60,

	containerSelector: '#propertydetails',

	innerWrapperSelector: '.nav-menu-stick'

});


function scrollToDiv(divId) {
  // Scroll to the target div with smooth behavior
  document.getElementById(divId).scrollIntoView({
	behavior: "smooth",
	block: "start"  // Aligns the target div to the top of the viewport
  });

  if(divId == "shellheading")
  {
	  setTimeout(function() {
			// Sau khi cuộn xong, điều chỉnh màn hình lên thêm 40px
			window.scrollBy(0, -40);  // Điều chỉnh thêm 40px lên trên
		}, 400);
  }
}

</script>

