<?php
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
?>
<!DOCTYPE html>
<html>
<head>
<style>
@page {
    margin: 0;
}

* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Arial', sans-serif;
    color: #333;
}

/* Hero Section */
.hero {
    position: relative;
    height: 400px;
    background-size: cover;
    background-position: center;
}

.hero-overlay {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    background: linear-gradient(to top, rgba(0,0,0,0.8) 0%, transparent 100%);
    padding: 40px 30px 30px;
    color: white;
}

.property-ref {
    font-size: 11px;
    font-weight: 600;
    letter-spacing: 2px;
    text-transform: uppercase;
    margin-bottom: 8px;
    opacity: 0.9;
}

.property-title {
    font-size: 32px;
    font-weight: 700;
    margin-bottom: 12px;
    line-height: 1.2;
}

.property-address {
    font-size: 14px;
    margin-bottom: 15px;
    opacity: 0.95;
}

.property-meta {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.property-type {
    font-size: 12px;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.property-price {
    font-size: 36px;
    font-weight: 700;
}

/* Key Features Bar */
.features-bar {
    background: white;
    box-shadow: 0 2px 15px rgba(0,0,0,0.1);
    margin: -25px 25px 0;
    position: relative;
    z-index: 10;
    border-radius: 6px;
    padding: 20px;
}

.features-table {
    width: 100%;
    border-collapse: collapse;
}

.features-table td {
    width: 25%;
    text-align: center;
    padding: 10px;
    border-right: 1px solid #e8e8e8;
    vertical-align: top;
}

.features-table td:last-child {
    border-right: none;
}

.feature-value {
    font-size: 36px;
    font-weight: 700;
    color: #2c3e50;
    display: block;
    margin-bottom: 5px;
}

.feature-label {
    font-size: 10px;
    color: #95a5a6;
    text-transform: uppercase;
    font-weight: 600;
    letter-spacing: 1px;
}

/* Content Section */
.content {
    padding: 40px 30px;
}

.section-title {
    font-size: 20px;
    font-weight: 700;
    color: #2c3e50;
    margin-bottom: 15px;
    padding-bottom: 10px;
    border-bottom: 3px solid #3498db;
}

.description {
    font-size: 11px;
    line-height: 1.8;
    color: #555;
    margin-bottom: 30px;
}

.description strong {
    display: block;
    font-size: 13px;
    color: #2c3e50;
    margin-bottom: 10px;
}

/* Two Column Layout */
.two-columns {
    display: flex;
    gap: 30px;
}

.main-column {
    flex: 2;
}

.side-column {
    flex: 1;
}

/* Info Cards */
.info-card {
    background: #f8f9fa;
    border-radius: 8px;
    margin-bottom: 20px;
    overflow: hidden;
    border: 1px solid #e0e0e0;
}

.info-card-header {
    background: #2c3e50;
    color: white;
    padding: 12px 15px;
    font-size: 13px;
    font-weight: 600;
    text-transform: uppercase;
}

.info-card-body {
    padding: 15px;
}

.info-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 12px;
    font-size: 10px;
}

.info-item {
    padding: 10px;
    background: white;
    border-radius: 5px;
}

.info-item-label {
    color: #7f8c8d;
    font-size: 9px;
    text-transform: uppercase;
    margin-bottom: 4px;
}

.info-item-value {
    color: #2c3e50;
    font-weight: 700;
    font-size: 11px;
}

/* Amenities */
.amenities-list {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 8px;
    font-size: 10px;
}

.amenity-item {
    padding: 8px;
    background: white;
    border-radius: 4px;
    border-left: 3px solid #27ae60;
}

/* Photo Gallery */
.photo-gallery {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 10px;
    margin-bottom: 30px;
}

.photo-gallery img {
    width: 100%;
    height: 150px;
    object-fit: cover;
    border-radius: 8px;
}

/* Agent Footer */
.agent-footer {
    background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
    padding: 30px;
    margin-top: 40px;
    display: flex;
    align-items: center;
    gap: 20px;
}

.agent-photo {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    border: 4px solid white;
    object-fit: cover;
}

.agent-info {
    flex: 1;
    color: white;
}

.agent-name {
    font-size: 20px;
    font-weight: 700;
    margin-bottom: 8px;
}

.agent-contact {
    font-size: 11px;
    margin: 4px 0;
    opacity: 0.9;
}

.agent-cta {
    background: white;
    color: #2c3e50;
    padding: 12px 25px;
    border-radius: 25px;
    font-size: 12px;
    font-weight: 700;
    text-transform: uppercase;
}
</style>
</head>
<body>

<!-- Hero Section with Main Image -->
<?php if(count($row->photo) > 0){ ?>
<div class="hero" style="background-image: url('<?php echo Uri::root()?>images/osproperty/properties/<?php echo $row->id;?>/<?php echo $row->photo[0]->image?>');">
    <div class="hero-overlay">
        <?php if(($row->ref != "") && ($configClass['show_ref'] == 1)){ ?>
        <div class="property-ref">#<?php echo $row->ref; ?></div>
        <?php } ?>
        
        <div class="property-title"><?php echo strtoupper(OSPHelper::getLanguageFieldValue($row,'pro_name'));?></div>
        
        <?php if($row->show_address == 1){ ?>
        <div class="property-address">📍 <?php echo OSPHelper::generateAddress($row);?></div>
        <?php } ?>
        
        <div class="property-meta">
            <div class="property-type">
                <?php echo $lists['type']; ?>
                <?php if(($configClass['active_market_status'] == 1) && ($row->isSold > 0)){ ?>
                • <span style="color: #e74c3c;"><?php echo OSPHelper::returnMarketStatus($row->isSold); ?></span>
                <?php } ?>
            </div>
            <div class="property-price">
                <?php
                if($row->price_text != "") {
                    echo OSPHelper::showPriceText(Text::_($row->price_text));
                } elseif($row->price_call == 1) {
                    echo Text::_('OS_CALL_FOR_PRICE');
                } else {
                    echo OSPHelper::generatePrice($row->curr,$row->price);
                    if($row->rent_time != "") {
                        echo " /".Text::_($row->rent_time);
                    }
                }
                ?>
            </div>
        </div>
    </div>
</div>
<?php } ?>

<!-- Key Features Bar -->
<div class="features-bar">
    <table class="features-table">
        <tr>
            <?php if(($configClass['use_bedrooms'] == 1) && ($row->bed_room > 0)){ ?>
            <td>
                <span class="feature-value"><?php echo $row->bed_room;?></span>
                <span class="feature-label"><?php echo Text::_('OS_BEDROOMS');?></span>
            </td>
            <?php } ?>
            
            <?php if(($configClass['use_bathrooms'] == 1) && ($row->bath_room > 0)){ ?>
            <td>
                <span class="feature-value"><?php echo OSPHelper::showBath($row->bath_room);?></span>
                <span class="feature-label"><?php echo Text::_('OS_BATHROOMS');?></span>
            </td>
            <?php } ?>
            
            <?php if($configClass['use_squarefeet'] == 1 && $row->square_feet > 0){ ?>
            <td>
                <span class="feature-value"><?php echo number_format($row->square_feet);?></span>
                <span class="feature-label"><?php echo OSPHelper::showSquareSymbol();?></span>
            </td>
            <?php } ?>
            
            <?php if($configClass['use_nfloors'] == 1 && $row->number_of_floors > 0){ ?>
            <td>
                <span class="feature-value"><?php echo $row->number_of_floors;?></span>
                <span class="feature-label"><?php echo Text::_('OS_FLOORS');?></span>
            </td>
            <?php } ?>
        </tr>
    </table>
</div>

<!-- Main Content -->
<div class="content">
    <div class="two-columns">
        <div class="main-column">
            <!-- Description -->
            <div class="section-title"><?php echo Text::_('OS_ABOUT_THIS_PROPERTY'); ?></div>
            <div class="description">
                <?php
                $small_desc = OSPHelper::getLanguageFieldValue($row,'pro_small_desc');
                $small_desc = strip_tags($small_desc); // Loại bỏ HTML
                $small_desc = OSPHelper::removeShortcodes($small_desc); // Loại bỏ shortcode

                if($small_desc != ""){
                    echo '<strong>'.$small_desc.'</strong>';
                }

                $full_desc = OSPHelper::getLanguageFieldValue($row,'pro_full_desc');
                $full_desc = strip_tags($full_desc); 
                $full_desc = OSPHelper::removeShortcodes($full_desc);

                if($full_desc != ""){
                    echo $full_desc;
                }
                ?>
            </div>

            <!-- Photo Gallery -->
            <?php if(count($row->photo) > 1){ ?>
            <div class="section-title"><?php echo Text::_('OS_PROPERTY_PHOTOS'); ?></div>
            <div class="photo-gallery">
                <?php
                for($i=0; $i<=min(6, count($row->photo)-1); $i++){
                    if(isset($row->photo[$i])){
                ?>
                <img src="<?php echo Uri::root()?>images/osproperty/properties/<?php echo $row->id;?>/thumb/<?php echo $row->photo[$i]->image?>" />
                <?php 
                    }
                } 
                ?>
            </div>
            <?php } ?>
        </div>

        <div class="side-column">
            <!-- Property Details -->
            <?php if($configClass['use_squarefeet'] == 1 && $row->square_feet > 0){ ?>
            <div class="info-card">
                <div class="info-card-header"><?php echo Text::_('OS_PROPERTY_DETAILS'); ?></div>
                <div class="info-card-body">
                    <div class="info-grid">
                        <?php if($row->square_feet > 0){ ?>
                        <div class="info-item">
                            <div class="info-item-label"><?php echo Text::_('OS_SQUARE_FEET'); ?></div>
                            <div class="info-item-value"><?php echo OSPHelper::showSquare($row->square_feet);?></div>
                        </div>
                        <?php } ?>
                        
                        <?php if($row->lot_size > 0){ ?>
                        <div class="info-item">
                            <div class="info-item-label"><?php echo Text::_('OS_LOT_SIZE'); ?></div>
                            <div class="info-item-value"><?php echo OSPHelper::showSquare($row->lot_size);?></div>
                        </div>
                        <?php } ?>
                        
                        <?php if($row->built_on > 0){ ?>
                        <div class="info-item">
                            <div class="info-item-label"><?PHP echo Text::_('OS_YEAR_BUILT'); ?></div>
                            <div class="info-item-value"><?php echo $row->built_on;?></div>
                        </div>
                        <?php } ?>
                        
                        <?php if($row->number_of_floors > 0){ ?>
                        <div class="info-item">
                            <div class="info-item-label"><?php echo Text::_('OS_FLOORS'); ?></div>
                            <div class="info-item-value"><?php echo $row->number_of_floors;?></div>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <?php } ?>

            <!-- Amenities -->
            <?php if(($configClass['show_amenity_group'] == 1) && (count($amenitylists) > 0)){ ?>
            <div class="info-card">
                <div class="info-card-header">Key Amenities</div>
                <div class="info-card-body">
                    <div class="amenities-list">
                        <?php
                        $count = 0;
                        foreach($amenities as $amenity){
                            if(in_array($amenity->id,$amenitylists) && $count < 8){
                                echo '<div class="amenity-item">'.OSPHelper::getLanguageFieldValue($amenity,'amenities').'</div>';
                                $count++;
                            }
                        }
                        ?>
                    </div>
                </div>
            </div>
            <?php } ?>

            <!-- Neighborhood -->
            <?php if($configClass['show_neighborhood_group'] == 1){
                $db->setQuery("Select count(id) from #__osrs_neighborhood where pid = '$row->id'");
                $count = $db->loadResult();
                if($count > 0){
                    $query = "Select a.*,b.neighborhood from #__osrs_neighborhood as a"
                        ." inner join #__osrs_neighborhoodname as b on b.id = a.neighbor_id"
                        ." where a.pid = '$row->id' LIMIT 5";
                    $db->setQuery($query);
                    $neighbors = $db->loadObjectList();
            ?>
            <div class="info-card">
                <div class="info-card-header">Nearby</div>
                <div class="info-card-body">
                    <?php foreach($neighbors as $neighbor){ ?>
                    <div class="info-item" style="margin-bottom: 8px;">
                        <div class="info-item-label"><?php echo Text::_($neighbor->neighborhood);?></div>
                        <div class="info-item-value"><?php echo $neighbor->mins?> <?php echo Text::_('OS_MINS'); ?></div>
                    </div>
                    <?php } ?>
                </div>
            </div>
            <?php 
                }
            }
            ?>
        </div>
    </div>
</div>

<!-- Agent Footer -->
<?php if(OSPHelper::allowShowingProfile($row->agent->optin)){ ?>
<div class="agent-footer">
    <?php if($configClass['show_agent_image'] == 1){ ?>
    <img src="<?php echo Uri::root()?>images/osproperty/agent/<?php echo $row->agent->photo ?: 'default.jpg'?>" class="agent-photo"/>
    <?php } ?>
    
    <div class="agent-info">
        <div class="agent-name"><?php echo $row->agent->name;?></div>
        <?php if($row->agent->phone != "" && $configClass['show_agent_phone'] == 1){ ?>
        <div class="agent-contact">📞 <?php echo $row->agent->phone;?></div>
        <?php } ?>
        <?php if($row->agent->mobile != "" && $configClass['show_agent_mobile'] == 1){ ?>
        <div class="agent-contact">📱 <?php echo $row->agent->mobile;?></div>
        <?php } ?>
    </div>
    
    <div class="agent-cta"><?php echo Text::_('OS_CONTACT_AGENT'); ?></div>
</div>
<?php } ?>

</body>
</html>
