<?php
/**
 * @package            Joomla
 * @subpackage         OS Property
 * @author             Dang Thuc Dam
 * @copyright          Copyright (C) 2025 joomdonation.com. All Rights Reserved.
 * @license            GNU/GPL, see LICENSE.php
 */
use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Filesystem\Folder;

class OspropertyHelperBootstrap
{
	/**
	 * Twitter bootstrap version, default 2
	 * @var string
	 */
	protected $bootstrapVersion;

	/**
	 * The class mapping to map between twitter bootstrap 2 and twitter bootstrap 3
	 * @var string
	 */
	protected static $classMaps;

	/**
	 * Constructor, initialize the classmaps array
	 *
	 * @param int $bootstrapVersion
	 */
	public function __construct($bootstrapVersion)
	{
		if (empty($bootstrapVersion))
		{
			$bootstrapVersion = 5;
		}
		
		if(Factory::getApplication()->isClient('administrator'))
		{
			$bootstrapVersion = 5;
		}
		$this->bootstrapVersion = $bootstrapVersion;

		// The static class map
		if ($bootstrapVersion == 5)
		{
			self::$classMaps = array(
				'row-fluid'          => 'row',
				'span1'              => 'col-md-1',
				'span2'              => 'col-md-2',
				'span3'              => 'col-md-3',
				'span4'              => 'col-md-4',
				'span5'              => 'col-md-5',
				'span6'              => 'col-md-6',
				'span7'              => 'col-md-7',
				'span8'              => 'col-md-8',
				'span9'              => 'col-md-9',
				'span10'             => 'col-md-10',
				'span11'             => 'col-md-11',
				'span12'             => 'col-md-12',
				'pull-left'          => 'float-start',
				'pull-right'         => 'float-end',
				'btn'                => 'btn btn-secondary',
				'btn-mini'           => 'btn-xs',
				'btn-small'          => 'btn-sm',
				'btn-large'          => 'btn-lg',
				'btn-inverse'        => 'btn-primary',
				'visible-phone'      => 'd-block d-sm-none',
				'visible-tablet'     => 'visible-sm',
				'visible-desktop'    => 'd-block d-md-none',
				'hidden-phone'       => 'd-none d-sm-block d-md-table-cell',
				'hidden-tablet'      => 'd-sm-none',
				'hidden-desktop'     => 'd-md-none hidden-lg',
				'control-group'      => 'row form-group form-row',
				'input-prepend'      => 'input-group-prepend',
				'input-append'       => 'input-group-append',
				'add-on'             => 'input-group-text',
				'img-polaroid'       => 'img-thumbnail',
				'control-label'      => 'col-md-3 form-control-label',
				'controls'           => 'col-md-9',
				'btn btn-primary'    => 'btn btn-primary',
				'row-fluid clearfix' => 'row clearfix',
				'icon-publish'       => 'fa fa-check',
				'icon-unpublish'     => 'fa fa-times',
				'badge badge-info'   => 'badge badge-info',
				'input-medium'	  => 'form-control',
				'input-small'	  => 'form-control',
				'input-large'	  => 'form-control',
				'input-xlarge'	  => 'form-control',
				'input-xxxlarge'	  => 'form-control',
				'input-mini'	  => 'form-control'
			);
		}
		elseif ($bootstrapVersion == 4)
		{
			self::$classMaps = array(
				'row-fluid'       => 'row',
				'span1'           => 'col-lg-1',
				'span2'           => 'col-lg-2',
				'span3'           => 'col-lg-3',
				'span4'           => 'col-lg-4',
				'span5'           => 'col-lg-5',
				'span6'           => 'col-lg-6',
				'span7'           => 'col-lg-7',
				'span8'           => 'col-lg-8',
				'span9'           => 'col-lg-9',
				'span10'          => 'col-lg-10',
				'span11'          => 'col-lg-11',
				'span12'          => 'col-lg-12',
				'pull-left'       => 'float-left',
				'pull-right'      => 'float-right',
				'btn'             => 'btn btn-secondary',
				'btn-mini'        => 'btn-xs',
				'btn-small'       => 'btn-sm',
				'btn-large'       => 'btn-lg',
				'btn-inverse'     => 'btn-primary',
				'visible-phone'   => 'd-block d-sm-none',
				'visible-tablet'  => 'visible-sm',
				'visible-desktop' => 'd-block d-md-none',
				'hidden-phone'    => 'd-none d-sm-block',
				'hidden-tablet'   => 'd-sm-none',
				'hidden-desktop'  => 'd-md-none hidden-lg',
				'control-group'   => 'form-group form-row row',
				'input-prepend'   => 'input-group-prepend',
				'input-append'    => 'input-group-append',
				'add-on'          => 'input-group-text',
				'img-polaroid'    => 'img-thumbnail',
				'control-label'   => 'col-md-3 form-control-label',
				'controls'        => 'col-md-9',
				'img-rounded'	  => 'rounded',
				'btn'			  => 'btn btn-light',
				'input-medium'	  => 'form-control',
				'input-small'	  => 'form-control',
				'input-large'	  => 'form-control',
				'input-xlarge'	  => 'form-control',
				'input-xxxlarge'  => 'form-control',
				'input-mini'	  => 'form-control'
			);
		}
	}

	/**
	 * Get the mapping of a given class
	 *
	 * @param $class The input class
	 *
	 * @return string The mapped class
	 */
	public function getClassMapping($class)
	{
		if (isset(self::$classMaps[$class]))
		{
			return self::$classMaps[$class];
		}

		// Handle icon class
		if (strpos($class, 'icon-') !== false)
		{
			if ($this->bootstrapVersion == 2)
			{
				return $class;
			}
			else
			{
				$icon = substr($class, 5);

				return "glyphicon glyphicon-$icon fa fa-$icon";
			}
		}

		// Not found, this class is for twitter bootstrap 3 only

		if (($this->bootstrapVersion == 3) || ($this->bootstrapVersion == 4))
		{
			return $class;
		}
		else
		{
			return;
		}

	}
}
