<?php

use AcyMailing\Helpers\TabHelper;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;

trait OspropertyInsertion
{
    private $symbolWidth;
    private $symbolHeight;

    public function getStandardStructure(&$customView)
    {
        $tag = new stdClass();
        $tag->id = 0;

        $format = new stdClass();
        $format->tag = $tag;
        $format->title = '{title}';
        $format->afterTitle = '';
        $format->afterArticle = '<br> {readmore}';
        $format->imagePath = '{image}';
        $format->description = '{shortdesc}';
        $format->link = '{link}';
        $format->customFields = [];
        $customView = '<div class="acymailing_content">'.$this->pluginHelper->getStandardDisplay($format).'</div>';
    }

    public function initReplaceOptionsCustomView()
    {
        $this->replaceOptions = [
            'link' => ['ACYM_LINK'],
            'picthtml' => ['ACYM_IMAGE'],
            'readmore' => ['ACYM_READ_MORE'],
        ];
    }

    public function initElementOptionsCustomView()
    {
        $query = 'SELECT element.*
                    FROM #__osrs_properties AS element
                    WHERE element.published = 1';
        $element = acym_loadObject($query);
        if (empty($element)) return;
        foreach ($element as $key => $value) {
            $this->elementOptions[$key] = [$key];
        }
    }

    public function insertionOptions($defaultValues = null)
    {
        $this->defaultValues = $defaultValues;

        acym_loadLanguageFile('com_osproperty', JPATH_ADMINISTRATOR);

        // Get the categories, always with the columns "id", "parent_id" and "title". Use the MySQL "AS" if needed
        $this->categories = acym_loadObjectList(
            'SELECT id, parent_id, category_name as title
            FROM `#__osrs_categories` 
            WHERE published = "1"'
        );

        $tabHelper = new TabHelper();
        $identifier = $this->name;
        $tabHelper->startTab(acym_translation('ACYM_ONE_BY_ONE'), !empty($this->defaultValues->defaultPluginTab) && $identifier === $this->defaultValues->defaultPluginTab);

        $displayOptions = [
            [
                'title' => 'ACYM_DISPLAY',
                'type' => 'checkbox',
                'name' => 'display',
                'options' => $this->displayOptions,
            ],
            [
                'title' => 'ACYM_CLICKABLE_TITLE',
                'type' => 'boolean',
                'name' => 'clickable',
                'default' => true,
            ],
            [
                'title' => 'ACYM_CLICKABLE_IMAGE',
                'type' => 'boolean',
                'name' => 'clickableimg',
                'default' => false,
            ],
            [
                'title' => 'ACYM_TRUNCATE',
                'type' => 'intextfield',
                'isNumber' => 1,
                'name' => 'wrap',
                'text' => 'ACYM_TRUNCATE_AFTER',
                'default' => 0,
            ],
            [
                'title' => 'ACYM_DISPLAY_PICTURES',
                'type' => 'pictures',
                'name' => 'pictures',
            ],
            [
                'title' => 'ACYM_AUTO_LOGIN',
                'tooltip' => 'ACYM_AUTO_LOGIN_DESCRIPTION_WARNING',
                'type' => 'boolean',
                'name' => 'autologin',
                'default' => false,
            ],
        ];

        $zoneContent = $this->getFilteringZone().$this->prepareListing();
        echo $this->displaySelectionZone($zoneContent);
        echo $this->pluginHelper->displayOptions($displayOptions, $identifier, 'individual', $this->defaultValues);

        $tabHelper->endTab();
        $identifier = 'auto'.$this->name;
        $tabHelper->startTab(acym_translation('ACYM_BY_CATEGORY'), !empty($this->defaultValues->defaultPluginTab) && $identifier === $this->defaultValues->defaultPluginTab);

        $catOptions = [
            [
                'title' => 'ACYM_ORDER_BY',
                'type' => 'select',
                'name' => 'order',
                'options' => [
                    'id' => 'ACYM_ID',
                    'publish_up' => 'ACYM_PUBLISHING_DATE',
                    'modified' => 'ACYM_MODIFICATION_DATE',
                    'title' => 'ACYM_TITLE',
                    'rand' => 'ACYM_RANDOM',
                ],
            ],
            [
                'title' => 'ACYM_ONLY_FEATURED',
                'type' => 'boolean',
                'name' => 'featured',
                'default' => false,
            ],
        ];
        $this->autoContentOptions($catOptions);

        $this->autoCampaignOptions($catOptions);

        $displayOptions = array_merge($displayOptions, $catOptions);

        echo $this->displaySelectionZone($this->getCategoryListing());
        echo $this->pluginHelper->displayOptions($displayOptions, $identifier, 'grouped', $this->defaultValues);

        $tabHelper->endTab();

        $tabHelper->display('plugin');
    }

    public function prepareListing()
    {
        //we load all elements with the categories
        $this->querySelect = 'SELECT element.id, element.pro_name as title, element.publish_up ';
        $this->query = 'FROM #__osrs_properties AS element ';
        $this->filters = [];
        $this->filters[] = 'element.published = 1';
        $this->searchFields = ['element.id', 'element.pro_name'];
        $this->pageInfo->order = 'element.id';
        $this->elementIdTable = 'element';
        $this->elementIdColumn = 'id';

        if (!acym_isAdmin() && $this->getParam('front', 'all') === 'author') {
            $this->filters[] = 'element.created_by = '.intval(acym_currentUserId());
        }

        parent::prepareListing();

        // If we filtered the listing for a specific category, we display only the elements of this category
        if (!empty($this->pageInfo->filter_cat)) {
            $this->filters[] = 'element.id in (Select pid from #__osrs_property_categories where category_id = '.intval($this->pageInfo->filter_cat).')';
        }

        $listingOptions = [
            'header' => [
                'title' => [
                    'label' => 'ACYM_TITLE',
                    'size' => '7',
                ],
                'publish_up' => [
                    'label' => 'ACYM_PUBLISHING_DATE',
                    'size' => '4',
                    'type' => 'date',
                ],
                'id' => [
                    'label' => 'ACYM_ID',
                    'size' => '1',
                    'class' => 'text-center',
                ],
            ],
            'id' => 'id',
            'rows' => $this->getElements(),
        ];

        return $this->getElementsListing($listingOptions);
    }

    public function replaceContent(&$email)
    {
        $this->replaceMultiple($email);
        $this->replaceOne($email);
    }

    public function generateByCategory(&$email)
    {
        $tags = $this->pluginHelper->extractTags($email, 'auto'.$this->name);
        $this->tags = [];
        $time = time();

        if (empty($tags)) return $this->generateCampaignResult;

        foreach ($tags as $oneTag => $parameter) {
            if (isset($this->tags[$oneTag])) continue;

            $query = 'SELECT DISTINCT element.`id` FROM #__osrs_properties AS element ';

            $where = [];

            $selectedArea = $this->getSelectedArea($parameter);
            if (!empty($selectedArea)) {
                $where[] = 'element.id in (Select pid from #__osrs_property_categories where category_id IN ('.implode(',', $selectedArea).'))';
            }

            $where[] = 'element.published = 1';
            $where[] = '`publish_up` < '.acym_escapeDB(date('Y-m-d H:i:s', $time - date('Z')));
            $where[] = '`publish_down` > '.acym_escapeDB(date('Y-m-d H:i:s', $time - date('Z'))).' OR `publish_down` = 0 OR `publish_down` IS NULL';
            if (!empty($parameter->min_publish)) {
                $parameter->min_publish = acym_date(acym_replaceDate($parameter->min_publish), 'Y-m-d H:i:s', false);
                $where[] = '`publish_up` >= '.acym_escapeDB($parameter->min_publish);
            }

            if ($parameter->featured) $where[] = 'element.featured = 1';

            if (!empty($parameter->onlynew)) {
                $lastGenerated = $this->getLastGenerated($email->id);
                if (!empty($lastGenerated)) {
                    $where[] = 'element.publish_up > '.acym_escapeDB(acym_date($lastGenerated, 'Y-m-d H:i:s', false));
                }
            }

            $query .= ' WHERE ('.implode(') AND (', $where).')';

            $this->tags[$oneTag] = $this->finalizeCategoryFormat($query, $parameter, 'element');
        }

        return $this->generateCampaignResult;
    }

    protected function loadLibraries($email)
    {
        $params = ComponentHelper::getParams('com_osproperty');

        $this->symbolWidth = $params->get('file_pic_size', '32');
        $this->symbolHeight = $params->get('file_pic_size_height', '32');

        acym_loadLanguageFile('com_osproperty', JPATH_ADMINISTRATOR);

        return true;
    }

    public function replaceIndividualContent($tag)
    {
		$db = Factory::getDbo();

		

        $query = 'SELECT element.*, element.pro_name as title
                    FROM #__osrs_properties AS element
                    WHERE element.published = 1
                        AND element.id = '.intval($tag->id);

        $element = $this->initIndividualContent($tag, $query);


		$db->setQuery('Select `image` from #__osrs_photos where pro_id = '.intval($tag->id).' order by ordering limit 1');
		$image = $db->loadResult();

		$images = [];
		$images[] = $image;

        if (empty($element)) return '';

        $varFields = $this->getCustomLayoutVars($element);

        $completeId = intval($element->id);
        if (!empty($element->alias)) $completeId .= ':'.$element->alias;

        $link = 'index.php?option=com_osproperty&task=property_details&id='.$completeId;
        $link = $this->finalizeLink($link, $tag);
        $varFields['{link}'] = $link;

        $title = '';
        $afterTitle = '';
        $afterArticle = '';
        $imagePath = '';
        $contentText = '';
        $customFields = [];

        $varFields['{title}'] = $element->title;
        if (in_array('title', $tag->display)) $title = $varFields['{title}'];

        $varFields['{image}'] = '';
        $varFields['{picthtml}'] = '';
        if (!empty($images)) {
            //$images = explode('|', $element->images);
            $varFields['{image}'] = acym_rootURI().'images/osproperty/properties/'.$completeId.'/medium/'.$images[0];
            $varFields['{picthtml}'] = '<img alt="" src="'.acym_escape($imagePath).'" />';
        }
        if (in_array('image', $tag->display) && !empty($images)) {
            $imagePath = acym_rootURI().'images/osproperty/properties/'.$completeId.'/medium/'.$images[0];
        }

        $varFields['{shortdesc}'] = !empty($element->pro_small_desc) ? $element->pro_small_desc : '';
        if (in_array('shortdesc', $tag->display) && !empty($element->pro_small_desc)) $contentText .= $varFields['{shortdesc}'];

        $varFields['{longdesc}'] = !empty($element->pro_full_desc) ? $element->pro_full_desc : '';
        if (in_array('longdesc', $tag->display) && !empty($element->pro_full_desc)) $contentText .= $element->pro_full_desc;

		$db->setQuery("Select name from #__osrs_agents where id = ".$element->agent_id);
		$element->author = $db->loadResult();

        if (empty($element->author)) {
            $varFields['{author}'] = '';
        } else {
            $varFields['{author}'] = !empty($element->url_author) ? '<a href="'.$element->url_author.'" target="_blank">'.$element->author.'</a>' : $element->author;
        }
        if (in_array('author', $tag->display) && !empty($element->author)) {
            $customFields[] = [
                $varFields['{author}'],
                acym_translation('Author'),
            ];
        }


        $varFields['{creation}'] = !empty($element->created) ? acym_date($element->created, acym_translation('ACYM_DATE_FORMAT_LC1'), false) : '';
        if (in_array('creation', $tag->display) && !empty($element->created)) {
            $customFields[] = [
                $varFields['{creation}'],
                acym_translation('Creted date'),
            ];
        }

		
       

        $varFields['{cat}'] = OSPHelper::getCategoryNamesOfPropertyWithLinks($tag->id);
        if (in_array('cat', $tag->display)) {
            $customFields[] = [
                $varFields['{cat}'],
                acym_translation('ACYM_CATEGORY'),
            ];
        }

        $varFields['{readmore}'] = '<a class="acymailing_readmore_link" style="text-decoration:none;" target="_blank" href="'.$link.'">';
        $varFields['{readmore}'] .= '<span class="acymailing_readmore">'.acym_translation('ACYM_READ_MORE').'</span>';
        $varFields['{readmore}'] .= '</a>';
        if (in_array('readmore', $tag->display)) {
            $afterArticle .= $varFields['{readmore}'];
        }

        $format = new stdClass();
        $format->tag = $tag;
        $format->title = $title;
        $format->afterTitle = $afterTitle;
        $format->afterArticle = $afterArticle;
        $format->imagePath = $imagePath;
        $format->description = $contentText;
        $format->link = empty($tag->clickable) && empty($tag->clickableimg) ? '' : $link;
        $format->customFields = $customFields;
        $result = '<div class="acymailing_content">'.$this->pluginHelper->getStandardDisplay($format).'</div>';

        return $this->finalizeElementFormat($result, $tag, $varFields);
    }
}
