<?php

/**
 * @package        Joomla
 * @subpackage     Membership Pro
 * @author         Tuan Pham Ngoc
 * @copyright      Copyright (C) 2012 - 2026 Ossolution Team
 * @license        GNU/GPL, see LICENSE.php
 */
defined('_JEXEC') or die;

use Joomla\Registry\Registry;

trait OSMembershipModelPlantrait
{
	/**
	 * Process plan custom fields
	 *
	 * @param   OSMembershipTablePlan  $row
	 */
	protected function processCustomFields($row)
	{
		$registry = new Registry($row->custom_fields);

		$row->fieldsData = $registry;

		foreach ($registry->toArray() as $key => $value)
		{
			if (!property_exists($row, $key))
			{
				$row->{$key} = $value;
			}

			if (!is_string($value))
			{
				continue;
			}

			$row->short_description = str_replace('[' . strtoupper($key) . ']', $value, $row->short_description);
			$row->description       = str_replace('[' . strtoupper($key) . ']', $value, $row->description);
		}
	}

	/**
	 * Process common tags in plan data
	 *
	 * @param   OSMembershipTablePlan  $row
	 */
	protected function processCommonTags($row): void
	{
		$replaces = OSMembershipHelper::buildCommonTags();

		$row->short_description = OSMembershipHelper::replaceUpperCaseTags($row->short_description, $replaces);
		$row->description       = OSMembershipHelper::replaceUpperCaseTags($row->description, $replaces);
	}
}
