<?php
/**
 * @package   OSDownloads-Pro
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2005-2025 Joomlashack.com. All rights reserved
 * @license   https://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of OSDownloads-Pro.
 *
 * OSDownloads-Pro is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * OSDownloads-Pro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSDownloads-Pro.  If not, see <https://www.gnu.org/licenses/>.
 */

use Alledia\OSDownloads\Factory;
use Joomla\CMS\Language\Text;

defined('_JEXEC') or die();

$message = Factory::getApplication()->input->getString('errorMessage');
?>
<style>
  body,
  div#all,
  div#main {
    background: none transparent !important;
  }

  div#main {
    min-height: 0 !important;
  }
</style>

<h1><?php echo Text::_('COM_OSDOWNLOADS_ERROR'); ?></h1>
<div class="alert alert-error">
    <p><?php echo Text::_('COM_OSDOWNLOADS_ERROR_SENDING_EMAIL'); ?></p>
    <?php if ($message) :
        echo '<p>' . $message . '</p>';
    endif; ?>
</div>
