<?php
/**
 * @package   OSDownloads-Pro
 * @contact   www.joomlashack.com, help@joomlashack.com
 * @copyright 2005-2025 Joomlashack.com. All rights reserved
 * @license   https://www.gnu.org/licenses/gpl.html GNU/GPL
 *
 * This file is part of OSDownloads-Pro.
 *
 * OSDownloads-Pro is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * OSDownloads-Pro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OSDownloads-Pro.  If not, see <https://www.gnu.org/licenses/>.
 */

use Alledia\OSDownloads\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die();

$container = Factory::getPimpleContainer();

$noItems = true;
?>
<div class="contentopen osdownloads-container">
    <?php
    if (
        $this->params->get('show_page_heading')
        && ($heading = $this->params->get('page_heading'))
    ) :
        ?>
        <div class="page-header">
            <h1> <?php echo $this->escape($this->params->get('page_heading')); ?> </h1>
        </div>
    <?php endif;

    if ($this->categories) :
        foreach ($this->categories as $category) :
            if ($category->hide) :
                continue;
            endif;
            ?>
            <div class="item_<?php echo $category->id; ?>">
                <h3>
                    <?php
                    echo HTMLHelper::_(
                        'link',
                        Route::_($container->helperRoute->getFileListRoute($category->id, $this->itemId)),
                        $category->title
                    );
                    ?>
                </h3>
                <?php if ($this->showDescriptions) : ?>
                    <div>
                        <p><?php echo $category->description; ?></p>
                    </div>
                <?php endif; ?>
                <div class="seperator"></div>
            </div>
            <?php
            $noItems = false;
        endforeach;
    endif;

    if ($noItems) :
        ?>
        <div class="osd-alert">
            <?php echo JText::_('COM_OSDOWNLOADS_NO_DOWNLOADS'); ?>
        </div>
    <?php endif; ?>

    <div class="clr"></div>
    <div><?php echo $this->pagination->getPagesCounter(); ?></div>
    <div class="osdownloads-pagination"><?php echo $this->pagination->getPagesLinks(); ?></div>
</div>
