<?php 
/*------------------------------------------------------------------------
# helper.php - Ossolution Property
# ------------------------------------------------------------------------
# author    Dang Thuc Dam
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/
// no direct access
defined('_JEXEC') or die;

if(!class_exists('OSCHelper'))
{
	class OSCHelper
	{
		/**
		 *
		 * Function to get all available languages except the default language
		 * @return languages object list
		 */
		public static function getAllLanguages()
		{
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);
			$default = self::getDefaultLanguage();
			$query->select('lang_id, lang_code, title, `sef`')
				->from('#__languages')
				->where('published = 1')
				->order('ordering');
			$db->setQuery($query);
			$languages = $db->loadObjectList();
			return $languages;
		}
	
		/**
		 * Get front-end default language
		 * @return string
		 */
		public static function getDefaultLanguage()
		{
			$params = JComponentHelper::getParams('com_languages');
			return $params->get('site', 'en-GB');
		}
		
		
		public static function generateDateRangeSearch($start_time,$end_time){
			ob_start();
			?>
			<div width="100%">
				<div style="float:left;">
					<B><?php echo JText::_('OS_CHECKIN')?>:</B>
					<?php echo JHTML::_('calendar',$start_time, 'start_time', 'start_time', '%Y-%m-%d', array('class'=>'input-small', 'size'=>'19',  'maxlength'=>'19')); ?>
				</div>
				<div style="float:left;padding-left:30px;">
					<B><?php echo JText::_('OS_CHECKOUT')?>:</B>
					<?php echo JHTML::_('calendar',$end_time, 'end_time', 'end_time', '%Y-%m-%d', array('class'=>'input-small', 'size'=>'19',  'maxlength'=>'19')); ?>
				</div>
			</div>
			<?php
			$body = ob_get_contents();
			ob_end_clean();
			return $body;
		}
		
		/**
		 * Build Date range query
		 *
		 * @param unknown_type $start_time
		 * @param unknown_type $end_time
		 */
		public static function buildDateRangeQuery($start_time, $end_time){
			die();
			global $mainframe;
			$start_time_int = strtotime ($start_time);
			$end_time_int	= strtotime ($end_time);
			$selected_date  = OSCHelper::generateDateArr($start_time,$end_time);
			print_r($selected_date);
			$db = JFactory::getDbo();
			$query = "";
			$ospConfig = OSPHelper::loadConfig();
			$show_date_search_in = $ospConfig['show_date_search_in'];
			if($show_date_search_in != ""){
				$pTypes = str_replace("|",",",$show_date_search_in);
				$query .= " AND a.pro_type in ($pTypes)";
			}			

			//find room available in Check in/out dates
			$roomArr = array();
			//search with Property Price Plan only
			//step 1: Find all available room
			$rQuery  = "Select a.id,a.pid,b.pro_type,c.price_type,a.room_number from #__oscalendar_rooms as a "
					   ." inner join #__osrs_properties as b on b.id = a.pid"
					   ." inner join #__osrs_types as c on c.id = b.pro_type"
					   ." where a.published = '1' and b.published = '1' and b.approved = '1' and c.published = '1'";
			$db->setQuery($rQuery);
			$rooms = $db->loadObjectList();
			
			foreach($rooms as $r){
				$room_number = $r->room_number;
				if($r->price_type == 0){ //holiday price
					$available_to_book = OSCHelper::checkAvailableStatus($r->id,$selected_date); //pass this step?
					if($available_to_book == 1){
						$db->setQuery("Select count(id) from #__oscalendar_room_prices where rid = '$r->id' and price_from = '$start_time' and price_to =  '$end_time'");
						$count = $db->loadResult();
						if($count > 0){
							$broom = OSCHelper::maxRoomBookedTypeHoliday($r->id,$start_time,$end_time);
							if($broom < $room_number){
								$roomArr[] = $r->id;
							}
						}
					}
				}else{ //property price
					$available_to_book = OSCHelper::checkAvailableStatus($r->id,$selected_date);
					if($available_to_book == 1){
						$available_to_book = OSCHelper::checkPriceSetupForOneTimeRange($r->id,$selected_date);
						if($available_to_book == 1){
							$broom = OSCHelper::maxRoomBookedTypeProperty($r->id,$start_time,$end_time);
							if($broom < $room_number){
								$roomArr[] = $r->id;
							}
						}
					}
				}
			}
			if(count($roomArr) > 0){
				$query .= " AND a.id in (Select pid from #__oscalendar_rooms where id in (".implode(",",$roomArr)."))";
			}else{
				$query .= " AND 1 = 2";
			}
			return $query;
		}
		
		public static function loadBootstrap($loadJs = true)
		{
			$document = JFactory::getDocument();
			if ($loadJs)
			{
				$document->addScript(JUri::root() . 'components/com_osproperty/js/bootstrap/js/jquery.min.js');
				$document->addScript(JUri::root() . 'components/com_osproperty/js/bootstrap/js/jquery-noconflict.js');
				$document->addScript(JUri::root() . 'components/com_osproperty/js/bootstrap/js/bootstrap.min.js');
			}
			$document->addStyleSheet(JURI::root() . 'components/com_osproperty/js/bootstrap/css/bootstrap.css');
		}
		
		public static function loadBootstrapStylesheet(){
			$document = JFactory::getDocument();
			$document->addStyleSheet(JURI::root() . 'components/com_osproperty/js/bootstrap/css/bootstrap.css');
		}
		
		public static function getRealTime(){
			$config = new JConfig();
			$offset = $config->offset;
			return strtotime(JFactory::getDate('now',$offset));
		}
		
		public static function generateOrderDetailsTip($order_id){
			global $mainframe,$configClass;
			$db = JFactory::getDbo();
			$db->setQuery("select a.ref,a.pro_name,b.* from #__osrs_properties as a inner join #__oscalendar_booking as b on b.pid = a.id where b.id = '$order_id'");
			$order = $db->loadObject();
			$ref = $order->ref;
			$pro_name = $order->pro_name;
			if($ref != ""){
				$pro_name = $ref.", ".$pro_name;
			}
			$title = JText::_('OS_ORDER')." #".$order_id."::";
			$title .= JText::_('OS_PROPERTY').": ".$pro_name;
			$title .= "<BR />";
			$title .= JText::_('OS_CUSTOMER').": ".$order->name.", ".$order->email;
			if($order->phone != ""){
				$title .= ", ".$order->phone;
			}
			$title .= "<BR />";
			$title .= JText::_('OS_CALENDAR_CHECK_IN').": ".date("h:i A, D, jS F Y",strtotime($order->book_from." ".$order->hour_from.":00:00"));
			$title .= "<BR />";
			$title .= JText::_('OS_CALENDAR_CHECK_OUT').": ".date("h:i A, D, jS F Y",strtotime($order->book_to." ".$order->hour_to.":00:00"));
			$title .= "<BR />";
			$title .= JText::_('OS_STATUS').": ";
			switch ($order->order_status){
				case "P":
					$title .= "<span class='label label-warning'>".JText::_('OS_CALENDAR_PENDDING')."</span>";
				break;
				case "C":
					$title .= "<span class='label label-important'>".JText::_('OS_CALENDAR_CANCEL')."</span>";
				break;
				case "S":
					$title .= "<span class='label label-success'>".JText::_('OS_CALENDAR_COMPLETED')."</span>";
				break;
			}
			
			return $title;
		}
		
		/**
		 * Check to see whether the ideal payment plugin installed and activated
		 * @return boolean
		 */
		public static function idealEnabled() {
			$db = & JFactory::getDBO();
			$sql = 'SELECT COUNT(id) FROM #__oscalendar_plugins WHERE name="os_ideal" AND published=1';
			$db->setQuery($sql) ;
			$total = $db->loadResult() ;
			if ($total) {
				require_once JPATH_ROOT.'/components/com_oscalendar/plugins/ideal/ideal.class.php';
				return true ;
			} else {
				return false ;
			}
		}
		
		/**
		 * Calculate number booking nights
		 *
		 * @param unknown_type $date_from
		 * @param unknown_type $date_to
		 */
		public static function calNights($date_from,$date_to){
			$nNights = round(($date_to - $date_from)/(24*3600));
			return $nNights;
		}
		
		/**
		 * return Sub total without tax
		 *
		 * @param unknown_type $pid
		 * @param unknown_type $rid
		 * @param unknown_type $start_date
		 * @param unknown_type $end_date
		 * @param unknown_type $nroom
		 * @return unknown
		 */
		public static function calSubTotal($pid,$rid,$start_date,$end_date,$nroom){
			global $mainframe,$configClass;
			$db = JFactory::getDbo();
			$db->setQuery("Select pro_type from #__osrs_properties where id = '$pid'");
			$category_id = $db->loadResult();
			$db->setQuery("Select price_type from #__osrs_types where id = '$category_id'");
			$price_type = $db->loadResult();
			if($price_type == 0){
				$price = self::calSubTotalTypeHoliday($rid, $start_date,$end_date,$nroom);
			}else{
				$selected_date = self::generateDateArr($start_date,$end_date);
				$price = self::calSubTotalTypeProperty($rid,$selected_date,$nroom);
			}
			return $price->price;
		}
		
		/**
		 * This function is used to generate the subtotal (only the renting price) of room with type: Holiday
		 *
		 * @param unknown_type $rid
		 * @param unknown_type $book_from
		 * @param unknown_type $book_to
		 * @param unknown_type $nroom
		 */
		public static function calSubTotalTypeHoliday($rid,$book_from,$book_to,$nroom){
			$db = JFactory::getDbo();
			$db->setQuery("Select id, price,curr,price_from,price_to from #__oscalendar_room_prices where rid = '$rid' and price_from >= '$book_from' and price_to <= '$book_to'");
			$price = $db->loadObject();
			$price->price = $nroom*$price->price;
			return $price;
		}
		
		/**
		 * This function is used to generate the subtotal of room with type: Property
		 *
		 * @param unknown_type $rid
		 * @param unknown_type $book_from
		 * @param unknown_type $book_to
		 * @param unknown_type $nroom
		 */
		public static function calSubTotalTypeProperty($rid,$selected_date,$nroom){
			$db = JFactory::getDbo();
			$price1 = new StdClass();
			$price2 = new StdClass();
			$total = 0;
			for($i=0;$i<count($selected_date)-1;$i++){
				$date = $selected_date[$i];
				$date_int = strtotime($date);
				$date_in_week = strtolower(date("D",$date_int));
				$db->setQuery("Select * from #__oscalendar_room_prices where rid = '$rid' and `$date_in_week` = '1' and price_from <= '$date' and price_to >= '$date' order by created_on desc");
				$prices1 = $db->loadObjectList();
			
				$db->setQuery("Select * from #__oscalendar_room_prices where rid = '$rid' and price_from <= '$date' and price_to >= '$date' and allday = '1' order by created_on desc");
				$prices2 = $db->loadObjectList();	
				
				if(count($prices1) > 0){
					$price1 = $prices1[0];
				}else{
					$price1->id = 0;
				}
				
				if(count($prices2) > 0){
					$price2 = $prices2[0];
				}else{
					$price2->id = 0;
				}
				
				if($price1->id > $price2->id){
					$price = $price1->price;
					$curr  = $price1->curr;
				}else{
					$price = $price2->price;
					$curr  = $price2->curr;
				}
				
				$total += $price;
			}
			$priceObj = new stdClass();
			$priceObj->price = $total*$nroom;
			$priceObj->curr  = $curr;
			return $priceObj;
		}
		
		/**
		 * Caculate price for one date with Property type
		 *
		 * @param unknown_type $rid
		 * @param unknown_type $selected_date
		 * @param unknown_type $nroom
		 * @return unknown
		 */
		public static function calPriceProperty($rid,$date){
			$db = JFactory::getDbo();
			$price1 = new StdClass();
			$price2 = new StdClass();
			$total = 0;
			$date_int = strtotime($date);
			$date_in_week = strtolower(date("D",$date_int));
			$db->setQuery("Select * from #__oscalendar_room_prices where rid = '$rid' and `$date_in_week` = '1' and price_from <= '$date' and price_to >= '$date' order by created_on desc");
			$prices1 = $db->loadObjectList();
		
			$db->setQuery("Select * from #__oscalendar_room_prices where rid = '$rid' and price_from <= '$date' and price_to >= '$date' and allday = '1' order by created_on desc");
			$prices2 = $db->loadObjectList();	
			
			if(count($prices1) > 0){
				$price1 = $prices1[0];
			}else{
				$price1->id = 0;
			}
			
			if(count($prices2) > 0){
				$price2 = $prices2[0];
			}else{
				$price2->id = 0;
			}
			
			$allow_book_all = 0;
	
			if($price1->id > $price2->id){
				$price = $price1->price;
				$curr  = $price1->curr;
				$min_stay = $price1->min_booking;
				$allow_book_all = $price1->allow_book_all;
				if($allow_book_all == 0){
					if($price1->{'allow_'.$date_in_week} == 1) {
						$allow_book_all = 1;
					}
				}
			}else{
				$price = $price2->price;
				$curr  = $price2->curr;
				$min_stay = $price2->min_booking;
				$allow_book_all = $price2->allow_book_all;
				if($allow_book_all == 0){
					if($price2->{'allow_'.$date_in_week} == 1) {
						$allow_book_all = 1;
					}
				}
			}
			$priceObj = new stdClass();
			$priceObj->price = $price;
			$priceObj->curr  = $curr;
			$priceObj->min_stay = $min_stay;
			$priceObj->allow_book = $allow_book_all;
			return $priceObj;
		}
		
		public static function getTotalFieldAmount($order_temp_id){
			global $mainframe;
			$db = JFactory::getDbo();
			$db->setQuery("Select a.*,b.price_for_order,c.option_free,c.additional_price as aprice,d.nroom from #__oscalendar_order_temp_field_options as a inner join #__oscalendar_fields as b on b.id = a.field_id inner join #__oscalendar_field_options as c on c.id = a.option_id inner join #__oscalendar_order_temp as d on d.id = a.order_id where a.order_id = '$order_temp_id'");
			$fields = $db->loadObjectList();
			$total = 0;
			if(count($fields) > 0){
				foreach($fields as $field){
					if($field->field_free== 0){
						if($field->price_for_order == 0){
							$field_price = $field->aprice;
						}else{
							$field_price = $field->nroom*$field->aprice;
						}
						$total += $field_price;
					}
				}
			}
			$total = round($total,2);
			return $total;
		}
		
		/**
		 * Sub Total calculator
		 *
		 * @param unknown_type $pid
		 * @param unknown_type $start_date_int
		 * @param unknown_type $end_date_int
		 * @return unknown
		 */
		public static function calTotalWithoutTax($pid,$rid,$book_from,$book_to,$nroom,$order_temp_id = 0){
			return round(self::calSubTotal($pid,$rid,$book_from,$book_to,$nroom) + self::getTotalFieldAmount($order_temp_id),2);
		}
		
		/**
		 * Tax calculator
		 *
		 * @param unknown_type $pid
		 * @param unknown_type $start_date_int
		 * @param unknown_type $end_date_int
		 * @return unknown
		 */
		public static function calTax($pid,$rid,$book_from,$book_to,$nroom,$order_temp_id = 0){
			global $cClass;
			if($cClass['enable_tax'] == 1){
				$subtotal = self::calTotalWithoutTax($pid,$rid,$book_from,$book_to,$nroom,$order_temp_id);
				$tax = $cClass['tax_payment'];
				return round(($subtotal*$tax)/100,2);
			}else{
				return 0;
			}
		}
		
		/**
		 * Deposit calculator
		 *
		 * @param unknown_type $pid
		 * @param unknown_type $start_date_int
		 * @param unknown_type $end_date_int
		 * @return unknown
		 */
		public static function calDeposit($pid,$rid,$book_from,$book_to,$nroom,$order_temp_id = 0){
			global $cClass;
			$total = self::calTotalWithoutTax($pid,$rid,$book_from,$book_to,$nroom,$order_temp_id) + self::calTax($pid,$rid,$book_from,$book_to,$nroom,$order_temp_id);
			$deposit = $cClass['deposit_payment'];
			return round(($total*$deposit)/100,2);
		}
		
		/**
		 * Show money with currency symbol and currency code
		 *
		 * @param unknown_type $amount
		 */
		static function showMoney($amount,$showCode){
			global $mainframe,$configClass,$cClass;
			$cClass = self::getConfiguration();
			$money = "";
			if($configClass['curr_symbol'] != ""){
				$symbol = $configClass['curr_symbol'];
			}else{
				$symbol = $configClass['currency_symbol'];
			}
			if($cClass['currency_symbol_position'] == 0){
				$money .= $symbol." ";
			}
			//$money .= number_format($amount,2,'.','')." ";
			switch ($cClass['price_format']){
				case "1":
					$money .= number_format($amount,2,'.','')." ";
				break;
				case "2":
					$money .= number_format($amount,2,'.','')." ";
				break;
				case "3":
					$money .= number_format($amount,2,'.',',')." ";
				break;
				case "4":
					$money .= number_format($amount,2,',','.')." ";
				break;
			}
			if($cClass['currency_symbol_position'] == 1){
				$money .= $symbol." ";
			}
			if($showCode==1){
				$money .= $configClass['currency_format'];
			}
			return $money;
		}
		
		/**
		 * Show money with currency symbol and currency code
		 *
		 * @param unknown_type $amount
		 */
		static function showMoneyWithoutCurrency($amount){
			global $mainframe,$configClass,$cClass;
			$cClass = self::getConfiguration();
			$money = "";
			switch ($cClass['price_format']){
				case "1":
					$money .= number_format($amount,2,'.','')." ";
				break;
				case "2":
					$money .= number_format($amount,2,'.','')." ";
				break;
				case "3":
					$money .= number_format($amount,2,'.',',')." ";
				break;
				case "4":
					$money .= number_format($amount,2,',','.')." ";
				break;
			}
			return $money;
		}
		
		/**
		 * Show money with currency symbol and currency code
		 *
		 * @param unknown_type $amount
		 */
		static function showMoneyInOrder($amount,$order_id){
			global $mainframe,$configClass,$cClass;
			$cClass = self::getConfiguration();
			$db = JFactory::getDbo();
			$db->setQuery("Select curr from #__oscalendar_booking where id = '$order_id'");
			$curr = $db->loadResult();
			$db->setQuery("Select currency_symbol from #__osrs_currencies where currency_code like '$curr'");
			$currency_symbol = $db->loadResult();
			$money = "";
			if($cClass['currency_symbol_position'] == 0){
				$money .= $currency_symbol." ";
			}
			switch ($cClass['price_format']){
				case "1":
					$money .= number_format($amount,2,'.','')." ";
				break;
				case "2":
					$money .= number_format($amount,2,'.','')." ";
				break;
				case "3":
					$money .= number_format($amount,2,'.',',')." ";
				break;
				case "4":
					$money .= number_format($amount,2,',','.')." ";
				break;
			}
			if($cClass['currency_symbol_position'] == 1){
				$money .= $currency_symbol." ";
			}
			return $money;
		}
		
		
		public static function showDateFormat($date,$isInteger){
			$cClass = self::getConfiguration();
			if($isInteger){
				return date($cClass['date_format'],$date);
			}else{
				return date($cClass['date_format'],strtotime($date));
			}
		}
		
		/**
		 * Check duplicate - Last time
		 * 1. There is the an unavailable date between the time range
		 * 2. No price setting for one or more days in time range
		 * 3. No available room for one or more days in time range
		 *
		 * @param unknown_type $pid
		 * @param unknown_type $book_from
		 * @param unknown_type $book_to
		 */
		static function checkDuplicateOrderItem($order){
			global $mainframe;
			$db = JFactory::getDbo();
			$book_from = $order->book_from;
			$book_to   = $order->book_to;
			$pid 	   = $order->pid;
			$rid	   = $order->rid;
			$nroom	   = $order->nroom;
			$db->setQuery("Select pro_type from #__osrs_properties where id = '$pid'");
			$category_id = $db->loadResult();
			$db->setQuery("Select price_type from #__osrs_types where id = '$category_id'");
			$price_type = $db->loadResult();
			$db->setQuery("Select * from #__oscalendar_rooms where id = '$rid'");
			$room = $db->loadObject();
			$room_number = $room->room_number;
			if($price_type == 0){ //type holiday
				//1. There is the an unavailable date between the time range
				$selected_date = OSCHelper::generateDateArr($book_from,$book_to);
				$available_to_book = self::checkAvailableStatus($room->id,$selected_date); //pass this step?
				if($available_to_book == 0){
					return false;
				}
				//2. No price setting for one or more days in time range
				$db->setQuery("Select count(id) from #__oscalendar_room_prices where rid = '$room->id' and price_from = '$book_from' and price_to =  '$book_to'");
				$count = $db->loadResult();
				if($count == 0){
					return false;
				}
				//3. No available room for one or more days in time range
				$broom = self::maxRoomBookedTypeHoliday($rid,$book_from,$book_to);
				if($broom == $room_number){
					return false;
				}elseif($room_number - $broom < $nroom){
					return false;	
				}
			}else{//type Property
				//1. There is the an unavailable date between the time range
				$selected_date = OSCHelper::generateDateArr($book_from,$book_to);
				$available_to_book = self::checkAvailableStatus($room->id,$selected_date); //pass this step?
				if($available_to_book == 0){
					return false;
				}
				//2. No price setting for one or more days in time range
				$available_to_book = self::checkPriceSetupForOneTimeRange($room->id,$selected_date);
				if($available_to_book == 0){
					return false;
				}
				//3. No available room for one or more days in time range
				$broom = self::maxRoomBookedTypeProperty($rid,$book_from,$book_to);
				if($broom == $room_number){
					return false;
				}elseif($room_number - $broom < $nroom){
					return false;	
				}
			}
			return true;
		}
		
		/**
		 * Return max room booked of one room ID in all price type
		 *
		 * @param unknown_type $rid
		 * @param unknown_type $date
		 * @return unknown
		 */
		public static function maxRoomBooked($rid,$date){
			$db = JFactory::getDbo();
			$db->setQuery("Select sum(nroom) from #__oscalendar_booking where rid = '$rid' and book_from <= '$date' and book_to > '$date' and `order_status` in ('S','P')");
			$count = $db->loadResult();
			return $count;
		}
		
		/**
		 * Check to see if in one specific day of room, there is existing price plan
		 *
		 * @param unknown_type $rid
		 * @param unknown_type $date
		 * @return unknown
		 */
		public static function isExistingPricePlan($rid,$date){
			$db = JFactory::getDbo();
			$db->setQuery("Select count(id) from #__oscalendar_room_prices where rid = '$rid' and price_from <= '$date' and price_to > '$date'");
			$count = $db->loadResult();
			if($count > 0){
				return true;
			}else{
				return false;
			}
		}
		
		/**
		 * Check to see if is one specific day of room, there is existing price plan
		 *
		 * @param unknown_type $rid
		 * @param unknown_type $date
		 */
		public static function isExistingPrice($rid,$date){
			$db = JFactory::getDbo();
			$date_int = strtotime($date);
			$date_in_week = strtolower(date("D",$date_int));
			$db->setQuery("Select count(id) from #__oscalendar_room_prices where rid = '$rid' and price_from <= '$date' and price_to > '$date' and (allday = '1' or `$date_in_week` = '1') order by created_on desc");
			$count = $db->loadResult();
			if($count > 0){
				return true;
			}else{
				return false;
			}
		}
		
		/**
		 * Return price plan information
		 *
		 * @param unknown_type $rid
		 * @param unknown_type $date
		 * @return unknown
		 */
		public static function getPricePlan($rid,$date){
			$db = JFactory::getDbo();
			if(self::isExistingPricePlan($rid,$date)){
				$db->setQuery("Select price,curr,price_from,price_to from #__oscalendar_room_prices where rid = '$rid' and price_from <= '$date' and price_to > '$date'");
				$price = $db->loadObject();
				return $price;
			}else{
				return null;
			}
		}
		
		/**
		 * Return price plan information
		 *
		 * @param unknown_type $rid
		 * @param unknown_type $date
		 * @return unknown
		 */
		public static function getPriceProperty($rid,$date){
			$db = JFactory::getDbo();
			if(self::isExistingPrice($rid,$date)){
				$date_int = strtotime($date);
				$date_in_week = strtolower(date("D",$date_int));
				$db->setQuery("Select id,price,curr from #__oscalendar_room_prices where rid = '$rid' and price_from <= '$date' and price_to >= '$date' and allday = '1' order by created_on desc");
				$prices1 = $db->loadObject();
				$db->setQuery("Select id,price,curr from #__oscalendar_room_prices where rid = '$rid' and price_from <= '$date' and price_to >= '$date' and `$date_in_week` = '1' order by created_on desc");
				$prices2 = $db->loadObject();
				
				if($prices1->id > $prices2->id){
					return $prices1;	
				}else{
					return $prices2;	
				}
			}else{
				return null;
			}
		}
		
		/**
		 * maxRoom Booked Type holiday
		 *
		 * @param unknown_type $rid
		 * @param unknown_type $book_from
		 * @param unknown_type $book_to
		 */
		public static function maxRoomBookedTypeHoliday($rid,$book_from,$book_to){
			$db = JFactory::getDbo();
			$db->setQuery("Select sum(nroom) from #__oscalendar_booking where rid = '$rid' and book_from = '$book_from' and book_to = '$book_to' and `order_status` in ('S','P')");
			$count = $db->loadResult();
			return $count;
		}
		
		/**
		 * maxRoom Booked Type Property
		 *
		 * @param unknown_type $rid
		 * @param unknown_type $book_from
		 * @param unknown_type $book_to
		 */
		public static function maxRoomBookedTypeProperty($rid,$book_from,$book_to){
			$db = JFactory::getDbo();
			$selected_date = self::generateDateArr($book_from,$book_to);
			$book = 0;
			if(count($selected_date) > 0){
				for($i=0;$i<=count($selected_date)-1;$i++){
					$date = $selected_date[$i];
					$db->setQuery("Select sum(nroom) from #__oscalendar_booking where rid = '$rid' and book_from <= '$date' and book_to > '$date' and `order_status` in ('S','P')");
					$count = $db->loadResult();
					if($book < $count){
						$book = $count;
					}
				}
			}
			return $book;
		}
		
		/**
		 * This function is used to check to see whether we need to update the database to support multilingual or not
		 *
		 * @return boolean
		 */
		public static function isSyncronized()
		{
			$db = JFactory::getDbo();
			$fields = array_keys($db->getTableColumns('#__oscalendar_emails'));
			$extraLanguages = self::getLanguages();
			if (count($extraLanguages))
			{
				foreach ($extraLanguages as $extraLanguage)
				{
					$prefix = $extraLanguage->sef;
					if (!in_array('email_title_' . $prefix, $fields))
					{
						return false;
					}
				}
			}
			
			$fields = array_keys($db->getTableColumns('#__oscalendar_rooms'));
			$extraLanguages = self::getLanguages();
			if (count($extraLanguages))
			{
				foreach ($extraLanguages as $extraLanguage)
				{
					$prefix = $extraLanguage->sef;
					if (!in_array('room_name_' . $prefix, $fields))
					{
						return false;
					}
				}
			}

			$fields = array_keys($db->getTableColumns('#__oscalendar_field_options'));
			$extraLanguages = self::getLanguages();
			if (count($extraLanguages))
			{
				foreach ($extraLanguages as $extraLanguage)
				{
					$prefix = $extraLanguage->sef;
					if (!in_array('field_option_' . $prefix, $fields))
					{
						return false;
					}
				}
			}

			$fields = array_keys($db->getTableColumns('#__oscalendar_fields'));
			$extraLanguages = self::getLanguages();
			if (count($extraLanguages))
			{
				foreach ($extraLanguages as $extraLanguage)
				{
					$prefix = $extraLanguage->sef;
					if (!in_array('field_label_' . $prefix, $fields))
					{
						return false;
					}
				}
			}
			
			return true;
		}
		
		/**
		 * Get field suffix used in sql query
		 *
		 * @return string
		 */
		public static function getFieldSuffix($activeLanguage = null)
		{
			$prefix = '';
			if (JLanguageMultilang::isEnabled())
			{
				if (!$activeLanguage)
					$activeLanguage = JFactory::getLanguage()->getTag();
				if ($activeLanguage != self::getDefaultLanguage())
				{
					$prefix = '_' . substr($activeLanguage, 0, 2);
				}
			}
			
			return $prefix;
		}
	
		/**
		 *
		 * Function to get all available languages except the default language
		 * @return languages object list
		 */
		public static function getLanguages()
		{
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);
			$default = self::getDefaultLanguage();
			$query->select('lang_id, lang_code, title, `sef`')
				->from('#__languages')
				->where('published = 1')
				->where('lang_code != "' . $default . '"')
				->order('ordering');
			$db->setQuery($query);
			$languages = $db->loadObjectList();
			return $languages;
		}
	
		/**
		 * Get default language of user
		 *
		 */
		public static function getUserLanguage($user_id){
			$default_language = self::getDefaultLanguage();
			if($user_id > 0){
				$user = JFactory::getUser($user_id);
				$default_language = $user->getParam('language',$default_language);
			}else{
				return $default_language;
			}
			return $default_language;
		}
		
		/**
		 * Syncronize Membership Pro database to support multilingual
		 */
		public static function setupMultilingual()
		{
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);
			$languages = self::getLanguages();
			if (count($languages))
			{
				foreach ($languages as $language)
				{
					#Process for #__osmembership_categories table
					$prefix = $language->sef;
					$fields = array_keys($db->getTableColumns('#__oscalendar_emails'));
					if (!in_array('email_title_' . $prefix, $fields))
					{
						$fieldName = 'email_title_' . $prefix;
						$sql = "ALTER TABLE  `#__oscalendar_emails` ADD  `$fieldName` VARCHAR( 255 );";
						$db->setQuery($sql);
						$db->execute();
						
						$fieldName = 'email_content_' . $prefix;
						$sql = "ALTER TABLE  `#__oscalendar_emails` ADD  `$fieldName` TEXT NULL;";
						$db->setQuery($sql);
						$db->execute();
					}
				}
				
				//emails table
				$db->setQuery("SHOW COLUMNS FROM #__oscalendar_rooms");
				$fields = $db->loadObjectList();
				if(count($fields) > 0){
					$fieldArr = array();
					for($i=0;$i<count($fields);$i++){
						$field = $fields[$i];
						$fieldname = $field->Field;
						$fieldArr[$i] = $fieldname;
					}
				}
				foreach ($languages as $language)
				{
					#Process for #__osrs_emails table
					$prefix = $language->sef;
					if (!in_array('room_name_' . $prefix, $fieldArr))
					{
						$fieldName = 'room_name_' . $prefix;
						$sql = "ALTER TABLE  `#__oscalendar_rooms` ADD  `$fieldName` VARCHAR( 255 );";
						$db->setQuery($sql);
						$db->execute();
						
						$fieldName = 'room_desc_' . $prefix;
						$sql = "ALTER TABLE  `#__oscalendar_rooms` ADD  `$fieldName` TEXT NULL;";
						$db->setQuery($sql);
						$db->execute();
					}
				}

				//emails table
				$db->setQuery("SHOW COLUMNS FROM #__oscalendar_field_options");
				$fields = $db->loadObjectList();
				if(count($fields) > 0){
					$fieldArr = array();
					for($i=0;$i<count($fields);$i++){
						$field = $fields[$i];
						$fieldname = $field->Field;
						$fieldArr[$i] = $fieldname;
					}
				}
				foreach ($languages as $language)
				{
					#Process for #__osrs_emails table
					$prefix = $language->sef;
					if (!in_array('field_option_' . $prefix, $fieldArr))
					{
						$fieldName = 'field_option_' . $prefix;
						$sql = "ALTER TABLE  `#__oscalendar_field_options` ADD  `$fieldName` VARCHAR( 255 );";
						$db->setQuery($sql);
						$db->execute();
					}
				}


				$db->setQuery("SHOW COLUMNS FROM #__oscalendar_fields");
				$fields = $db->loadObjectList();
				if(count($fields) > 0){
					$fieldArr = array();
					for($i=0;$i<count($fields);$i++){
						$field = $fields[$i];
						$fieldname = $field->Field;
						$fieldArr[$i] = $fieldname;
					}
				}
				foreach ($languages as $language)
				{
					#Process for #__osrs_emails table
					$prefix = $language->sef;
					if (!in_array('field_label_' . $prefix, $fieldArr))
					{
						$fieldName = 'field_label_' . $prefix;
						$sql = "ALTER TABLE  `#__oscalendar_fields` ADD  `$fieldName` VARCHAR( 255 );";
						$db->setQuery($sql);
						$db->execute();
					}
				}
			}
		}
		
		/**
		 * Check the email message
		 *
		 */
		public static function isEmptyMailContent($subject,$content){
			if(($subject == "") or (strlen(strip_tags($content)) == 0)){
				return false;
			}else{
				return true;
			}
		}
		
		/**
		 * Load language from main component
		 *
		 */
		public static function loadLanguage()
		{
			static $loaded;
			if (!$loaded)
			{
				$lang = JFactory::getLanguage();
				$tag = $lang->getTag();
				if (!$tag)
					$tag = 'en-GB';
				$lang->load('com_oscalendar', JPATH_ROOT, $tag);
				$loaded = true;
			}
		}
		
		/**
		 * Load current language
		 *
		 */
		public static function getCurrentLanguage(){
			$lang = JFactory::getLanguage();
			$tag = $lang->getTag();
			if (!$tag){
				$tag = 'en-GB';
			}
			$prefix_language = substr($tag, 0, 2);
			return $prefix_language;
		}
		
		/**
		 * Get Configuration
		 *
		 */
		public static function getConfiguration(){
			$db = JFactory::getDbo();
			$db->setQuery("Select * from #__oscalendar_configuration");
			$configs = $db->loadObjectList();
			$cClass = array();
			foreach ($configs as $config) {
				$cClass[$config->config_key] = $config->config_value;
			}
			return $cClass;
		}
		
		/**
		 * Synchronous user to orders
		 *
		 */
		public static function synOrder(){
			$user = JFactory::getUser();
			$email = $user->email;
			$db = JFactory::getDbo();
			$db->setQuery("Update #__oscalendar_booking set user_id = '$user->id' where email like '$email' and user_id = '0'");
			$db->execute();
		}
		
		/**
		 * Public static function
		 *
		 * @param unknown_type $rid
		 * @param unknown_type $pid
		 * @param unknown_type $date
		 */
		public static function returnPropertyPriceInfo($rid,$pid,$date){
			global $mainframe;
			$db = JFactory::getDbo();
			$date1 = strtotime($date);
			$date_in_week = strtolower(date("D",$date1));
			$db->setQuery("Select id, price,curr,min_booking from #__oscalendar_room_prices where rid = '$rid' and price_from <= '$date' and price_to >= '$date' and (allday = '1' or `$date_in_week` = '1') order by created_on desc");
			$row = $db->loadObject();
			if($row->price > 0){
				$db->setQuery("Select allow_book_all, `allow_".$date_in_week."` from #__oscalendar_room_prices where id = '$row->id'");
				$allow_booking = $db->loadObject();
				$db->setQuery("Select currency_code from #__osrs_currencies where id = '$row->curr'");
				$currency_code = $db->loadResult();
				$return =  HelperOspropertyCommon::showPrice($row->price)." ".$currency_code." <BR />".JText::_('OS_MINIMUM_STAY').": ".$row->min_booking;
				if($allow_booking->allow_book_all == 1){
					$return .= "<BR /><font style='color:green;'>".JText::_('OS_ALLOW_CHECKIN')."</font>";
				}else{
					if($allow_booking->{'allow_'.$date_in_week} == 1){
						$return .= "<BR /><font style='color:green;'>".JText::_('OS_ALLOW_CHECKIN')."</font>";
					}else{
						$return .= "<BR /><font style='color:red;'>".JText::_('OS_NOT_ALLOW_CHECKIN')."</font>";
					}
				}
				return $return;
			}else{
				return  '';
			}
		}
		
		/**
		 * Show Currency
		 *
		 * @param unknown_type $curr
		 */
		static function showCurrency($curr){
			$db = JFactory::getDbo();
			$db->setQuery("Select currency_code from #__osrs_currencies where id = '$curr'");
			return $db->loadResult();
		}
		
		/**
		 * Show Icon of Adult for one Room
		 *
		 */
		static function generateAdultIcon($max_adult){
			$str = "";
			for($i=1;$i<=$max_adult;$i++){
				$str .= "<img src='".JURI::root()."components/com_oscalendar/style/images/adult.png'>";
			}
			return $str;
		}
		
		/**
		 * Generate Date Arr
		 *
		 * @param unknown_type $book_from
		 * @param unknown_type $book_to
		 */
		static function generateDateArr($book_from,$book_to){
			global $mainframe;
			$return = array();
			$book_from_int = strtotime($book_from);
			$book_to_int   = strtotime($book_to);
			$j = 0;
			for($i=$book_from_int;$i<=$book_to_int;$i = $i + 24*3600){
				$return[$j] = date("Y-m-d",$i);
				$j++;
			}
			return $return;
		}
		
		/**
		 * Check to see if there is an unavailable date in this time range
		 *
		 * @param unknown_type $selected_date
		 */
		public static function checkAvailableStatus($rid,$selected_date){
			$db = JFactory::getDbo();
			if(count($selected_date) > 0){
				$tempArr = array();
                $j = 0;
                if(count($selected_date) == 2){
                    $firstdate = $selected_date[0];
                    $lastdate  = $selected_date[1];
                    $db->setQuery("Select count(id) from #__oscalendar_available where rid = '$rid' and `checkdate` = '$firstdate' and availtype = '2'");
                    $count = $db->loadResult();
                    if($count == 0){
                        $db->setQuery("Select count(id) from #__oscalendar_available where rid = '$rid' and `checkdate` = '$lastdate' and availtype = '1'");
                        $count = $db->loadResult();
                        if($count == 0){
                            return 1;
                        }else{
                            return 0;
                        }
                    }else{
                        return 0;
                    }
                }elseif(count($selected_date) > 2) {
                    for($j=1;$j<count($selected_date)-1;$j++){
                        $tempArr[] = "'" . $selected_date[$j] . "'";
                    }
                    $db->setQuery("Select count(id) from #__oscalendar_available where rid = '$rid' and `checkdate` in (" . implode(",", $tempArr) . ")");
                    $count = $db->loadResult();
                    if ($count > 0) {
                        return 0;
                    }
                    $firstdate = $selected_date[0];
                    $lastdate  = $selected_date[count($selected_date)];
                    $db->setQuery("Select count(id) from #__oscalendar_available where rid = '$rid' and `checkdate` = '$firstdate' and availtype = '2'");
                    $count = $db->loadResult();
                    if($count == 0){
                        $db->setQuery("Select count(id) from #__oscalendar_available where rid = '$rid' and `checkdate` = '$lastdate' and availtype = '1'");
                        $count = $db->loadResult();
                        if($count == 0){
                            return 1;
                        }else{
                            return 0;
                        }
                    }else{
                        return 0;
                    }
                }
			}else{
				return 0;
			}
		}
		
		/**
		 * Check to see if the price are setup for all date in one time range
		 *
		 * @param unknown_type $rid
		 * @param unknown_type $selected_date
		 */
		public static function checkPriceSetupForOneTimeRange($rid,$selected_date){
			$db = JFactory::getDbo();
			$return = 1;
			for($i=0;$i<count($selected_date);$i++){
				$date = $selected_date[$i];
				$db->setQuery("Select count(id) from #__oscalendar_room_prices where rid = '$rid' and price_from <= '$date' and price_to >= '$date'");
				$count = $db->loadResult();
				if($count == 0){
					$return = 0;
				}
			}
			if($return == 1){
				$allowBookObj = self::calPriceProperty($rid,$selected_date[0]);
				if($allowBookObj->allow_book == 0){
					$return = 0;
				}
			}
			return $return;
		}
		
		/**
		 * Return Minimum stay
		 *
		 * @param unknown_type $rid
		 * @param unknown_type $book_from
		 */
		public static function returnMinStay($rid,$book_from){
			$db = JFactory::getDbo();
			$db->setQuery("Select min_booking from #__oscalendar_room_prices where rid = '$rid' and price_from <= '$book_from' and price_to >= '$book_from' order by created_on desc");
			$min_booking = $db->loadResult();
			return $min_booking;
		}
		
		public static function loadThemeStyle(){
			$db = Jfactory::getDBO();
			$db->setQuery("Select * from #__osrs_themes where published = '1'");
			$theme = $db->loadObject();
			$themename = ($theme->name!= "")? $theme->name:"default";
			$document = Jfactory::getDocument();
			$document->addStyleSheet(JURI::root().'components/com_osproperty/templates/'.$themename.'/style/style.css');
		}
		
		/**
		 * Load Calendar Tag
		 *
		 * @param unknown_type $name
		 * @param unknown_type $value
		 * @param unknown_type $class
		 * @param unknown_type $style
		 * @param unknown_type $onChange
		 */
		public static function loadCalendarTag($name,$value,$class,$style,$placeholder,$onChangeScript){
			global $cClass;
			$cClass = OSCHelper::getConfiguration();
			if($cClass['use_calendar'] == 0){
				return JHTML::_('calendar',$value, $name, $name, '%Y-%m-%d', array('class'=>$class, 'size'=>'19',  'maxlength'=>'19','style'=>$style,'readonly'=> 'true','onChange' => $onChangeScript, 'placeholder' => $placeholder));
			}else{
				return '<input type="text" readonly value="'.$value.'" class="'.$class.'" name="'.$name.'" id="'.$name.'" autocomplete="off" placeholder="'.$placeholder.'" style="'.$style.'" onChange="'.$onChangeScript.'" />';
			}
		}
		
		/**
		 * maxRoom Booked Type Property
		 *
		 * @param unknown_type $rid
		 * @param unknown_type $book_from
		 * @param unknown_type $book_to
		 */
		public static function maxRoomBookedTypePropertyOneDate($rid,$date){
			$db = JFactory::getDbo();
			$book = 0;
			$db->setQuery("Select sum(nroom) from #__oscalendar_booking where rid = '$rid' and book_from <= '$date' and book_to > '$date' and `order_status` in ('S','P')");
			$count = $db->loadResult();
			return $count;
		}
		
		/**
		 * Generate Price Table
		 *
		 * @param unknown_type $pid
		 * @param unknown_type $rid
		 * @param unknown_type $start
		 * @param unknown_type $end
		 */
		public static function generatePriceTable($pid,$rid,$selected_date,$nroom){
			global $cClass;
			$db = JFactory::getDbo();
			$returnArr = array();
			$return = "";
			if(count($selected_date) <= 7){
				ob_start();
				?>
				<table width="100%" class="price_table">
					<tr>
						<th width="20%">
							<?php echo JText::_('OS_DATE');?>
						</th>
						<th width="80%">
							<?php echo JText::_('OS_PRICE_INFO');?>
						</th>
					</tr>
					<?php
					$k = 0;
					for($i=0;$i<count($selected_date);$i++){
						$date = $selected_date[$i];
						$temp = array();
						$temp[] = $date;
						$temp[] = $date;
						$price = self::calPriceProperty($rid,$date);
						$broom = self::maxRoomBookedTypePropertyOneDate($rid,$date);
						$froom = $nroom - $broom;
						?>
						<tr class="row<?php echo $k;?>">
							<td style="text-align:center;border-right:1px solid #CCC;">
								<?php echo self::showDateFormat($date,0)?>
							</td>
							<td style="padding-left:20px;">
								<?php
								echo OSPHelper::generatePrice($price->curr,$price->price)."/ ".JText::_('OS_PER_NIGHT');
								?>
								&nbsp;|&nbsp;
								<?php
								echo JText::_('OS_MINIMUM_STAY').": ".$price->min_stay;
								?>
								&nbsp;|&nbsp;
								<?php
								echo JText::_('OS_AVAILABLE').": ".$froom;
								?>
								&nbsp;|&nbsp;
								<?php
								echo JText::_('OS_ALLOW_CHECKIN').": ";
								if($price->allow_book == 1){
									if(!self::checkAvailableStatus($rid, $temp)){
										echo "<font style='color:red;'>".JText::_('OS_NO')."</font>";
									}else{
										echo "<font style='color:green;'>".JText::_('OS_YES')."</font>";
									}
								}else{
									echo "<font style='color:red;'>".JText::_('OS_NO')."</font>";
								}
								?>
							</td>
						</tr>
						<?php
						$k = 1 - $k;
					}
					?>
				</table>
				<?php
				
				$return = ob_get_contents();
				ob_end_clean();
			}
			return $return;
		}
		
		/**
		 * Confirm the booking date is later than today
		 *
		 * @param unknown_type $book_from
		 * @param unknown_type $book_to
		 * @return unknown
		 */
		public static function confirmBookingDate($book_from,$book_to){
			$today = strtotime(date("Y-m-d",time()));
			$book_from_int = strtotime($book_from);
			$book_to_int = strtotime($book_to);
			if(($today <= $book_from_int) and ($today < $book_to_int)){
				return true;
			}else{
				return false;
			}
		}

        public static function getPaymentTitle($payment_name){
            $db = JFactory::getDbo();
            $db->setQuery("Select title from #__oscalendar_plugins where name like '$payment_name'");
            return $db->loadResult();
        }

        /**
         * Load Country code value
         * @param $country_name
         * @return mixed|string
         */
        public function loadCountryCode($country_name){
            $db = JFactory::getDbo();
            if($country_name == ""){
                return "IN";
            }else{
                $db->setQuery("Select `country_code` from #__osrs_countries where country_name like '$country_name'");
                return $db->loadResult();
            }
        }
	}
}
?>