<?php
/*------------------------------------------------------------------------
# extrafield.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

// No direct access.
defined('_JEXEC') or die;

/**
 * Extra fields class
 *
 */
class HelperOScalendarExtrafields{
	/**
	 * Show Field at the booking form
	 *
	 * @param unknown_type $fieldObj
	 */
	public static function showFormField($fieldObj,$orderId){
		global $mainframe;
		switch ($fieldObj->field_type){
			case "0":
				self::showFormField_TextField($fieldObj);
			break;
			case "1":
				self::showFormField_TextareaField($fieldObj);
			break;
			case "2":
				self::showFormField_SelectField($fieldObj,$orderId);
			break;
			case "3":
				self::showFormField_CheckboxField($fieldObj,$orderId);
			break;
		}
	}
	
	/**
	 * Show TEXT field
	 *
	 * @param unknown_type $field
	 * @param unknown_type $pid
	 */
	public static function showFormField_TextField($field){
		global $mainframe;
		?>
		<input type="text" class="input-large form-control" name="field_<?php echo $field->id?>" id="field_<?php echo $field->id?>" />
		<?php
	}
	
	/**
	 * Show TEXTAREA field
	 *
	 * @param unknown_type $field
	 * @param unknown_type $pid
	 */
	public static function showFormField_TextareaField($field){
		global $mainframe;
		?>
		<textarea class="input-large form-control" name="field_<?php echo $field->id?>" id="field_<?php echo $field->id?>" rows="5" cols="60"/></textarea>
		<?php
	}
	
	/**
	 * Show Select list field
	 *
	 * @param unknown_type $field
	 * @param unknown_type $pid
	 */
	public static function showFormField_SelectField($field,$orderId){
		global $mainframe,$cClass,$configClass;
		$db = JFactory::getDbo();
		$db->setQuery("Select nroom from #__oscalendar_order_temp where id = '$orderId'");
		$nroom = $db->loadResult();
		
		$db->setQuery("Select * from #__oscalendar_field_options where field_id = '$field->id'");
		$options = $db->loadObjectList();
		
		$db->setQuery("Select option_id from #__oscalendar_order_temp_field_options where order_id = '$orderId' and field_id = '$field->id'");
		$option_id = $db->loadResult();
		?>
		<select name="field_<?php echo $field->id?>" id="field_<?php echo $field->id?>" class="input-large form-control form-select" onChange="javascript:updateSummarySelectField('field_<?php echo $field->id?>');">
		<option value=""></option>
		<?php
		if(count($options) > 0){
			for($i=0;$i<count($options);$i++){
				$option = $options[$i];
				if($option->id == $option_id){
					$selected = "selected";
				}else{
					$selected = "";
				}
				if($option->option_free == 1){
					$text = OSPHelper::getLanguageFieldValue($option,'field_option')." [".JText::_('OS_FREE')."]";
				}else{
					if($field->price_for_order == 0){
						$price = $option->additional_price;
					}else{
						$price = $nroom*$option->additional_price;
					}
                    if($price < 0){
                        $sign = "-";
                        $price = (-1)*$price;
                    }else{
                        $sign = "+";
                    }
					$text = OSPHelper::getLanguageFieldValue($option,'field_option')." [".$sign." ".OSCHelper::showMoney($price,0)."]";
				}
				?>
				<option value="<?php echo $option->id?>" <?php echo $selected?>><?php echo $text?></option>
				<?php
			}
		}
		?>
		</select>
		<?php
	}
	
	/**
	 * Checkboxes fields
	 *
	 * @param unknown_type $field
	 * @param unknown_type $pid
	 */
	public static function showFormField_CheckboxField($field,$orderId){
		global $mainframe,$configClass;
		$db = JFactory::getDBO();
		$db->setQuery("Select nroom from #__oscalendar_order_temp where id = '$orderId'");
		$nroom = $db->loadResult();
		
		$db->setQuery("Select * from #__oscalendar_field_options where field_id = '$field->id'");
		$options = $db->loadObjectList();
		if(count($options) > 0){
			$j = 0;
			for($i=0;$i<count($options);$i++){
				$j++;
				$opt = $options[$i];
				$db->setQuery("Select count(id) from #__oscalendar_order_temp_field_options where order_id = '$orderId' and field_id = '$field->id' and option_id='$opt->id'");
				$count = $db->loadResult();
				if($count > 0){
					$checked = "checked";
				}else{
					$checked = "";
				}
				if($opt->option_free == 1){
					$text = OSPHelper::getLanguageFieldValue($opt,'field_option')." [".JText::_('OS_FREE')."]";
				}else{
					if($field->price_for_order == 0){
						$price = $opt->additional_price;
					}else{
						$price = $nroom*$opt->additional_price;
					}
                    if($price < 0){
                        $sign = "-";
                        $price = (-1)*$price;
                    }else{
                        $sign = "+";
                    }
					$text = OSPHelper::getLanguageFieldValue($opt,'field_option')." [".$sign." ".OSCHelper::showMoney($price,0)."]";
				}
				?>
				<input type="checkbox" name="field_<?php echo $field->id?>[]" id="<?php echo $field->id?>_<?php echo $opt->id;?>"  value="<?php echo $opt->id;?>" onclick="javascript:updateSummaryCheckboxField('<?php echo $field->id?>','<?php echo $opt->id;?>');" <?php echo $checked;?> >&nbsp; <?php echo $text;?>
				<BR />
				<?php
			}
			?>
			<input type="hidden" name="count_field_<?php echo $field->id?>" id="count_field_<?php echo $field->id;?>"  value="<?php echo count($options);?>" />
			<input type="hidden" id="field_<?php echo $field->id;?>"  value="" />
			<?php
		}
	}
	
	/**
	 * Retrieve form field
	 *
	 * @param unknown_type $fieldObj
	 */
	public static function showRetrieveFormField($fieldObj,$order_id){
		global $mainframe;
		switch ($fieldObj->field_type){
			case "0":
				self::showRetrieveFormField_TextField($fieldObj,$order_id);
			break;
			case "1":
				self::showRetrieveFormField_TextareaField($fieldObj,$order_id);
			break;
			case "2":
				self::showRetrieveFormField_SelectField($fieldObj,$order_id);
			break;
			case "3":
				self::showRetrieveFormField_CheckboxField($fieldObj,$order_id);
			break;
		}
	}
	
	/**
	 * Show TEXT field
	 *
	 * @param unknown_type $field
	 * @param unknown_type $pid
	 */
	public static function showRetrieveFormField_TextField($field,$order_id){
		global $mainframe;
		$db = JFactory::getDbo();
		$db->setQuery("Select field_value from #__oscalendar_order_field_values where order_id = '$order_id' and field_id = '$field->id'");
		$field_value = $db->loadResult();
		?>
		<input type="text" class="input-large" name="field_<?php echo $field->id?>" id="field_<?php echo $field->id?>" value="<?php echo $field_value?>" />
		<?php
	}
	
	/**
	 * Show TEXTAREA field
	 *
	 * @param unknown_type $field
	 * @param unknown_type $pid
	 */
	public static function showRetrieveFormField_TextareaField($field,$order_id){
		global $mainframe;
		$db = JFactory::getDbo();
		$db->setQuery("Select field_value from #__oscalendar_order_field_values where order_id = '$order_id' and field_id = '$field->id'");
		$field_value = $db->loadResult();
		?>
		<textarea class="input-large" name="field_<?php echo $field->id?>" id="field_<?php echo $field->id?>" rows="5" cols="60"/><?php echo $field_value?></textarea>
		<?php
	}
	
	/**
	 * Show Select list field
	 *
	 * @param unknown_type $field
	 * @param unknown_type $pid
	 */
	public static function showRetrieveFormField_SelectField($field,$order_id){
		global $mainframe,$cClass,$configClass;
		$db = JFactory::getDbo();
		$db->setQuery("Select option_id from #__oscalendar_order_field_options where order_id = '$order_id' and field_id = '$field->id'");
		$option_id = $db->loadResult();
		$db->setQuery("Select * from #__oscalendar_field_options where field_id = '$field->id'");
		$options = $db->loadObjectList();
		?>
		<select name="field_<?php echo $field->id?>" id="field_<?php echo $field->id?>" class="input-large">
		<option value=""></option>
		<?php
		if(count($options) > 0){
			for($i=0;$i<count($options);$i++){
				$option = $options[$i];
				if($option->option_free == 1){
					$text = $option->field_option." [".JText::_('OS_FREE')."]";
				}else{
                    if($opt->additional_price < 0){
                        $opt->additional_price = -1*$opt->additional_price;
                        $sign = "-";
                    }else{
                        $sign = "+";
                    }
					$text = $option->field_option." [".$sign." ".OSCHelper::showMoney($option->additional_price,0)."]";
				}
				if($option->id == $option_id){
					$selected = "selected";
				}else{
					$selected = "";
				}
				?>
				<option value="<?php echo $option->id?>" <?php echo $selected?>><?php echo $text?></option>
				<?php
			}
		}
		?>
		</select>
		<?php
	}
	
	/**
	 * Checkboxes fields
	 *
	 * @param unknown_type $field
	 * @param unknown_type $pid
	 */
	public static function showRetrieveFormField_CheckboxField($field,$order_id){
		global $mainframe,$configClass;
		$db = JFactory::getDBO();
		
		$db->setQuery("Select option_id from #__oscalendar_order_field_options where order_id = '$order_id' and field_id = '$field->id'");
		$optionChk = $db->loadObjectList();
		$optionArr = array();
		if(count($optionChk) > 0){
			for($i=0;$i<count($optionChk);$i++){
				$optionArr[] = $optionChk[$i]->option_id;
			}
		}
		
		//$options = $field->options;
		$db->setQuery("Select * from #__oscalendar_field_options where field_id = '$field->id'");
		$options = $db->loadObjectList();
		if(count($options) > 0){
			$j = 0;
			for($i=0;$i<count($options);$i++){
				$j++;
				$opt = $options[$i];
				if($opt->option_free == 1){
					$text = $opt->field_option." [".JText::_('OS_FREE')."]";
				}else{
                    if($opt->additional_price < 0){
                        $opt->additional_price = -1*$opt->additional_price;
                        $sign = "-";
                    }else{
                        $sign = "+";
                    }
					$text = $opt->field_option." [".$sign." ".OSCHelper::showMoney($opt->additional_price,0)."]";
				}
				
				if(in_array($opt->id,$optionArr)){
					$checked = "checked";
				}else{
					$checked = "";
				}
				?>
				<input type="checkbox" name="field_<?php echo $field->id?>[]" id="field_<?php echo $field->id."_".$i;?>"  value="<?php echo $opt->id?>" <?php echo $checked;?> />&nbsp; <?php echo $text;?>
				<BR />
				<?php
			}
			?>
			<input type="hidden" name="count_field_<?php echo $field->id?>" id="count_field_<?php echo $field->id;?>"  value="<?php echo count($options);?>" />
			<?php
		}
	}
	
	/**
	 * get form field Submitted
	 *
	 * @param unknown_type $fieldObj
	 */
	public static function getFormFieldInOrder($fieldObj,$order_id){
		global $mainframe;
		$db = JFactory::getDbo();
		$db->setQuery("Select curr from #__oscalendar_booking where id = '$order_id'");
		$curr = $db->loadResult();
		switch ($fieldObj->field_type){
			case "0":
				return self::getFormFieldInOrder_TextField($fieldObj,$order_id,$curr);
			break;
			case "1":
				return self::getFormFieldInOrder_TextareaField($fieldObj,$order_id,$curr);
			break;
			case "2":
				return self::getFormFieldInOrder_SelectField($fieldObj,$order_id,$curr);
			break;
			case "3":
				return self::getFormFieldInOrder_CheckboxField($fieldObj,$order_id,$curr);
			break;
		}
	}
	
	public static function getFormFieldInOrder_TextField($fieldObj,$order_id,$curr){
		$db = JFactory::getDbo();
		$db->setQuery("Select field_value from #__oscalendar_order_field_values where order_id = '$order_id' and field_id = '$fieldObj->id'");
		$value = $db->loadResult();
		return $value;
	}
	
	public static function getFormFieldInOrder_TextareaField($fieldObj,$order_id,$curr){
		$db = JFactory::getDbo();
		$db->setQuery("Select field_value from #__oscalendar_order_field_values where order_id = '$order_id' and field_id = '$fieldObj->id'");
		$value = $db->loadResult();
		return $value;
	}
	
	public static function getFormFieldInOrder_SelectField($fieldObj,$order_id,$curr){
		global $configClass;
		$db = JFactory::getDbo();
		$db->setQuery("Select option_id from #__oscalendar_order_field_options where order_id = '$order_id' and field_id = '$fieldObj->id'");
		$value = $db->loadResult();
		if($value > 0){
			$db->setQuery("Select id,field_option,option_free,additional_price from #__oscalendar_field_options where id = '$value'");
			$fieldvalue = $db->loadObject();
			$additional_fee = "";
			if($fieldvalue->field_free == 0){
				if($fieldvalue->option_free == 1){
					$additional_fee = " [".JText::_('OS_FREE')."]";
				}else{
					$additional_fee = " [+ ".OSCHelper::showMoneyWithoutCurrency($fieldvalue->additional_price)." ".$curr."]";
				}
			}
			return $fieldvalue->field_option.$additional_fee;
		}else{
			return '';
		}
	}
	
	public static function getFormFieldInOrder_CheckboxField($fieldObj,$order_id,$curr){
		global $configClass;
		$db = JFactory::getDbo();
		$db->setQuery("Select option_id from #__oscalendar_order_field_options where order_id = '$order_id' and field_id = '$fieldObj->id'");
		$value = $db->loadObjectList();
		if(count($value) > 0){
			$returnArr = array();
			for($i=0;$i<count($value);$i++){
				$v = $value[$i]->option_id;
				$additional_fee = "";
				if($fieldObj->field_free == 0){
					$db->setQuery("Select id,field_option,option_free,additional_price from #__oscalendar_field_options where id = '$v'");
					$fieldvalue = $db->loadObject();
					$fieldoption = $fieldvalue->field_option;
					if($fieldvalue->option_free == 1){
						$additional_fee = " [".JText::_('OS_FREE')."]";
					}else{
						$additional_fee = " [+ ".OSCHelper::showMoneyWithoutCurrency($fieldvalue->additional_price)." ".$curr."]";
					}
				}
				$returnArr[] = $fieldoption.$additional_fee;
			}
			return implode(" + ",$returnArr);
		}else{
			return "";
		}
	}
	
	
	
	/**
	 * get form field Submitted
	 *
	 * @param unknown_type $fieldObj
	 */
	public static function getFormFieldSubmitted($fieldObj){
		global $mainframe;
		switch ($fieldObj->field_type){
			case "0":
				return self::getFormFieldSubmitted_TextField($fieldObj);
			break;
			case "1":
				return self::getFormFieldSubmitted_TextareaField($fieldObj);
			break;
			case "2":
				return self::getFormFieldSubmitted_SelectField($fieldObj);
			break;
			case "3":
				return self::getFormFieldSubmitted_CheckboxField($fieldObj);
			break;
		}
	}
	
	public static function getFormFieldSubmitted_TextField($fieldObj){
		global $mainframe;
		$input = $mainframe->input;
		$value = $input->getString('field_'.$fieldObj->id);
		return $value;
	}
	
	public static function getFormFieldSubmitted_TextareaField($fieldObj){
		global $mainframe;
		$input = $mainframe->input;
		$value = $input->getString('field_'.$fieldObj->id);
		return $value;
	}
	
	public static function getFormFieldSubmitted_SelectField($fieldObj){
		global $configClass;
		global $mainframe;
		$input = $mainframe->input;
		$db    = JFactory::getDbo();
		$value = $input->getString('field_'.$fieldObj->id,0);
		if($value > 0){
			$db->setQuery("Select id,field_option,option_free,additional_price from #__oscalendar_field_options where id = '$value'");
			$fieldvalue = $db->loadObject();
			$additional_fee = "";
			if($fieldvalue->field_free == 0){
				if($fieldvalue->option_free == 1){
					$additional_fee = " [".JText::_('OS_FREE')."]";
				}else{
					//$additional_fee = " [+".$fieldvalue->additional_price." ".$configClass['currency_format']."]";
					$additional_fee = " [+ ".OSCHelper::showMoney($fieldvalue->additional_price,1)."]";
				}
			}
			return $fieldvalue->field_option.$additional_fee;
		}else{
			return '';
		}
	}
	
	public static function getFormFieldSubmitted_CheckboxField($fieldObj){
		global $configClass;
		global $mainframe;
		$input = $mainframe->input;
		$db = JFactory::getDbo();
		$value = $input->getString('field_'.$fieldObj->id);
		if(count($value) > 0){
			$returnArr = array();
			for($i=0;$i<count($value);$i++){
				$v = $value[$i];
				$additional_fee = "";
				if($fieldObj->field_free == 0){
					$db->setQuery("Select id,field_option,option_free,additional_price from #__oscalendar_field_options where id = '$v'");
					$fieldvalue = $db->loadObject();
					$fieldoption = $fieldvalue->field_option;
					if($fieldvalue->option_free == 1){
						$additional_fee = " [".JText::_('OS_FREE')."]";
					}else{
						//$additional_fee = " [+".$fieldvalue->additional_price." ".$configClass['currency_format']."]";
						$additional_fee = " [+ ".OSCHelper::showMoney($fieldvalue->additional_price,1)."]";
					}
				}
				$returnArr[] = $fieldoption.$additional_fee;
			}
			return implode(",",$returnArr);
		}else{
			return "";
		}
	}
	
	/**
	 * Get field price
	 *
	 * @param unknown_type $fieldObj
	 * @return unknown
	 */
	public static function getFieldPriceSubmit($fieldObj){
		global $mainframe;
		$input = $mainframe->input;
		switch ($fieldObj->field_type){
			case "2":
				$getValue = $input->getString('field_'.$fieldObj->id);
				return self::getFieldPrice_SelectField($fieldObj,$getValue);
			break;
			case "3":
				$getValue = $input->getString('field_'.$fieldObj->id);
				return self::getFieldPrice_CheckboxField($fieldObj,$getValue);
			break;
		}
	}
	
	/**
	 * Get field price
	 *
	 * @param unknown_type $fieldObj
	 * @return unknown
	 */
	public static function getFieldPrice($fieldObj){
		global $mainframe;
		
		$input = $mainframe->input;
		switch ($fieldObj->field_type){
			case "2":
				$getValue = $input->getString('field_'.$fieldObj->id);
				return self::getFieldPrice_SelectField($fieldObj,$getValue);
			break;
			case "3":
				$getValue = $input->getString('field_'.$fieldObj->id);
				$getValue = explode(",",$getValue);
				return self::getFieldPrice_CheckboxField($fieldObj,$getValue);
			break;
		}
	}
	
	/**
	 * Get price of select field
	 *
	 * @param unknown_type $field
	 * @param unknown_type $getValue
	 * @return unknown
	 */
	public static function getFieldPrice_SelectField($field,$getValue){
		$total = 0;
		if($field->field_free == 0){
			$db = JFactory::getDbo();
			$db->setQuery("Select * from #__oscalendar_field_options where id = '$getValue'");
			$field_option = $db->loadObject();
			if($field_option->option_free == 0){
				$total = $field_option->additional_price;
			}
		}
		return round($total,2);
	}
	
	/**
	 * Get price of checkbox field
	 *
	 * @param unknown_type $field
	 * @param unknown_type $getValue
	 * @return unknown
	 */
	public static function getFieldPrice_CheckboxField($field,$getValue){
		$db = JFactory::getDbo();
		$total = 0;
		if(count($getValue) > 0){
			$getValue = implode(",",$getValue);
			if(trim($getValue) != ""){
				if($field->field_free == 0){
					$db = JFactory::getDbo();
					$db->setQuery("Select * from #__oscalendar_field_options where id in ($getValue)");
					$field_options = $db->loadObjectList();
					if(count($field_options) > 0){
						for($i=0;$i<count($field_options);$i++){
							$option = $field_options[$i];
							if($option->option_free == 0){
								$total += $option->additional_price;
							}
						}
					}
				}
			}
		}
		return round($total,2);
	}
	
	
	/**
	 * Update fields to Order details
	 *
	 * @param unknown_type $order_id
	 */
	public static function updateFieldsToOrderDetails($order_id){
		global $mainframe,$configClass;
	
		$input = $mainframe->input;
		$db = JFactory::getDbo();
		$db->setQuery("Select * from #__oscalendar_fields where published = '1'");
		$fields = $db->loadObjectList();
		if(count($fields) > 0){
			foreach($fields as $field){
				$field_type = $field->field_type;
				switch ($field_type){
					case "0":
						$fieldvalue = $input->getString('field_'.$field->id);
						if($fieldvalue != ""){
							HelperOScalendarExtrafields::updateFieldsToOrderDetails_TextField($order_id,$field,$fieldvalue);
						}
					break;
					case "1":
						$fieldvalue = $input->getString('field_'.$field->id);
						if($fieldvalue != ""){
							HelperOScalendarExtrafields::updateFieldsToOrderDetails_TextareaField($order_id,$field,$fieldvalue);
						}
					break;
					case "2":
						$fieldvalue = $input->getInt('field_'.$field->id,0);
						if($fieldvalue > 0){
							HelperOScalendarExtrafields::updateFieldsToOrderDetails_SelectField($order_id,$field,$fieldvalue);
						}
					break;
					case "3":
						$fieldvalue = $input->getString('field_'.$field->id);
						if($fieldvalue != ""){
							$fieldvalue = explode(",",$fieldvalue);
							HelperOScalendarExtrafields::updateFieldsToOrderDetails_CheckboxField($order_id,$field,$fieldvalue);
						}
					break;
				}
			}
		}
	}
	
	/**
	 * Update field value to order
	 *
	 * @param unknown_type $order_id
	 * @param unknown_type $field
	 * @param unknown_type $fieldvalue
	 */
	public static function updateFieldsToOrderDetails_TextField($order_id,$field,$fieldvalue){
		global $mainframe;
		$fieldvalue = addslashes($fieldvalue);
		$db = JFactory::getDbo();
		$db->setQuery("Select count(id) from #__oscalendar_order_field_values where order_id = '$order_id' and field_id = '$field->id'");
		$count = $db->loadResult();
		if($count > 0){
			$db->setQuery("Update #__oscalendar_order_field_values set field_value = '$fieldvalue' where order_id = '$order_id' and field_id = '$field->id'");
			$db->execute();
		}else{
			$db->setQuery("Insert into #__oscalendar_order_field_values (id,order_id,field_id,field_value) values (NULL,'$order_id','$field->id','$fieldvalue')");
			$db->execute();
		}
	}
	
	/**
	 * Update field value to order
	 *
	 * @param unknown_type $order_id
	 * @param unknown_type $field
	 * @param unknown_type $fieldvalue
	 */
	public static function updateFieldsToOrderDetails_TextareaField($order_id,$field,$fieldvalue){
		global $mainframe;
		$fieldvalue = addslashes($fieldvalue);
		$db = JFactory::getDbo();
		$db->setQuery("Select count(id) from #__oscalendar_order_field_values where order_id = '$order_id' and field_id = '$field->id'");
		$count = $db->loadResult();
		if($count > 0){
			$db->setQuery("Update #__oscalendar_order_field_values set field_value = '$fieldvalue' where order_id = '$order_id' and field_id = '$field->id'");
			$db->execute();
		}else{
			$db->setQuery("Insert into #__oscalendar_order_field_values (id,order_id,field_id,field_value) values (NULL,'$order_id','$field->id','$fieldvalue')");
			$db->execute();
		}
	}
	
	/**
	 * Update field value to order
	 *
	 * @param unknown_type $order_id
	 * @param unknown_type $field
	 * @param unknown_type $fieldvalue
	 */
	public static function updateFieldsToOrderDetails_SelectField($order_id,$field,$fieldvalue){
		global $mainframe;
		$db = JFactory::getDbo();
		$db->setQuery("Select * from #__oscalendar_field_options where id = '$fieldvalue'");
		$field_option = $db->loadObject();
		$option_free = $field_option->option_free;
		
		$db->setQuery("Select count(id) from #__oscalendar_order_field_options where order_id = '$order_id' and field_id = '$field->id'");
		$count = $db->loadResult();
		if($count > 0){
			$optionSql = "";
			if($option_free == 0){
				$optionSql = ",option_price='$field_option->additional_price'";
			}
			$db->setQuery("Update #__oscalendar_order_field_options set option_id = '$fieldvalue' $optionSql where order_id = '$order_id' and field_id = '$field->id'");
			$db->execute();
		}else{
			if($option_free == 1){
				$db->setQuery("Insert into #__oscalendar_order_field_options (id,order_id,field_id,option_id) values (NULL,'$order_id','$field->id','$fieldvalue')");
				$db->execute();
			}else{
				$db->setQuery("Insert into #__oscalendar_order_field_options (id,order_id,field_id,option_id,option_price) values (NULL,'$order_id','$field->id','$fieldvalue','$field_option->additional_price')");
				$db->execute();
			}
		}
		
		if($field->field_free == 0){
			$db->setQuery("Select count(id) from #__oscalendar_order_field_price where order_id = '$order_id' and field_id = '$field->id'");
			$count = $db->loadResult();
			if($count > 0){
				$db->setQuery("Update #__oscalendar_order_field_price set field_price = '$option_free->additional_price' where order_id = '$order_id' and field_id = '$field->id' ");
				$db->execute();
			}else{
				$db->setQuery("Insert into #__oscalendar_order_field_price (id,order_id,field_id,field_price) values (NULL,'$order_id','$field->id','$option_free->additional_price')");
				$db->execute();
			}
		}
	}
	
	
	/**
	 * Update field value to order
	 *
	 * @param unknown_type $order_id
	 * @param unknown_type $field
	 * @param unknown_type $fieldvalue
	 */
	public static function updateFieldsToOrderDetails_CheckboxField($order_id,$field,$fieldvalue){
		global $mainframe;
		$db = JFactory::getDbo();
		
		$db->setQuery("Delete from #__oscalendar_order_field_options where order_id = '$order_id' and field_id = '$field->id'");
		$db->execute();
		
		if(count($fieldvalue) > 0){
			$total = 0;
			for($i=0;$i<count($fieldvalue);$i++){
				$field_option = $fieldvalue[$i];
				
				$db->setQuery("Select * from #__oscalendar_field_options where id = '$field_option'");
				$fieldOptionObj = $db->loadObject();
				$option_free = $fieldOptionObj->option_free;
				
				if($option_free == 1){
					$db->setQuery("Insert into #__oscalendar_order_field_options (id,order_id,field_id,option_id) values (NULL,'$order_id','$field->id','$field_option')");
					$db->execute();
				}else{
					$db->setQuery("Insert into #__oscalendar_order_field_options (id,order_id,field_id,option_id,option_price) values (NULL,'$order_id','$field->id','$field_option','$fieldOptionObj->additional_price')");
					$db->execute();
					
					$total += $fieldOptionObj->additional_price;
				}
			}
		}
		
		$total = round($total,2);
		if($field->field_free == 0){
			$db->setQuery("Select count(id) from #__oscalendar_order_field_price where order_id = '$order_id' and field_id = '$field->id'");
			$count = $db->loadResult();
			if($count > 0){
				$db->setQuery("Update #__oscalendar_order_field_price set field_price = '$total' where order_id = '$order_id' and field_id = '$field->id' ");
				$db->execute();
			}else{
				$db->setQuery("Insert into #__oscalendar_order_field_price (id,order_id,field_id,field_price) values (NULL,'$order_id','$field->id','$total')");
				$db->execute();
			}
		}
	}
}
?>