<?php
/*------------------------------------------------------------------------
# common.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

// No direct access.
defined('_JEXEC') or die;

/**
 * Calendar class
 *
 */
class HelperOScalendarCommon{
	
	/**
	 * Send email
	 *
	 * @param unknown_type $email_type
	 */
	function sendEmail($email_type,$orderId){
		global $configClass;
		include_once(JPATH_ROOT.'/components/com_osproperty/helpers/helper.php');
		$db = JFactory::getDbo();
		$db->setQuery("Select order_status from #__oscalendar_booking where id = '$orderId'");
		$order_status = $db->loadResult();
		switch ($order_status){
			case "P":
				$status = JText::_('OS_PENDING');
			break;
			case "C":
				$status = JText::_('OS_CANCEL');
			break;
			case "S":
				$status = JText::_('OS_COMPLETE');
			break;
		}
		
		$db->setQuery("Select * from #__oscalendar_booking where id = '$orderId'");
		$order = $db->loadObject();
		$pid = $order->pid;
		$language_prefix = $order->language_prefix;
		
		$prefix = "";
		if(JLanguageMultilang::isEnabled()){
			if($language_prefix == ""){
				$language = JFactory::getLanguage();
				$current_language = $language->getTag();
				$current_language = explode("-",$current_language);
				$language_prefix  = $current_language[0];
			}
			
			$default_lang 		  = OSPHelper::getDefaultLanguage();
			$default_lang 		  = explode("-",$default_lang);
			$default_prefix 	  = $default_lang[0];
			//echo $current_language;
			
			if($language_prefix != $default_prefix){
				$prefix 		  = '_' . $language_prefix;
			}
		}
		$db->setQuery("Select * from #__osrs_properties where id = '$pid'");
		$property = $db->loadObject();
		
		$config = new JConfig();
		$mailfrom = $config->mailfrom;
		$fromname = $config->fromname;
		switch ($email_type){
			case "cancel_notification_agent":
			case "agent_notification":
				$db->setQuery("Select * from #__osrs_agents where id = '$property->agent_id'");
				$agent = $db->loadObject();
				$order_email = $agent->email;
				
				$db->setQuery("Select * from #__oscalendar_emails where email_key like '$email_type' and published = '1'");
				$email = $db->loadObject();
				$sbj = $email->email_title;
				$body = $email->email_content;
			break;
			case "confirmation_email":
				$db->setQuery("Select `language_prefix`,email from #__oscalendar_booking where id = '$orderId'");
				$order_details = $db->loadObject();
				$order_email   = $order_details->email;
				
				$language_prefix = $order_details->language_prefix;
				//echo $language_prefix;
				//echo "<BR />";
				$db->setQuery("Select * from #__oscalendar_emails where email_key like '$email_type' and published = '1'");
				$email = $db->loadObject();
				$sbj = OSPHelper::getLanguageFieldValueBackend($email,'email_title','_'.$language_prefix);
				//echo $sbj;
				//die();
				$body = OSPHelper::getLanguageFieldValueBackend($email,'email_content','_'.$language_prefix);
			break;
			case "cancel_notification_admin":
			case "admin_notification":
				$order_email = $mailfrom;
				$db->setQuery("Select * from #__oscalendar_emails where email_key like '$email_type' and published = '1'");
				$email = $db->loadObject();
				$sbj = $email->email_title;
				$body = $email->email_content;
			break;
			case "cancel_notification_customer":
			case "order_status_change":
				$db->setQuery("Select `language_prefix`,email from #__oscalendar_booking where id = '$orderId'");
				$order_details = $db->loadObject();
				$order_email   = $order_details->email;
				$language_prefix = $order_details->language_prefix;
				
				$db->setQuery("Select * from #__oscalendar_emails where email_key like '$email_type' and published = '1'");
				$email = $db->loadObject();
				$sbj = OSPHelper::getLanguageFieldValueBackend($email,'email_title','_'.$language_prefix);
				$body = OSPHelper::getLanguageFieldValueBackend($email,'email_content','_'.$language_prefix);
			break;
		}
		
		//$db->setQuery("Select * from #__oscalendar_emails where email_key like '$email_type' and published = '1'");
		//$email = $db->loadObject();
		//$sbj = $email->{'email_title'.$prefix};
		//$body = $email->{'email_content'.$prefix};	
		
		ob_start();
		$order_id = OsCalendarDefault::orderDetailsForm($orderId);	
		$order_details = ob_get_contents();
		ob_end_clean();
		
		$body = str_replace("{booking_details}",$order_details,$body);
		$body = str_replace("{order_id}",$orderId,$body);
		$body = str_replace("{new_status}",$status,$body);
		
		$sbj = str_replace("{order_id}",$orderId,$sbj);
		
		$mailer = JFactory::getMailer();
		try
		{
			$mailer->sendMail($mailfrom,$fromname,$order_email,$sbj,$body,1);
		}
		catch (Exception $e)
		{
			JFactory::getApplication()->enqueueMessage($e->getMessage(), 'warning');
		}
	}
}

?>