<?php
/*------------------------------------------------------------------------
# calendar.php - Availability Calendar
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2014 joomdonation.com. All Rights Reserved.
# @license		GNU/GPL, see LICENSE.php
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

// No direct access.
defined('_JEXEC') or die;

/**
 * Calendar class
 *
 */
class HelperOsCalendarCalendar{
	/**
	 * Init the calendar
	 *
	 * @param unknown_type $option
	 */
	static function initCalendar($pid,$year,$month,$item){
		global $mainframe;
		require_once(JPATH_ROOT.DS."components".DS."com_osproperty".DS."helpers".DS."common.php");
		$db = JFactory::getDbo();
		$current_month 				= intval(date("m",OSCHelper::getRealTime()));
		$current_year				= intval(date("Y",OSCHelper::getRealTime()));
		$current_date				= intval(date("d",OSCHelper::getRealTime()));
		//set up the first date
		$start_date_current_month 	= strtotime($year."-".$month."-01");
		$start_date_in_week			= date("N",$start_date_current_month);
		
		$number_days_in_month		= self::days_in_month($month,$year);//cal_days_in_month(CAL_GREGORIAN,$month,$year);
		//$number_days_in_month		= HelperOsCalendarCalendar::days_in_month($current_month,$current_year);

		///if(($current_month == $month) and ($current_year == $year)){
			//$display = "block";
		//}else{
		//	$display = "none";
		//}
		
		$monthArr = array( JText::_('OS_CALENDAR_JANUARY'), JText::_('OS_CALENDAR_FEBRUARY'), JText::_('OS_CALENDAR_MARCH'), JText::_('OS_CALENDAR_APRIL'), JText::_('OS_CALENDAR_MAY'), JText::_('OS_CALENDAR_JUNE'), JText::_('OS_CALENDAR_JULY'), JText::_('OS_CALENDAR_AUGUST'), JText::_('OS_CALENDAR_SEPTEMBER'), JText::_('OS_CALENDAR_OCTOBER'), JText::_('OS_CALENDAR_NOVEMBER'), JText::_('OS_CALENDAR_DECEMBER'));
		?>
		<div id="cal<?php echo intval($month)?><?php echo $year?>">
			<table width="100%" class="apptable">
				<tr>
					<td width="20%" align="center" style="font-weight:bold;">
						<a href="javascript:prev('<?php echo $pid?>','<?php echo $item?>')" class="applink">
						<
						</a>
					</td>
					<td width="60%" align="center" style="height:25px;font-weight:bold;">
						<?php
						echo $monthArr[$month-1];
						?>
						&nbsp;
						<?php echo $year;?>
					</td>
					<td width="20%" align="center" style="font-weight:bold;">
						<a href="javascript:next('<?php echo $pid?>','<?php echo $item?>')" class="applink">
						>
						</a>
					</td>
				</tr>
				<tr>
					<td width="100%" colspan="3" style="padding:3px;text-align:center;">
						<select name="<?php echo $item?>_ossm" class="input-small" id="<?php echo $item?>_ossm" onchange="javascript:updateMonth(this.value)">
							<?php							
							for($i=0;$i<count($monthArr);$i++){
								if(intval($month) == $i + 1){
									$selected = "selected";
								}else{
									$selected = "";
								}
								?>
								<option value="<?php echo $i + 1?>" <?php echo $selected?>><?php echo $monthArr[$i]?></option>
								<?php
							}
							?>
						</select>
						<select name="<?php echo $item?>_ossy" class="input-mini" id="<?php echo $item?>_ossy" onchange="javascript:updateYear(this.value)">
							<?php
							for($i=date("Y",OSCHelper::getRealTime());$i<=date("Y",OSCHelper::getRealTime())+3;$i++){
								if(intval($year) == $i){
									$selected = "selected";
								}else{
									$selected = "";
								}
								?>
								<option value="<?php echo $i?>" <?php echo $selected?>><?php echo $i?></option>
								<?php
							}
							?>
						</select>
						<input type="button" class="btn btn-info" value="Go" onclick="javascript:calendarMoving('<?php echo $pid?>','<?php echo $item?>');">
					</td>
				</tr>
			</table>
			<table width="100%">
				<tr>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_MON')?>
					</td>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_TUE')?>
					</td>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_WED')?>
					</td>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_THU')?>
					</td>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_FRI')?>
					</td>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_SAT')?>
					</td>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_SUN')?>
					</td>
				</tr>
				<tr>
					<?php
					for($i=1;$i<$start_date_in_week;$i++){
						//empty
						?>
						<td>
						
						</td>
						<?php
					}
					$j = $start_date_in_week-1;
					if($month < 10){
						$month = "0".$month;
					}
					for($i=1;$i<=$number_days_in_month;$i++){
						$j++;
						$nolink = 0;
						//check to see if today
						if(($i == $current_date) and ($month == $current_month) and ($year == $current_year)){
							$bgcolor = "pink";
						}else{
							$bgcolor = "#2D9B35";
						}
						
						$tempdate1 = strtotime($year."-".$month."-".$i);
						//echo $year."-".$month."-".$i;
						//echo "<BR>";
						$tempdate2 = strtotime($current_year."-".$current_month."-".$current_date);
						//echo $tempdate1." - ".$tempdate2;
						//echo "<BR />";
						if($tempdate1 < $tempdate2){
							$bgcolor = "#ABAAB2";
							$nolink = 1;
						}
						
						if($i < 10){
							$day = "0".$i;
						}else{
							$day = $i;
						}
						$date = $year."-".$month."-".$day;
						$db->setQuery("Select count(id) from #__oscalendar_booking where pid = '$pid' and (book_from <= '$date' and book_to >= '$date') and order_status in ('S','P')");
						$count = $db->loadResult();
						if($count > 0){
							$bgcolor = "red";
							$nolink = 1;
							$db->setQuery("Select count(id) from #__oscalendar_booking where pid = '$pid' and book_from = '$date'");
							$isstartdate = $db->loadResult();
							if($isstartdate > 0){
								$db->setQuery("Select hour_from from #__oscalendar_booking where pid = '$pid' and book_from = '$date'");
								$hour_from = $db->loadResult();
								$hour_from = intval($hour_from);
								if($hour_from < 12){
									$nolink = 1;
								}else{
									$nolink = 3;
								}
							}
							
							$db->setQuery("Select count(id) from #__oscalendar_booking where pid = '$pid' and book_to = '$date'");
							$isenddate = $db->loadResult();
							if($isenddate > 0){
								$db->setQuery("Select hour_to from #__oscalendar_booking where pid = '$pid' and book_from = '$date'");
								$hour_to = $db->loadResult();
								$hour_to = intval($hour_to);
								if($hour_to > 12){
									$nolink = 1;
								}else{
									$nolink = 4;
									
									$db->setQuery("Select count(id) from #__oscalendar_booking where pid = '$pid' and book_from = '$date'");
									$isenddate = $db->loadResult();
									if($isenddate > 0){
										$db->setQuery("Select hour_to from #__oscalendar_booking where pid = '$pid' and book_from = '$date'");
										$hour_to = $db->loadResult();
										$hour_to = intval($hour_to);
										if($hour_to > 12){
										}else{
											$nolink = 1;
										}
									}
								}
							}
						}else{
							$db->setQuery("Select count(id) from #__oscalendar_available where pid = '$pid' and checkdate = '$date'");
							$count = $db->loadResult();
							if($count > 0){
								$bgcolor = "#252DC2";
								$nolink = 2;
							}
						}
						
						if($nolink == 1){
							$spantitle = JText::_('OS_CALENDAR_BOOKED');
							//check available
							
						}elseif($nolink == 2){
							$spantitle = JText::_('OS_CALENDAR_UNAVAILABLE');
						}elseif($nolink == 0){
							$db->setQuery("Select count(id) from #__oscalendar_property_prices where pid = '$pid' and start_time <= '$date' and end_time >= '$date'");
							$count  = $db->loadResult();
							if($count  > 0){
								$db->setQuery("Select price from #__oscalendar_property_prices where pid = '$pid' and start_time <= '$date' and end_time >= '$date'");
								$spantitle = $db->loadResult();
								
								
							}else{
								$db->setQuery("Select curr from #__osrs_properties where id = '$pid'");
								$curr = $db->loadResult();
								$db->setQuery("Select * from #__oscalendar_properties_config where pid = '$pid'");
								$config = $db->loadObject();
								$spantitle = $config->default_price;
							}
							$spantitle = HelperOspropertyCommon::loadCurrency($curr)." ".HelperOspropertyCommon::showPrice($spantitle);
							
						}
						
						$db->setQuery("Select count(id) from #__oscalendar_available where pid = '$pid' and availtype = '1' and checkdate = '$date'");
						$count1 = $db->loadResult();
						
						$db->setQuery("Select count(id) from #__oscalendar_available where pid = '$pid' and availtype = '2' and checkdate = '$date'");
						$count2 = $db->loadResult();
					
						if($nolink == 3){
							$classname = "nolink3bg";
							if($count1 > 0){
								$classname = "nolink5bg";
								$nolink =  5;
							}
						}elseif($nolink == 4){
							$classname = "nolink4bg";
							if($count2 > 0){
								$classname = "nolink6bg";
								$nolink =  6;
							}
						}else{
							$classname =  "td_calendar_date";
							if($count1 > 0){
								$classname = "nolink7bg";
								$nolink =  5;
							}
							if($count2 > 0){
								$nolink =  6;
								$classname = "nolink8bg";
							}
							if(($count1 > 0) and ($count2 > 0)){
								$nolink =  7;
								$classname = "nolink9bg";
							}
						}
						
						?>
						<td id="td_cal_<?php echo $i?>"  align="center" class="<?php echo $classname;?>" style="background-color:<?php echo $bgcolor?>;">
							<span id="a<?php echo $year?><?php echo $month?><?php echo $i;?>" class="hasTitle" title="<?php echo $spantitle?>">
							<?php
							if($nolink == 0){
							?>
							<a href="javascript:addBook('<?php echo $pid?>','<?php echo $date?>','<?php echo $item?>');">
							<?php
							}elseif((($nolink == 3) or ($nolink == 6)) and ($item == "book_to")){
								?>
								<a href="javascript:addBook('<?php echo $pid?>','<?php echo $date?>','<?php echo $item?>');">
								<?php
							}elseif((($nolink == 4) or ($nolink == 5)) and ($item == "book_from")){
								?>
								<a href="javascript:addBook('<?php echo $pid?>','<?php echo $date?>','<?php echo $item?>');">
								<?php
							}
							if(($nolink == 1) or ($nolink == 2)){
								echo "<font color='white'>";
							}else{
								echo "<font color='white'>";
							}
							echo $i;
							echo "</font>";
								
							if($nolink == 0){
							?>
							</a>
							<?php
							}
							?>
							</span>
						</td>
						<?php
						if($j >= 7){
							$j = 0;
							echo "</tr><tr>";
						}
						
					}
					?>
				</tr>
			</table>
		</div>
		<?php
	}
	
	
	/**
	 * Init the calendar
	 *
	 * @param unknown_type $option
	 */
	static function initAvailabilityCalendar($pid,$rid,$year,$month,$item){
		global $mainframe;
		require_once(JPATH_ROOT.DS."components".DS."com_osproperty".DS."helpers".DS."common.php");
		$db = JFactory::getDbo();
		if($rid > 0){
			$db->setQuery("Select * from #__oscalendar_rooms where id = '$rid'");
			$room = $db->loadObject();
			$nroom = $room->room_number;
		}
		$db->setQuery("Select pro_type from #__osrs_properties where id = '$pid'");
		$category_id = $db->loadResult();
		
		$db->setQuery("Select price_type from #__osrs_types where id = '$category_id'");
		$price_type = $db->loadResult();
		
		$current_month 				= intval(date("m",OSCHelper::getRealTime()));
		$current_year				= intval(date("Y",OSCHelper::getRealTime()));
		$current_date				= intval(date("d",OSCHelper::getRealTime()));
		//set up the first date
		$start_date_current_month 	= strtotime($year."-".$month."-01");
		$start_date_in_week			= date("N",$start_date_current_month);
		
		$number_days_in_month		= cal_days_in_month(CAL_GREGORIAN,$month,$year);
		
		$monthArr = array( JText::_('OS_CALENDAR_JANUARY'), JText::_('OS_CALENDAR_FEBRUARY'), JText::_('OS_CALENDAR_MARCH'), JText::_('OS_CALENDAR_APRIL'), JText::_('OS_CALENDAR_MAY'), JText::_('OS_CALENDAR_JUNE'), JText::_('OS_CALENDAR_JULY'), JText::_('OS_CALENDAR_AUGUST'), JText::_('OS_CALENDAR_SEPTEMBER'), JText::_('OS_CALENDAR_OCTOBER'), JText::_('OS_CALENDAR_NOVEMBER'), JText::_('OS_CALENDAR_DECEMBER'));
		?>
		<div id="cal<?php echo intval($month)?><?php echo $year?>">
			<table width="100%" class="apptable">
				<tr>
					<td width="20%">
						<?php
						if(intval($month) == 1){
							$m = 12;
							$y = intval($year) - 1;
						}else{
							$m = intval($month) - 1;
							$y = $year;
						}
						?>
						<a href="javascript:loadAvailabilityCalendar('<?php echo $pid?>',<?php echo $rid?>,'<?php echo $y;?>','<?php echo $m;?>');" class="applink">
						<
						</a>
					</td>
					<td width="60%">
						<?php
						echo $monthArr[$month-1];
						?>
						&nbsp;
						<?php echo $year;?>
					</td>
					<td width="20%">
						<?php
						if(intval($month) == 12){
							$m  = 1;
							$y  = intval($year) + 1;
						}else{
							$m = intval($month) + 1;
							$y = $year;
						}
						?>
						<a href="javascript:loadAvailabilityCalendar('<?php echo $pid?>',<?php echo $rid?>,'<?php echo $y;?>','<?php echo $m;?>');" class="applink">
						>
						</a>
					</td>
				</tr>
			</table>
			<table width="100%">
				<tr>
					<td class="header_availability_calendar">
						<?php echo JText::_('OS_CALENDAR_MON')?>
					</td>
					<td class="header_availability_calendar">
						<?php echo JText::_('OS_CALENDAR_TUE')?>
					</td>
					<td class="header_availability_calendar">
						<?php echo JText::_('OS_CALENDAR_WED')?>
					</td>
					<td class="header_availability_calendar">
						<?php echo JText::_('OS_CALENDAR_THU')?>
					</td>
					<td class="header_availability_calendar">
						<?php echo JText::_('OS_CALENDAR_FRI')?>
					</td>
					<td class="header_availability_calendar">
						<?php echo JText::_('OS_CALENDAR_SAT')?>
					</td>
					<td class="header_availability_calendar">
						<?php echo JText::_('OS_CALENDAR_SUN')?>
					</td>
				</tr>
				<tr>
					<?php
					for($i=1;$i<$start_date_in_week;$i++){
						//empty
						?>
						<td>
						
						</td>
						<?php
					}
					$j = $start_date_in_week-1;
					if($month < 10){
						$month = "0".$month;
					}
					for($i=1;$i<=$number_days_in_month;$i++){

						$nolink = 0;
						$j++;
						
						//check to see if today
						if(($i == $current_date) and ($month == $current_month) and ($year == $current_year)){
							$bgcolor = "pink";
						}else{
							$bgcolor = "#2D9B35";
						}
						
						if($price_type == 0){
							$existing_price = OSCHelper::isExistingPricePlan($rid,$year."-".$month."-".$i);
						}else{
							$existing_price = OSCHelper::isExistingPrice($rid,$year."-".$month."-".$i);
						}
						
						if(!$existing_price){
							$tempdate1 = strtotime($year."-".$month."-".$i);
							$tempdate2 = strtotime($current_year."-".$current_month."-".$current_date);
							if($tempdate1 < $tempdate2){
								$bgcolor = "#ABAAB2";
								$nolink = 1;
							}else{
								$nolink = 4;
							}
							
							if($i < 10){
								$day = "0".$i;
							}else{
								$day = $i;
							}
							
							$date = $year."-".$month."-".$day;
							
							$db->setQuery("Select count(id) from #__oscalendar_available where rid = '$rid' and checkdate = '$date'");
							$count = $db->loadResult();
							if($count > 0){
								$bgcolor = "#C28D25";
								$nolink = 2;
							}
						}else{
							$tempdate1 = strtotime($year."-".$month."-".$i);
							$tempdate2 = strtotime($current_year."-".$current_month."-".$current_date);
							if($tempdate1 < $tempdate2){
								$bgcolor = "#ABAAB2";
								$nolink = 1;
								
							}
							
							if($i < 10){
								$day = "0".$i;
							}else{
								$day = $i;
							}
							
							$date = $year."-".$month."-".$day;
							$db->setQuery("Select sum(nroom) from #__oscalendar_booking where rid = '$rid' and (book_from <= '$date' and book_to > '$date') and order_status in ('S','P')");
							$count = $db->loadResult();
							
							if($count > 0){ //there is at least one booking request on this room on these days
								if($count >= $nroom){
									$bgcolor = "red";
									$nolink = 1;
								}else{
									$bgcolor = "#7CC2EA";
									$nolink = 3;
								}
							}else{
								$db->setQuery("Select count(id) from #__oscalendar_available where rid = '$rid' and checkdate = '$date'");
								$count = $db->loadResult();
								if($count > 0){
									$bgcolor = "#C28D25";
									$nolink = 2;
								}else{
									$nolink = 3;
								}
							}
						}
								
						if($nolink == 1){
							$spantitle = JText::_('OS_NO_ROOM_AVAILABLE');
							//check available
						}elseif($nolink == 2){
							$spantitle = JText::_('OS_CALENDAR_UNAVAILABLE');
						}elseif($nolink == 0){
							if($price_type == 0){
								$priceInfo = OSCHelper::getPricePlan($rid,$date);
								$spantitle = $nroom." ".JText::_('OS_ROOMS')." ".JText::_('OS_AVAILABLE').". ".OSPHelper::generatePrice($priceInfo->curr,$priceInfo->price)."/ ".JText::_('OS_FROM').": ".$priceInfo->price_from." ".JText::_('OS_TO').": ".$priceInfo->price_to;
							}else{
								$priceInfo = OSCHelper::getPriceProperty($rid,$date);
								$spantitle = $nroom." ".JText::_('OS_ROOMS')." ".JText::_('OS_AVAILABLE').". ".OSPHelper::generatePrice($priceInfo->curr,$priceInfo->price);
							}
						}elseif($nolink == 3){
							if($price_type == 0){//price type = 0. Type Holiday
								$broom = OSCHelper::maxRoomBooked($rid,$date);
								if($broom == $nroom){
									$spantitle = JText::_('OS_NO_ROOM_AVAILABLE');
								}else{
									$froom = $nroom - $broom;
									$spantitle = $froom." ".JText::_('OS_ROOMS')." ".JText::_('OS_AVAILABLE');
									$priceInfo = OSCHelper::getPricePlan($rid,$date);
									$spantitle .= ". ".OSPHelper::generatePrice($priceInfo->curr,$priceInfo->price)."/ ".JText::_('OS_FROM').": ".$priceInfo->price_from." ".JText::_('OS_TO').": ".$priceInfo->price_to;
								}
							}else{ //price type  == 1. Type Property
								$broom = OSCHelper::maxRoomBooked($rid,$date);
								if($broom == $nroom){
									$spantitle = JText::_('OS_NO_ROOM_AVAILABLE');
								}else{
									$froom = $nroom - $broom;
									$spantitle = $froom." ".JText::_('OS_ROOMS')." ".JText::_('OS_AVAILABLE');
									$priceInfo = OSCHelper::getPriceProperty($rid,$date);
									$spantitle .= ". ".OSPHelper::generatePrice($priceInfo->curr,$priceInfo->price);
								}
							}
						}elseif($nolink == 4){
							$bgcolor = "#F8ECF8";
							if($price_type == 0){
								$spantitle = JText::_('OS_NO_PRICE_SETUP');
							}else{
								$spantitle = JText::_('OS_NO_PRICE_SETUP');
							}
						}
						
						$db->setQuery("Select count(id) from #__oscalendar_available where pid = '$pid' and availtype = '1' and checkdate = '$date'");
						$count1 = $db->loadResult();
						
						$db->setQuery("Select count(id) from #__oscalendar_available where pid = '$pid' and availtype = '2' and checkdate = '$date'");
						$count2 = $db->loadResult();
					
						$classname =  "td_calendar_date";
						
						?>
						<td id="td_cal_<?php echo $i?>"  align="center" class="<?php echo $classname;?> td_availability_calendar" style="background-color:<?php echo $bgcolor?>;">
							<span id="a<?php echo $year?><?php echo $month?><?php echo $i;?>" class="hasTitle" title="<?php echo $spantitle?>">
							<?php
							if($nolink == 0){
							?>
							<!--<a href="javascript:addBook('<?php echo $pid?>','<?php echo $date?>','<?php echo $item?>');">-->
							<?php
							}elseif((($nolink == 3) or ($nolink == 6)) and ($item == "book_to")){
								?>
								<!--<a href="javascript:addBook('<?php echo $pid?>','<?php echo $date?>','<?php echo $item?>');">-->
								<?php
							}elseif((($nolink == 4) or ($nolink == 5)) and ($item == "book_from")){
								?>
								<!--<a href="javascript:addBook('<?php echo $pid?>','<?php echo $date?>','<?php echo $item?>');">-->
								<?php
							}
							if(($nolink == 1) or ($nolink == 2) or ($nolink == 3) or ($nolink == 0)){
								echo "<font color='white'>";
							}elseif($nolink == 4){
								echo "<font color='black'>";
							}
							echo $i;
							echo "</font>";
								
							if($nolink == 0){
							?>
							<!--</a>-->
							<?php
							}
							?>
							</span>
						</td>
						<?php
						if($j >= 7){
							$j = 0;
							echo "</tr><tr>";
						}	
					}
					?>
				</tr>
			</table>
		</div>
		<?php
	}
	
	
	static function initCalendarInBackend($pid,$rid,$year,$month){
		global $mainframe;
		$db = JFactory::getDbo();
		$current_month 				= intval(date("m",OSCHelper::getRealTime()));
		$current_year				= intval(date("Y",OSCHelper::getRealTime()));
		$current_date				= intval(date("d",OSCHelper::getRealTime()));
		//set up the first date
		$start_date_current_month 	= strtotime($year."-".$month."-01");
		$start_date_in_week			= date("N",$start_date_current_month);
		
		$number_days_in_month		= cal_days_in_month(CAL_GREGORIAN,$month,$year);
		
		$monthArr = array( JText::_('OS_CALENDAR_JANUARY'), JText::_('OS_CALENDAR_FEBRUARY'), JText::_('OS_CALENDAR_MARCH'), JText::_('OS_CALENDAR_APRIL'), JText::_('OS_CALENDAR_MAY'), JText::_('OS_CALENDAR_JUNE'), JText::_('OS_CALENDAR_JULY'), JText::_('OS_CALENDAR_AUGUST'), JText::_('OS_CALENDAR_SEPTEMBER'), JText::_('OS_CALENDAR_OCTOBER'), JText::_('OS_CALENDAR_NOVEMBER'), JText::_('OS_CALENDAR_DECEMBER'));
		
		?>
		<div id="cal<?php echo intval($month)?><?php echo $year?>">
			<table width="100%" class="apptable">
				<tr>
					<td width="40%" align="right" style="font-weight:bold;font-size:15px;">
						<a href="javascript:prev('<?php echo $pid?>','<?php echo $rid?>')" class="applink">
						<b><</b>
						</a>
					</td>
					<td width="20%" align="center" style="height:25px;font-weight:bold;">
						<?php
						echo $monthArr[$month-1];
						?>
						&nbsp;
						<?php echo $year;?>
					</td>
					<td width="40%" align="left" style="font-weight:bold;font-size:15px;">
						<a href="javascript:next('<?php echo $pid?>','<?php echo $rid?>')" class="applink">
						<b>></b>
						</a>
					</td>
				</tr>
				<tr>
					<td width="100%" colspan="3" style="padding:3px;text-align:center;">
						<select name="ossm" class="input-medium form-control form-select" id="ossm" onchange="javascript:updateMonth(this.value)">
							<?php							
							for($i=0;$i<count($monthArr);$i++){
								if(intval($month) == $i + 1){
									$selected = "selected";
								}else{
									$selected = "";
								}
								?>
								<option value="<?php echo $i + 1?>" <?php echo $selected?>><?php echo $monthArr[$i]?></option>
								<?php
							}
							?>
						</select>
						<select name="ossy" class="input-small form-control form-select" id="ossy" onchange="javascript:updateYear(this.value)">
							<?php
							for($i=date("Y",OSCHelper::getRealTime());$i<=date("Y",OSCHelper::getRealTime())+3;$i++){
								if(intval($year) == $i){
									$selected = "selected";
								}else{
									$selected = "";
								}
								?>
								<option value="<?php echo $i?>" <?php echo $selected?>><?php echo $i?></option>
								<?php
							}
							?>
						</select>
						<input type="button" class="btn btn-warning" value="Go" onclick="javascript:calendarMoving('<?php echo $pid?>','<?php echo $rid?>');">
					</td>
				</tr>
			</table>
			<table width="100%">
				<tr>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_MON')?>
					</td>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_TUE')?>
					</td>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_WED')?>
					</td>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_THU')?>
					</td>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_FRI')?>
					</td>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_SAT')?>
					</td>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_SUN')?>
					</td>
				</tr>
				<tr>
					<?php
					for($i=1;$i<$start_date_in_week;$i++){
						//empty
						?>
						<td>
						
						</td>
						<?php
					}
					$j = $start_date_in_week-1;
					
					$m = intval($month);
					
					if($m  < 10){
						$m = "0".$m;
					}
					$month = $m;
					
					for($i=1;$i<=$number_days_in_month;$i++){
						$j++;
						$nolink = 0;
						//check to see if today
						if(($i == $current_date) and ($month == $current_month) and ($year == $current_year)){
							$bgcolor = "pink";
						}else{
							$bgcolor = "#2D9B35";
						}
						
						if($i < 10){
							$day = "0".$i;
						}else{
							$day = $i;
						}
						
						$tempdate1 = strtotime($year."-".$month."-".$day);
						$tempdate2 = strtotime($current_year."-".$current_month."-".$current_date);
						if($tempdate1 < $tempdate2){
							$bgcolor = "#ABAAB2";
							$nolink = 5;
						}
						
						if($i < 10){
							$day = "0".$i;
						}else{
							$day = $i;
						}
						$date = $year."-".$month."-".$day;
						$db->setQuery("Select count(id) from #__oscalendar_booking where rid = '$rid' and (book_from <= '$date' and book_to >= '$date') and order_status in ('S','P')");
						$count = $db->loadResult();
						if($count > 0){
							$bgcolor = "red";
							$nolink = 1;
							
							$db->setQuery("Select count(id) from #__oscalendar_booking where rid = '$rid' and book_from = '$date'");
							$isstartdate = $db->loadResult();
							if($isstartdate > 0){
								$db->setQuery("Select hour_from from #__oscalendar_booking where rid = '$rid' and book_from = '$date'");
								$hour_from = $db->loadResult();
								$hour_from = intval($hour_from);
								if($hour_from < 12){
									$nolink = 1;
								}else{
									$nolink = 3;
								}
							}
							
							$db->setQuery("Select count(id) from #__oscalendar_booking where rid = '$rid' and book_to = '$date'");
							$isenddate = $db->loadResult();
							if($isenddate > 0){
								$db->setQuery("Select hour_to from #__oscalendar_booking where rid = '$rid' and book_from = '$date'");
								$hour_to = $db->loadResult();
								$hour_to = intval($hour_to);
								if($hour_to > 12){
									$nolink = 1;
								}else{
									$nolink = 4;
									
									$db->setQuery("Select count(id) from #__oscalendar_booking where rid = '$rid' and book_from = '$date'");
									$isenddate = $db->loadResult();
									if($isenddate > 0){
										$db->setQuery("Select hour_to from #__oscalendar_booking where rid = '$rid' and book_from = '$date'");
										$hour_to = $db->loadResult();
										$hour_to = intval($hour_to);
										if($hour_to > 12){
										}else{
											$nolink = 1;
										}
									}
								}
							}
						}else{
							$db->setQuery("Select count(id) from #__oscalendar_available where rid = '$rid' and checkdate = '$date'");
							$count = $db->loadResult();
							if($count > 0){
								$bgcolor = "#252DC2";
								$nolink = 2;
							}
						}
						if($nolink == 5){
							$background = "#555";
						}else{
							$background = "#CCDFCE";
						}
						?>
						<td id="td_cal_<?php echo $i?>"  align="center" class="td_calendar_date" style="text-align:left;padding:2px;background-color:<?php echo $background;?>;vertical-align:top;">
							<span class="label label-info">
							<?php
							echo $i;
							echo "</span>";
							if($nolink == 5){
								echo  " <font color='#FFF'>[".JText::_('OS_CALENDAR_PAST')."]</font>";
							}else{
								$bgcolor1 = "";
								$bgcolor2 = "";
								if($nolink == 1){
									$bgcolor1 = "#FF0000";
									$bgcolor2 = "#FF0000";
								}elseif($nolink == 5){
									$bgcolor1 = "gray";
									$bgcolor2 = "gray";
								}elseif($nolink == 3){
									$bgcolor1  = "#2D9B35";
									$bgcolor2  = "#FF0000";
								}elseif($nolink == 4){
									$bgcolor2  = "#2D9B35";
									$bgcolor1  = "#FF0000";
								}else{
									$bgcolor2  = "#2D9B35";
									$bgcolor1  = "#2D9B35";
								}
								$nolink1 = 0;
								$nolink2 = 0;
								$db->setQuery("Select count(id) from #__oscalendar_available where rid = '$rid' and checkdate = '$date' and availtype = '1'");
								$count = $db->loadResult();
								if($count > 0){
									$nolink1 = 1;
									$bgcolor1  = "#252DC2";
								}
								$db->setQuery("Select count(id) from #__oscalendar_available where rid = '$rid' and checkdate = '$date' and availtype = '2'");
								$count = $db->loadResult();
								if($count > 0){
									$nolink2 = 1;
									$bgcolor2  = "#252DC2";
								}
								?>
								<table width="100%" height="60">
									<tr>
										<td width="100%" style="background-color:<?php echo $bgcolor1?>;border-bottom:1px dotted orange !important;">
											<span id="a<?php echo $year?><?php echo $month?><?php echo $i;?>" style="">
											<?php
											if(($nolink == 0) or ($nolink==2) or ($nolink == 3)){
												?>
												<input type="checkbox" name="cid1[]" value="<?php echo $date?>">
												<?php
											}
											?>
											<font style='color:#efefef;font-size:11px;font-weight:normal !important;'>1:00 AM - 12:00PM</font>
											<?php
											if($nolink == 1){
												echo  "<font color='#FFF'>[".JText::_('OS_CALENDAR_BOOKED')."]</font>";
											}elseif($nolink1 == 1){
												echo  "<font color='#FFF'>[".JText::_('OS_CALENDAR_UNAVAILABLE')."]</font>";
											}elseif($nolink == 4){
												echo  "<font color='#FFF'>[".JText::_('OS_CALENDAR_BOOKED')."]</font>";
											}else{
												echo  "<font color='white'>[".JText::_('OS_CALENDAR_AVAILABLE')."]</font>";
											}
											?>
										</span>
										</td>
									</tr>
									<tr>
										<td width="100%" style="background-color:<?php echo $bgcolor2?>;">
											<span id="a<?php echo $year?><?php echo $month?><?php echo $i;?>" style="">
											<?php
											if(($nolink == 0) or ($nolink==2) or ($nolink == 4)){
												?>
												<input type="checkbox" name="cid2[]" value="<?php echo $date?>">
												<?php
											}
											?>
											<font style='color:#efefef;font-size:11px;font-weight:normal !important;'>1:00 PM - 12:00AM</font>
											<?php
											if($nolink == 1){
												echo  "<font color='#FFF'>[".JText::_('OS_CALENDAR_BOOKED')."]</font>";
											}elseif($nolink2 == 1){
												echo  "<font color='#FFF'>[".JText::_('OS_CALENDAR_UNAVAILABLE')."]</font>";
											}elseif($nolink == 3){
												echo  "<font color='#FFF'>[".JText::_('OS_CALENDAR_BOOKED')."]</font>";
											}else{
												echo  "<font color='white'>[".JText::_('OS_CALENDAR_AVAILABLE')."]</font>";
											}
											?>
										</span>
										</td>
									</tr>
								</table>
								<?php
							}
							?>
						</td>
						<?php
						if($j >= 7){
							$j = 0;
							echo "</tr><tr>";
						}
						
					}
					?>
				</tr>
			</table>
		</div>
		<?php
	}
	
	/**
	 * This function will show one calendar with price information of one room of property
	 *
	 * @param unknown_type $rid
	 * @param unknown_type $pid
	 * @param unknown_type $year
	 * @param unknown_type $month
	 */
	static function showCalendarWithPriceBackend($rid,$pid,$year,$month){
		global $mainframe;
		$db = JFactory::getDbo();
		$db->setQuery("Select room_number from #__oscalendar_rooms where id = '$rid'");
		$room_number = $db->loadResult();
		$current_month 				= intval(date("m",OSCHelper::getRealTime()));
		$current_year				= intval(date("Y",OSCHelper::getRealTime()));
		$current_date				= intval(date("d",OSCHelper::getRealTime()));
		//set up the first date
		$start_date_current_month 	= strtotime($year."-".$month."-01");
		$start_date_in_week			= date("N",$start_date_current_month);
		$number_days_in_month		= cal_days_in_month(CAL_GREGORIAN,$month,$year);
		
		$monthArr = array( JText::_('OS_CALENDAR_JANUARY'), JText::_('OS_CALENDAR_FEBRUARY'), JText::_('OS_CALENDAR_MARCH'), JText::_('OS_CALENDAR_APRIL'), JText::_('OS_CALENDAR_MAY'), JText::_('OS_CALENDAR_JUNE'), JText::_('OS_CALENDAR_JULY'), JText::_('OS_CALENDAR_AUGUST'), JText::_('OS_CALENDAR_SEPTEMBER'), JText::_('OS_CALENDAR_OCTOBER'), JText::_('OS_CALENDAR_NOVEMBER'), JText::_('OS_CALENDAR_DECEMBER'));
		
		?>
		<div id="cal<?php echo intval($month)?><?php echo $year?>">
			<table width="100%" class="apptable">
				<tr>
					<td width="35%" align="right" style="font-weight:bold;font-size:15px;">
						
					</td>
					<td width="30%" align="center" style="height:25px;font-weight:bold;font-size:18px;">
						<?php
						echo $monthArr[$month-1];
						?>
						&nbsp;
						<?php echo $year;?>
					</td>
					<td width="35%" align="left" style="font-weight:bold;font-size:15px;">
						
					</td>
				</tr>
			</table>
			<table width="100%">
				<tr>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_MON')?>
					</td>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_TUE')?>
					</td>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_WED')?>
					</td>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_THU')?>
					</td>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_FRI')?>
					</td>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_SAT')?>
					</td>
					<td class="header_calendar">
						<?php echo JText::_('OS_CALENDAR_SUN')?>
					</td>
				</tr>
				<tr>
					<?php
					for($i=1;$i<$start_date_in_week;$i++){
						//empty
						?>
						<td>
						
						</td>
						<?php
					}
					$j = $start_date_in_week-1;
					
					$m = intval($month);
					
					if($m  < 10){
						$m = "0".$m;
					}
					$month = $m;
					
					for($i=1;$i<=$number_days_in_month;$i++){
						$j++;
						$nolink = 0;
						//check to see if today
						if(($i == $current_date) and ($month == $current_month) and ($year == $current_year)){
							$bgcolor = "pink";
						}else{
							$bgcolor = "#2D9B35";
						}
						
						if($i < 10){
							$day = "0".$i;
						}else{
							$day = $i;
						}
						
						$tempdate1 = strtotime($year."-".$month."-".$day);
						$tempdate2 = strtotime($current_year."-".$current_month."-".$current_date);
						if($tempdate1 < $tempdate2){
							$bgcolor = "#ABAAB2";
							$nolink = 5;
						}
						
						if($i < 10){
							$day = "0".$i;
						}else{
							$day = $i;
						}
						$date = $year."-".$month."-".$day;
						if($nolink==5){
							$calendarbgcolor = "#555";
						}else{
							$calendarbgcolor = "#fff";
						}
						?>
						<td id="td_cal_<?php echo $i?>"  align="center" class="td_calendar_date" style="background-color:<?php echo $calendarbgcolor;?>;">
							<span class="label label-info">
							<?php
							echo $i;
							echo "</span>";
							if($nolink == 5){
							}else{
								$priceDayInfo = OSCHelper::returnPropertyPriceInfo($rid,$pid,$date);
								$broom		  = OSCHelper::maxRoomBookedTypeProperty($rid,$date,$date);
								if($priceDayInfo != ""){
									?>
									<table width="100%">
										<tr>
											<td width="100%">
												<?php echo JText::_('OS_PRICE')?>: <?php echo $priceDayInfo;?>
												<BR />
												<?php echo JText::_('OS_FREE')?>: <?php 
												if($room_number - $broom < 0){
													echo "0";
												}else{
													echo $room_number - $broom;
												}
												?>
											</td>
										</tr>
									</table>
									<?php
								}
							}
							?>
						</td>
						<?php
						if($j >= 7){
							$j = 0;
							echo "</tr><tr>";
						}
					}
					?>
				</tr>
			</table>
		</div>
		<?php
	}
	
	/**
	 * Check duplicate order item 
	 *
	 * @param unknown_type $userdata
	 */
	function checkDuplicateOrderItem($pid,$book_from,$book_to){
		global $mainframe;
		$db = JFactory::getDbo();
		$return   = array();
		$sids	  = array();
		$db->setQuery("Select count(id) from #__oscalendar_booking where pid = '$pid' and book_from = '$date_from' and book_to = '$date_to'");
		$count = $db->loadResult();
		if($count > 0){
			$return[0]->canCreateOrder = false;
		}else{
			$return[0]->canCreateOrder = true;
		}
		
		return $return;
	}
	
	public static function days_in_month($month, $year){
	// calculate number of days in a month
		return $month == 2 ? ($year % 4 ? 28 : ($year % 100 ? 29 : ($year % 400 ? 28 : 29))) : (($month - 1) % 7 % 2 ? 30 : 31);
	} 
}
?>